/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.extension.model.ErrorModelBuilder;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.core.module.contribution.ErrorModelMapper;
import org.mule.tooling.messageflow.util.MessageFlowEntityRef;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomErrorModelFactory;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesTree;

public class ErrorTypesProvider {
    public static final String MULE_NAMESPACE = "MULE";
    public static final String CORE_NAMESPACE = "CORE";
    private static final Set<String> CORE_NAMESPACES = Sets.newHashSet((Object[])new String[]{"MULE", "CORE"});
    public static final org.mule.tooling.client.api.extension.model.ErrorModel ANY_ERROR_TOOLING_MODEL = ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build();
    public static final ErrorModel ANY_ERROR_MODEL = ErrorModelMapper.toErrorModel((org.mule.tooling.client.api.extension.model.ErrorModel)ErrorModelBuilder.newError((String)"ANY", (String)"MULE").build());
    private static final Set<ErrorModel> CORE_ERROR_TYPES = new HashSet<ErrorModel>();
    private final IMuleProject muleProject;

    static {
        CORE_ERROR_TYPES.add(ANY_ERROR_MODEL);
        CORE_ERROR_TYPES.add(ErrorModelMapper.toErrorModel((org.mule.tooling.client.api.extension.model.ErrorModel)ErrorModelBuilder.newError((String)"EXPRESSION", (String)MULE_NAMESPACE).withParent(ANY_ERROR_TOOLING_MODEL).build()));
        CORE_ERROR_TYPES.add(ErrorModelMapper.toErrorModel((org.mule.tooling.client.api.extension.model.ErrorModel)ErrorModelBuilder.newError((String)"STREAM_MAXIMUM_SIZE_EXCEEDED", (String)MULE_NAMESPACE).withParent(ANY_ERROR_TOOLING_MODEL).build()));
    }

    public ErrorTypesProvider(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public ErrorModel[] getErrorTypesForNode(String baseTypes, IMessageFlowNode node) {
        Set<ErrorModel> errorTypes = ModelUtils.isOnError((IMessageFlowNode)node) ? this.calculateOnErrorOptions(baseTypes, node) : this.calculateNodeOptions(baseTypes, node);
        errorTypes.add(ANY_ERROR_MODEL);
        ErrorModel[] result = errorTypes.toArray(new ErrorModel[errorTypes.size()]);
        Arrays.sort(result, (o1, o2) -> {
            boolean isCore1 = CORE_NAMESPACES.contains(o1.getNamespace());
            boolean isCore2 = CORE_NAMESPACES.contains(o2.getNamespace());
            if (isCore1 && !isCore2) {
                return 1;
            }
            if (!isCore1 && isCore2) {
                return -1;
            }
            if (o1.getNamespace().compareTo(o2.getNamespace()) == 0) {
                return o1.getType().compareTo(o2.getType());
            }
            return o1.getNamespace().compareTo(o2.getNamespace());
        });
        return result;
    }

    public Set<ErrorModel> getAllErrorModels() {
        return Sets.newHashSet((Iterable)Sets.union(this.getCoreErrorTypes(this.muleProject.getServerDefinition().getVersionWithSuffix()), this.getExternalModuleErrors(this.muleProject.getModuleManager())));
    }

    private Set<ErrorModel> getExternalModuleErrors(IMuleModuleManager moduleManager) {
        List externalModules = moduleManager.getExternalModules();
        HashSet result = Sets.newHashSet();
        externalModules.forEach(module -> {
            boolean bl = result.addAll(module.getErrorModels());
        });
        return result;
    }

    private Set<ErrorModel> calculateNodeOptions(String typesText, IMessageFlowNode node) {
        String actualVersion = this.muleProject.getServerDefinition().getVersionWithSuffix();
        Set<ErrorModel> errorTypes = this.getCoreErrorTypes(actualVersion);
        NodeDefinition definition = node.getDefinition();
        List nodeErrorTypes = definition.getErrorTypes().stream().map(CustomErrorModelFactory::createErrorFrom).collect(Collectors.toList());
        errorTypes.addAll(nodeErrorTypes);
        return errorTypes;
    }

    private Set<ErrorModel> calculateOnErrorOptions(String typesText, IMessageFlowNode node) {
        String actualVersion = this.muleProject.getServerDefinition().getVersionWithSuffix();
        Set<ErrorModel> errorTypes = this.getCoreErrorTypes(actualVersion);
        this.addCustomErrors(errorTypes, typesText);
        this.collectContextErrors(errorTypes, node);
        return errorTypes;
    }

    private Set<ErrorModel> getCoreErrorTypes(String version) {
        return Sets.newHashSet(CORE_ERROR_TYPES);
    }

    private void collectContextErrors(final Set<ErrorModel> errorTypes, IMessageFlowNode node) {
        final MessageFlowEntity parentNode = this.findParentNode(node);
        if (parentNode == null) {
            return;
        }
        parentNode.accept(new MessageFlowEntityVisitor(){

            public void visitUnknownNode(UnknownNode unknownNode) {
            }

            public void visitCommentNode(CommentContainer commentNode) {
            }

            public void visitSplitterNode(SplitterNode splitterNode) {
                splitterNode.getCompartment().getLanes().forEach(l -> l.accept((MessageFlowEntityVisitor)this));
                this.collectErrorMapping((IMessageFlowNode)splitterNode);
            }

            public void visitPatternNode(PatternNode patternNode) {
                if (ModelUtils.isFlowRef((IMessageFlowNode)patternNode)) {
                    this.visitFlowOrSubFlow(patternNode);
                }
                this.collectErrorMapping((IMessageFlowNode)patternNode);
            }

            private void visitFlowOrSubFlow(PatternNode flowRef) {
                String flowOrSubFlowName;
                MessageFlowEntity flowOrSubFlowEntity;
                IReadOnlyProperty flowOrSubFlow = (IReadOnlyProperty)flowRef.getProperties().getProperty("name");
                if (flowOrSubFlow != null && (flowOrSubFlowEntity = MessageFlowUtils.findEntityForMulePathInOpenEditors((String)(flowOrSubFlowName = flowOrSubFlow.getValue()), (String)ErrorTypesProvider.this.muleProject.getName())) != null) {
                    flowOrSubFlowEntity.accept((MessageFlowEntityVisitor)this);
                }
            }

            public void visitNestedContainer(NestedContainer nestedContainer) {
                nestedContainer.getCompartmentLaneEntries().forEach(e -> e.accept((MessageFlowEntityVisitor)this));
            }

            public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                muleConfiguration.getFlows().forEach(f -> f.accept((MessageFlowEntityVisitor)this));
            }

            public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
            }

            public void visitGlobalElement(GlobalElement globalElement) {
                this.collectErrorMapping((IMessageFlowNode)globalElement);
            }

            public void visitEndpointNode(EndpointNode endpointNode) {
                this.collectErrorMapping((IMessageFlowNode)endpointNode);
            }

            public void visitContainer(Container container) {
                if (this.shouldInspectContainer(container)) {
                    container.getLanes().forEach(l -> l.accept((MessageFlowEntityVisitor)this));
                }
                this.collectErrorMapping((IMessageFlowNode)container);
            }

            private boolean shouldInspectContainer(Container container) {
                return !ModelUtils.isTryScope((IMessageFlowNode)container) || container == parentNode;
            }

            public void visitCompartmentLane(CompartmentLane lane) {
                lane.getCompartmentLaneEntries().forEach(e -> e.accept((MessageFlowEntityVisitor)this));
            }

            public void visitRoute(Route route) {
                this.visitCompartmentLane((CompartmentLane)route);
            }

            public void visitCompartment(Compartment compartment) {
                compartment.getLanes().forEach(l -> l.accept((MessageFlowEntityVisitor)this));
                this.collectErrorMapping((IMessageFlowNode)compartment);
            }

            private void collectErrorMapping(IMessageFlowNode node) {
                List propertyCollections = node.getProperties().getPropertyCollections();
                propertyCollections.forEach(p -> {
                    IReadOnlyProperty targetType;
                    String collectionName = p.getName();
                    if (collectionName.contains("error-mapping") && (targetType = (IReadOnlyProperty)p.getProperty("targetType")) != null) {
                        errorTypes.add(CustomErrorModelFactory.createErrorFrom(targetType.getValue()));
                    }
                });
                NodeDefinition definition = node.getDefinition();
                if (definition != null) {
                    definition.getErrorTypes().forEach(e -> {
                        boolean bl = errorTypes.add(CustomErrorModelFactory.createErrorFrom(e));
                    });
                }
            }
        });
    }

    private MessageFlowEntity findParentNode(IMessageFlowNode node) {
        MessageFlowEntityRef entityRef = MessageFlowUtils.findMulePathForEntityInOpenEditors((IMessageFlowEntity)node);
        MulePath parentPath = entityRef.getMulePath().getParent();
        if (parentPath.hasParent()) {
            MulePath grandParent = parentPath.getParent();
            return MessageFlowUtils.findEntityForMulePathInOpenEditors((String)grandParent.toPath(), (String)entityRef.getMuleProject().getName());
        }
        return null;
    }

    private void addCustomErrors(Set<ErrorModel> errorTypes, String text) {
        ArrayList checkedText = StringUtils.isNotBlank((CharSequence)text) ? Lists.newArrayList((Object[])text.split(", ")) : Lists.newArrayList();
        List collect = checkedText.stream().filter(e -> errorTypes.stream().noneMatch(errorModel -> ErrorTypesTree.sameError(errorModel, e))).map(CustomErrorModelFactory::createErrorFrom).collect(Collectors.toList());
        errorTypes.addAll(collect);
    }
}

