/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IForceSave;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesTree;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class ErrorTypeCustomEditor
extends CustomEditor
implements IForceSave {
    private static final int SHELL_WIDTH = 300;
    private static final int SHELL_MAX_HEIGHT = 222;
    private static final String TYPE_ATTR_NAME = "type";
    private Text types;
    private ErrorTypesTree errorTypeTree;
    private Shell shell;

    public ErrorTypeCustomEditor(AttributesPropertyPage parentPage, AttributeHelper helper, AttributeGroup attributeGroup, Composite groupComposite) {
        super(parentPage, helper, attributeGroup, groupComposite);
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
    }

    @Override
    protected Control createControl(AttributesPropertyPage parentPage) {
        Composite parentComposite = this.getGroupComposite();
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).extendedMargins(0, 0, 0, 0).applyTo(parentComposite);
        this.createTypesSelector(parentComposite);
        return parentComposite;
    }

    private Composite createTypesSelector(Composite parentComposite) {
        Composite typeComposite = new Composite(parentComposite, 4);
        Label typeLabel = new Label(typeComposite, 64);
        typeLabel.setText("Type:");
        typeLabel.setToolTipText("Types are defined by comma separated values");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)typeLabel);
        this.createTextWithButton(parentComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.types);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)typeComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(typeComposite);
        return typeComposite;
    }

    private void createTextWithButton(Composite parentComposite) {
        Composite baseComposite = new Composite(parentComposite, 2048);
        baseComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout baseCompositeGridLayout = new GridLayout(2, false);
        baseCompositeGridLayout.marginHeight = 0;
        baseCompositeGridLayout.marginWidth = 0;
        baseComposite.setLayout((Layout)baseCompositeGridLayout);
        baseComposite.setBackground(new Color((Device)parentComposite.getDisplay(), new RGB(255, 255, 255)));
        baseComposite.setBackgroundMode(2);
        this.types = new Text(baseComposite, 0);
        this.types.setLayoutData((Object)new GridData(4, 4, true, true));
        this.types.setMessage("Click on the icon or start typing");
        Label button = new Label(baseComposite, 0);
        button.setLayoutData((Object)new GridData(4, 4, false, true));
        Image buttonImage = MuleImages.DESC_SEARCH.createImage();
        button.setImage(buttonImage);
        button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ErrorTypeCustomEditor.this.initComboSelector();
            }
        });
        button.addDisposeListener(e -> buttonImage.dispose());
    }

    protected void initComboSelector() {
        this.shell = new Shell(this.getParentPage().getShell(), 12);
        GridLayout layout = new GridLayout();
        layout.marginTop = 3;
        layout.marginBottom = 3;
        this.shell.setLayout((Layout)layout);
        this.shell.setSize(300, 222);
        this.shell.setLocation(this.findLocation(222));
        GridDataFactory.fillDefaults().applyTo((Control)this.shell);
        this.createList(this.shell);
        this.shell.open();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                super.shellClosed(e);
                if (!ErrorTypeCustomEditor.this.shell.isDisposed()) {
                    ErrorTypeCustomEditor.this.shell.dispose();
                }
            }

            public void shellDeactivated(ShellEvent e) {
                super.shellDeactivated(e);
                if (!ErrorTypeCustomEditor.this.shell.isDisposed()) {
                    String typesText = ErrorTypeCustomEditor.this.errorTypeTree.getTypesText();
                    ErrorTypeCustomEditor.this.types.setText(typesText);
                    ErrorTypeCustomEditor.this.shell.dispose();
                }
            }
        });
    }

    private Point findLocation(int shellHeight) {
        Point location = this.types.toDisplay(this.types.getLocation());
        Rectangle clientArea = this.findCurrentMonitor(location);
        location.y = location.y + shellHeight > clientArea.height ? (location.y -= shellHeight) : (location.y += this.types.getSize().y);
        return location;
    }

    private Rectangle findCurrentMonitor(Point location) {
        Monitor[] monitorArray = Display.getCurrent().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Rectangle clientArea = monitor.getClientArea();
            boolean isInClientArea = clientArea.x < location.x && location.x < clientArea.x + clientArea.width;
            if (isInClientArea &= clientArea.y < location.y && location.y < clientArea.y + clientArea.height) {
                return clientArea;
            }
            ++n2;
        }
        return Display.getCurrent().getPrimaryMonitor().getClientArea();
    }

    private void createList(Shell shell) {
        Label errorsLabel = new Label((Composite)shell, 0);
        errorsLabel.setText("Select the error types: ");
        Text filterText = new Text((Composite)shell, 2048);
        filterText.setMessage("Filter the list writing here");
        filterText.setLayoutData((Object)new GridData(768));
        this.errorTypeTree = new ErrorTypesTree(this.getParentPage().getMessageFlowNode(), true);
        this.errorTypeTree.createTypesTree((Composite)shell, this.types.getText());
        this.setTreeFilter(filterText);
    }

    private void setTreeFilter(Text filterText) {
        TypesFilter typesFilter = new TypesFilter();
        this.errorTypeTree.getTypesTree().addFilter((ViewerFilter)typesFilter);
        filterText.addModifyListener(s -> {
            Text text = (Text)s.getSource();
            typesFilter.setSearchText(text.getText());
            this.errorTypeTree.getTypesTree().refresh();
        });
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.types.setText(props.getProperty(TYPE_ATTR_NAME, ""));
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        this.saveTypeToNode(node, props);
    }

    private void saveTypeToNode(IMessageFlowNode node, PropertyCollectionMap props) {
        String typesText = this.types.getText();
        if (StringUtils.isNotBlank((CharSequence)typesText)) {
            Property typeProperty = new Property(TYPE_ATTR_NAME, typesText);
            props.addProperty(typeProperty);
        } else {
            props.addProperty("auxiliary;erased;" + this.getHelper().getId(), "true");
        }
    }

    @Override
    public boolean hasToForceSave(MuleConfiguration currentMuleConfiguration, IMuleProject muleProject, IMessageFlowNode messageFlowEntity) {
        return false;
    }

    private class TypesFilter
    extends ViewerFilter {
        private String searchString;
        private ErrorModel[] all;

        private TypesFilter() {
        }

        public void setSearchText(String s) {
            this.searchString = s.toLowerCase();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.searchString == null || this.searchString.length() == 0) {
                return true;
            }
            ErrorModel error = (ErrorModel)element;
            String child = this.getCompleteName(error);
            boolean result = child.contains(this.searchString);
            if (parentElement instanceof ErrorModel[] && element instanceof ErrorModel) {
                this.all = (ErrorModel[])parentElement;
            }
            if (this.all != null) {
                result |= this.oneChildContainsSearch(error, this.all);
            }
            return result;
        }

        private boolean oneChildContainsSearch(ErrorModel element, ErrorModel[] all) {
            List<ErrorModel> children = this.getChildren(element, all);
            return children.stream().filter(e -> this.getCompleteName((ErrorModel)e).contains(this.searchString)).findFirst().isPresent();
        }

        private String getCompleteName(ErrorModel error) {
            return error.getNamespace().concat(":").concat(error.getType()).toLowerCase();
        }

        private List<ErrorModel> getChildren(ErrorModel element, ErrorModel[] all) {
            ArrayList result = Lists.newArrayList();
            ErrorModel[] errorModelArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorModel e = errorModelArray[n2];
                if (e.getParent().isPresent() && e.getParent().get() == element) {
                    result.add(e);
                    result.addAll(this.getChildren(e, all));
                }
                ++n2;
            }
            return result;
        }
    }
}

