/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.jface.viewer.radiogroup.RadioGroupViewer;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.client.ToolingValueProviderErrorNotification;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ExpressionWrapperFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.GlobalRefEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IButtonEnablement;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesAction;
import org.mule.tooling.ui.modules.core.widgets.editors.RefreshTypesButtonEnabler;
import org.mule.tooling.ui.modules.core.widgets.editors.options.RefreshTypesButton;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderEventHandler;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderEventTypes;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ButtonAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;
import org.mule.tooling.ui.modules.core.widgets.meta.Sort;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.listener.IdleSelectionEventListener;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.script.ScriptUtils;
import org.osgi.framework.Version;

public class EnumFieldEditor
extends ExpressionWrapperFieldEditor
implements IRefresheableEditor,
IEditorValueModifiedObservable {
    protected static StructuredViewer lastEnum;
    protected StructuredViewer cmb;
    protected String value;
    private boolean inSet;
    private boolean onSelectionChangeCalled = false;
    private Set<IEditorValueModifiedListener> valueModifiedListeners;
    private Action buttonAction;
    private Action extraButtonAction;
    private SimpleContentProposalProvider contentProposal;
    private List<IPropertyValueChangeListener> propertyValueChangeListeners;
    private EventBus eventBus;
    private EventBusHelper eventBusHelper;
    private List<PropertyCollection> previousDefinitions = new ArrayList<PropertyCollection>();
    private Optional<IButtonEnablement> actionButtonEnablement;
    private Optional<IButtonEnablement> extraActionButtonEnablement;
    private ModifyListener modifyListener;
    private DisposeListener disposeListener;

    public EnumFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    public void toogleWarningIndicator(boolean showWarningIndicator) {
        Image image = null;
        String tooltip = "";
        if (showWarningIndicator) {
            image = WidgetsImages.getImage((String)"/icons/notification/warning-16x16.png");
            tooltip = "There was a problem fetching metadata for this element or its global connector, please check your configuration.";
        }
        if (this.label instanceof CLabel) {
            CLabel clabel = (CLabel)this.label;
            clabel.setImage(image);
            clabel.setToolTipText(tooltip);
            clabel.redraw();
        }
    }

    @Override
    protected void createExtraContent(Composite parent) {
        super.createExtraContent(parent);
        if (!(this.getHelper() instanceof EnumHelper)) {
            return;
        }
        EnumHelper enumHelper = (EnumHelper)this.getHelper();
        String buttonClass = enumHelper.getButtonClass();
        if (enumHelper.isTypeChooser() || StringUtils.isNotBlank((String)buttonClass)) {
            this.actionButtonEnablement = Optional.ofNullable(this.createButtonEnablementObject(enumHelper));
            if (!enumHelper.isButtonDisabled() && this.actionButtonEnablement.isPresent()) {
                ToolBarManager toolBarManager = new ToolBarManager();
                this.addButton(enumHelper, buttonClass, toolBarManager);
                this.addExtraButton(enumHelper, toolBarManager);
                ToolBar toolbar = toolBarManager.createControl(parent);
                toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).indent(-7, 0).create());
                this.refreshButtonStatus();
            }
        }
    }

    private void addExtraButton(EnumHelper enumHelper, ToolBarManager toolBarManager) {
        if (enumHelper.isUseSelectionDialog()) {
            this.extraButtonAction = new RefreshTypesButton(){

                public void run() {
                    AttributesPropertyPage parentPage = EnumFieldEditor.this.getParentPage();
                    new RefreshTypesAction().click(EnumFieldEditor.this, parentPage);
                    EnumFieldEditor.this.refreshEditor(EnumFieldEditor.this.getValue(), false);
                }
            };
            toolBarManager.add((IAction)this.extraButtonAction);
            this.extraActionButtonEnablement = Optional.ofNullable(new RefreshTypesButtonEnabler());
        }
    }

    private void addButton(final EnumHelper enumHelper, final String buttonClass, ToolBarManager toolBarManager) {
        this.buttonAction = new Action(){

            public void run() {
                AttributesPropertyPage parentPage = EnumFieldEditor.this.getParentPage();
                enumHelper.click(EnumFieldEditor.this, parentPage, buttonClass);
                EnumFieldEditor.this.refreshEditor(EnumFieldEditor.this.getValue(), false);
            }
        };
        String buttonCaption = enumHelper.getButtonCaption();
        if (StringUtils.isNotBlank((String)buttonCaption)) {
            this.buttonAction.setText(buttonCaption);
        }
        this.buttonAction.setToolTipText(enumHelper.getButtonTooltip());
        ImageDescriptor buttonImage = enumHelper.getButtonImageDescriptor();
        if (buttonImage != null) {
            this.buttonAction.setImageDescriptor(buttonImage);
            this.buttonAction.setDisabledImageDescriptor(enumHelper.getButtonDisabledImageDescriptor());
        }
        toolBarManager.add((IAction)this.buttonAction);
    }

    private IButtonEnablement createButtonEnablementObject(EnumHelper enumHelper) {
        String buttonEnablementClass = enumHelper.getButtonEnablementClass();
        if (StringUtils.isBlank((String)buttonEnablementClass)) {
            return null;
        }
        try {
            return (IButtonEnablement)ButtonAttributeHelper.class.getClassLoader().loadClass(buttonEnablementClass).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create button enablement object with class [" + buttonEnablementClass + "]");
        }
    }

    private void refreshButtonStatus() {
        this.refreshButton(this.buttonAction, this.actionButtonEnablement);
        this.refreshButton(this.extraButtonAction, this.extraActionButtonEnablement);
    }

    private void refreshButton(Action buttonAction, Optional<IButtonEnablement> actionButtonEnablement) {
        if (buttonAction != null && actionButtonEnablement.isPresent()) {
            buttonAction.setEnabled(actionButtonEnablement.get().isEnabled(this.getHelper(), this.getParentPage()));
        }
    }

    private boolean isEnumHelper() {
        return this.attributeHelper instanceof EnumHelper;
    }

    protected boolean allowsCustomValues() {
        return this.isEnumHelper() && this.getAttributes().isAllowsCustom();
    }

    private String getOptionText(EnumOption m) {
        return m.caption;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        boolean allowsCustom = this.allowsCustomValues();
        this.cmb = this.createViewer(this.attributeHelper, parent, allowsCustom);
        this.cmb.getControl().setToolTipText(this.getHelper().getDescription());
        if (this.isEnumHelper()) {
            EnumHelper enumHelper = (EnumHelper)this.getHelper();
            if (this.eventBus == null) {
                this.eventBus = MuleCorePlugin.getEventBus();
                this.eventBusHelper = new EventBusHelper();
            }
            if (StringUtils.isNotEmpty((String)enumHelper.getProviderName())) {
                this.eventBusHelper.registerUIListener(this.eventBus, ValueProviderEventTypes.VALUE_PROVIDER_EVENT, (IEventHandler)new ValueProviderEventHandler(){

                    @Override
                    public void onSuccess(String editorId) {
                        EnumFieldEditor.this.setError(null);
                        AttributeHelper helper = EnumFieldEditor.this.getHelper();
                        boolean belongsToEditor = editorId.equals(((EnumHelper)helper).getProviderName());
                        if (belongsToEditor && !EnumFieldEditor.this.cmb.getControl().isDisposed()) {
                            EnumOption enumOption = EnumFieldEditor.this.getEnumOptionFrom(EnumFieldEditor.this.calcOptions(), EnumFieldEditor.this.getValue());
                            EnumFieldEditor.this.refreshEditor(EnumFieldEditor.this.getValue(), false);
                            if (enumOption != null) {
                                EnumFieldEditor.this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
                            }
                        }
                    }

                    @Override
                    public void onError(String editorId, ToolingValueProviderErrorNotification error) {
                        EnumFieldEditor.this.setError(error.getMessage());
                    }
                });
            } else {
                this.eventBusHelper.registerUIListener(this.eventBus, ValueProviderEventTypes.VALUE_PROVIDER_EVENT, (IEventHandler)new ValueProviderEventHandler(){

                    @Override
                    public void onSuccess(String editorId) {
                        if (EnumFieldEditor.this.getHelper().getId().equals(editorId)) {
                            EnumOption enumOption = EnumFieldEditor.this.getEnumOptionFrom(EnumFieldEditor.this.calcOptions(), EnumFieldEditor.this.getValue());
                            EnumFieldEditor.this.refreshEditor(EnumFieldEditor.this.getValue(), false);
                            if (enumOption != null) {
                                EnumFieldEditor.this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
                            }
                        }
                    }

                    @Override
                    public void onError(String editorId, ToolingValueProviderErrorNotification error) {
                        EnumFieldEditor.this.setError(error.getMessage());
                    }
                });
            }
        }
        this.contentProposal = WidgetUtils.enableContentProposal((Control)this.cmb.getControl());
        if (this.attributeHelper.getId().equals("engine")) {
            lastEnum = this.cmb;
            this.cmb.getControl().addDisposeListener(event -> {
                lastEnum = null;
            });
        }
        this.cmb.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmb.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EnumOption m = (EnumOption)element;
                String name = EnumFieldEditor.this.getOptionText(m);
                if (EnumFieldEditor.this.mustShowOptionsValues() && !m.isEmptyOption()) {
                    name = EnumFieldEditor.this.getOptionText(m);
                }
                return name;
            }
        });
        this.cmb.setComparator(new ViewerComparator());
        ISelectionChangedListener selectionChangeListener = event -> this.onSelectionChange(true);
        if (this.isTypeChooser()) {
            IdleSelectionEventListener listener = new IdleSelectionEventListener(selectionChangeListener, this.cmb.getControl());
            this.cmb.addSelectionChangedListener((ISelectionChangedListener)listener);
        } else {
            this.cmb.addSelectionChangedListener(selectionChangeListener);
        }
        this.cmb.getControl().addDisposeListener(event -> {
            this.cmb.removeSelectionChangedListener(selectionChangeListener);
            if (this.eventBusHelper != null) {
                this.eventBusHelper.unregister();
                this.eventBus = null;
            }
        });
        this.initInput();
        return this.cmb.getControl();
    }

    private void removeModifierListener() {
        if (this.cmb.getControl() instanceof Combo && this.modifyListener != null) {
            Combo enumCombo = (Combo)this.cmb.getControl();
            enumCombo.removeModifyListener(this.modifyListener);
            enumCombo.removeDisposeListener(this.disposeListener);
            this.modifyListener = null;
        }
    }

    private void addModifierListener() {
        if (this.cmb.getControl() instanceof Combo && this.modifyListener == null) {
            Combo enumCombo = (Combo)this.cmb.getControl();
            ModifyListener baseListener = event -> {
                if (enumCombo != null && !enumCombo.isDisposed()) {
                    this.notifyObservers();
                }
            };
            boolean isReadOnly = (enumCombo.getStyle() & 8) != 0;
            this.modifyListener = !isReadOnly ? new IdleModifyEventListener(1000L, baseListener, (Control)enumCombo) : baseListener;
            enumCombo.addModifyListener(this.modifyListener);
            this.disposeListener = event -> enumCombo.removeModifyListener(this.modifyListener);
            enumCombo.addDisposeListener(this.disposeListener);
        }
    }

    private StructuredViewer createViewer(AttributeHelper helper, Composite parent, boolean allowsCustom) {
        if (helper instanceof EnumHelper && ((EnumHelper)helper).isRadioGroup()) {
            return new RadioGroupViewer(parent, ((EnumHelper)helper).isHorizontal() ? 256 : 512);
        }
        ComboViewer comboViewer = new ComboViewer(parent, allowsCustom ? 0 : 8);
        if (allowsCustom && this.supportExpressions()) {
            comboViewer.getCombo().addVerifyListener((VerifyListener)new PasteActionListener());
        }
        return comboViewer;
    }

    @Override
    public void validate() {
        List<EnumOption> options = this.getOptions();
        if (options != null && !options.isEmpty() && !ExpressionUtils.hasPropertyPlaceholder((String)this.value)) {
            Optional<EnumOption> selectedOption = options.stream().filter(x -> x.value.equals(this.value)).findFirst();
            if (!selectedOption.isPresent() && this.isTypeChooser()) {
                Combo combo = (Combo)this.cmb.getControl();
                String currentContent = combo.getText();
                if (StringUtils.isNotBlank((String)currentContent)) {
                    this.setError("Invalid field value: " + currentContent);
                } else {
                    super.validate();
                }
            } else {
                super.validate();
            }
        } else {
            super.validate();
        }
        this.getParentPage().validate();
    }

    protected void initInput() {
        this.refreshEditor(this.getValue(), false);
        if (this.value != null) {
            this.setValue(this.value);
        }
    }

    private boolean shouldUseSelectionDialog() {
        if (this.getHelper() instanceof EnumHelper) {
            EnumHelper enumHelper = (EnumHelper)this.getHelper();
            return enumHelper.isUseSelectionDialog();
        }
        return false;
    }

    @Override
    public final void refreshEditor(String value, boolean shouldNotifyObservers) {
        if (!ExpressionUtils.isExpressionOrProperty((String)value)) {
            List<EnumOption> options = this.calcOptions();
            if (this.shouldUseSelectionDialog()) {
                boolean notEmpty;
                boolean bl = notEmpty = !options.isEmpty();
                if (this.buttonAction != null && this.actionButtonEnablement.isPresent()) {
                    this.actionButtonEnablement.get().setEnabled(notEmpty);
                }
            } else if (this.cmb.getControl() instanceof Combo) {
                this.updateContentProposals(options);
                Combo combo = (Combo)this.cmb.getControl();
                String currentContent = combo.getText();
                ISelection selection = this.cmb.getSelection();
                if (this.hasDifferentOptions(options)) {
                    this.cmb.setInput((Object)options.toArray());
                }
                if (!selection.isEmpty()) {
                    this.cmb.setSelection(selection);
                } else if (StringUtils.isNotBlank((String)currentContent)) {
                    if (this.allowsCustomValues()) {
                        combo.setText(currentContent);
                    }
                } else if (options.size() == 1 && StringUtils.isNotEmpty((String)options.get((int)0).value) && this.isNotGlobalRefOrIsRequiredGlobalRef()) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                }
            } else {
                this.cmb.setInput((Object)options.toArray());
                if (options.size() == 1) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                }
            }
            this.refreshButtonStatus();
            this.setSelection(value, options);
        }
    }

    private boolean isNotGlobalRefOrIsRequiredGlobalRef() {
        return !(this instanceof GlobalRefEditor) || this.attributeHelper.isRequired();
    }

    private boolean hasDifferentOptions(List<EnumOption> options) {
        List<Object> cmbOptions;
        if (this.cmb.getInput() != null && (cmbOptions = Arrays.asList((Object[])this.cmb.getInput())).size() == options.size()) {
            for (Object enumOption : cmbOptions) {
                if (options.contains(enumOption)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void setSelection(String value, List<EnumOption> options) {
        if (this.attributeHelper instanceof EnumHelper) {
            EnumOption enumOption;
            IValueCalculator valueCalculator = this.getAttributes().getValueCalculator();
            if (valueCalculator != null) {
                value = valueCalculator.value(value, this, this.node);
            }
            if ((enumOption = this.getEnumOptionFrom(options, value)) != null) {
                if (this.shouldUseSelectionDialog()) {
                    this.cmb.setInput(Arrays.asList(enumOption));
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
                } else if (this.allowsCustomValues()) {
                    ((ComboViewer)this.cmb).getCombo().setText(enumOption.value);
                } else {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
                }
            }
        }
    }

    private EnumOption getEnumOptionFrom(List<EnumOption> options, String enumValue) {
        for (EnumOption enumOption : options) {
            if (!enumOption.value.equals(enumValue)) continue;
            return enumOption;
        }
        return null;
    }

    private EnumHelper getAttributes() {
        return (EnumHelper)this.attributeHelper;
    }

    private boolean mustShowOptionsValues() {
        return this.isEnumHelper();
    }

    public List<EnumOption> calcOptions() {
        EnumHelper eatr = this.getAttributes();
        IOptionsCalculator calc = eatr.getOptionsCalculator();
        if (calc != null) {
            if (this.getParentPage() != null) {
                List<EnumOption> options = calc.options(this, this.node);
                eatr.setOptions(options);
                EnumOption.sortOptions(options, Sort.ASC);
                return options;
            }
            return new ArrayList<EnumOption>();
        }
        Collection<EnumOption> options2 = eatr.getOptions();
        HashSet<EnumOption> options = new HashSet<EnumOption>();
        for (EnumOption o : options2) {
            if (o.getVersions() != null) {
                String attribute = o.getVersions();
                if ((attribute = attribute.replace(".EE", ";EE")).length() > 0) {
                    int indexOf = attribute.indexOf(59);
                    String version = this.context.getVersion();
                    if (indexOf != -1) {
                        attribute = attribute.substring(0, indexOf);
                        if (version.indexOf(59) == -1) continue;
                    }
                    VersionRange versionRange = new VersionRange(attribute);
                    if (version.charAt(version.length() - 1) == ';') {
                        version = version.substring(0, version.length() - 1);
                    }
                    if (!versionRange.isIncluded(new Version(version))) continue;
                }
            }
            options.add(o);
        }
        boolean removeEmptyOption = this.isEnumHelper() && this.getAttributes().isRemoveEmptyOption();
        boolean isAutoSort = this.isEnumHelper() && this.getAttributes().isAutoSort();
        ArrayList<EnumOption> sortedOptions = new ArrayList<EnumOption>(options);
        if (!removeEmptyOption && this.attributeHelper.shouldAddEmptyOption()) {
            sortedOptions.add(0, EnumOption.getEmptyOption(this.attributeHelper));
        }
        if (isAutoSort) {
            EnumOption.sortOptions(sortedOptions, Sort.ASC);
        } else {
            EnumOption.sortOptions(sortedOptions, Sort.NONE);
        }
        return sortedOptions;
    }

    @Override
    public String getPublicValue() {
        return this.getValue();
    }

    @Override
    public String getLiteralValue() {
        String trimmedName;
        if (Display.getCurrent() == null || this.isDisposed()) {
            return this.value;
        }
        if (this.allowsCustomValues() && StringUtils.isNotBlank((String)(trimmedName = ((Combo)this.cmb.getControl()).getText().trim()))) {
            Collection<EnumOption> options = null;
            options = this.attributeHelper instanceof EnumHelper ? this.getAttributes().getOptions() : this.calcOptions();
            for (EnumOption option : options) {
                if (!this.getOptionText(option).trim().equals(trimmedName)) continue;
                return option.value;
            }
            return trimmedName;
        }
        EnumOption option = this.getSelectedEnumOption();
        if (option == null || option.value == null) {
            return "";
        }
        return option.value;
    }

    protected EnumOption getSelectedEnumOption() {
        IStructuredSelection selection = (IStructuredSelection)this.cmb.getSelection();
        return (EnumOption)selection.getFirstElement();
    }

    @Override
    public void setLiteralValue(String value) {
        this.value = value;
        this.inSet = true;
        try {
            List<EnumOption> options = this.calcOptions(value);
            if (this.shouldUseSelectionDialog()) {
                if (this.buttonAction != null && this.actionButtonEnablement.isPresent()) {
                    this.actionButtonEnablement.get().setEnabled(!options.isEmpty());
                }
            } else {
                this.cmb.setInput((Object)options.toArray());
                this.updateContentProposals(options);
            }
            for (EnumOption o : options) {
                if (o.value == null || !o.value.equals(value)) continue;
                if (this.shouldUseSelectionDialog()) {
                    this.cmb.setInput(Arrays.asList(o));
                }
                this.cmb.setSelection((ISelection)new StructuredSelection((Object)o), true);
                return;
            }
            if (this.allowsCustomValues()) {
                ((ComboViewer)this.cmb).getCombo().setText(value);
                return;
            }
        }
        finally {
            this.inSet = false;
        }
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnumHelper() && this.getAttributes().isChildElementChooser()) {
            this.saveWhenChildElementChooser(node, props);
        } else {
            super.saveTo(node, props);
        }
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.cmb instanceof ComboViewer) {
            this.removeModifierListener();
        }
        if (this.isEnumHelper() && this.getAttributes().isChildElementChooser()) {
            this.loadWhenChildElementChooser(node, props);
            this.previousDefinitions = this.loadPreviousDefinitions(props);
        } else {
            super.loadFrom(node, props);
        }
        if (this.cmb instanceof ComboViewer) {
            this.addModifierListener();
        }
        this.refreshButtonStatus();
    }

    private void loadWhenChildElementChooser(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnabled) {
            List<EnumOption> options = this.calcOptions();
            Set keySet = props.getPropertyCollections().keySet();
            for (String propertyCollectionName : keySet) {
                for (EnumOption option : options) {
                    if (!StringUtils.isNotBlank((String)option.value) || !propertyCollectionName.contains(option.value)) continue;
                    this.setValue(option.value);
                    return;
                }
            }
            this.setValue("");
        }
    }

    private void saveWhenChildElementChooser(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnabled) {
            EnumOption option = this.getSelectedEnumOption();
            if (option != null && !option.isEmptyOption()) {
                this.clearPreviousDefinitions(props);
                PropertyCollection currentNestedElement = new PropertyCollection();
                currentNestedElement.setName(this.createId(this.value));
                currentNestedElement.setElement(MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)currentNestedElement, (int)this.getHelper().getXmlOrder()));
                props.addPropertyCollection(currentNestedElement.getName(), new PropertyCollectionMap(currentNestedElement));
            } else {
                this.clearPreviousDefinitions(props);
            }
        }
    }

    protected List<EnumOption> calcOptions(String valueToSet) {
        return this.calcOptions();
    }

    protected void onSelectionChange(boolean shouldNotify) {
        if (this.onSelectionChangeCalled || this.isDisposed()) {
            return;
        }
        try {
            IEditorSelectionListener listener2;
            AttributeHelper helper;
            AttributesPropertyPage parentPage;
            this.onSelectionChangeCalled = true;
            if (!this.inSet) {
                this.value = this.getValue();
            }
            if ((parentPage = this.getParentPage()) != null) {
                if (!this.inSet) {
                    this.value = this.getValue();
                }
                for (IFieldEditor f : parentPage.getEditors().values()) {
                    if (!(f instanceof AbstractFieldEditor)) continue;
                    AbstractFieldEditor fa = (AbstractFieldEditor)f;
                    fa.validate();
                }
                parentPage.validate();
            }
            if ((helper = this.getHelper()) instanceof IHasListener && (listener2 = ((IHasListener)((Object)helper)).getListener()) != null) {
                listener2.selectionChanged(this);
            }
            for (IPropertyValueChangeListener propertyValueChangeListener : this.getPropertyValueChangeListeners()) {
                propertyValueChangeListener.propertyChanged(helper.getId(), "", this.getValue());
            }
        }
        finally {
            this.onSelectionChangeCalled = false;
        }
    }

    private boolean isTypeChooser() {
        AttributeHelper helper = this.getHelper();
        if (helper instanceof EnumHelper) {
            EnumHelper enumHelper = (EnumHelper)helper;
            return enumHelper.isTypeChooser();
        }
        return false;
    }

    private List<IPropertyValueChangeListener> getPropertyValueChangeListeners() {
        if (this.propertyValueChangeListeners == null) {
            this.propertyValueChangeListeners = new ArrayList<IPropertyValueChangeListener>();
        }
        return this.propertyValueChangeListeners;
    }

    protected void notifyObservers() {
        for (IEditorValueModifiedListener valueModifiedListener : this.getValueModifiedListeners()) {
            valueModifiedListener.valueModified(this.getValue());
        }
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener listener) {
        this.getValueModifiedListeners().add(listener);
    }

    private Set<IEditorValueModifiedListener> getValueModifiedListeners() {
        if (this.valueModifiedListeners == null) {
            this.valueModifiedListeners = new HashSet<IEditorValueModifiedListener>();
        }
        return this.valueModifiedListeners;
    }

    public List<EnumOption> getOptions() {
        Object input = this.cmb.getInput();
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        if (input instanceof Object[]) {
            Object[] objectArray = (Object[])input;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                options.add((EnumOption)o);
                ++n2;
            }
            return options;
        }
        return null;
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return true;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private void updateContentProposals(List<EnumOption> options) {
        String[] proposals = new String[options.size()];
        int i = 0;
        while (i < options.size()) {
            String totalName;
            proposals[i] = totalName = this.getOptionText(options.get(i));
            ++i;
        }
        if (this.contentProposal != null) {
            this.contentProposal.setProposals(proposals);
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyValueChangeListener propertyListener) {
        this.getPropertyValueChangeListeners().add(propertyListener);
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
        this.getPropertyValueChangeListeners().clear();
    }

    private List<PropertyCollection> loadPreviousDefinitions(PropertyCollectionMap props) {
        ArrayList<PropertyCollection> previousDefinitions = new ArrayList<PropertyCollection>();
        PropertyCollection properties = props.asPropertyCollection();
        ChildElementAttributeHelper.sortNestedProperties(properties);
        List propertyCollections = properties.getPropertyCollections();
        for (PropertyCollection c : propertyCollections) {
            String name = c.getName();
            if (name == null || name.length() <= 0 || !name.startsWith("@")) continue;
            previousDefinitions.add(c);
        }
        return previousDefinitions;
    }

    private String createId(String definition) {
        return "@" + definition + ";0";
    }

    private void clearPreviousDefinitions(PropertyCollectionMap props) {
        for (PropertyCollection oldPropertyCollection : this.previousDefinitions) {
            oldPropertyCollection.setErased(true);
            props.addPropertyCollection(oldPropertyCollection.getName(), new PropertyCollectionMap(oldPropertyCollection));
        }
    }

    public boolean isButtonActionEnabled() {
        return this.buttonAction != null && this.buttonAction.isEnabled();
    }

    public boolean hasListenerMatching(Predicate<IEditorValueModifiedListener> predicate) {
        return this.getValueModifiedListeners().stream().anyMatch(predicate);
    }

    private final class PasteActionListener
    implements VerifyListener {
        private PasteActionListener() {
        }

        public void verifyText(VerifyEvent event) {
            String pasted = event.text;
            if (ScriptUtils.isScript((String)pasted)) {
                Display.getCurrent().asyncExec(() -> EnumFieldEditor.this.switchToExpression());
            }
        }
    }
}

