/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.onpositive.ide.ui.ControlDecoration;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.ExpressionWidget;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DateTimeAttributeHelper;

public class DateTimeFieldEditor
extends LabelledFieldEditor {
    private final DateTimeAttributeHelper helper;
    private final ExpressionWidget exprWidget;
    private final Composite calendarComposite;
    private final DateTime dateWidget;
    private final DateTime timeWidget;
    private boolean isExpression;
    private final Runnable switchToCalendars;
    private final Runnable switchToExprEditor;
    private final Runnable showError;
    private final Runnable hideError;

    public DateTimeFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        Composite mainComposite = (Composite)this.control;
        final Composite stackComposite = new Composite(mainComposite, 0);
        final StackLayout stackLayout = new StackLayout();
        stackLayout.marginHeight = 0;
        stackLayout.marginWidth = 0;
        stackComposite.setLayout((Layout)stackLayout);
        GridData stackGridData = new GridData();
        stackGridData.grabExcessHorizontalSpace = true;
        stackGridData.horizontalAlignment = 4;
        stackGridData.horizontalIndent = 0;
        stackComposite.setLayoutData((Object)stackGridData);
        if (!(atr instanceof DateTimeAttributeHelper)) {
            throw new IllegalArgumentException();
        }
        this.calendarComposite = new Composite(stackComposite, 0);
        FillLayout fillLayout = new FillLayout();
        this.calendarComposite.setLayout((Layout)fillLayout);
        final Composite exprEditComposite = new Composite(stackComposite, 0);
        GridLayout gridLayoutForExprEdit = new GridLayout();
        exprEditComposite.setLayout((Layout)gridLayoutForExprEdit);
        this.helper = (DateTimeAttributeHelper)atr;
        DateTimeAttributeHelper.InputType inputType = this.helper.getInputType();
        if (inputType == DateTimeAttributeHelper.InputType.DATE || inputType == DateTimeAttributeHelper.InputType.DATETIME) {
            this.dateWidget = new DateTime(this.calendarComposite, 2084);
            this.dateWidget.setDate(2012, 0, 1);
            this.dateWidget.pack();
        } else {
            this.dateWidget = null;
        }
        if (inputType == DateTimeAttributeHelper.InputType.TIME || inputType == DateTimeAttributeHelper.InputType.DATETIME) {
            this.timeWidget = new DateTime(this.calendarComposite, 2180);
            this.timeWidget.setTime(0, 0, 0);
            this.timeWidget.pack();
        } else {
            this.timeWidget = null;
        }
        this.exprWidget = new ExpressionWidget(ctx);
        this.exprWidget.createPartControl(exprEditComposite);
        this.resizeWidgetToSingleLine(exprEditComposite);
        ToolBarManager toolBar = new ToolBarManager();
        final Action switchAction = new Action("Switch"){

            public void run() {
                if (stackLayout.topControl == DateTimeFieldEditor.this.calendarComposite) {
                    DateTimeFieldEditor.this.switchToExprEditor.run();
                } else {
                    DateTimeFieldEditor.this.switchToCalendars.run();
                }
            }
        };
        switchAction.setImageDescriptor(MuleImages.DESC_EDIT);
        switchAction.setDisabledImageDescriptor(MuleImages.DESC_EDIT_DISABLED);
        toolBar.add((IAction)switchAction);
        toolBar.createControl(mainComposite);
        this.switchToCalendars = new Runnable(){
            final Parser[] parsers;
            boolean errorMessageIsNeeded;
            {
                this.parsers = new Parser[]{new FormatParser(DateTimeFieldEditor.this.helper.getSimpleDateFormat()), new FormatParser("dd.MM.yy HH:mm"), new FormatParser("dd.MM.yy"), new FormatParser("dd/MM/yy"), new FormatParser("HH:mm"), new FormatParser("EEE MMM dd HH:mm:ss zzz yyyy")};
                this.errorMessageIsNeeded = false;
            }

            boolean showDateTimeInCalendar(String value) {
                MessageDialog dialog;
                this.errorMessageIsNeeded = false;
                if (value.equals("")) {
                    return true;
                }
                if (!ExpressionUtils.isExpressionOrProperty((String)value)) {
                    Parser[] parserArray = this.parsers;
                    int n = this.parsers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Parser parser = parserArray[n2];
                        Calendar calendar = parser.parse(value);
                        if (calendar != null) {
                            if (DateTimeFieldEditor.this.timeWidget != null) {
                                int hour = calendar.get(10);
                                int minute = calendar.get(12);
                                int second = calendar.get(13);
                                DateTimeFieldEditor.this.timeWidget.setTime(hour, minute, second);
                            }
                            if (DateTimeFieldEditor.this.dateWidget != null) {
                                int year = calendar.get(1);
                                int month = calendar.get(2);
                                int day = calendar.get(5);
                                DateTimeFieldEditor.this.dateWidget.setDate(year, month, day);
                            }
                            return true;
                        }
                        ++n2;
                    }
                }
                this.errorMessageIsNeeded = (dialog = new MessageDialog(DateTimeFieldEditor.this.getControl().getShell(), "Warning", null, "Warning: going to calendar picker mode will make you lose your expression.", 4, new String[]{"Ok", "Cancel"}, 4)).open() == 0;
                return this.errorMessageIsNeeded;
            }

            boolean getDateTimeFromEditorAndShowItInCalendar() {
                String text = DateTimeFieldEditor.this.exprWidget.getText();
                return this.showDateTimeInCalendar(text);
            }

            @Override
            public void run() {
                if (!this.getDateTimeFromEditorAndShowItInCalendar()) {
                    return;
                }
                switchAction.setText("Switch to expression editor");
                stackLayout.topControl = DateTimeFieldEditor.this.calendarComposite;
                stackComposite.layout();
                if (this.errorMessageIsNeeded) {
                    DateTimeFieldEditor.this.showError.run();
                }
                DateTimeFieldEditor.this.isExpression = false;
            }

            class FormatParser
            extends Parser {
                final SimpleDateFormat format;

                FormatParser(String format) {
                    this.format = new SimpleDateFormat(format);
                }

                FormatParser(SimpleDateFormat format) {
                    this.format = format;
                }

                @Override
                Calendar parse(String s) {
                    ParsePosition parsePosition = new ParsePosition(0);
                    Date date = this.format.parse(s, parsePosition);
                    if (date == null) {
                        return null;
                    }
                    if (parsePosition.getIndex() != s.length()) {
                        return null;
                    }
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(date);
                    return calendar;
                }
            }

            abstract class Parser {
                Parser() {
                }

                abstract Calendar parse(String var1);
            }
        };
        this.switchToExprEditor = new Runnable(){

            void getDateTimeFromCalendarAndShowItInEditor() {
                String text = DateTimeFieldEditor.this.getDateTimeFromCalendar();
                DateTimeFieldEditor.this.exprWidget.setText(text);
            }

            @Override
            public void run() {
                switchAction.setText("Switch to date picker");
                stackLayout.topControl = exprEditComposite;
                stackComposite.layout();
                this.getDateTimeFromCalendarAndShowItInEditor();
                DateTimeFieldEditor.this.isExpression = true;
                DateTimeFieldEditor.this.hideError.run();
            }
        };
        switchAction.setText("Switch to date picker");
        stackLayout.topControl = exprEditComposite;
        stackComposite.layout();
        this.isExpression = true;
        final ControlDecoration decoration = new ControlDecoration((Control)this.calendarComposite, 16512);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        decoration.setDescriptionText("The expression value is lost");
        decoration.hide();
        this.showError = new Runnable(){

            @Override
            public void run() {
                decoration.show();
            }
        };
        this.hideError = new Runnable(){

            @Override
            public void run() {
                decoration.hide();
            }
        };
    }

    private void resizeWidgetToSingleLine(Composite exprEditComposite) {
        Point size = this.calculateSizeOfTextWidget(exprEditComposite);
        GridData dataToSetYAndFillHorizontalSpace = new GridData(-1, size.y);
        dataToSetYAndFillHorizontalSpace.grabExcessHorizontalSpace = true;
        dataToSetYAndFillHorizontalSpace.horizontalAlignment = 4;
        dataToSetYAndFillHorizontalSpace.horizontalIndent = 0;
        this.exprWidget.getTextWidget().getParent().getParent().setLayoutData((Object)dataToSetYAndFillHorizontalSpace);
    }

    private Point calculateSizeOfTextWidget(Composite parent) {
        Text textToCalculateSizeOfWidget = new Text(parent, 0);
        Point sizeOfWidget = textToCalculateSizeOfWidget.computeSize(-1, -1);
        textToCalculateSizeOfWidget.dispose();
        return sizeOfWidget;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        return this.createMainComposite(parent);
    }

    private Composite createMainComposite(Composite parent) {
        Composite mainComposite = new Composite(parent, 0x1000000);
        GridLayout twoColumnsLayout = new GridLayout(2, false);
        twoColumnsLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)twoColumnsLayout);
        return mainComposite;
    }

    @Override
    public String getValue() {
        if (this.isExpression) {
            return this.exprWidget.getText();
        }
        return this.getDateTimeFromCalendar();
    }

    private String getDateTimeFromCalendar() {
        int year = this.dateWidget != null ? this.dateWidget.getYear() : 0;
        int month = this.dateWidget != null ? this.dateWidget.getMonth() : 0;
        int day = this.dateWidget != null ? this.dateWidget.getDay() : 0;
        int hrs = this.timeWidget != null ? this.timeWidget.getHours() : 0;
        int min = this.timeWidget != null ? this.timeWidget.getMinutes() : 0;
        int sec = this.timeWidget != null ? this.timeWidget.getSeconds() : 0;
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hrs, min, sec);
        Date date = calendar.getTime();
        SimpleDateFormat format = this.helper.getSimpleDateFormat();
        return format.format(date);
    }

    @Override
    public void setValue(String value) {
        if (value.length() != 0) {
            this.exprWidget.setText(value);
            this.switchToCalendars.run();
        }
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

