/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.DateTimeParser;
import org.mule.tooling.ui.modules.core.widgets.editors.FormatParser;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.ExpressionWidget;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DateTimeAttributeHelper;

public class DateTimeEditor
extends AbstractFieldEditor {
    private final DateTimeAttributeHelper helper;
    private final DateTimeParser[] parsers;
    private boolean isInExpressionMode;
    private boolean isEnabled;
    private Runnable refreshRadio;
    private Runnable refresh;
    private Runnable setEnabled;
    private DateTime date;
    private DateTime time;
    private ExpressionWidget expression;
    private boolean changed = false;

    public DateTimeEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        this.helper = (DateTimeAttributeHelper)atr;
        this.parsers = new DateTimeParser[]{new FormatParser(this.helper.getSimpleDateFormat()), new FormatParser("dd.MM.yy HH:mm"), new FormatParser("dd.MM.yy"), new FormatParser("dd/MM/yy"), new FormatParser("HH:mm"), new FormatParser("EEE MMM dd HH:mm:ss zzz yyyy")};
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.setEnabled.run();
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite grid = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        GridData gridLayoutData = GridDataFactory.fillDefaults().grab(true, false).create();
        grid.setLayoutData((Object)gridLayoutData);
        grid.setLayout((Layout)gridLayout);
        final Button datetimeMode = new Button(grid, 16);
        datetimeMode.setText("Date \\ Time:");
        Composite datetime = new Composite(grid, 0);
        GridData datetimeLayoutData = GridDataFactory.fillDefaults().grab(true, false).create();
        FillLayout datetimeLayout = new FillLayout();
        datetime.setLayoutData((Object)datetimeLayoutData);
        datetime.setLayout((Layout)datetimeLayout);
        this.date = new DateTime(datetime, 2084);
        SelectionAdapter calendarChangingHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeEditor.this.changed = true;
                DateTimeEditor.this.refreshExpressionValue();
            }
        };
        this.date.addSelectionListener((SelectionListener)calendarChangingHandler);
        this.date.pack();
        this.time = new DateTime(datetime, 2180);
        this.time.addSelectionListener((SelectionListener)calendarChangingHandler);
        this.time.pack();
        final Button expressionMode = new Button(grid, 16);
        expressionMode.setText("Expression: ");
        GridData expressionLayoutData = GridDataFactory.copyData((GridData)datetimeLayoutData);
        this.expression = new ExpressionWidget(this.context);
        this.expression.createPartControl(grid);
        this.expression.getControl().setLayoutData((Object)expressionLayoutData);
        this.resizeWidgetToSingleLine(grid);
        this.expression.setText("#[]");
        this.expression.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent arg0) {
                DateTimeEditor.this.support.firePropertyChange("value", null, DateTimeEditor.this.getValue());
            }
        });
        this.isInExpressionMode = false;
        this.refreshRadio = new Runnable(){

            @Override
            public void run() {
                DateTimeEditor.this.support.firePropertyChange("value", null, DateTimeEditor.this.getValue());
                expressionMode.setSelection(DateTimeEditor.this.isInExpressionMode);
                datetimeMode.setSelection(!DateTimeEditor.this.isInExpressionMode);
            }
        };
        this.refresh = new Runnable(){

            @Override
            public void run() {
                DateTimeEditor.this.refreshRadio.run();
                DateTimeEditor.this.date.setEnabled(!DateTimeEditor.this.isInExpressionMode);
                DateTimeEditor.this.time.setEnabled(!DateTimeEditor.this.isInExpressionMode);
                DateTimeEditor.this.expression.getControl().setEnabled(DateTimeEditor.this.isInExpressionMode);
                Control c = DateTimeEditor.this.expression.getTextWidget();
                c.setEnabled(DateTimeEditor.this.isInExpressionMode);
                if (c instanceof StyledText) {
                    Color backgroundColor = Display.getCurrent().getSystemColor(DateTimeEditor.this.isInExpressionMode ? 25 : 22);
                    StyledText styledText = (StyledText)c;
                    styledText.setBackground(backgroundColor);
                }
            }
        };
        this.setEnabled = new Runnable(){

            @Override
            public void run() {
                expressionMode.setEnabled(DateTimeEditor.this.isEnabled);
                datetimeMode.setEnabled(DateTimeEditor.this.isEnabled);
                if (DateTimeEditor.this.isEnabled) {
                    DateTimeEditor.this.refresh.run();
                } else {
                    DateTimeEditor.this.date.setEnabled(false);
                    DateTimeEditor.this.time.setEnabled(false);
                    DateTimeEditor.this.expression.getControl().setEnabled(false);
                    Control c = DateTimeEditor.this.expression.getTextWidget();
                    c.setEnabled(DateTimeEditor.this.isInExpressionMode);
                    if (c instanceof StyledText) {
                        Color backgroundColor = Display.getCurrent().getSystemColor(22);
                        StyledText styledText = (StyledText)c;
                        styledText.setBackground(backgroundColor);
                    }
                }
            }
        };
        datetimeMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeEditor.this.changed = true;
                DateTimeEditor.this.isInExpressionMode = !datetimeMode.getSelection();
                DateTimeEditor.this.refresh.run();
            }
        });
        expressionMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeEditor.this.changed = true;
                DateTimeEditor.this.isInExpressionMode = expressionMode.getSelection();
                DateTimeEditor.this.refresh.run();
            }
        });
        datetimeMode.setSelection(true);
        return grid;
    }

    private void refreshExpressionValue() {
        this.support.firePropertyChange("value", null, this.getValue());
        this.expression.setText(this.getDateAndTimeFromCalendar());
    }

    @Override
    public String getValue() {
        if (!this.isEnabled || !this.changed) {
            return "";
        }
        if (this.isInExpressionMode) {
            String text = this.expression.getText();
            if (text.equals("#[]")) {
                return "";
            }
            return text;
        }
        return this.getDateAndTimeFromCalendar();
    }

    private String getDateAndTimeFromCalendar() {
        int year = this.date.getYear();
        int month = this.date.getMonth();
        int day = this.date.getDay();
        int hrs = this.time.getHours();
        int min = this.time.getMinutes();
        int sec = this.time.getSeconds();
        GregorianCalendar calendar = new GregorianCalendar(year, month, day, hrs, min, sec);
        Date date = calendar.getTime();
        SimpleDateFormat format = this.helper.getSimpleDateFormat();
        return format.format(date);
    }

    @Override
    public void setValue(String value) {
        if (value.equals("")) {
            return;
        }
        this.changed = true;
        this.expression.setText(value);
        this.isInExpressionMode = ExpressionUtils.isExpressionOrProperty((String)value);
        if (!this.isInExpressionMode) {
            boolean parsed = false;
            DateTimeParser[] dateTimeParserArray = this.parsers;
            int n = this.parsers.length;
            int n2 = 0;
            while (n2 < n) {
                DateTimeParser parser = dateTimeParserArray[n2];
                Calendar calendar = parser.parse(value);
                if (calendar != null) {
                    int hour = calendar.get(10);
                    int minute = calendar.get(12);
                    int second = calendar.get(13);
                    this.time.setTime(hour, minute, second);
                    int year = calendar.get(1);
                    int month = calendar.get(2);
                    int day = calendar.get(5);
                    this.date.setDate(year, month, day);
                    parsed = true;
                    break;
                }
                ++n2;
            }
            if (!parsed) {
                this.isInExpressionMode = true;
            }
        }
        this.refreshRadio.run();
    }

    private void resizeWidgetToSingleLine(Composite exprEditComposite) {
        Point size = this.calculateSizeOfTextWidget(exprEditComposite);
        GridData dataToSetYAndFillHorizontalSpace = new GridData(-1, size.y);
        dataToSetYAndFillHorizontalSpace.grabExcessHorizontalSpace = true;
        dataToSetYAndFillHorizontalSpace.horizontalAlignment = 4;
        dataToSetYAndFillHorizontalSpace.horizontalIndent = 0;
        this.expression.getTextWidget().getParent().getParent().setLayoutData((Object)dataToSetYAndFillHorizontalSpace);
    }

    private Point calculateSizeOfTextWidget(Composite parent) {
        Text textToCalculateSizeOfWidget = new Text(parent, 0);
        Point sizeOfWidget = textToCalculateSizeOfWidget.computeSize(-1, -1);
        textToCalculateSizeOfWidget.dispose();
        return sizeOfWidget;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

