/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.client.api.KeyValuePairsResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.ExpressionWrapperFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.PairLabelProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.table.MapTableComposite;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;

public class DWPropertiesFieldEditor
extends ExpressionWrapperFieldEditor {
    private static final String SEPARATOR = "---";
    private static final String OUTPUT_APPLICATION_JAVA = "output application/java";
    private static final String WARNING_MESSAGE = "Couldn't read key-values any change in table will overwrite value";
    private static final String CONVERT_TO_TABLE_TITLE = "Warning";
    private static final String CONVERT_TO_TABLE_EDITOR_WARNING = "Converting this expression to table format may result in loss of data. Convert the expression?";
    private MapTableComposite table;
    private boolean invalidLoading;
    private String expressionValue;

    public DWPropertiesFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visitDefault(this);
    }

    @Override
    public void setLiteralValue(String literalValue) {
        this.loadScript(literalValue);
        if (this.invalidLoading) {
            this.expressionValue = literalValue;
        }
    }

    @Override
    public String getLiteralValue() {
        return this.invalidLoading ? this.expressionValue : this.getScriptFromTable(this.table.getInputData());
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.loadTable(props);
    }

    @Override
    protected void showLiteralEditor() {
        if (this.canSwitchToTable()) {
            super.showLiteralEditor();
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean goToTable = MessageDialog.openQuestion((Shell)shell, (String)CONVERT_TO_TABLE_TITLE, (String)CONVERT_TO_TABLE_EDITOR_WARNING);
            if (goToTable) {
                this.setValue("");
                this.invalidLoading = false;
                super.showLiteralEditor();
            } else {
                this.setExpressionSwitcherSelection(true);
            }
        }
        AnalyticsRecordsFactory.single((String)(this.isExpressionSelected() ? Events.SWITCH_EXPRESSION_TO_DW_TABLE : Events.SWITCH_DW_TABLE_TO_EXPRESSION), (IMuleProject)this.getContext().getProject()).track();
    }

    private boolean canSwitchToTable() {
        return !this.isExpressionSelected() && !this.invalidLoading;
    }

    private void loadTable(PropertyCollectionMap props) {
        String script = props.getProperty(this.getHelper().getId(), "");
        if (StringUtils.isBlank((CharSequence)script)) {
            return;
        }
        this.loadScript(script);
        if (this.invalidLoading) {
            this.expressionValue = script;
            this.switchToExpression();
        }
    }

    private void loadScript(String script) {
        Map<String, String> result = this.processScript((String)(this.isExpression(script) ? script : "#[" + script + "]"));
        this.table.setInputData(result);
    }

    private boolean isExpression(String script) {
        return ExpressionUtils.isExpression((String)script) || StringUtils.startsWith((CharSequence)script, (CharSequence)"#[") && StringUtils.endsWith((CharSequence)script, (CharSequence)"]");
    }

    private Map<String, String> processScript(String script) {
        Map<String, String> keyValues = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)script) && !"#[]".equals(script)) {
            try {
                KeyValuePairsResult result = WeaveEngineHelperManager.parseKeyValuePairs((String)script.substring(2, script.length() - 1));
                if (this.parsedSuccessfully(script, result)) {
                    Optional keyValuePairs = result.getKeyValuePairs();
                    if (keyValuePairs.isPresent()) {
                        keyValues = (Map)keyValuePairs.get();
                    }
                    this.invalidLoading = false;
                } else {
                    this.invalidLoading = true;
                    MuleCorePlugin.logWarning((String)"Couldn't parse DW script as KeyValue pairs");
                }
            }
            catch (Error ex) {
                this.invalidLoading = true;
                MuleCorePlugin.logError((String)"Couldn't parse DW script as KeyValue pairs", (Throwable)ex);
            }
            this.processWarningMessage(this.invalidLoading);
        }
        return keyValues;
    }

    private boolean parsedSuccessfully(String script, KeyValuePairsResult result) {
        return result.isSuccess() && StringUtils.equals((CharSequence)script, (CharSequence)this.getScriptFromTable((Map)result.getKeyValuePairs().get()));
    }

    private void processWarningMessage(boolean loadingFail) {
        if (loadingFail) {
            this.showTabWarning(WARNING_MESSAGE);
        } else {
            this.showTabWarning("");
        }
    }

    private String getScriptFromTable(Map<String, String> inputData) {
        if (inputData.isEmpty()) {
            return "";
        }
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("#[").append(OUTPUT_APPLICATION_JAVA).append(System.lineSeparator()).append(SEPARATOR).append(System.lineSeparator()).append("{").append(System.lineSeparator());
        int i = 1;
        for (Map.Entry<String, String> keyValue : inputData.entrySet()) {
            String value = StringUtils.isBlank((CharSequence)keyValue.getValue()) ? "\"\"" : keyValue.getValue();
            String key = StringUtils.isBlank((CharSequence)keyValue.getKey()) ? "\"\"" : keyValue.getKey();
            scriptBuilder.append("\t").append(key).append(" : ").append(value);
            if (i < inputData.size()) {
                scriptBuilder.append(",");
            }
            ++i;
            scriptBuilder.append(System.lineSeparator());
        }
        scriptBuilder.append("}").append("]");
        return scriptBuilder.toString();
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        Group wrapper;
        if (!this.isDisplayedInTabs()) {
            wrapper = new Group(parent, 0);
            wrapper.setText(this.getHelper().getCaption());
        } else {
            wrapper = new Composite(parent, 0);
        }
        GridLayoutFactory.fillDefaults().applyTo((Composite)wrapper);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)wrapper);
        this.createTable((Composite)wrapper);
        return wrapper;
    }

    @Override
    protected int getHeightHint(Composite wrapper) {
        return WidgetUtils.getLinesHeightInPixels((Control)wrapper, (int)5);
    }

    private boolean isDisplayedInTabs() {
        return StringUtils.isNotBlank((CharSequence)this.getHelper().getParent());
    }

    private void createTable(Composite tableComposite) {
        this.table = new MapTableComposite(tableComposite, 4, new String[]{"Name", "Value"}){

            public void refreshTableViewer() {
                super.refreshTableViewer();
                DWPropertiesFieldEditor.this.validateTable();
            }
        };
        this.table.setDefaultInputKey("\"Key\"");
        this.table.setDefaultInputValue("\"Value\"");
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, this.getHeightHint((Composite)this.table)).applyTo((Control)this.table);
        final CellEditor[] cellEditors = this.table.getTableViewer().getCellEditors();
        int i = 0;
        while (i < cellEditors.length) {
            final int cell = i++;
            cellEditors[cell].addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (newValidState) {
                        String actualValue = (String)cellEditors[cell].getValue();
                        this.fireModifyEvent(actualValue);
                    }
                }

                public void cancelEditor() {
                }

                public void applyEditorValue() {
                }

                private void fireModifyEvent(Object newValue) {
                    Object selected = ((IStructuredSelection)DWPropertiesFieldEditor.this.table.getTableViewer().getSelection()).getFirstElement();
                    if (selected instanceof MapTableComposite.Pair) {
                        if (cell == 0) {
                            ((MapTableComposite.Pair)selected).setKey(String.valueOf(newValue));
                        } else {
                            ((MapTableComposite.Pair)selected).setValue(String.valueOf(newValue));
                        }
                        DWPropertiesFieldEditor.this.validateTable();
                    }
                }
            });
        }
        this.table.getTableViewer().setComparator(null);
        this.table.getTableViewer().setLabelProvider((IBaseLabelProvider)new PairLabelProvider(this.table));
        this.table.getTableViewer().setCellModifier((ICellModifier)new MapTableComposite.PairCellModifier(this.table){

            protected void onSetKey(Object data, Object value) {
                super.onSetKey(data, value);
                DWPropertiesFieldEditor.this.invalidLoading = false;
            }

            protected void onSetValue(Object data, Object value) {
                super.onSetValue(data, value);
                DWPropertiesFieldEditor.this.invalidLoading = false;
            }
        });
    }

    protected void validateTable() {
        Map inputData = this.table.getInputData();
        String message = "";
        if (this.hasRepeatedKeys()) {
            message = "There are repeated keys.";
        } else {
            for (Map.Entry keyValue : inputData.entrySet()) {
                String wrongKeyValue = this.validateKeyValue((String)keyValue.getKey(), (String)keyValue.getValue());
                if (!StringUtils.isNotBlank((CharSequence)wrongKeyValue)) continue;
                message = wrongKeyValue;
                break;
            }
        }
        this.showTabWarning(message);
    }

    private void showTabWarning(String message) {
        CTabItem actualTab;
        if (this.isDisplayedInTabs() && (actualTab = this.getActualTab()) != null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                if (!this.invalidLoading) {
                    actualTab.setImage(null);
                    actualTab.setToolTipText("");
                }
            } else {
                actualTab.setImage(WidgetsImages.getImage((String)"icons/errors/warning.png"));
                actualTab.setToolTipText(message);
            }
        }
    }

    private boolean hasRepeatedKeys() {
        ArrayList input = (ArrayList)this.table.getTableViewer().getInput();
        HashSet<String> set = new HashSet<String>();
        if (input != null) {
            for (MapTableComposite.Pair pair : input) {
                if (set.add(pair.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private String validateKeyValue(String k, String v) {
        boolean emptyKey = StringUtils.isBlank((CharSequence)k);
        boolean emptyValue = StringUtils.isBlank((CharSequence)v);
        if (emptyKey) {
            return "Key not defined";
        }
        if (emptyValue) {
            return "Value not defined";
        }
        return "";
    }

    private CTabItem getActualTab() {
        CTabFolder tabFolder = this.getTabFolder();
        CTabItem[] tabs = tabFolder.getItems();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].getData("ID").equals(this.getHelper().getParent())) {
                return tabs[i];
            }
            ++i;
        }
        return null;
    }

    private CTabFolder getTabFolder() {
        Composite parent = this.control.getParent();
        while (parent != null) {
            if (parent instanceof CTabFolder) {
                return (CTabFolder)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

