/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.mule.tooling.client.api.extension.model.ErrorModel;
import org.mule.tooling.client.api.extension.model.ErrorModelBuilder;
import org.mule.tooling.core.module.contribution.ErrorModelMapper;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesProvider;

public class CustomErrorModelFactory {
    public static final String ERROR_SEPARATOR = ":";

    private CustomErrorModelFactory() {
    }

    public static org.mule.tooling.core.module.contribution.ErrorModel createErrorFrom(String error) {
        String id = CustomErrorModelFactory.getId(error);
        String namespace = CustomErrorModelFactory.getNamespace(error);
        ErrorModelBuilder customError = ErrorModelBuilder.newError((String)id, (String)namespace);
        if (!CustomErrorModelFactory.isAnyError(id, namespace)) {
            customError.withParent(ErrorTypesProvider.ANY_ERROR_TOOLING_MODEL);
        }
        return ErrorModelMapper.toErrorModel((ErrorModel)customError.build());
    }

    private static String getId(String error) {
        boolean notCore = error.contains(ERROR_SEPARATOR);
        String identifier = error;
        if (notCore) {
            int indexOf = error.indexOf(ERROR_SEPARATOR);
            identifier = error.substring(indexOf + 1, error.length());
        }
        return identifier;
    }

    private static String getNamespace(String error) {
        boolean notCore = error.contains(ERROR_SEPARATOR);
        String namespace = "MULE";
        if (notCore) {
            int indexOf = error.indexOf(ERROR_SEPARATOR);
            namespace = error.substring(0, indexOf);
        }
        return namespace;
    }

    private static boolean isAnyError(String id, String namespace) {
        return ErrorTypesProvider.ANY_ERROR_MODEL.getType().equals(id) && ErrorTypesProvider.ANY_ERROR_MODEL.getNamespace().equals(namespace);
    }
}

