/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.MetadataRetrievalManager;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.IElementBasedInitializable;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.w3c.dom.Element;

public class ConfiglessMetadataTypesCalculator
implements IOptionsCalculator,
IElementBasedInitializable {
    private List<String> keyComponents = new ArrayList<String>();

    @Override
    public List<EnumOption> options(AbstractFieldEditor editor, IMessageFlowNode currentNode) {
        try {
            AttributesPropertyPage attributesPropertyPage;
            MessageFlowEditor flowEditorFromActivePage;
            if (currentNode != null && (flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage()) != null && (attributesPropertyPage = editor.getParentPage()) != null) {
                List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(editor);
                IMessageFlowNode updatedCurrentNode = MessageFlowUtils.getMessageFlowNodeWithUpdatedProperties((IMessageFlowNode)currentNode, pages);
                String key = MetadataHelpers.getMetadataCacheKey(currentNode);
                IMuleProject muleProject = flowEditorFromActivePage.getMuleProject();
                MuleConfiguration muleConfiguration = flowEditorFromActivePage.getMuleConfiguration();
                String componentPath = muleConfiguration.getPathsCache().getPath((IMessageFlowEntity)currentNode, muleProject).toPath();
                return MetadataRetrievalManager.getConfiglessEnumOptionsMetadataKeys(muleProject, muleConfiguration, currentNode, updatedCurrentNode, key, true, this.keyComponents, componentPath, editor.getHelper().getId());
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error getting DataSense types...", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public void init(Element element) {
        String keyParts = element.getAttribute("keyParts");
        if (StringUtils.isNotEmpty((String)keyParts)) {
            String[] parts;
            String[] stringArray = parts = keyParts.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.keyComponents.add(part);
                ++n2;
            }
        }
    }
}

