/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.ObservableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ClassNameAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.utils.JavaFactory;

public class ClassNameFieldEditor
extends LabelledFieldEditor
implements IEditorValueModifiedObservable {
    private Composite parentChild;
    private Text text;
    private DropTarget dropTarget;
    private Action addClassAction;
    private Action browseClassAction;

    public Control getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public ClassNameFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        this.registerComponent(ObservableEditor.class, new ObservableEditor());
    }

    @Override
    protected Control getInfoDecorationControl() {
        return this.text;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.parentChild = new Composite(parent, 0);
        this.parentChild.addDisposeListener(event -> this.dropTarget.dispose());
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(this.parentChild);
        GridData gd = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create();
        this.text = new Text(this.parentChild, 2048);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(event -> {
            this.doValidate();
            if (!this.isLoading()) {
                this.getComponent(ObservableEditor.class).ifPresent(x -> x.valueModified(this.text.getText()));
            }
        });
        this.dropTarget = new DropTarget((Control)this.text, 1);
        this.dropTarget.setTransfer(new Transfer[]{ResourceTransfer.getInstance(), PluginTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                IResource[] fileList = null;
                ResourceTransfer ft = ResourceTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType) && (fileList = (IResource[])event.data).length == 1) {
                    ClassNameFieldEditor.this.setValueFromFullClassName(fileList[0]);
                }
            }
        });
        Composite cm = new Composite(this.parentChild, 0);
        GridLayout ll = new GridLayout(1, false);
        ll.marginWidth = 2;
        ll.marginHeight = 0;
        cm.setLayout((Layout)ll);
        ToolBarManager tman = new ToolBarManager();
        if (this.getHelper() instanceof ClassNameAttributeHelper) {
            final ClassNameAttributeHelper classNameAttributeHelper = (ClassNameAttributeHelper)this.getHelper();
            this.addClassAction = new Action("Add Java class"){

                public void run() {
                    AttributesPropertyPage page = ClassNameFieldEditor.this.getParentPage();
                    IMuleProject project = page.getContext().getProject();
                    JavaFactory javaClassFactory = (JavaFactory)classNameAttributeHelper.getValueFactory();
                    IType createdClass = javaClassFactory.getCreatedClass(project.getProject());
                    if (createdClass != null) {
                        ClassNameFieldEditor.this.setValue(createdClass.getFullyQualifiedName());
                        ClassNameFieldEditor.this.setSelectedType(createdClass);
                    }
                }
            };
            this.addClassAction.setImageDescriptor(MuleImages.DESC_ADD);
            this.addClassAction.setDisabledImageDescriptor(MuleImages.DESC_ADD_DISABLED);
            tman.add((IAction)this.addClassAction);
            cm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).span(3, 1).create());
        }
        if (this.getHelper().getValueFactory() != null) {
            this.browseClassAction = new Action("Browse for Java class"){

                public void run() {
                    Object selectedValue = ClassNameFieldEditor.this.getHelper().getValueFactory().getValue(ClassNameFieldEditor.this.context);
                    if (selectedValue != null) {
                        if (selectedValue instanceof String) {
                            ClassNameFieldEditor.this.setValue(ClassNameFieldEditor.this.calculateValue(selectedValue.toString()));
                        } else if (selectedValue instanceof IType) {
                            IType type = (IType)selectedValue;
                            ClassNameFieldEditor.this.setValue(type.getFullyQualifiedName());
                            ClassNameFieldEditor.this.setSelectedType(type);
                        }
                    }
                }
            };
            this.browseClassAction.setImageDescriptor(MuleImages.DESC_SEARCH);
            this.browseClassAction.setDisabledImageDescriptor(MuleImages.DESC_SEARCH_DISABLED);
            tman.add((IAction)this.browseClassAction);
        }
        tman.createControl(cm);
        return this.parentChild;
    }

    private void setValueFromFullClassName(IResource file) {
        ICompilationUnit compilationUnit;
        IType type;
        IJavaElement javaElement = JavaCore.create((IResource)file);
        if (javaElement instanceof ICompilationUnit && (type = (compilationUnit = (ICompilationUnit)javaElement).findPrimaryType()) != null) {
            String name = type.getFullyQualifiedName();
            this.setValue(name);
        }
    }

    @Override
    public String getValue() {
        Text t = this.text;
        return t.getText();
    }

    @Override
    public void setValue(String value) {
        Text t = this.text;
        t.setText(value);
    }

    @Override
    protected void setInternalControlEnabled(boolean enabled) {
        if (this.addClassAction != null) {
            this.addClassAction.setEnabled(enabled);
        }
        if (this.browseClassAction != null) {
            this.browseClassAction.setEnabled(enabled);
        }
        this.text.setEnabled(enabled);
    }

    @Override
    protected void createExtraContent(Composite parent) {
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener observer) {
        this.getComponent(ObservableEditor.class).ifPresent(x -> x.addListener(observer));
    }
}

