/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ILayoutPropertiesEditorRequested;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.Severity;
import org.mule.tooling.messageflow.dialog.HelpSystemConnector;
import org.mule.tooling.messageflow.dialog.HostAdapter;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertiesMap;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementDialog;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementWizard;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.utils.DelayedRunnableScheduler;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class ChildElementWizardPage
extends WizardPage
implements IWizardPage {
    private static final Message OK_MESSAGE = MessageBuilder.newMessage((String)"", (Severity)Severity.NONE).build();
    private static final WeakHashMap<AttributesPropertyPage, String> ids = new WeakHashMap();
    protected NestedDefinition definition;
    protected IMuleProject project;
    private final ChildElementDialog.FinishButtonCallbacks callbacks;
    private IMessageFlowNode node;
    private EventBusHelper busHelper = new EventBusHelper();
    private DelayedRunnableScheduler relayoutRequestScheduler = new DelayedRunnableScheduler(10);
    protected ArrayList<AttributesPropertyPage> pages = new ArrayList();
    protected Composite parent;
    PropertyCollection collection;
    private TabFolder tf;

    public ChildElementWizardPage(IMuleProject project2, NestedDefinition nestedDefinition, ChildElementDialog.FinishButtonCallbacks callbacks) {
        super("def");
        this.project = project2;
        this.definition = nestedDefinition;
        this.callbacks = callbacks;
        if (this.definition != null) {
            this.setTitle(this.definition.getName());
            this.setMessage(this.definition.getDescription());
        } else {
            this.setTitle("No matches for your global type");
            this.setMessage("No definitions found for the selected type");
        }
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        if (this.definition != null) {
            HelpSystemConnector.connect((Composite)this.getWizard().getContainer().getShell(), (NodeDefinition)this.definition);
        }
    }

    public void createControl(final Composite parent) {
        Point correctSize;
        this.parent = parent;
        this.busHelper.unregisterWith((Widget)parent);
        this.busHelper.registerListener(UtilsPlugin.getEventBus(), CoreEventTypes.LAYOUT_PROPERTIES_EDITOR_REQUEST, (IEventHandler)new ILayoutPropertiesEditorRequested(){

            public void onLayoutRequested() {
                ChildElementWizardPage.this.relayoutRequestScheduler.schedule(() -> {
                    if (!parent.isDisposed()) {
                        parent.layout(true, true);
                    }
                });
            }
        });
        if (this.definition == null) {
            parent.setRedraw(false);
            Composite m = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            m.setLayout((Layout)layout);
            this.setControl((Control)m);
            parent.setRedraw(true);
            return;
        }
        this.pages.clear();
        parent.setRedraw(false);
        try {
            IWizardContainer container;
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            Composite m = new Composite((Composite)scrolledComposite, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            m.setLayout((Layout)layout);
            this.tf = null;
            final Map<String, AttributeCategory> attributeCategoryMap = ((AbstractComponentMeta)this.definition.getService(AbstractComponentMeta.class)).getAttributeCategoryMap();
            Composite topPart = null;
            Set<String> keySet = attributeCategoryMap.keySet();
            ArrayList<String> orderedPages = new ArrayList<String>();
            for (String page : keySet) {
                if (!page.equals("General")) continue;
                orderedPages.add(page);
            }
            for (String page : keySet) {
                if (page.equals("General")) continue;
                orderedPages.add(page);
            }
            for (final String s : orderedPages) {
                Composite p = null;
                if (s.length() == 0) {
                    if (topPart == null) {
                        topPart = new Composite(m, 0);
                        topPart.setLayout((Layout)new GridLayout(1, false));
                        topPart.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                    }
                    p = topPart;
                }
                if (this.tf == null && p == null) {
                    this.tf = new TabFolder(m, 0);
                    this.tf.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                }
                if (p == null) {
                    p = this.tf;
                }
                AttributeCategoryProvider provider = new AttributeCategoryProvider(){

                    @Override
                    public AttributeCategory getAttributeCategory(AttributesPropertyPage page) {
                        if (!ids.containsKey(page)) {
                            ids.put(page, ChildElementWizardPage.this.definition.getId());
                        }
                        return (AttributeCategory)attributeCategoryMap.get(s);
                    }
                };
                final AttributesPropertyPage page = new AttributesPropertyPage(null, this.project, p, provider){

                    @Override
                    public String getName() {
                        return ChildElementWizardPage.this.getName();
                    }

                    @Override
                    protected boolean isGeneral() {
                        return false;
                    }
                };
                page.setHost((IHost)new HostAdapter(){

                    public void setMessage(String description) {
                        ChildElementWizardPage.this.setMessage(description);
                    }

                    public void setMessages(List<Message> messages) {
                        if (!messages.isEmpty()) {
                            this.setMessage(messages.get(0));
                        } else {
                            this.setMessage(OK_MESSAGE);
                        }
                    }

                    public void setMessage(Message message) {
                        this.updateDialogMessage(message);
                        this.updateFinishButtonEnablement(page, message);
                    }

                    private void updateFinishButtonEnablement(AttributesPropertyPage page2, Message message) {
                        boolean activePopup = false;
                        for (Map.Entry<String, IFieldEditor> editor : page2.getEditors().entrySet()) {
                            StringFieldEditor stringFieldEditor;
                            if (!(editor.getValue() instanceof StringFieldEditor) || !(stringFieldEditor = (StringFieldEditor)editor.getValue()).isActivePopup()) continue;
                            activePopup = true;
                            break;
                        }
                        if (ChildElementWizardPage.this.callbacks != null) {
                            if (message.isErrorMessage() || activePopup) {
                                ChildElementWizardPage.this.callbacks.disable();
                            } else {
                                ChildElementWizardPage.this.callbacks.enable();
                            }
                        }
                    }

                    private void updateDialogMessage(Message message) {
                        if (message.isOkMessage()) {
                            ChildElementWizardPage.this.setErrorMessage(null);
                        } else {
                            ChildElementWizardPage.this.setErrorMessage(message.getMessage());
                        }
                    }

                    public MessageFlowNode getNode() {
                        MessageFlowNode node = new MessageFlowNode(){};
                        node.setType(ChildElementWizardPage.this.definition.getId());
                        node.setDefinition((NodeDefinition)ChildElementWizardPage.this.definition);
                        return node;
                    }

                    public Composite[] getAllPages() {
                        return ChildElementWizardPage.this.pages.toArray(new Composite[ChildElementWizardPage.this.pages.size()]);
                    }
                });
                page.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
                this.pages.add(page);
                if (s.length() == 0) continue;
                TabItem item = new TabItem(this.tf, 0);
                item.setText(s);
                item.setControl((Control)page);
            }
            if (topPart != null && this.tf != null) {
                topPart.moveAbove((Control)this.tf);
            }
            if (this.collection == null) {
                this.collection = new PropertyCollection();
                this.collection.setName(this.createId(this.collection));
            }
            for (AttributesPropertyPage p : this.pages) {
                p.loadFrom(this.node, new PropertyCollectionMap(this.collection));
            }
            scrolledComposite.setContent((Control)m);
            Point contentSize = m.computeSize(-1, -1);
            scrolledComposite.setMinSize(contentSize);
            this.setControl((Control)scrolledComposite);
            IWizard wizard = this.getWizard();
            if (wizard != null && this.definition != null && (container = wizard.getContainer()) != null) {
                Shell shell = container.getShell();
                HelpSystemConnector.connect((Composite)shell, (NodeDefinition)this.definition);
            }
        }
        catch (Throwable throwable) {
            Point correctSize2;
            Point computeSize = parent.getShell().computeSize(-1, -1);
            Point size = parent.getShell().getSize();
            size.x = Math.max(size.x, computeSize.x);
            size.y = Math.max(size.y, computeSize.y);
            if (size.x > 700) {
                size.x = 700;
            }
            parent.getShell().setSize(size);
            if (this.definition.getId().equals("http://www.mulesoft.org/schema/mule/core/xa-transaction")) {
                correctSize2 = new Point(size.x, 300);
                parent.getShell().setSize(correctSize2);
            }
            if (this.definition.getId().equals("http://www.mulesoft.org/schema/mule/ee/tracking/meta-data")) {
                correctSize2 = new Point(size.x, 300);
                parent.getShell().setSize(correctSize2);
            }
            if (this.definition.getWindowHeight() != 0) {
                correctSize2 = new Point(size.x, this.definition.getWindowHeight());
                parent.getShell().setSize(correctSize2);
            }
            parent.setRedraw(true);
            throw throwable;
        }
        Point computeSize = parent.getShell().computeSize(-1, -1);
        Point size = parent.getShell().getSize();
        size.x = Math.max(size.x, computeSize.x);
        size.y = Math.max(size.y, computeSize.y);
        if (size.x > 700) {
            size.x = 700;
        }
        parent.getShell().setSize(size);
        if (this.definition.getId().equals("http://www.mulesoft.org/schema/mule/core/xa-transaction")) {
            correctSize = new Point(size.x, 300);
            parent.getShell().setSize(correctSize);
        }
        if (this.definition.getId().equals("http://www.mulesoft.org/schema/mule/ee/tracking/meta-data")) {
            correctSize = new Point(size.x, 300);
            parent.getShell().setSize(correctSize);
        }
        if (this.definition.getWindowHeight() != 0) {
            correctSize = new Point(size.x, this.definition.getWindowHeight());
            parent.getShell().setSize(correctSize);
        }
        parent.setRedraw(true);
    }

    private String createId(PropertyCollection collection) {
        return "@" + this.definition.getId() + ";" + System.identityHashCode(collection);
    }

    public void setMuleProject(IMuleProject project) {
        this.project = project;
    }

    public void setDefinition(NestedDefinition nestedDefinition) {
        if (this.definition != nestedDefinition && nestedDefinition != null) {
            IWizardContainer container;
            this.definition = nestedDefinition;
            this.setTitle(this.definition.getName());
            this.setMessage(this.definition.getDescription());
            IWizard wizard = this.getWizard();
            if (wizard != null && (container = wizard.getContainer()) != null) {
                Shell shell = container.getShell();
                HelpSystemConnector.connect((Composite)shell, (NodeDefinition)nestedDefinition);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.setErrorMessage(null);
        if (visible) {
            Control control = this.getControl();
            if (control != null) {
                control.dispose();
            }
            if (this.getWizard() instanceof ChildElementWizard) {
                ChildElementWizard wizard = (ChildElementWizard)this.getWizard();
                wizard.getCallbacks().enable();
            }
            this.createControl(this.parent);
            this.parent.layout(true, true);
            this.getControl().setVisible(true);
        } else {
            Control control = this.getControl();
            if (control != null) {
                control.dispose();
            }
            if (this.getWizard() instanceof ChildElementWizard) {
                ChildElementWizard wizard = (ChildElementWizard)this.getWizard();
                wizard.getCallbacks().disable();
            }
        }
    }

    public void init(PropertyCollection propertyCollection, IMessageFlowNode node) {
        this.node = node;
        this.collection = propertyCollection;
        NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(propertyCollection);
        this.setDefinition(nodeDef);
        for (AttributesPropertyPage p : this.pages) {
            p.loadFrom(node, new PropertyCollectionMap(propertyCollection));
        }
    }

    public void performFinish() {
        PropertyCollectionMap props = new PropertyCollectionMap();
        for (AttributesPropertyPage p : this.pages) {
            p.saveTo(this.node, props);
        }
        this.collection.getProperties().clear();
        this.collection.getPropertyCollections().clear();
        if (StringUtils.isNotBlank((CharSequence)this.collection.getName())) {
            this.collection.setName(this.collection.getName());
        } else {
            this.collection.setName(this.createId(this.collection));
        }
        PropertiesMap propertiesMap = props.getPropertiesMap();
        List asPropertyList = propertiesMap.asPropertyList();
        for (Property p : asPropertyList) {
            this.collection.getProperties().add(p);
        }
        Map propertyCollections = props.getPropertyCollections();
        for (String s : propertyCollections.keySet()) {
            PropertyCollection asPropertyCollection = ((PropertyCollectionMap)propertyCollections.get(s)).asPropertyCollection();
            asPropertyCollection.setName(s);
            this.collection.getPropertyCollections().add(asPropertyCollection);
        }
    }

    public static WeakHashMap<AttributesPropertyPage, String> getIds() {
        return ids;
    }

    public boolean canFinish() {
        for (AttributesPropertyPage page : this.pages) {
            for (Map.Entry<String, IFieldEditor> editor : page.getEditors().entrySet()) {
                StringFieldEditor stringFieldEditor;
                if (!(editor.getValue() instanceof StringFieldEditor) || !(stringFieldEditor = (StringFieldEditor)editor.getValue()).isActivePopup()) continue;
                return false;
            }
        }
        return true;
    }
}

