/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementDialog;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementListSelectionPage;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementWizardPage;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;

public class ChildElementWizard
extends Wizard {
    private IMuleProject project;
    private List<NestedDefinition> defs;
    private ChildElementWizardPage page;
    private IMessageFlowNode node;
    private PropertyCollection collection;
    private ChildElementListSelectionPage listPage;
    private boolean showSelection;
    private ChildElementDialog.FinishButtonCallbacks callbacks;

    public ChildElementWizard(IMuleProject iMuleProject, List<NestedDefinition> allowedDefinitions, boolean showSelection) {
        this.project = iMuleProject;
        this.defs = allowedDefinitions;
        this.showSelection = showSelection;
        this.callbacks = null;
        ArrayList<NestedDefinition> dd = new ArrayList<NestedDefinition>();
        for (NestedDefinition ddd : this.defs) {
            IKnowsVersionRange service = (IKnowsVersionRange)ddd.getService(IKnowsVersionRange.class);
            if (service != null && !service.supported(iMuleProject.getServerDefinition().getVersionWithEESign())) continue;
            dd.add(ddd);
        }
        this.defs = dd;
    }

    public void setCallbacks(ChildElementDialog.FinishButtonCallbacks callbacks) {
        this.callbacks = callbacks;
    }

    public ChildElementDialog.FinishButtonCallbacks getCallbacks() {
        return this.callbacks;
    }

    public void addPages() {
        if (this.defs.size() > 1 && this.showSelection) {
            this.page = new ChildElementWizardPage(this.project, this.defs.get(0), this.callbacks);
            this.listPage = new ChildElementListSelectionPage(this.page, this.defs);
            NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(this.collection);
            this.listPage.setSelection((NodeDefinition)nodeDef);
            this.addPage((IWizardPage)this.listPage);
        } else {
            this.page = new ChildElementWizardPage(this.project, this.defs.isEmpty() ? null : this.defs.get(0), this.callbacks);
        }
        this.page.init(this.collection, this.node);
        this.addPage(this.page);
        super.addPages();
    }

    PropertyCollection getResult() {
        return this.page.collection;
    }

    public boolean performFinish() {
        this.page.performFinish();
        return true;
    }

    public boolean canFinish() {
        return this.page.canFinish() ? super.canFinish() : false;
    }

    public void init(PropertyCollection propertyCollection, IMessageFlowNode node) {
        this.collection = propertyCollection;
        this.node = node;
        NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(propertyCollection);
        if (nodeDef != null) {
            AbstractComponentMeta service = (AbstractComponentMeta)nodeDef.getService(AbstractComponentMeta.class);
            if (this.listPage != null) {
                this.listPage.setSelection((NodeDefinition)nodeDef);
            }
            if (service.getAllAttributes().size() == 0) {
                return;
            }
            if (this.page != null) {
                this.page.init(this.collection, node);
            }
        }
    }

    public boolean needsProgressMonitor() {
        return false;
    }

    public void setNeedsProgressMonitor(boolean b) {
        super.setNeedsProgressMonitor(false);
    }
}

