/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.TempChildNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IParametrizableFactory;
import org.mule.tooling.ui.modules.core.widgets.IValueFactory;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AttributeHelperCellEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementDialog;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementEditStack;
import org.mule.tooling.ui.modules.core.widgets.editors.ListNodeTableLabelProvider;
import org.mule.tooling.ui.modules.core.widgets.editors.TableSortController;
import org.mule.tooling.ui.modules.core.widgets.editors.TransientAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IAddNewChildActionHandler;
import org.mule.tooling.ui.modules.core.widgets.meta.LabelHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.TextAttributeMeta;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;

public class ChildElementTableFieldEditor
extends AbstractChildElementFieldEditor {
    private static final String SPRING_BEAN_ID = PropertiesUtils.createCollectionId((String)"http://www.springframework.org/schema/beans/bean");
    private static boolean revaidating = false;
    private ColumnViewer columnViewer;
    private ArrayList<Action> addList;
    private Action delete;
    private Action edit;
    private Action deleteAll;
    String evaluator;
    private int nDefs = 0;
    boolean inited;
    private PropertyCollection lastEdited;
    private ToolBarManager manager;
    protected ChildElementAttributeHelper nestedChild;
    private AttributesPropertyPage parentPage;

    @Override
    protected Control getEventControl() {
        return this.columnViewer.getControl();
    }

    public ChildElementTableFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    public ColumnViewer getTv() {
        return this.columnViewer;
    }

    @Override
    protected Control createControl(Composite parent) {
        boolean isTable;
        Composite cm = this.createComposite(parent);
        cm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).minSize(250, 50).create());
        GridLayout pl = new GridLayout(1, false);
        pl.marginWidth = 0;
        this.addList = new ArrayList();
        pl.marginRight = 0;
        ToolBar ts = new ToolBar(cm, 0);
        this.manager = new ToolBarManager(ts);
        cm.setLayout((Layout)pl);
        Composite q = new Composite(cm, 0);
        this.columnViewer = this.createViewer(q);
        AbstractColumnLayout qa = this.initLayout(q);
        q.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.columnViewer.addOpenListener(event -> {
            int n = this.editSelected();
        });
        this.addMeasureItemListener();
        this.addEraseItemListener();
        this.addPaintItemListener();
        this.addPaintListener();
        this.configureContextMenu();
        Collection<AttributeHelper> commonHelpers = this.getCommonHelpers();
        boolean bl = isTable = commonHelpers != null && !commonHelpers.isEmpty();
        if (isTable) {
            ArrayList<String> sss = new ArrayList<String>();
            if (commonHelpers.isEmpty()) {
                if (this.columnViewer instanceof TreeViewer) {
                    tc = new TreeColumn(((TreeViewer)this.columnViewer).getTree(), 0);
                    tc.setData(null);
                    tc.setText("");
                    qa.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(2));
                } else {
                    tc = new TableColumn(((TableViewer)this.columnViewer).getTable(), 0);
                    Comparator tcomp = (o1, o2) -> {
                        ITableLabelProvider mn = (ITableLabelProvider)this.columnViewer.getLabelProvider();
                        return mn.getColumnText(o1, 0).compareTo(mn.getColumnText(o2, 0));
                    };
                    new TableSortController((TableViewer)this.columnViewer, (TableColumn)tc, tcomp, true);
                    tc.setData(null);
                    tc.setText("");
                    qa.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(2));
                }
                sss.add(null);
            }
            for (AttributeHelper h : commonHelpers) {
                this.createColumn(qa, h);
                sss.add(h.getId());
            }
            this.initHeader();
            this.columnViewer.setColumnProperties(sss.toArray(new String[sss.size()]));
        } else {
            q.setLayout((Layout)new FillLayout());
        }
        this.populateMenuOptions();
        NestedElemenContentProvider provider = new NestedElemenContentProvider();
        this.columnViewer.setContentProvider((IContentProvider)provider);
        if (isTable) {
            this.columnViewer.setLabelProvider((IBaseLabelProvider)new ListNodeTableLabelProvider(this.columnViewer, this));
        } else {
            this.columnViewer.setLabelProvider((IBaseLabelProvider)new ListNodeLabelProvider());
        }
        this.columnViewer.addSelectionChangedListener(event -> this.updateButtons());
        return cm;
    }

    private void addMeasureItemListener() {
        this.columnViewer.getControl().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                Table table;
                TreeItem ti;
                TreeColumn column;
                AttributeHelper data;
                Tree tree;
                int columnIndex = event.index;
                ColumnViewer viewer = ChildElementTableFieldEditor.this.columnViewer;
                boolean isText = false;
                int w = 0;
                String ts = "";
                if (viewer instanceof TreeViewer && (tree = ((TreeViewer)viewer).getTree()).getColumnCount() > 0 && (data = (AttributeHelper)(column = tree.getColumn(columnIndex)).getData()) instanceof TextAttributeMeta) {
                    isText = true;
                    ti = (TreeItem)event.item;
                    ts = ti.getText(columnIndex);
                    w = column.getWidth();
                }
                if (viewer instanceof TableViewer && (table = ((TableViewer)viewer).getTable()).getColumnCount() > 0 && (data = (AttributeHelper)(column = table.getColumn(columnIndex)).getData()) instanceof TextAttributeMeta) {
                    isText = true;
                    ti = (TableItem)event.item;
                    ts = ti.getText(columnIndex);
                    w = column.getWidth();
                }
                if (isText) {
                    TextLayout tl = new TextLayout((Device)event.display);
                    if (w > 0) {
                        tl.setWidth(w);
                    }
                    tl.setText(ts);
                    event.height = tl.getBounds().height + 4;
                    if (event.height > 150) {
                        event.height = 150;
                    }
                    tl.dispose();
                }
            }
        });
    }

    private void addEraseItemListener() {
        this.columnViewer.getControl().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                AttributeHelper data;
                TreeColumn column;
                Tree tree;
                int columnIndex = event.index;
                ColumnViewer viewer = ChildElementTableFieldEditor.this.columnViewer;
                boolean isText = false;
                if (viewer instanceof TreeViewer && (tree = ((TreeViewer)viewer).getTree()).getColumnCount() > 0) {
                    column = tree.getColumn(columnIndex);
                    data = (AttributeHelper)column.getData();
                    if (!this.testEnabled(event.item.getData(), data.getId())) {
                        event.gc.setBackground(Display.getCurrent().getSystemColor(15));
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                    }
                    if (data instanceof TextAttributeMeta) {
                        isText = true;
                    }
                }
                if (viewer instanceof TableViewer) {
                    Table table = ((TableViewer)viewer).getTable();
                    if (table.getColumnCount() > 0) {
                        column = table.getColumn(columnIndex);
                        data = (AttributeHelper)column.getData();
                        if (!this.testEnabled(event.item.getData(), data.getId())) {
                            event.gc.setBackground(Display.getCurrent().getSystemColor(15));
                            event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        }
                        if (data instanceof TextAttributeMeta) {
                            isText = true;
                        }
                    }
                    if (isText) {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }

            boolean testEnabled(Object element, String property) {
                PropertyCollection pc = (PropertyCollection)element;
                if (pc == null) {
                    return false;
                }
                NestedDefinition nodeDef = ChildElementTableFieldEditor.getNodeDef(pc);
                AbstractComponentMeta service = (AbstractComponentMeta)nodeDef.getService(AbstractComponentMeta.class);
                if (service != null) {
                    String requiredPropertyId;
                    AttributeHelper attribute = service.getAttribute(property);
                    if (attribute != null && (requiredPropertyId = attribute.getRequiredPropertyId()) != null) {
                        boolean isEq;
                        int indexOf = requiredPropertyId.indexOf(61);
                        String pn = null;
                        String pv = null;
                        boolean bl = isEq = indexOf != -1;
                        if (isEq) {
                            pn = requiredPropertyId.substring(0, indexOf);
                            pv = requiredPropertyId.substring(indexOf + 1);
                        } else {
                            pn = requiredPropertyId;
                        }
                        boolean found = false;
                        for (Property p : pc.getProperties()) {
                            if (!pn.equals(p.getName())) continue;
                            if (pv == null) {
                                if (!Boolean.parseBoolean(p.getValue())) continue;
                                found = true;
                                continue;
                            }
                            if (!p.getValue().equals(pv)) continue;
                            found = true;
                        }
                        return found;
                    }
                    if (ChildElementTableFieldEditor.this.columnViewer instanceof TreeViewer) {
                        return attribute != null;
                    }
                }
                return property != null;
            }
        });
    }

    private void addPaintItemListener() {
        this.columnViewer.getControl().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Table table;
                TreeItem ti;
                TreeColumn column;
                AttributeHelper data;
                Tree tree;
                int columnIndex = event.index;
                ColumnViewer viewer = ChildElementTableFieldEditor.this.columnViewer;
                boolean isText = false;
                int w = 0;
                String ts = "";
                Image m = null;
                if (viewer instanceof TreeViewer && (tree = ((TreeViewer)viewer).getTree()).getColumnCount() > 0 && (data = (AttributeHelper)(column = tree.getColumn(columnIndex)).getData()) instanceof TextAttributeMeta) {
                    isText = true;
                    ti = (TreeItem)event.item;
                    m = ti.getImage(0);
                    ts = ti.getText(columnIndex);
                    w = column.getWidth();
                }
                if (viewer instanceof TableViewer && (table = ((TableViewer)viewer).getTable()).getColumnCount() > 0 && (data = (AttributeHelper)(column = table.getColumn(columnIndex)).getData()) instanceof TextAttributeMeta) {
                    isText = true;
                    ti = (TableItem)event.item;
                    m = ti.getImage(0);
                    ts = ti.getText(columnIndex);
                    w = column.getWidth();
                }
                if (event.index == 0 && m != null) {
                    event.gc.drawImage(m, event.x, event.y);
                    event.x += m.getBounds().width + 2;
                }
                if (isText) {
                    TextLayout tl = new TextLayout((Device)event.display);
                    tl.setWidth(w);
                    tl.setText(ts);
                    event.height = tl.getBounds().height + 4;
                    tl.draw(event.gc, event.x, event.y);
                    tl.dispose();
                    event.detail &= 0xFFFFFFD5;
                }
            }
        });
    }

    private void addPaintListener() {
        this.columnViewer.getControl().addPaintListener(e -> {
            if (!this.inited) {
                this.inited = true;
                this.columnViewer.getControl().getParent().layout(true, true);
            }
        });
    }

    private void configureContextMenu() {
        final MenuManager mn = new MenuManager();
        mn.setRemoveAllWhenShown(true);
        mn.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)ChildElementTableFieldEditor.this.columnViewer.getSelection();
                if (!selection.isEmpty()) {
                    final PropertyCollection pc = (PropertyCollection)selection.getFirstElement();
                    final NestedDefinition nodeDef = ChildElementTableFieldEditor.getNodeDef(pc);
                    LinkedHashSet<NestedDefinition> multipleChildren = ChildElementTableFieldEditor.this.getMultipleChildren(nodeDef);
                    for (final NestedDefinition d : multipleChildren) {
                        Action as = new Action(){

                            public void run() {
                                LinkedHashSet<NestedDefinition> allowedDefinitions = ChildElementTableFieldEditor.this.getMultipleChildren(nodeDef);
                                ChildElementDialog cdlg = new ChildElementDialog((this).ChildElementTableFieldEditor.this.context.getProject(), new ArrayList<NestedDefinition>(allowedDefinitions), false);
                                PropertyCollection propertyCollection = new PropertyCollection();
                                propertyCollection.setName(PropertiesUtils.createTailCollectionId((String)d.getId()));
                                if (!ChildElementTableFieldEditor.this.hasMeningfull((NodeDefinition)d)) {
                                    pc.getPropertyCollections().add(propertyCollection);
                                    ChildElementTableFieldEditor.this.initUI((this).ChildElementTableFieldEditor.this.defs);
                                    (this).ChildElementTableFieldEditor.this.columnViewer.setSelection((ISelection)new StructuredSelection((Object)propertyCollection));
                                    return;
                                }
                                ChildElementEditStack.editNested((this).ChildElementTableFieldEditor.this.defs, null, true);
                                cdlg.init(propertyCollection, ChildElementTableFieldEditor.this.getMessageFlowNode());
                                try {
                                    int open = cdlg.open();
                                    if (open == 0) {
                                        PropertyCollection resultCollection = cdlg.getResultCollection();
                                        pc.getPropertyCollections().add(resultCollection);
                                        ChildElementTableFieldEditor.this.initUI((this).ChildElementTableFieldEditor.this.defs);
                                    }
                                }
                                finally {
                                    ChildElementEditStack.finishEdit();
                                }
                                ChildElementTableFieldEditor.this.revalidateParent();
                            }
                        };
                        as.setText("Add " + d.getName());
                        as.setImageDescriptor(d.getIcon());
                        mn.add((IAction)as);
                    }
                    mn.add((IContributionItem)new Separator());
                    mn.add((IAction)ChildElementTableFieldEditor.this.delete);
                    mn.add((IAction)ChildElementTableFieldEditor.this.edit);
                    mn.update(true);
                }
            }
        });
        Menu createContextMenu = mn.createContextMenu(this.columnViewer.getControl());
        this.columnViewer.getControl().setMenu(createContextMenu);
    }

    private void populateMenuOptions() {
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        for (final NestedDefinition d : allowedDefinitions) {
            Action addAction = new Action(){

                public void run() {
                    ChildElementTableFieldEditor.this.addNew((NodeDefinition)d);
                }
            };
            addAction.setText("Add " + d.getName());
            addAction.setImageDescriptor(d.getIcon());
            this.addList.add(addAction);
        }
        this.delete = new Action(){

            public void run() {
                ChildElementTableFieldEditor.this.deleteSelected();
            }
        };
        this.delete.setText("Delete");
        this.delete.setImageDescriptor(MuleImages.DESC_DELETE);
        this.delete.setDisabledImageDescriptor(MuleImages.DESC_DELETE_DISABLED);
        this.edit = new Action(){

            public void run() {
                ChildElementTableFieldEditor.this.editSelected();
            }
        };
        this.edit.setText("Edit");
        this.edit.setImageDescriptor(MuleImages.DESC_EDIT);
        this.edit.setDisabledImageDescriptor(MuleImages.DESC_EDIT_DISABLED);
        if (this.addList.size() == 1) {
            action = this.addList.get(0);
            action.setImageDescriptor(MuleImages.DESC_ADD);
            action.setDisabledImageDescriptor(MuleImages.DESC_ADD_DISABLED);
            this.manager.add((IAction)action);
        } else {
            action = new DropdownAction("Add", 4);
            action.setImageDescriptor(MuleImages.DESC_ADD);
            action.setDisabledImageDescriptor(MuleImages.DESC_ADD_DISABLED);
            action.setMenuCreator((IMenuCreator)action);
            this.manager.add((IAction)action);
        }
        this.deleteAll = new Action(){

            public void run() {
                ChildElementTableFieldEditor.this.deleteAll();
            }
        };
        this.deleteAll.setText("Delete all");
        this.deleteAll.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
        this.deleteAll.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL_DISABLED"));
        this.manager.add((IAction)this.edit);
        this.manager.add((IAction)this.delete);
        this.manager.add((IAction)this.deleteAll);
        this.manager.update(true);
    }

    protected ColumnViewer createViewer(Composite q) {
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        for (NestedDefinition m : allowedDefinitions) {
            LinkedHashSet<NestedDefinition> multipleChildren = this.getMultipleChildren(m);
            if (multipleChildren.isEmpty()) continue;
            TreeViewer tableViewer = new TreeViewer(q, 67584);
            return tableViewer;
        }
        OutEditor tableViewer = new OutEditor(q, 67584);
        return tableViewer;
    }

    protected void createColumn(AbstractColumnLayout qa, AttributeHelper h) {
        if (this.columnViewer instanceof TreeViewer) {
            TreeColumn tc = new TreeColumn(((TreeViewer)this.columnViewer).getTree(), 0);
            tc.setData((Object)h);
            tc.setText(h.getCaption());
            qa.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(1));
        } else {
            TableColumn tc = new TableColumn(((TableViewer)this.columnViewer).getTable(), 0);
            tc.setData((Object)h);
            tc.setText(h.getCaption());
            if (h instanceof TextAttributeMeta) {
                qa.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(3));
            } else {
                qa.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(1));
            }
            Comparator tcomp = (o1, o2) -> {
                PropertyCollection c1 = (PropertyCollection)o1;
                PropertyCollection c2 = (PropertyCollection)o2;
                String property = new PropertyCollectionMap(c1).getProperty(h.getId(), "");
                String property2 = new PropertyCollectionMap(c2).getProperty(h.getId(), "");
                if (Number.class.isAssignableFrom(h.getType())) {
                    try {
                        return Double.valueOf(property).compareTo(Double.valueOf(property2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return property.compareTo(property2);
            };
            new TableSortController((TableViewer)this.columnViewer, tc, tcomp, true);
        }
    }

    protected void initHeader() {
        if (this.columnViewer instanceof TreeViewer) {
            ((TreeViewer)this.columnViewer).getTree().setHeaderVisible(true);
        } else {
            ((TableViewer)this.columnViewer).getTable().setHeaderVisible(true);
        }
    }

    protected AbstractColumnLayout initLayout(Composite q) {
        if (this.columnViewer instanceof TreeViewer) {
            TreeColumnLayout qa = new TreeColumnLayout();
            q.setLayout((Layout)qa);
            return qa;
        }
        TableColumnLayout qa = new TableColumnLayout();
        q.setLayout((Layout)qa);
        return qa;
    }

    protected Composite createComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    protected int editSelected() {
        AttributeHelper next;
        IValueFactory valueFactory;
        NestedDefinition nestedDefinition;
        AbstractComponentMeta service;
        List<AttributeHelper> allAttributes;
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        IStructuredSelection sm = (IStructuredSelection)this.columnViewer.getSelection();
        PropertyCollection pc = (PropertyCollection)sm.getFirstElement();
        ChildElementEditStack.editNested(this.defs, pc, false);
        if (allowedDefinitions.size() == 1 && (allAttributes = (service = (AbstractComponentMeta)(nestedDefinition = allowedDefinitions.get(0)).getService(AbstractComponentMeta.class)).getAllAttributes()).size() == 1 && (valueFactory = (next = (AttributeHelper)allAttributes.iterator().next()).getValueFactory()) instanceof IParametrizableFactory) {
            Object value = ((IParametrizableFactory)((Object)valueFactory)).getValue(this.context, nestedDefinition.getName(), nestedDefinition.getDescription());
            if (value != null) {
                for (Property p : pc.getProperties()) {
                    if (!p.getName().equals(next.getId())) continue;
                    p.setValue(value.toString());
                    this.columnViewer.refresh(true);
                    this.revalidateParent();
                    return 1;
                }
                Property property = new Property();
                property.setName(next.getId());
                property.setValue(value.toString());
                pc.getProperties().add(property);
                this.columnViewer.refresh(true);
                this.revalidateParent();
                return 1;
            }
            return 1;
        }
        int result = 1;
        try {
            ChildElementDialog cdlg = new ChildElementDialog(this.context.getProject(), allowedDefinitions, false);
            if (pc.getName().startsWith(SPRING_BEAN_ID)) {
                return 0;
            }
            cdlg.init(pc, this.getMessageFlowNode());
            result = cdlg.open();
        }
        finally {
            ChildElementEditStack.finishEdit();
        }
        this.columnViewer.refresh(true);
        this.revalidateParent();
        return result;
    }

    protected void deleteSelected() {
        IStructuredSelection sm = (IStructuredSelection)this.columnViewer.getSelection();
        Object firstElement = sm.getFirstElement();
        if (this.columnViewer instanceof TreeViewer) {
            ((TreeViewer)this.columnViewer).remove(firstElement);
        }
        if (this.columnViewer instanceof TableViewer) {
            ((TableViewer)this.columnViewer).remove(firstElement);
        }
        this.delete(this.defs, (PropertyCollection)firstElement);
        List<PropertyCollection> notErased = this.getNotErased(this.defs);
        this.columnViewer.setInput((Object)notErased.toArray(new PropertyCollection[notErased.size()]));
        if (this.columnViewer instanceof TreeViewer) {
            TreeViewer ma = (TreeViewer)this.columnViewer;
            ma.expandAll();
        }
        this.updateButtons();
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
        this.revalidateParent();
    }

    private void deleteAll() {
        PropertyCollection[] input;
        PropertyCollection[] propertyCollectionArray = input = (PropertyCollection[])this.columnViewer.getInput();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyCollection prop = propertyCollectionArray[n2];
            this.delete(this.defs, prop);
            ++n2;
        }
        this.columnViewer.setInput((Object)new PropertyCollection[0]);
        this.revalidateParent();
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    protected void addNew(NodeDefinition d) {
        boolean hasMeeningfull;
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        PropertyCollection propertyCollection = new PropertyCollection();
        String name = PropertiesUtils.createCollectionIdWithSuffix((String)d.getId(), (String)Integer.toString(++this.nDefs));
        propertyCollection.setName(name);
        ChildElementAttributeHelper h = (ChildElementAttributeHelper)this.getHelper();
        final IAddNewChildActionHandler addCommand = h.getAddCommand();
        boolean bl = hasMeeningfull = this.hasMeningfull(d) && addCommand == null;
        if (!hasMeeningfull) {
            TempChildNode tempNode = new TempChildNode();
            tempNode.setProperties(propertyCollection);
            tempNode.setType(d.getId());
            tempNode.setDefinition(d);
            if (this.nestedChild != null) {
                PropertyCollection e = new PropertyCollection();
                e.setName(PropertiesUtils.createCollectionIdWithSuffix((String)this.nestedChild.getId(), (String)"1"));
                propertyCollection.getPropertyCollections().add(e);
            }
            if (addCommand != null) {
                try {
                    final List[] newCollectionsRef = new List[1];
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            newCollectionsRef[0] = addCommand.run(ChildElementTableFieldEditor.this.page, (ChildElementAttributeHelper)ChildElementTableFieldEditor.this.getHelper(), ChildElementTableFieldEditor.this);
                        }
                    };
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(activeShell);
                    progressMonitorDialog.run(true, true, op);
                    List newCollections = newCollectionsRef[0];
                    this.createAndAddElement(newCollections);
                    if (newCollections == null) {
                        return;
                    }
                    if (newCollections.isEmpty() || newCollections.size() > 1) {
                        this.defs.addAll(newCollections);
                        this.initUI(this.defs);
                        if (!this.defs.isEmpty()) {
                            PropertyCollection selectedCollection = (PropertyCollection)this.defs.get(0);
                            this.columnViewer.setSelection((ISelection)new StructuredSelection((Object)selectedCollection));
                        }
                        return;
                    }
                    PropertyCollection theNewChild = (PropertyCollection)newCollections.get(0);
                    this.openDialog(allowedDefinitions, theNewChild);
                    return;
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    return;
                }
            }
            this.createAndAddElement(propertyCollection);
            this.defs.add(propertyCollection);
            this.initUI(this.defs);
            this.columnViewer.setSelection((ISelection)new StructuredSelection((Object)propertyCollection));
            if (this.hasAnyAttributeOrChildElement(d) && this.editSelected() == 1) {
                this.deleteSelected();
            }
            return;
        }
        this.openDialog(allowedDefinitions, propertyCollection);
    }

    private void createAndAddElement(List<PropertyCollection> newCollections) {
        for (PropertyCollection propertyCollection : newCollections) {
            this.createAndAddElement(propertyCollection);
        }
    }

    private void createAndAddElement(PropertyCollection propertyCollection) {
        IElementWrapper element = MessageFlowUtils.createElement((IMessageFlowNode)this.getMessageFlowNode(), (PropertyCollection)propertyCollection, (int)this.getHelper().getXmlOrder());
        propertyCollection.setElement(element);
    }

    private void openDialog(List<NestedDefinition> allowedDefinitions, PropertyCollection propertyCollection) {
        ChildElementEditStack.editNested(this.defs, null, true);
        try {
            IMuleProject project = this.context.getProject();
            ChildElementDialog cdlg = new ChildElementDialog(project, allowedDefinitions, false);
            cdlg.init(propertyCollection, this.getMessageFlowNode());
            int open = cdlg.open();
            if (open == 0) {
                PropertyCollection resultCollection = cdlg.getResultCollection();
                this.createAndAddElement(resultCollection);
                this.defs.add(resultCollection);
                if (!this.isDisposed()) {
                    this.initUI(this.defs);
                    this.columnViewer.setSelection((ISelection)new StructuredSelection((Object)resultCollection));
                }
            }
        }
        finally {
            ChildElementEditStack.finishEdit();
        }
        this.revalidateParent();
    }

    protected boolean hasMeningfull(NodeDefinition d) {
        AbstractComponentMeta service = (AbstractComponentMeta)d.getService(AbstractComponentMeta.class);
        List<AttributeHelper> allAttributes = service.getAllAttributes();
        boolean hasMeeningfull = false;
        for (AttributeHelper h : allAttributes) {
            if (!(h instanceof ChildElementAttributeHelper)) {
                if (!(this.columnViewer instanceof TreeViewer) && !(h instanceof GlobalRefAttributeHelper) && !(h instanceof TransientAttributeHelper) && !(h instanceof LabelHelper)) continue;
                hasMeeningfull = true;
                break;
            }
            ChildElementAttributeHelper m = (ChildElementAttributeHelper)h;
            if (m.isMultiple() || m == this.nestedChild) continue;
            hasMeeningfull = true;
        }
        return hasMeeningfull;
    }

    private boolean hasAnyAttributeOrChildElement(NodeDefinition d) {
        AbstractComponentMeta service = (AbstractComponentMeta)d.getService(AbstractComponentMeta.class);
        List<AttributeHelper> allAttributes = service.getAllAttributes();
        return !allAttributes.isEmpty() || service.getChildElements().length > 0;
    }

    protected List<NestedDefinition> getAllowedDefinitions() {
        ChildElementAttributeHelper h = (ChildElementAttributeHelper)this.getHelper();
        return h.getAllowedDefinitions();
    }

    protected LinkedHashSet<NestedDefinition> getMultipleChildren(NestedDefinition def) {
        AbstractComponentMeta service = (AbstractComponentMeta)def.getService(AbstractComponentMeta.class);
        List<AttributeHelper> allAttributes = service.getAllAttributes();
        LinkedHashSet<NestedDefinition> results = new LinkedHashSet<NestedDefinition>();
        for (AttributeHelper h : allAttributes) {
            ChildElementAttributeHelper cm;
            boolean multiple;
            if (!(h instanceof ChildElementAttributeHelper) || !(multiple = (cm = (ChildElementAttributeHelper)h).isMultiple())) continue;
            results.addAll(cm.getAllowedDefinitions());
        }
        return results;
    }

    protected Collection<AttributeHelper> getCommonHelpers() {
        List<NestedDefinition> allowedDefinitions = this.getAllowedDefinitions();
        Set<AttributeHelper> attributes = this.getAttrs(allowedDefinitions);
        ArrayList<AttributeHelper> res = new ArrayList<AttributeHelper>();
        for (AttributeHelper h : attributes) {
            if (h instanceof ChildElementAttributeHelper) {
                List<NestedDefinition> allowedDefinitions2;
                Set<AttributeHelper> attrs;
                ChildElementAttributeHelper qq;
                if (attributes.size() != 1 || (qq = (ChildElementAttributeHelper)h).isSubtypes() || !qq.isInplace() || qq.isMultiple() || (attrs = this.getAttrs(allowedDefinitions2 = qq.getAllowedDefinitions())).size() <= 1 || attrs.size() >= 5) continue;
                ArrayList<AttributeHelper> result = new ArrayList<AttributeHelper>();
                for (AttributeHelper m : attrs) {
                    result.add(m);
                }
                this.nestedChild = qq;
                return result;
            }
            if (h instanceof TransientAttributeHelper || h instanceof LabelHelper) continue;
            res.add(h);
        }
        return res;
    }

    private Set<AttributeHelper> getAttrs(List<NestedDefinition> allowedDefinitions) {
        LinkedHashSet<AttributeHelper> attributes = null;
        for (NestedDefinition d : allowedDefinitions) {
            AbstractComponentMeta service = (AbstractComponentMeta)d.getService(AbstractComponentMeta.class);
            List<AttributeHelper> allAttributes = service.getAllAttributes();
            if (attributes == null) {
                attributes = new LinkedHashSet<AttributeHelper>(allAttributes);
                continue;
            }
            attributes.retainAll(allAttributes);
        }
        return attributes == null ? Collections.emptySet() : attributes;
    }

    protected void updateButtons() {
        IStructuredSelection sm = (IStructuredSelection)this.columnViewer.getSelection();
        this.delete.setEnabled(!sm.isEmpty());
        this.edit.setEnabled(!sm.isEmpty());
        this.deleteAll.setEnabled(this.hasValues());
        if (this.getHelper().isRequired() && this.defs.isEmpty()) {
            this.validate();
        }
    }

    private boolean hasValues() {
        PropertyCollection[] input = (PropertyCollection[])this.columnViewer.getInput();
        return input != null && input.length > 0;
    }

    public void refreshTable() {
        this.initUI(this.defs);
    }

    @Override
    protected void initUI(List<PropertyCollection> defs2) {
        List<PropertyCollection> notErased = this.getNotErased(defs2);
        this.columnViewer.setInput((Object)notErased.toArray(new PropertyCollection[notErased.size()]));
        this.nDefs = defs2.size();
        this.updateButtons();
        if (this.columnViewer instanceof TreeViewer) {
            TreeViewer ts = (TreeViewer)this.columnViewer;
            ts.expandAll();
        }
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.columnViewer.getControl().getEnabled() != enabled) {
            this.columnViewer.getControl().setEnabled(enabled);
            for (IAction iAction : this.addList) {
                iAction.setEnabled(enabled);
            }
            this.edit.setEnabled(enabled);
            this.delete.setEnabled(enabled);
            this.deleteAll.setEnabled(enabled);
            if (enabled) {
                this.updateButtons();
            }
        }
    }

    public ChildElementEditStack.ListInfo getInfo() {
        IStructuredSelection sm = (IStructuredSelection)this.columnViewer.getSelection();
        PropertyCollection pc = (PropertyCollection)sm.getFirstElement();
        return new ChildElementEditStack.ListInfo(this.defs, pc, false);
    }

    protected PropertyCollection adjustCollectionToNested(PropertyCollection pc) {
        if (this.nestedChild != null) {
            for (PropertyCollection m : pc.getPropertyCollections()) {
                NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(m);
                if (!nodeDef.getId().equals(this.nestedChild.getId())) continue;
                pc = m;
                break;
            }
        }
        return pc;
    }

    public void activateNext(AttributeHelperCellEditor childElementTableFieldEditor) {
        CellEditor[] cellEditors;
        int indexOf;
        if (this.columnViewer instanceof TableViewer && (indexOf = Arrays.asList(cellEditors = this.columnViewer.getCellEditors()).indexOf((Object)childElementTableFieldEditor)) != -1 && indexOf < cellEditors.length - 1) {
            TableViewer tableViewer = (TableViewer)this.columnViewer;
            tableViewer.editElement((Object)this.lastEdited, indexOf + 1);
        }
    }

    public void activatePrev(AttributeHelperCellEditor childElementTableFieldEditor) {
        CellEditor[] cellEditors;
        int indexOf;
        if (this.columnViewer instanceof TableViewer && (indexOf = Arrays.asList(cellEditors = this.columnViewer.getCellEditors()).indexOf((Object)childElementTableFieldEditor)) > 0) {
            TableViewer tableViewer = (TableViewer)this.columnViewer;
            tableViewer.editElement((Object)this.lastEdited, indexOf - 1);
        }
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        if (this.parentPage != null) {
            return this.parentPage;
        }
        Composite parent = this.control.getParent();
        while (!(parent instanceof AttributesPropertyPage)) {
            parent = parent.getParent();
        }
        this.parentPage = (AttributesPropertyPage)parent;
        return this.parentPage;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        OutEditor or;
        if (this.columnViewer instanceof OutEditor && (or = (OutEditor)this.columnViewer).isCellEditorActive()) {
            or.applyEditorValue();
        }
        PropertyCollection[] input = (PropertyCollection[])this.columnViewer.getInput();
        if (this.isEnabled()) {
            ArrayList<PropertyCollection> backupDefs = new ArrayList<PropertyCollection>(this.getDefs());
            Optional backupState = props.getPropertyOpt("BACKUP_STATE");
            this.clearDefs();
            block0: for (PropertyCollection propertyCollection : backupDefs) {
                PropertyCollection collection = new PropertyCollection();
                collection.setErased(propertyCollection.isErased());
                this.addToDefs(collection);
                boolean found = false;
                PropertyCollection updatedProperty = null;
                String collectionName = propertyCollection.getName();
                PropertyCollection[] propertyCollectionArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyCollection prop = propertyCollectionArray[n2];
                    if (prop.getName().equals(collectionName)) {
                        updatedProperty = prop;
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) {
                    updatedProperty.getProperties().stream().forEach(arg_0 -> ((PropertyCollection)collection).addProperty(arg_0));
                    updatedProperty.getPropertyCollections().stream().forEach(arg_0 -> ((PropertyCollection)collection).addPropertyCollection(arg_0));
                } else {
                    propertyCollection.getProperties().stream().forEach(arg_0 -> ((PropertyCollection)collection).addProperty(arg_0));
                    propertyCollection.getPropertyCollections().stream().forEach(arg_0 -> ((PropertyCollection)collection).addPropertyCollection(arg_0));
                }
                collection.setName(collectionName);
                if (backupState.isPresent()) {
                    element = propertyCollection.getElement().getParent() != null ? propertyCollection.getElement() : MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)collection, (int)this.getHelper().getXmlOrder());
                    collection.setElement(element);
                    props.addPropertyCollection(collectionName, collection.toPropertyCollectionMap());
                } else {
                    element = MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)collection, (int)this.getHelper().getXmlOrder());
                    collection.setElement(element);
                    props.addPropertyCollection(collectionName, collection.toPropertyCollectionMap());
                }
                if (backupState.isPresent()) continue;
                for (PropertyCollection oldPropertyCollection : backupDefs) {
                    String oldPropertyCollectionName = oldPropertyCollection.getName();
                    if (oldPropertyCollectionName == null || !collection.getName().equals(oldPropertyCollectionName) || oldPropertyCollection.getElement() == null) continue;
                    this.removeFromDefs(collection);
                    this.addToDefs(PropertiesUtils.from((PropertyCollection)collection, (IElementWrapper)oldPropertyCollection.getElement()));
                    continue block0;
                }
            }
            for (PropertyCollection propetyCollection : this.getDefs()) {
                String name = propetyCollection.getName();
                PropertyCollectionMap defsMap = new PropertyCollectionMap(propetyCollection);
                props.addPropertyCollection(name, defsMap);
            }
            if (backupState.isPresent()) {
                this.clearDefs();
                this.setDefs(backupDefs);
            }
        }
    }

    public void clear() {
        this.defs.clear();
    }

    @Override
    public void postInitLoadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.postInitLoadFrom(node, props);
        CellEditor[] cellEditors = this.columnViewer.getCellEditors();
        if (cellEditors != null) {
            CellEditor[] cellEditorArray = cellEditors;
            int n = cellEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor cell = cellEditorArray[n2];
                if (cell instanceof AttributeHelperCellEditor) {
                    ((AttributeHelperCellEditor)cell).getInnerEditor().setNode(node);
                }
                ++n2;
            }
        }
        this.setMessageFlowNode(node);
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private final class DropdownAction
    extends Action
    implements IMenuCreator {
        private MenuManager man;

        private DropdownAction(String text, int style) {
            super(text, style);
        }

        public void dispose() {
            this.man.getMenu().dispose();
        }

        public void run() {
            this.getMenu(ChildElementTableFieldEditor.this.getControl()).setVisible(true);
        }

        public Menu getMenu(Control parent) {
            if (this.man == null) {
                this.man = new MenuManager();
                for (Action a : ChildElementTableFieldEditor.this.addList) {
                    this.man.add((IAction)a);
                }
            }
            return this.man.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class ListNodeLabelProvider
    extends LabelProvider {
        private ListNodeLabelProvider() {
        }

        public String getText(Object element) {
            PropertyCollection collection = (PropertyCollection)element;
            NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(collection);
            if (ChildElementTableFieldEditor.this.nestedChild != null) {
                return "nested";
            }
            return ChildElementTableFieldEditor.getNestedElementLabel(nodeDef, collection);
        }

        public Image getImage(Object element) {
            PropertyCollection collection = (PropertyCollection)element;
            NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(collection);
            return nodeDef.getIconImage();
        }
    }

    private final class NestedElemenContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private NestedElemenContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            PropertyCollection cm = (PropertyCollection)parentElement;
            return cm.getPropertyCollections().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            PropertyCollection cm = (PropertyCollection)element;
            return !cm.getPropertyCollections().isEmpty();
        }
    }

    private final class OutEditor
    extends TableViewer {
        boolean applying;

        private OutEditor(Composite parent, int style) {
            super(parent, style);
        }

        protected void internalRefresh(Object element) {
            this.applying = true;
            super.internalRefresh(element);
            this.applying = false;
        }

        public void applyEditorValue() {
            try {
                if (revaidating) {
                    return;
                }
                super.applyEditorValue();
                try {
                    if (!this.applying) {
                        this.applying = true;
                        Display.getCurrent().asyncExec(() -> {
                            if (!ChildElementTableFieldEditor.this.control.isDisposed()) {
                                ChildElementTableFieldEditor.this.revalidateParent();
                            }
                        });
                    }
                }
                finally {
                    this.applying = false;
                }
            }
            catch (Throwable e) {
                MuleCorePlugin.logError((String)"Exception in applyEditorValue", (Throwable)e);
            }
        }
    }
}

