/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementWizardPage;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class ChildElementListSelectionPage
extends WizardPage {
    private TableViewer tableViewer;
    IMuleProject project;
    protected List<NestedDefinition> defs;
    private ChildElementWizardPage nextPage;
    private NodeDefinition selection;

    protected ChildElementListSelectionPage(ChildElementWizardPage nextPage, List<NestedDefinition> defs) {
        super("def");
        this.defs = defs;
        this.nextPage = nextPage;
        this.setMessage("Please select element");
        this.setTitle("Select element to use");
    }

    public boolean canFlipToNextPage() {
        List<AttributeHelper> allAttributes;
        AbstractComponentMeta service;
        if (this.nextPage.definition != null && (service = (AbstractComponentMeta)this.nextPage.definition.getService(AbstractComponentMeta.class)) != null && (allAttributes = service.getAllAttributes()).isEmpty()) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Composite p = new Composite(parent, 0);
        p.setLayout((Layout)new GridLayout(1, true));
        p.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(p, 68100);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                NestedDefinition nodeDef = (NestedDefinition)element;
                return AbstractChildElementFieldEditor.getNestedElementLabel(nodeDef, null);
            }

            public Image getImage(Object element) {
                NestedDefinition nodeDef = (NestedDefinition)element;
                return nodeDef.getIconImage();
            }
        });
        this.tableViewer.setInput((Object)this.defs.toArray(new NestedDefinition[this.defs.size()]));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selectedElement;
                ISelection selection = ChildElementListSelectionPage.this.tableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof NestedDefinition) {
                    ChildElementListSelectionPage.this.nextPage.setDefinition((NestedDefinition)selectedElement);
                    ChildElementListSelectionPage.this.setPageComplete(true);
                }
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)p);
        if (this.selection != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.selection));
        }
    }

    public void setSelection(NodeDefinition def) {
        this.selection = def;
        if (this.tableViewer != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)def));
        }
    }
}

