/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementDialog;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementEditStack;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;

public class ChildElementListFieldEditor
extends AbstractChildElementFieldEditor {
    private TableViewer tv;
    private Button add;
    private Button delete;
    private Button edit;
    private AttributesPropertyPage parentPage;

    public ChildElementListFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        if (this.parentPage != null) {
            return this.parentPage;
        }
        Composite parent = this.control.getParent();
        while (!(parent instanceof AttributesPropertyPage)) {
            parent = parent.getParent();
        }
        this.parentPage = (AttributesPropertyPage)parent;
        return this.parentPage;
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite cm = this.createComposite(parent);
        cm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        GridLayout pl = new GridLayout(2, false);
        pl.marginWidth = 0;
        pl.marginRight = 0;
        cm.setLayout((Layout)pl);
        this.tv = new TableViewer(cm);
        this.tv.getTable().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.tv.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ChildElementListFieldEditor.this.editSelected();
            }
        });
        Composite buttons = new Composite(cm, 0);
        buttons.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        GridLayout layout = new GridLayout(1, false);
        this.add = new Button(buttons, 0);
        this.add.setText("Add");
        this.add.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.add).create());
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildElementListFieldEditor.this.addNew();
            }
        });
        this.delete = new Button(buttons, 0);
        this.delete.setText("Delete");
        this.delete.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.add).create());
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildElementListFieldEditor.this.deleteSelected();
            }
        });
        this.edit = new Button(buttons, 0);
        this.edit.setText("Edit");
        this.edit.setLayoutData((Object)GridDataFactory.defaultsFor((Control)this.add).create());
        layout.marginHeight = 0;
        layout.marginRight = -5;
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildElementListFieldEditor.this.editSelected();
            }
        });
        buttons.setLayout((Layout)layout);
        this.tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                PropertyCollection collection = (PropertyCollection)element;
                NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(collection);
                return ChildElementListFieldEditor.getNestedElementLabel(nodeDef, collection);
            }

            public Image getImage(Object element) {
                PropertyCollection collection = (PropertyCollection)element;
                NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(collection);
                return nodeDef.getIconImage();
            }
        });
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChildElementListFieldEditor.this.updateButtons();
            }
        });
        return cm;
    }

    protected Composite createComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    public ChildElementEditStack.ListInfo getInfo() {
        IStructuredSelection sm = (IStructuredSelection)this.tv.getSelection();
        PropertyCollection pc = (PropertyCollection)sm.getFirstElement();
        return new ChildElementEditStack.ListInfo(this.defs, pc, false);
    }

    protected void editSelected() {
        ChildElementAttributeHelper h = (ChildElementAttributeHelper)this.getHelper();
        List<NestedDefinition> allowedDefinitions = h.getAllowedDefinitions();
        IStructuredSelection sm = (IStructuredSelection)this.tv.getSelection();
        PropertyCollection pc = (PropertyCollection)sm.getFirstElement();
        ChildElementEditStack.editNested(this.defs, pc, false);
        try {
            ChildElementDialog cdlg = new ChildElementDialog(this.context.getProject(), allowedDefinitions, false);
            cdlg.init(pc, (IMessageFlowNode)this.getNode());
            cdlg.open();
        }
        finally {
            ChildElementEditStack.finishEdit();
        }
    }

    protected void deleteSelected() {
        IStructuredSelection sm = (IStructuredSelection)this.tv.getSelection();
        Object firstElement = sm.getFirstElement();
        this.tv.remove(firstElement);
        this.defs.remove(firstElement);
    }

    protected void addNew() {
        ChildElementAttributeHelper h = (ChildElementAttributeHelper)this.getHelper();
        List<NestedDefinition> allowedDefinitions = h.getAllowedDefinitions();
        ChildElementDialog cdlg = new ChildElementDialog(this.context.getProject(), allowedDefinitions, true);
        PropertyCollection propertyCollection = new PropertyCollection();
        cdlg.init(propertyCollection, (IMessageFlowNode)this.getNode());
        ChildElementEditStack.editNested(this.defs, propertyCollection, true);
        try {
            int open = cdlg.open();
            if (open == 0) {
                this.defs.add(cdlg.getResultCollection());
                this.initUI(this.defs);
            }
        }
        finally {
            ChildElementEditStack.finishEdit();
        }
    }

    protected void updateButtons() {
        IStructuredSelection sm = (IStructuredSelection)this.tv.getSelection();
        this.delete.setEnabled(!sm.isEmpty());
        this.edit.setEnabled(!sm.isEmpty());
    }

    @Override
    protected void initUI(List<PropertyCollection> defs2) {
        this.tv.setInput((Object)defs2.toArray());
        this.updateButtons();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.add.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.delete.setEnabled(enabled);
        if (enabled) {
            this.updateButtons();
        }
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

