/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.base.Optional;
import com.onpositive.ide.ui.ControlDecoration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.FixedAttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.IValueConverter;
import org.mule.tooling.ui.modules.core.widgets.RecalcWhenConfigurerUtils;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementDialog;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementTableFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IFieldEditorLayouter;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.INestedElementChooser;

public class ChildElementFieldEditor
extends AbstractChildElementFieldEditor
implements IFieldEditorLayouter,
IRefresheableEditor,
IEditorValueModifiedObservable {
    private static final QName DUMMY_ELEMENT_FOR_VALIDATION = new QName("dummy-element-for-validation");
    private static final Stack<String> stackOfChildren = new Stack();
    private AttributesPropertyPage parentPage;
    protected Label label;
    protected Button browse;
    private Text text;
    private ControlDecoration errorDecoration;
    private Button clear;
    private CLabel cLabel;
    private Composite wrapper;
    private Map<String, AttributesPropertyPage> attributesPages;
    private boolean enabled = true;

    public ChildElementFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    public Map<String, AttributesPropertyPage> getAttributePages() {
        return this.attributesPages;
    }

    @Override
    protected boolean actuallyEmpty(AttributeHelper h) {
        if (this.attributesPages != null) {
            for (AttributesPropertyPage p : this.attributesPages.values()) {
                LinkedHashMap<String, IFieldEditor> editors = p.getEditors();
                IFieldEditor iFieldEditor = editors.get(h.getId());
                if (!(iFieldEditor instanceof ChildElementTableFieldEditor)) continue;
                ChildElementTableFieldEditor tf = (ChildElementTableFieldEditor)iFieldEditor;
                if (tf.defs != null && !tf.defs.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Control createControl(Composite parent) {
        Control result;
        String id = this.getHelper().getId();
        boolean recursiveStructure = stackOfChildren.contains(id);
        stackOfChildren.add(id);
        try {
            result = this.createControl0(parent, recursiveStructure);
        }
        finally {
            stackOfChildren.pop();
        }
        return result;
    }

    @Override
    protected void runPostCreateControlActions() {
        RecalcWhenConfigurerUtils.configureRecalcWhenFor(this.getContributedPages());
    }

    private Control createControl0(Composite parent, boolean recursiveStructure) {
        List<NestedDefinition> allowed;
        ChildElementAttributeHelper h;
        if (this.attributesPages == null) {
            this.attributesPages = new HashMap<String, AttributesPropertyPage>();
        }
        if (this.shouldCreateInplaceEditor(recursiveStructure, h = this.getHelper(), allowed = h.getAllowedDefinitions())) {
            return this.createInplaceEditor(parent, allowed);
        }
        return this.createEditorToConfigureInDialog(parent);
    }

    private boolean shouldCreateInplaceEditor(boolean recursiveStructure, ChildElementAttributeHelper h, List<NestedDefinition> allowed) {
        return allowed != null && allowed.size() == 1 && h.isInplace() && !recursiveStructure;
    }

    private Control createInplaceEditor(Composite parent, List<NestedDefinition> allowed) {
        NestedDefinition definition = allowed.get(0);
        AbstractComponentMeta service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
        Map<String, AttributeCategory> attributesMap = service.getAttributeCategoryMap();
        this.wrapper = new Composite(parent, 0);
        GridLayout c1Layout = new GridLayout(1, false);
        c1Layout.marginWidth = 0;
        c1Layout.marginHeight = 0;
        c1Layout.horizontalSpacing = 0;
        this.wrapper.setLayout((Layout)c1Layout);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.horizontalSpan = 3;
        this.wrapper.setLayoutData((Object)layoutData);
        if (attributesMap.isEmpty()) {
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 0).span(3, 1).applyTo((Control)this.wrapper);
            return this.wrapper;
        }
        CTabFolder tabFolder = new CTabFolder(this.wrapper, 2048);
        tabFolder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        CTabFolder composite = tabFolder;
        boolean changed = false;
        for (String key : attributesMap.keySet()) {
            if (key.length() == 0) {
                composite = this.wrapper;
                changed = true;
            } else {
                composite = tabFolder;
            }
            AttributeCategory attributes = attributesMap.get(key);
            FixedAttributeCategoryProvider provider = new FixedAttributeCategoryProvider(attributes);
            AttributesPropertyPage attributesPage = this.createInternalPage(parent, (Composite)composite, provider);
            this.attributesPages.put(key, attributesPage);
            if (key.length() != 0) {
                CTabItem item = new CTabItem(tabFolder, 0);
                item.setText(key);
                item.setControl((Control)attributesPage);
                continue;
            }
            attributesPage.setLayoutData(new GridData(4, 4, true, false));
            Layout l = attributesPage.getLayout();
            if (!(l instanceof GridLayout)) continue;
            GridLayout pgl = (GridLayout)l;
            pgl.marginWidth = 0;
            pgl.marginHeight = 0;
            pgl.horizontalSpacing = 0;
            pgl.verticalSpacing = 0;
        }
        tabFolder.setSelection(0);
        if (changed && attributesMap.size() == 1) {
            tabFolder.dispose();
        } else if (changed) {
            composite = tabFolder;
        }
        return composite;
    }

    private AttributesPropertyPage createInternalPage(Composite parent, Composite composite, FixedAttributeCategoryProvider provider) {
        AttributesPropertyPage attributesPage = new AttributesPropertyPage(null, this.context.getProject(), composite, (AttributeCategoryProvider)provider){

            @Override
            public IHost getHost() {
                AttributesPropertyPage parentPage2 = ChildElementFieldEditor.this.getParentPage();
                IHost host2 = parentPage2.getHost();
                return host2;
            }

            @Override
            public String getName() {
                return ChildElementFieldEditor.this.getParentPage().getName();
            }

            @Override
            public void validate() {
                super.validate();
                ChildElementFieldEditor.this.getParentPage().validate();
                AttributesPropertyPage.validateLastOpenedFromRoot();
            }

            @Override
            protected boolean isGeneral() {
                return false;
            }
        };
        return attributesPage;
    }

    private Control createEditorToConfigureInDialog(Composite parent) {
        this.setLabel(new Label(parent, 0));
        this.getLabel().setText(this.getHelper().getCaption() + ":");
        this.wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.wrapper.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.wrapper.setLayout((Layout)layout);
        this.cLabel = new CLabel(this.wrapper, 0);
        this.text = new Text(this.wrapper, 2056);
        this.text.setLayoutData(this.getLayoutData());
        this.browse = new Button(this.wrapper, 0);
        this.browse.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildElementFieldEditor.this.doConfigure();
            }
        });
        this.clear = new Button(this.wrapper, 0);
        this.clear.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildElementFieldEditor.this.doClear();
            }
        });
        this.clear.setEnabled(false);
        FieldDecoration dec = new FieldDecoration(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage(), this.getHelper().getDescription());
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.clear, 131200);
        controlDecoration.setMarginWidth(1);
        controlDecoration.setImage(dec.getImage());
        controlDecoration.setDescriptionText(dec.getDescription());
        controlDecoration.setShowHover(true);
        this.errorDecoration = new ControlDecoration((Control)this.text, 17408);
        this.errorDecoration.setMarginWidth(1);
        this.errorDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.errorDecoration.hide();
        return this.text;
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractComponentMeta getMeta(Composite parent) {
        if (this.page == null) ** GOTO lbl4
        return this.page.getAssotiatedMeta();
lbl-1000:
        // 1 sources

        {
            parent = parent.getParent();
lbl4:
            // 2 sources

            ** while (!(parent instanceof AttributesPropertyPage))
        }
lbl5:
        // 1 sources

        this.page = (AttributesPropertyPage)parent;
        return this.page.getAssotiatedMeta();
    }

    private void doClear() {
        this.getDefs().forEach(def -> this.delete(this.getDefs(), (PropertyCollection)def));
        this.initUI(this.getDefs());
        this.getParentPage().validate();
    }

    protected void doConfigure() {
        ChildElementAttributeHelper h = this.getHelper();
        List<NestedDefinition> allowedDefinitions = h.getAllowedDefinitions();
        ChildElementDialog dlg = new ChildElementDialog(this.context.getProject(), allowedDefinitions, this.getDefs().isEmpty());
        if (!this.getDefs().isEmpty()) {
            dlg.init(this.getDefs().get(0), this.getMessageFlowNode());
        } else {
            PropertyCollection propertyCollection = new PropertyCollection();
            propertyCollection.setName(this.getPropertyCollectionName(this.getMessageFlowNode().getType()));
            dlg.init(propertyCollection, this.getMessageFlowNode());
        }
        int open = dlg.open();
        if (open == 0) {
            if (this.getDefs().isEmpty()) {
                PropertyCollection resultCollection = dlg.getResultCollection();
                IElementWrapper newElement = MessageFlowUtils.createElement((IMessageFlowNode)this.getMessageFlowNode(), (PropertyCollection)resultCollection, (int)this.getHelper().getXmlOrder());
                resultCollection.setElement(newElement);
                this.addToDefs(resultCollection);
            }
            if (!this.isDisposed()) {
                this.initUI(this.getDefs());
                this.getParentPage().validate();
            }
        }
    }

    private Object getLayoutData() {
        return GridDataFactory.fillDefaults().grab(true, true).minSize(1, 41).create();
    }

    private Label getLabel() {
        return this.label;
    }

    private void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        Optional backupState = props.getPropertyOpt("BACKUP_STATE");
        ArrayList<PropertyCollection> backupDefs = new ArrayList<PropertyCollection>(this.getDefs());
        ChildElementAttributeHelper h = this.getHelper();
        List<NestedDefinition> allowed = h.getAllowedDefinitions();
        ArrayList<PropertyCollection> oldDefs = new ArrayList<PropertyCollection>(this.getDefs());
        if (allowed != null && allowed.size() == 1 && h.isInplace()) {
            PropertyCollectionMap newProperties = new PropertyCollectionMap();
            PropertyCollection collection = new PropertyCollection();
            Property index = null;
            if (this.getDefs().size() >= 1) {
                index = PropertiesUtils.findPropertyByName((List)this.getDefs().get(0).getProperties(), (String)"auxiliary;index");
            }
            this.clearDefs();
            this.addToDefs(collection);
            for (String k : this.attributesPages.keySet()) {
                AttributesPropertyPage attributesPage = this.attributesPages.get(k);
                if (backupState.isPresent()) {
                    newProperties.addProperty("BACKUP_STATE", Boolean.TRUE.toString());
                }
                attributesPage.saveTo(node, newProperties);
                newProperties.removeProperty("BACKUP_STATE");
            }
            collection.getProperties().clear();
            IValueConverter persistence = this.getHelper().getPersistence();
            if (persistence == null) {
                String id = this.getHelper().getId();
                NestedDefinition nestedElement = MuleCorePlugin.getModuleManager().getNestedDefinition(id);
                if (nestedElement != null) {
                    persistence = (IValueConverter)nestedElement.getService(INestedElementChooser.class);
                }
            }
            if (persistence instanceof INestedElementChooser) {
                INestedElementChooser ch = (INestedElementChooser)((Object)persistence);
                String id = ch.getId(newProperties, props, this.getHelper().getId());
                if (StringUtils.isBlank((String)id)) {
                    this.removeFromDefs(collection);
                    return;
                }
                collection.setName(id);
            } else {
                collection.setName(this.getPropertyCollectionName(allowed.get(0).getId()));
            }
            collection.getPropertyCollections().clear();
            Map propertyCollections = newProperties.getPropertyCollections();
            Set keySet = propertyCollections.keySet();
            HashSet<String> toRemove = new HashSet<String>();
            for (String key : keySet) {
                if (!key.startsWith("-")) continue;
                toRemove.add(key);
            }
            for (String key : toRemove) {
                keySet.remove(key);
            }
            List asPropertyList = newProperties.getPropertiesMap().asPropertyList();
            for (Property newProp : asPropertyList) {
                collection.getProperties().add(newProp);
            }
            for (String s : propertyCollections.keySet()) {
                PropertyCollection asPropertyCollection = ((PropertyCollectionMap)propertyCollections.get(s)).asPropertyCollection();
                asPropertyCollection.setName(s);
                collection.getPropertyCollections().add(asPropertyCollection);
            }
            if (index != null) {
                collection.getProperties().add(index);
            }
            IElementWrapper element = MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)collection, (int)this.getHelper().getXmlOrder());
            collection.setElement(element);
            if (!backupState.isPresent()) {
                for (PropertyCollection oldPropertyCollection : oldDefs) {
                    String oldPropertyCollectionName = oldPropertyCollection.getName();
                    if (oldPropertyCollectionName == null) continue;
                    int lastIndexOf = oldPropertyCollectionName.lastIndexOf(59);
                    oldPropertyCollectionName = oldPropertyCollectionName.substring(0, lastIndexOf != -1 ? lastIndexOf : oldPropertyCollectionName.length());
                    if (!collection.getName().startsWith(oldPropertyCollectionName) || oldPropertyCollection.getElement() == null) continue;
                    this.removeFromDefs(collection);
                    this.addToDefs(PropertiesUtils.from((PropertyCollection)collection, (IElementWrapper)oldPropertyCollection.getElement()));
                }
            }
        } else if (backupState.isPresent()) {
            this.clearDefs();
            for (PropertyCollection oldPropertyCollection : oldDefs) {
                IElementWrapper element = MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)oldPropertyCollection, (int)this.getHelper().getXmlOrder());
                this.addToDefs(PropertiesUtils.from((PropertyCollection)oldPropertyCollection, (IElementWrapper)element));
            }
        }
        super.saveTo(node, props);
        if (backupState.isPresent()) {
            this.clearDefs();
            this.setDefs(backupDefs);
        }
    }

    @Override
    protected void initUI(List<PropertyCollection> defs2) {
        ChildElementAttributeHelper h = this.getHelper();
        List<NestedDefinition> allowed = h.getAllowedDefinitions();
        List<PropertyCollection> propertyCollections = this.getNotErased(defs2);
        if (allowed != null && allowed.size() == 1 && h.isInplace()) {
            PropertyCollection propertyCollection;
            if (propertyCollections.isEmpty()) {
                propertyCollection = new PropertyCollection();
                propertyCollection.setName(this.getPropertyCollectionName(allowed.get(0).getId()));
                this.addToDefs(propertyCollection);
            }
            propertyCollection = this.getNotErased(defs2).get(0);
            for (String k : this.attributesPages.keySet()) {
                AttributesPropertyPage attributesPage = this.attributesPages.get(k);
                attributesPage.loadFrom(this.getMessageFlowNode(), new PropertyCollectionMap(propertyCollection));
            }
        } else {
            if (propertyCollections.isEmpty()) {
                this.clear.setEnabled(false);
                this.browse.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
                this.cLabel.setImage(null);
                this.cLabel.setLayoutData((Object)new GridData(0, 0));
                this.text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(-5, 0).create());
                this.text.setText("");
                this.wrapper.layout(true, true);
                return;
            }
            this.browse.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW"));
            this.clear.setEnabled(true);
            PropertyCollection propertyCollection = propertyCollections.get(0);
            NestedDefinition nodeDef = AbstractChildElementFieldEditor.getNodeDef(propertyCollection);
            this.text.setText(ChildElementFieldEditor.getNestedElementLabel(nodeDef, propertyCollection));
            this.cLabel.setLayoutData((Object)new GridData());
            this.text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).create());
            this.cLabel.setImage(nodeDef.getIconImage());
            this.wrapper.layout(true, true);
        }
    }

    @Override
    public int computeLabelSize() {
        int msize = 0;
        for (AttributesPropertyPage page : this.attributesPages.values()) {
            int tmpSize = page.computeLabelSize();
            msize = Math.max(tmpSize, msize);
        }
        return msize;
    }

    @Override
    public void updateLabelSize(int size) {
        for (AttributesPropertyPage page : this.attributesPages.values()) {
            page.updateLabelSize(size);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.text != null) {
            this.text.setEnabled(enabled);
            this.browse.setEnabled(enabled);
        }
        for (AttributesPropertyPage p : this.attributesPages.values()) {
            p.setEnabled(enabled);
        }
    }

    @Override
    protected void processMap(PropertyCollectionMap mq) {
        String valuePersistenceRequires;
        IDocumentWrapper document = ((MuleConfiguration)this.context.getDecorator().getEntity()).getDocument();
        final IElementWrapper xmlelement = document.createElement(DUMMY_ELEMENT_FOR_VALIDATION);
        MessageFlowNode node = new MessageFlowNode(){

            public IElementWrapper getElement() {
                return xmlelement;
            }
        };
        if (this.getHelper() instanceof ChildElementAttributeHelper && (valuePersistenceRequires = this.getHelper().getValuePersistenceRequires()) != null) {
            String[] requiredEditors;
            String[] stringArray = requiredEditors = valuePersistenceRequires.split(",");
            int n = requiredEditors.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredEditor = stringArray[n2];
                this.getParentPage().getEditors().get(requiredEditor).saveTo((IMessageFlowNode)node, mq);
                ++n2;
            }
        }
        this.saveTo((IMessageFlowNode)node, mq);
    }

    public String getText() {
        return this.text.getText();
    }

    public PropertyCollection getPropertyCollection() {
        if (this.getDefs().isEmpty()) {
            return null;
        }
        return this.getDefs().get(0);
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener observer) {
        Collection<AttributesPropertyPage> values = this.attributesPages.values();
        for (AttributesPropertyPage attributesPropertyPage : values) {
            Collection<IFieldEditor> innerEditors = attributesPropertyPage.getEditors().values();
            for (IFieldEditor innerEditor : innerEditors) {
                if (!(innerEditor instanceof IEditorValueModifiedObservable)) continue;
                ((IEditorValueModifiedObservable)((Object)innerEditor)).addModificationListener(observer);
            }
        }
    }

    @Override
    public void refreshEditor(String value, boolean shouldNotifyObservers) {
        if (this.loaded()) {
            Collection<AttributesPropertyPage> values = this.attributesPages.values();
            for (AttributesPropertyPage attributesPropertyPage : values) {
                Collection<IFieldEditor> innerEditors = attributesPropertyPage.getEditors().values();
                for (IFieldEditor innerEditor : innerEditors) {
                    if (!(innerEditor instanceof IRefresheableEditor)) continue;
                    ((IRefresheableEditor)innerEditor).refreshEditor(value, shouldNotifyObservers);
                }
            }
        }
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        if (this.parentPage != null) {
            return this.parentPage;
        }
        Composite parent = this.control.getParent();
        while (!(parent instanceof AttributesPropertyPage)) {
            parent = parent.getParent();
        }
        this.parentPage = (AttributesPropertyPage)parent;
        return this.parentPage;
    }

    @Override
    public void setMessageFlowNode(IMessageFlowNode node) {
        super.setMessageFlowNode(node);
        for (Map.Entry<String, AttributesPropertyPage> entry : this.attributesPages.entrySet()) {
            entry.getValue().setMessageFlowNode(node);
        }
    }

    public static String getGroupPrefix() {
        StringBuilder prefix = new StringBuilder();
        for (String nestedName : stackOfChildren) {
            prefix.append(nestedName);
            prefix.append('.');
        }
        return prefix.toString();
    }

    private List<MessageFlowNodeComposite> getContributedPages() {
        Stream<MessageFlowNodeComposite> parentPages = this.getParentOpenPagesIfAvailable();
        Stream<MessageFlowNodeComposite> currentChildPages = this.attributesPages.values().stream().map(MessageFlowNodeComposite.class::cast);
        return Stream.concat(parentPages, currentChildPages).collect(Collectors.toList());
    }

    private Stream<MessageFlowNodeComposite> getParentOpenPagesIfAvailable() {
        AttributesPropertyPage parentPage = this.getParentPage();
        Stream<MessageFlowNodeComposite> parentPages = parentPage != null ? parentPage.getAllOpenPages().stream().map(MessageFlowNodeComposite.class::cast) : Stream.empty();
        return parentPages;
    }

    private String getPropertyCollectionName(String type) {
        if (this.getHelper().isMultiple()) {
            return PropertiesUtils.createTailCollectionId((String)type);
        }
        return PropertiesUtils.createNewCollectionId((String)type);
    }

    @Override
    public ChildElementAttributeHelper getHelper() {
        return (ChildElementAttributeHelper)super.getHelper();
    }
}

