/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.HelpSystemConnector;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementWizard;

public class ChildElementDialog
extends WizardDialog {
    private ChildElementWizard q;

    public ChildElementDialog(IMuleProject iMuleProject, List<NestedDefinition> allowedDefinitions, boolean showSelection) {
        super(Display.getCurrent().getActiveShell(), (IWizard)new ChildElementWizard(iMuleProject, allowedDefinitions, showSelection));
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    public void init(PropertyCollection propertyCollection, IMessageFlowNode node) {
        NestedDefinition nodeDef;
        this.q = (ChildElementWizard)this.getWizard();
        this.q.setCallbacks(new FinishButtonCallbacksImpl());
        this.q.init(propertyCollection, node);
        if (propertyCollection != null && (nodeDef = AbstractChildElementFieldEditor.getNodeDef(propertyCollection)) != null) {
            HelpSystemConnector.connect((Composite)this.getParentShell(), (NodeDefinition)nodeDef);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control createDialogArea = super.createDialogArea(parent);
        IProgressMonitor progressPart = this.getProgressMonitor();
        if (progressPart instanceof Composite) {
            ((Composite)progressPart).dispose();
        }
        return createDialogArea;
    }

    public PropertyCollection getResultCollection() {
        ChildElementWizard q = (ChildElementWizard)this.getWizard();
        return q.getResult();
    }

    protected void finishPressed() {
        ChildElementWizard q = (ChildElementWizard)this.getWizard();
        if (q.canFinish()) {
            super.finishPressed();
        }
    }

    public static interface FinishButtonCallbacks {
        public void disable();

        public void enable();
    }

    private class FinishButtonCallbacksImpl
    implements FinishButtonCallbacks {
        private FinishButtonCallbacksImpl() {
        }

        @Override
        public void disable() {
            this.setFinishButtonEnabled(false);
        }

        @Override
        public void enable() {
            this.setFinishButtonEnabled(true);
        }

        void setFinishButtonEnabled(boolean enabled) {
            Button finishButton = ChildElementDialog.this.getButton(16);
            if (finishButton != null) {
                finishButton.setEnabled(enabled);
            }
        }
    }
}

