/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.autocomplete.mel.AutocompleteConfiguration;
import org.mule.tooling.ui.modules.core.autocomplete.mel.view.MELViewer;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.utils.script.ScriptUtils;

public class BooleanWithExpressionEditor
extends LabelledFieldEditor
implements IRefresheableEditor,
IEditorValueModifiedObservable {
    private static final String EXPRESSION_ITEM = "expression";
    protected StructuredViewer cmb;
    protected String value;
    private boolean inSet;
    private boolean onSelectionChangeCalled = false;
    private Set<IEditorValueModifiedListener> valueModifiedListeners;
    private List<IPropertyValueChangeListener> propertyValueChangeListeners;
    private TextViewer viewer;

    public BooleanWithExpressionEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        if (!atr.isSupportsExpressions() && (atr.isRequired() || atr.hasDefaultValue())) {
            throw new IllegalArgumentException("Use a regular two-state Boolean editor instead");
        }
    }

    public void toogleWarningIndicator(boolean showWarningIndicator) {
        Image image = null;
        String tooltip = "";
        if (this.label instanceof CLabel) {
            CLabel clabel = (CLabel)this.label;
            clabel.setImage(image);
            clabel.setToolTipText(tooltip);
            clabel.redraw();
        }
    }

    private String getOptionText(EnumOption m) {
        return m.caption;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.cmb = new ComboViewer(container, 8);
        this.cmb.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmb.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EnumOption m = (EnumOption)element;
                String name = BooleanWithExpressionEditor.this.getOptionText(m);
                if (!m.isEmptyOption()) {
                    name = BooleanWithExpressionEditor.this.getOptionText(m);
                }
                return name;
            }
        });
        ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BooleanWithExpressionEditor.this.onSelectionChange(true);
            }
        };
        this.cmb.addSelectionChangedListener(selectionChangeListener);
        this.viewer = this.createDefaultViewer(container);
        GridDataFactory.swtDefaults().applyTo(this.cmb.getControl());
        this.initInput();
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        GridDataFactory.swtDefaults().applyTo((Control)container);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.viewer.getControl());
        this.addModificationListeners(this.viewer);
        return container;
    }

    private void addModificationListeners(TextViewer scriptViewer) {
        IDocumentListener callback = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                BooleanWithExpressionEditor.this.doValidate();
                BooleanWithExpressionEditor.this.notifyObservers();
            }
        };
        scriptViewer.getDocument().addDocumentListener((IDocumentListener)new IdleDocumentEventListener(callback, scriptViewer.getControl()));
    }

    protected TextViewer createDefaultViewer(Composite parent) {
        MELViewer viewer = new MELViewer(parent, new IObjectRef<EvaluatorExtensionConfiguration>(){

            public AutocompleteConfiguration get() {
                return new AutocompleteConfiguration(BooleanWithExpressionEditor.this.node, BooleanWithExpressionEditor.this.context.getMuleConfiguration(), BooleanWithExpressionEditor.this.context.getProject(), BooleanWithExpressionEditor.this);
            }
        }, 2052);
        return viewer;
    }

    @Override
    public void validate() {
        super.validate();
    }

    protected void initInput() {
        this.refreshEditor(this.getValue(), false);
        if (this.value != null) {
            this.setValue(this.value);
        }
    }

    @Override
    public final void refreshEditor(String value, boolean shouldNotifyObservers) {
        if (!ExpressionUtils.isExpressionOrProperty((String)value)) {
            List<EnumOption> options = this.calcOptions();
            if (this.cmb.getControl() instanceof Combo) {
                ISelection selection = this.cmb.getSelection();
                this.cmb.setInput((Object)options.toArray());
                if (!selection.isEmpty()) {
                    this.cmb.setSelection(selection);
                } else if (options.size() == 1 && StringUtils.isEmpty((String)options.get((int)0).value)) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                } else {
                    Optional<EnumOption> enumValue = options.stream().filter(x -> x.value == value).findFirst();
                    enumValue.ifPresent(x -> this.cmb.setSelection((ISelection)new StructuredSelection(x)));
                }
            } else {
                this.cmb.setInput((Object)options.toArray());
                if (options.size() == 1) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                }
            }
            this.setSelection(value, options);
        }
    }

    protected void setSelection(String value, List<EnumOption> options) {
        String enumValue;
        EnumOption enumOption;
        IValueCalculator valueCalculator;
        if (this.attributeHelper instanceof EnumHelper && (valueCalculator = this.getAttributes().getValueCalculator()) != null && (enumOption = this.getEnumOptionFrom(options, enumValue = valueCalculator.value(value, this, this.node))) != null) {
            this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
        }
    }

    private EnumOption getEnumOptionFrom(List<EnumOption> options, String enumValue) {
        for (EnumOption enumOption : options) {
            if (!enumOption.value.equals(enumValue)) continue;
            return enumOption;
        }
        return null;
    }

    private EnumHelper getAttributes() {
        return (EnumHelper)this.attributeHelper;
    }

    protected List<EnumOption> calcOptions() {
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        options.add(EnumOption.getEmptyOption());
        Boolean booleanDefaultValue = this.attributeHelper.hasDefaultValue() ? (Boolean)this.attributeHelper.getDefaultValue() : null;
        options.add(new EnumOption("true", "True" + (Boolean.TRUE.equals(booleanDefaultValue) ? " (Default)" : "")));
        options.add(new EnumOption("false", "False" + (Boolean.FALSE.equals(booleanDefaultValue) ? " (Default)" : "")));
        if (this.attributeHelper.isSupportsExpressions()) {
            options.add(new EnumOption(EXPRESSION_ITEM, "Expression"));
        }
        return options;
    }

    @Override
    public String getPublicValue() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        if (Display.getCurrent() == null) {
            return this.value;
        }
        EnumOption option = this.getSelectedEnumOption();
        if (option == null || option.value == null) {
            if (this.getHelper().getDefaultValue() != null && StringUtils.isNotBlank((String)this.getHelper().getDefaultValue().toString())) {
                return this.getHelper().getDefaultValue().toString();
            }
            return "";
        }
        if (EXPRESSION_ITEM == option.value) {
            if (this.viewer != null && this.viewer.getDocument() != null) {
                return this.viewer.getDocument().get();
            }
            return "";
        }
        return option.value;
    }

    protected EnumOption getSelectedEnumOption() {
        IStructuredSelection selection = (IStructuredSelection)this.cmb.getSelection();
        EnumOption op = (EnumOption)selection.getFirstElement();
        return op;
    }

    @Override
    public void setValue(String value) {
        block7: {
            this.value = value;
            this.inSet = true;
            try {
                List<EnumOption> options = this.calcOptions(value);
                this.cmb.setInput((Object)options.toArray());
                for (EnumOption o : options) {
                    if (o.value == null || !o.value.equals(value)) continue;
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)o), true);
                    return;
                }
                if (!ScriptUtils.isScript((String)value)) break block7;
                try {
                    this.viewer.getDocument().set(value);
                    this.viewer.refresh();
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(options.size() - 1)), true);
            }
            finally {
                this.inSet = false;
            }
        }
    }

    protected List<EnumOption> calcOptions(String valueToSet) {
        return this.calcOptions();
    }

    protected void onSelectionChange(boolean shouldNotify) {
        if (this.onSelectionChangeCalled) {
            return;
        }
        try {
            IEditorSelectionListener listener2;
            this.onSelectionChangeCalled = true;
            if (!this.inSet) {
                this.value = this.getValue();
            }
            EnumOption option = this.getSelectedEnumOption();
            if (option.value == EXPRESSION_ITEM) {
                this.viewer.getControl().setVisible(true);
                this.viewer.getControl().setFocus();
            } else {
                this.viewer.getControl().setVisible(false);
            }
            AttributeHelper helper = this.getHelper();
            if (helper instanceof IHasListener && (listener2 = ((IHasListener)((Object)helper)).getListener()) != null) {
                listener2.selectionChanged(this);
            }
            for (IPropertyValueChangeListener propertyValueChangeListener : this.getPropertyValueChangeListeners()) {
                propertyValueChangeListener.propertyChanged(helper.getId(), "", this.getValue());
            }
        }
        finally {
            this.onSelectionChangeCalled = false;
        }
    }

    private List<IPropertyValueChangeListener> getPropertyValueChangeListeners() {
        if (this.propertyValueChangeListeners == null) {
            this.propertyValueChangeListeners = new ArrayList<IPropertyValueChangeListener>();
        }
        return this.propertyValueChangeListeners;
    }

    protected void notifyObservers() {
        for (IEditorValueModifiedListener valueModifiedListener : this.getValueModifiedListeners()) {
            valueModifiedListener.valueModified(this.getValue());
        }
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener listener) {
        this.getValueModifiedListeners().add(listener);
    }

    private Set<IEditorValueModifiedListener> getValueModifiedListeners() {
        if (this.valueModifiedListeners == null) {
            this.valueModifiedListeners = new HashSet<IEditorValueModifiedListener>();
        }
        return this.valueModifiedListeners;
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return true;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addPropertyChangeListener(IPropertyValueChangeListener propertyListener) {
        this.getPropertyValueChangeListeners().add(propertyListener);
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
        this.getPropertyValueChangeListeners().clear();
    }
}

