/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.MultiSelectAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class BooleanListEditor
extends AbstractFieldEditor {
    private CheckboxTableViewer tv;
    private HashMap<String, String> optionsMap;
    private Object dataForController;

    public BooleanListEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout fill = new FillLayout(256);
        fill.marginHeight = 0;
        fill.marginWidth = 0;
        composite.setLayout((Layout)fill);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData);
        this.tv = new CheckboxTableViewer(new Table(composite, 2080));
        this.tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.updateOptions();
        return this.tv.getTable();
    }

    @Override
    public String getValue() {
        if (this.getHelper().getBooleanListController() != null) {
            return this.getHelper().getBooleanListController().getValue(this);
        }
        return this.defaultGetValue();
    }

    @Override
    public void setValue(String value) {
        if (this.getHelper().getBooleanListController() != null) {
            this.getHelper().getBooleanListController().setValue(value, this);
        } else {
            this.defaultSetValue(value);
        }
    }

    public String defaultGetValue() {
        Object[] checkedElements = this.tv.getCheckedElements();
        StringBuilder bld = new StringBuilder();
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            String value = this.optionsMap.get(checkedElement.toString());
            bld.append(value);
            bld.append(this.getDelimiter());
            ++n2;
        }
        if (bld.length() > 0) {
            bld.deleteCharAt(bld.length() - 1);
        }
        return bld.toString();
    }

    public void defaultSetValue(String value) {
        this.updateOptions();
        String[] split = value.split(String.valueOf(this.getDelimiter()));
        List<EnumOption> options = this.getHelper().getOptionsCalculator().options(this, this.node);
        ArrayList<EnumOption> msq = new ArrayList<EnumOption>();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            for (EnumOption o : options) {
                if (!o.value.equals(s)) continue;
                msq.add(o);
            }
            ++n2;
        }
        this.tv.setCheckedElements(msq.toArray());
    }

    public void updateOptions() {
        List<EnumOption> options = this.getHelper().getOptionsCalculator().options(this, this.node);
        ArrayList<String> options2 = new ArrayList<String>();
        for (EnumOption option : options) {
            if (option.caption.isEmpty()) continue;
            options2.add(option.caption);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (EnumOption option : options) {
            map.put(option.caption, option.value);
        }
        this.optionsMap = map;
        this.tv.setInput((Object)options2.toArray());
        this.tv.setCheckedElements((Object[])new String[0]);
    }

    public final char getDelimiter() {
        return this.getHelper().getDelimiter() == null ? (char)',' : this.getHelper().getDelimiter().charValue();
    }

    public final CheckboxTableViewer getCheckboxTableViewer() {
        return this.tv;
    }

    @Override
    public MultiSelectAttributeHelper getHelper() {
        return (MultiSelectAttributeHelper)this.attributeHelper;
    }

    public final void setDataForController(Object stateDataForController) {
        this.dataForController = stateDataForController;
    }

    public final Object getDataForController() {
        return this.dataForController;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

