/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.onpositive.ide.ui.ControlDecoration;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.ExpressionWidget;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.HighlighterImpl;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.BooleanAttributeHelper;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.script.ScriptUtils;

public class BooleanFieldEditor
extends AbstractFieldEditor {
    private final boolean isNegative;
    private ExpressionWidget expressionWidget;
    private Composite holder;
    protected Button button;
    private ControlDecoration infoDecoration;

    public BooleanFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        this.isNegative = atr instanceof BooleanAttributeHelper ? ((BooleanAttributeHelper)atr).isNegative() : false;
        if (atr.isTiny()) {
            this.hide();
        }
    }

    @Override
    public Control getEventControl() {
        return this.button;
    }

    @Override
    protected Control getInfoDecorationControl() {
        return this.holder;
    }

    @Override
    protected String getBasicModeTooltip() {
        return "Click here to use the default 'true' or 'false' values for this attribute";
    }

    @Override
    protected String getExpressionModeTooltip() {
        return "Click here to add an expression for this logic attribute";
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite cm = new Composite(parent, 0);
        GridLayout ll = new GridLayout(3, false);
        ll.marginHeight = 0;
        ll.marginWidth = 0;
        ll.horizontalSpacing = 10;
        cm.setLayout((Layout)ll);
        this.holder = new Composite(cm, 0);
        this.button = new Button(cm, this.getStyle());
        if (32 == this.getStyle()) {
            ThemeUtils.setCssClass((Object)this.button, (String)"CheckBoxButton");
        }
        this.button.setText(this.attributeHelper.getCaption());
        if (this.hasWarningMessage()) {
            this.button.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        }
        cm.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).span(3, 1).create());
        StackLayout layout = new StackLayout();
        this.holder.setLayout((Layout)layout);
        layout.topControl = this.button;
        if (this.attributeHelper.isSupportsExpressions()) {
            this.createExpressionSwitcher(cm);
        }
        return cm;
    }

    private boolean hasWarningMessage() {
        return StringUtils.isNotEmpty((String)this.attributeHelper.getWarningMessage());
    }

    @Override
    protected int switchOffset() {
        return 18;
    }

    protected int getStyle() {
        return 32;
    }

    @Override
    protected void switchFromExpression() {
        if (this.infoDecoration != null) {
            this.infoDecoration.hide();
            this.infoDecoration.setShowOnlyOnFocus(false);
        }
        if (!this.doBasicExpressionFieldCheck(this.expressionWidget.getText())) {
            this.setValue(this.expressionWidget.getText());
        } else {
            this.setValue("");
            this.expressionWidget.setText("");
        }
        this.expressionWidget.getControl().setVisible(false);
        this.button.setEnabled(true);
        this.validate();
    }

    @Override
    protected boolean doBasicExpressionFieldCheck(String value) {
        String trim = value;
        return !trim.equalsIgnoreCase("true") && !trim.equalsIgnoreCase("false") && !trim.equals("");
    }

    @Override
    public String getValue() {
        if (this.isExpression()) {
            return this.expressionWidget.getText();
        }
        return this.getValue1();
    }

    protected void popupClosed() {
    }

    protected void popupOpened() {
    }

    protected StyleRange[] doHighlight(LineStyleEvent event) {
        HighlighterImpl im = new HighlighterImpl(this.context.getVersion());
        return im.highlightInsideExpresssion(0, event.lineText);
    }

    @Override
    protected void switchToExpression() {
        if (this.expressionWidget == null) {
            this.expressionWidget = new ExpressionWidget(this.context){

                @Override
                public int getStyle() {
                    return 64;
                }

                @Override
                protected void completionStarted() {
                    BooleanFieldEditor.this.popupOpened();
                }

                @Override
                protected void completionFinished() {
                    BooleanFieldEditor.this.popupClosed();
                }

                @Override
                protected StyleRange[] doHighlight(LineStyleEvent event) {
                    return BooleanFieldEditor.this.doHighlight(event);
                }

                @Override
                public void createPartControl(Composite parent) {
                    super.createPartControl(parent);
                    this.sv.getDocument().addDocumentListener(new IDocumentListener(){

                        public void documentChanged(DocumentEvent event) {
                            BooleanFieldEditor.this.doValidate();
                        }

                        public void documentAboutToBeChanged(DocumentEvent event) {
                        }
                    });
                }

                @Override
                protected String getEvaluator() {
                    return BooleanFieldEditor.this.getDefaultEvaluator();
                }
            };
            this.expressionWidget.createPartControl((Composite)this.getControl());
            Text c = new Text(this.holder, 0);
            Point computeSize = c.computeSize(-1, -1);
            c.dispose();
            GridData dd = new GridData(-1, computeSize.y);
            dd.grabExcessHorizontalSpace = true;
            dd.horizontalAlignment = 4;
            this.expressionWidget.getTextWidget().getParent().getParent().setLayoutData((Object)dd);
            this.infoDecoration = new ControlDecoration(this.expressionWidget.getTextWidget(), 17408);
            this.infoDecoration.setMarginWidth(4);
            this.infoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
            this.infoDecoration.setDescriptionText(this.attributeHelper.getDescription());
            this.infoDecoration.hide();
        } else {
            this.expressionWidget.getControl().setVisible(true);
        }
        this.holder.layout(true, true);
        this.button.setEnabled(false);
        AttributesPropertyPage parentPage = this.getParentPage();
        parentPage.layout(true, true);
        if (parentPage.getParent() instanceof ScrolledComposite) {
            ScrolledComposite pm = (ScrolledComposite)parentPage.getParent();
            panelSize = parentPage.computeSize(-1, -1);
            pm.setMinSize(-1, panelSize.y);
        } else {
            Shell shell = parentPage.getShell();
            panelSize = shell.computeSize(-1, -1);
            Point size = shell.getSize();
            if (size.y < panelSize.y) {
                size.y = panelSize.y;
                shell.setSize(size);
            }
        }
        this.getControl().getShell().layout(true, true);
    }

    protected String getDefaultEvaluator() {
        return null;
    }

    @Override
    public void setValue(String value) {
        if (ScriptUtils.isScript((String)value)) {
            this.enableExpressionEditor();
            this.expressionWidget.setText(value);
        } else {
            this.setValue1(value);
        }
    }

    protected String getValue1() {
        Button b = this.button;
        if (this.hadValue) {
            return Boolean.toString(b.getSelection() ^ this.isNegative);
        }
        return null;
    }

    protected void setValue1(String value) {
        Button b = this.button;
        b.setSelection(Boolean.parseBoolean(value) ^ this.isNegative);
    }

    public void hide() {
        Control[] controls = new Control[]{this.control, this.button, this.holder};
        int i = 0;
        while (i < controls.length) {
            if (controls[i] != null && controls[i].getLayoutData() != null) {
                controls[i].setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 128).hint(1, 1).grab(false, false).create());
                controls[i].setVisible(false);
            }
            ++i;
        }
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return true;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.hasWarningMessage()) {
            if (enabled) {
                this.button.setImage(MuleImages.WARN_EDITOR_IMAGE);
            } else {
                this.button.setImage(MuleImages.WARN_EDITOR_IMAGE_DISABLED);
            }
        }
        super.setEnabled(enabled);
    }
}

