/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementEditStack;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementTableFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.TextAttributeMeta;

public class AttributeHelperCellEditor
extends CellEditor {
    protected AttributeContext ctx;
    private ChildElementTableFieldEditor editor;
    protected AttributeHelper atr;
    protected StringFieldEditor innerEditor;
    protected boolean isPopup;
    static ChildElementEditStack.ListInfo lastInfo;

    public AttributeHelperCellEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, ChildElementTableFieldEditor ed) {
        this.ctx = ctx;
        this.atr = atr;
        this.editor = ed;
        this.create(parent);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = new CellEditor.LayoutData();
        Control control = this.getControl();
        if (control != null) {
            Point computeSize = control.computeSize(-1, -1, true);
            layoutData.minimumWidth = computeSize.x;
            layoutData.minimumHeight = computeSize.y;
            layoutData.verticalAlignment = 128;
        }
        return layoutData;
    }

    protected Control createControl(Composite parent) {
        final boolean isMultiline = this.atr instanceof TextAttributeMeta;
        this.innerEditor = new StringFieldEditor(this.ctx, this.atr, parent, this.editor.getMessageFlowNode()){

            @Override
            protected void popupOpened() {
                AttributeHelperCellEditor.this.isPopup = true;
            }

            @Override
            protected void popupClosed() {
                AttributeHelperCellEditor.this.isPopup = false;
            }

            @Override
            protected boolean isMultiline() {
                return isMultiline;
            }
        };
        this.innerEditor.addTraverseListener(e -> {
            if (!this.isPopup && e.detail == 4) {
                this.fireApplyEditorValue();
                e.doit = false;
                this.fireCancelEditor();
            }
            if (e.detail == 2) {
                e.doit = false;
                this.fireCancelEditor();
            }
            if (e.detail == 16) {
                e.doit = false;
                this.fireApplyEditorValue();
                this.fireCancelEditor();
                this.editor.activateNext(this);
            }
            if (e.detail == 8) {
                e.doit = false;
                this.fireApplyEditorValue();
                this.fireCancelEditor();
                this.editor.activatePrev(this);
            }
        });
        return this.innerEditor.getControl();
    }

    protected Object doGetValue() {
        return this.innerEditor.getValue();
    }

    protected void doSetFocus() {
        this.innerEditor.setFocus();
    }

    protected void doSetValue(Object value) {
        lastInfo = this.editor.getInfo();
        this.innerEditor.setValue(value != null ? value.toString() : "");
    }

    public StringFieldEditor getInnerEditor() {
        return this.innerEditor;
    }

    public static ChildElementEditStack.ListInfo getParentInfo() {
        return lastInfo;
    }
}

