/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.Comparator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

public abstract class AbstractSortController
extends SelectionAdapter {
    private static final String CONTROLLER = "controller";
    private StructuredViewer viewer;
    private Item column;
    private Comparator columnComparator;
    private boolean state = true;

    public static AbstractSortController getController(Control control, Item column) {
        return (AbstractSortController)((Object)column.getData(CONTROLLER));
    }

    public AbstractSortController(StructuredViewer viewer, Item column, Comparator columnComparator, boolean defaultDesc) {
        column.setData(CONTROLLER, (Object)this);
        this.viewer = viewer;
        this.column = column;
        this.columnComparator = columnComparator;
        this.state = defaultDesc;
    }

    public void widgetSelected(SelectionEvent e) {
        TableViewer tv;
        boolean newColumn = false;
        if (this.viewer instanceof TableViewer) {
            tv = (TableViewer)this.viewer;
            boolean bl = newColumn = tv.getTable().getSortColumn() != this.column;
        }
        if (this.viewer instanceof TreeViewer) {
            tv = (TreeViewer)this.viewer;
            boolean bl = newColumn = tv.getTree().getSortColumn() != this.column;
        }
        if (newColumn) {
            this.state = true;
        }
        this.stateChanged();
        this.state = !this.state;
    }

    public void setState(boolean state) {
        this.stateChanged();
        this.state = !state;
    }

    private boolean getState() {
        return this.state;
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }

    protected Item getColumn() {
        return this.column;
    }

    private ViewerSorter getViewerSorter() {
        final boolean state = this.getState();
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int rev = state ? -1 : 1;
                return rev * AbstractSortController.this.columnComparator.compare(e1, e2);
            }
        };
    }

    public Comparator getComparator() {
        boolean state = this.getState();
        return new MComparator(state);
    }

    protected int getSortDirection() {
        return this.getState() ? 1024 : 128;
    }

    public void initState() {
        this.state = this.getRealSortDirection() == 1024;
        this.update();
        this.state = !this.state;
    }

    protected void update() {
        this.getViewer().setSorter(this.getViewerSorter());
    }

    public abstract int getRealSortDirection();

    public abstract void stateChanged();

    private final class MComparator
    implements Comparator {
        private final boolean state;

        private MComparator(boolean state) {
            this.state = state;
        }

        public int compare(Object e1, Object e2) {
            int rev = this.state ? -1 : 1;
            return rev * AbstractSortController.this.columnComparator.compare(e1, e2);
        }
    }
}

