/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.onpositive.ide.ui.ControlDecoration;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEntityAwareValidator;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IPropsInterestedValueConverter;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValidatorWithSeverity;
import org.mule.tooling.ui.modules.core.widgets.IValueConverter;
import org.mule.tooling.ui.modules.core.widgets.editors.BaseAbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.BooleanFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.FieldEditorContext;
import org.mule.tooling.ui.modules.core.widgets.editors.FieldEditorValidator;
import org.mule.tooling.ui.modules.core.widgets.editors.FieldEditorValueAware;
import org.mule.tooling.ui.modules.core.widgets.editors.ILoadedValueModifier;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.PageWithControlsProvider;
import org.mule.tooling.ui.widgets.group.CollapsableGroup;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.eventbus.EventBus;

public abstract class AbstractFieldEditor
extends BaseAbstractFieldEditor
implements FieldEditorValueAware,
FieldEditorValidator {
    private static final String BASIC_MODE_TOOLTIP = "Click to switch field to basic mode";
    private static final String EXPRESSION_MODE_TOOLTIP = "Click to switch field to expression mode";
    private static final Image ERROR_IMAGE = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    private static final Image INFO_IMAGE = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
    static Image expImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"/icons/Expression-16x16.png").createImage();
    static Image bsImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"/icons/Basic-16x16.png").createImage();
    static Image fxImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"/icons/fx.png").createImage();
    static Image fxDarkImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"/icons/fx-dark.png").createImage();
    protected Control control;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected final AttributeContext context;
    protected boolean isEnabled = true;
    protected boolean isErased = false;
    protected boolean hadValue = false;
    protected Object userData = null;
    protected IMessageFlowNode node;
    private AttributesPropertyPage parentPage;
    protected Listener listener;
    protected DisposeListener disposeListener;
    private LazyValue<ControlDecoration> infoDecoration;
    private LazyValue<ControlDecoration> errorDecoration;
    private boolean isExpression;
    protected String error;
    private Canvas toExpressionEditorCanvas;
    protected boolean loading;
    private EventBus eventBus = new EventBus();
    private SeverityProvider defaultSeverityProvider;
    protected SeverityProvider severityProvider = this.defaultSeverityProvider = DefaultSeverityProvider.INSTANCE;
    private FieldEditorValidator validator = new BasicFieldEditorValidator();

    public AbstractFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        this(ctx, atr, parent, null);
    }

    public AbstractFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, IMessageFlowNode node) {
        super(atr);
        this.context = ctx;
        this.control = this.createControl(parent);
        this.node = node;
        this.listener = new EventControlListener();
        this.disposeListener = new EventControlDisposeListener();
        this.setEventControl(this.getEventControl());
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setEnabled(boolean selection) {
        this.isEnabled = selection;
        this.getEventControl().setEnabled(this.isEnabled);
        if (this.errorDecoration != null) {
            if (this.isEnabled) {
                if (this.error != null) {
                    ((ControlDecoration)this.errorDecoration.getOrCompute()).show();
                }
            } else {
                ((ControlDecoration)this.errorDecoration.getOrCompute()).hide();
                this.setError(null);
            }
        }
    }

    protected FieldEditorContext createFieldEditorContext(Composite parent) {
        AbstractComponentMeta associatedMeta = this.getAbstractComponentMeta(parent);
        return new FieldEditorContext(this, !this.isGlobalElementPage(associatedMeta));
    }

    public IMessageFlowNode getNode() {
        return this.getParentPage().getMessageFlowNode();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void enableDisableExpressionEditor() {
        if (!this.isExpression()) {
            this.enableExpressionEditor();
        } else {
            MessageDialog messageDialog;
            if (this.doBasicExpressionFieldCheck(this.getValue()) && (messageDialog = new MessageDialog(this.getControl().getShell(), "Warning", null, "Warning: going back to basic mode will make you lose your expression.", 4, new String[]{"Ok", "Cancel"}, 4)).open() != 0) {
                return;
            }
            this.setExpression(false);
            this.switchFromExpression();
            this.toExpressionEditorCanvas.redraw();
        }
    }

    protected void enableExpressionEditor() {
        this.setExpression(true);
        this.switchToExpression();
        this.toExpressionEditorCanvas.redraw();
    }

    protected void createExpressionSwitcher(Composite cParent) {
        if (this.attributeHelper.isSupportsExpressions()) {
            this.toExpressionEditorCanvas = new Canvas(cParent, 0);
            this.toExpressionEditorCanvas.addPaintListener(e -> {
                if (!this.isExpression()) {
                    e.gc.drawImage(expImage, 2, 1);
                } else {
                    e.gc.drawImage(bsImage, 2, 1);
                }
            });
            this.toExpressionEditorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    AbstractFieldEditor.this.enableDisableExpressionEditor();
                }
            });
            this.toExpressionEditorCanvas.setCursor(Display.getCurrent().getSystemCursor(21));
            this.toExpressionEditorCanvas.setLayoutData((Object)GridDataFactory.fillDefaults().hint(this.switchOffset(), 20).create());
            new ToolTip((Control)this.toExpressionEditorCanvas){

                protected Composite createToolTipContentArea(Event event, Composite parent) {
                    Composite c = new Composite(parent, 0);
                    FillLayout layout2 = new FillLayout();
                    layout2.marginHeight = 4;
                    layout2.marginWidth = 4;
                    c.setLayout((Layout)layout2);
                    Label ls = new Label(c, 0);
                    if (AbstractFieldEditor.this.isExpression()) {
                        ls.setText(AbstractFieldEditor.this.getBasicModeTooltip());
                    } else {
                        ls.setText(AbstractFieldEditor.this.getExpressionModeTooltip());
                    }
                    return c;
                }
            };
        }
    }

    protected int switchOffset() {
        return 30;
    }

    protected void switchFromExpression() {
    }

    protected void switchToExpression() {
    }

    private void setTooltipTextRec(Control control, String description) {
        control.setToolTipText(description);
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setTooltipTextRec(child, description);
                ++n2;
            }
        }
    }

    @Override
    public Control getEventControl() {
        return this.control;
    }

    private void setEventControl(Control control) {
        control.addListener(24, this.listener);
        control.addListener(13, this.listener);
        control.addDisposeListener(this.disposeListener);
        if (this.infoDecoration != null) {
            ((ControlDecoration)this.infoDecoration.getOrCompute()).hide();
        }
        if (this.errorDecoration != null) {
            ((ControlDecoration)this.errorDecoration.getOrCompute()).hide();
        }
        this.infoDecoration = this.buildInfoDecoration();
        this.errorDecoration = this.buildErrorDecorator();
    }

    protected void changeEventControl(Control control) {
        if (this.control != null) {
            this.control.removeListener(24, this.listener);
            this.control.removeListener(13, this.listener);
            this.control.removeDisposeListener(this.disposeListener);
        }
        this.control = control;
        this.setEventControl(control);
    }

    protected Control getInfoDecorationControl() {
        return this.getEventControl();
    }

    protected Control getErrorDecorationControl() {
        return this.getEventControl();
    }

    public void init() {
        this.internalInit();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public FieldEditorValidator getValidator() {
        return this.validator;
    }

    @Override
    public void validate() {
        this.getValidator().validate();
    }

    protected void validateParent() {
        if (this.parentPage != null) {
            this.parentPage.validate();
        }
    }

    protected boolean shouldReportErrorMessage() {
        CollapsableGroup collapsableGroup = this.getAssociatedCollapsableGroup();
        return collapsableGroup == null || collapsableGroup.isExpanded();
    }

    public Message getError() {
        if (StringUtils.isBlank((String)this.error)) {
            return ValidationConstants.MESSAGE_OK;
        }
        return MessageBuilder.newErrorMessage((String)this.error, (String)(this.getParentPage().getName() + "/" + this.getHelper().getCaption())).build();
    }

    public void setError(String errorDescription) {
        this.setError(errorDescription, this.defaultSeverityProvider);
    }

    private void setError(String errorDescription, SeverityProvider provider) {
        this.severityProvider = provider;
        this.error = errorDescription;
        if (!this.isDisposed()) {
            this.onErrorSet(errorDescription);
        }
    }

    private void onErrorSet(String errorDescription) {
        if (errorDescription == null) {
            ((ControlDecoration)this.errorDecoration.getOrCompute()).hide();
            ((ControlDecoration)this.infoDecoration.getOrCompute()).show();
        } else if (this.isEnabled() && this.shouldReportErrorMessage()) {
            this.showError(errorDescription);
        }
    }

    private void showError(String errorDescription) {
        ((ControlDecoration)this.infoDecoration.getOrCompute()).hide();
        ControlDecoration errorControl = (ControlDecoration)this.errorDecoration.getOrCompute();
        errorControl.setDescriptionText(errorDescription);
        errorControl.show();
        IValidator helperValidator = this.getHelper().getValidator();
        if (helperValidator instanceof IValidatorWithSeverity) {
            IValidatorWithSeverity validatorWithSeverity = (IValidatorWithSeverity)((Object)helperValidator);
            String fieldDecorationId = validatorWithSeverity.getSeverity() == 1 ? "DEC_WARNING" : "DEC_ERROR";
            errorControl.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration(fieldDecorationId).getImage());
        }
    }

    private CollapsableGroup getAssociatedCollapsableGroup() {
        Control myControl = this.getControl();
        while (myControl.getParent() != null) {
            Composite parent = myControl.getParent();
            if (parent instanceof CollapsableGroup) {
                return (CollapsableGroup)parent;
            }
            myControl = parent;
        }
        return null;
    }

    protected abstract Control createControl(Composite var1);

    public String getPublicValue() {
        return this.getValue();
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        if (this.parentPage != null) {
            return this.parentPage;
        }
        Control eventControl = this.getEventControl();
        if (eventControl == null) {
            return null;
        }
        Composite parent = eventControl.getParent();
        while (!(parent instanceof AttributesPropertyPage)) {
            parent = parent.getParent();
        }
        this.parentPage = (AttributesPropertyPage)parent;
        return this.parentPage;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        try {
            this.loading = true;
            this.setNode(node);
            String property = this.getProperty(props);
            this.hadValue = StringUtils.isNotEmpty((String)property);
            if (!this.hadValue) {
                String string = property = this.shouldInitDefaultProperty(props, this.attributeHelper) ? this.initPropertyDefault() : "";
            }
            if (this.isErased(props)) {
                this.isErased = true;
                property = "";
            }
            if (property != null) {
                this.setValue(property);
            } else {
                this.setEmptyValue();
            }
            this.internalInit();
        }
        finally {
            this.loading = false;
        }
    }

    public String getProperty(PropertyCollectionMap props) {
        IValueConverter persistence;
        String fieldId = this.attributeHelper.getId();
        String property = props.getProperty(fieldId, null);
        ILoadedValueModifier valueModifier = this.attributeHelper.getLoadedValueModifier();
        if (valueModifier != null) {
            property = valueModifier.getModifiedValue(this, this.node, props, property);
        }
        if ((persistence = this.attributeHelper.getPersistence()) != null) {
            if (persistence instanceof IPropsInterestedValueConverter) {
                IPropsInterestedValueConverter pm = (IPropsInterestedValueConverter)persistence;
                property = pm.convertXMLToModel(property, props);
            } else {
                property = persistence.convertXMLToModel(property);
            }
        }
        return property;
    }

    private boolean isErased(PropertyCollectionMap props) {
        String key = "auxiliary;erased;" + this.attributeHelper.getId();
        String value = props.getProperty(key, null);
        return Boolean.parseBoolean(value);
    }

    protected void setEmptyValue() {
    }

    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        boolean hasDefaultValue;
        boolean bl = hasDefaultValue = helper.getDefaultValue() instanceof String && StringUtils.isNotBlank((String)((String)helper.getDefaultValue()));
        return this.attributeHelper instanceof AttributeReader.NameHelper || hasDefaultValue;
    }

    protected String initPropertyDefault() {
        Object defaultValue = this.attributeHelper.getDefaultValue();
        String property = null;
        if (defaultValue != null) {
            property = defaultValue.toString();
            this.hadValue = true;
        }
        return property;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.getHelper().isTransient()) {
            return;
        }
        if (this.isEnabled) {
            boolean hasEmptyValue;
            String value = this.getValue();
            boolean bl = hasEmptyValue = value == null || value.length() == 0;
            if (this.hadValue) {
                if (hasEmptyValue) {
                    props.addProperty("auxiliary;erased;" + this.attributeHelper.getId(), "true");
                } else {
                    props.removeProperty("auxiliary;erased;" + this.attributeHelper.getId());
                }
            }
            if (value == null) {
                return;
            }
            props.addProperty(this.attributeHelper.getId(), value);
        }
    }

    protected AbstractComponentMeta getMeta(String type) {
        try {
            NodeDefinition definition = MuleCorePlugin.getModuleManager().getDefinition(type);
            return (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
        }
        catch (RuntimeException runtimeException) {
            GlobalDefinition definition = MuleCorePlugin.getModuleManager().getGlobalDefinition(type);
            if (definition != null) {
                return (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
            }
            return null;
        }
    }

    protected void internalInit() {
        this.validate();
        this.support.firePropertyChange("value", null, this.getValue());
    }

    public void sendValue() {
        this.support.firePropertyChange("value", null, this.getValue());
    }

    @Override
    public void setParentPage(AttributesPropertyPage attributesPropertyPage) {
        this.parentPage = attributesPropertyPage;
    }

    protected void doValidate() {
        if (this.parentPage != null && !this.parentPage.insideLoad()) {
            Display.getCurrent().asyncExec(() -> {
                if (this.getEventControl() != null && !this.getEventControl().isDisposed()) {
                    this.internalInit();
                }
            });
        }
    }

    public int getSeverity() {
        return this.severityProvider.getSeverity(this);
    }

    protected String getBasicModeTooltip() {
        return BASIC_MODE_TOOLTIP;
    }

    protected String getExpressionModeTooltip() {
        return EXPRESSION_MODE_TOOLTIP;
    }

    protected boolean doBasicExpressionFieldCheck(String value) {
        return ExpressionUtils.isExpression((String)value);
    }

    @Override
    public Control getContentControl() {
        return this.getControl();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.attributeHelper.getId() + "=" + this.getValue() + ")";
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public void showErrorDecoration(boolean show) {
        if (this.error != null && !show) {
            ((ControlDecoration)this.errorDecoration.getOrCompute()).hide();
        }
        if (this.error != null && show) {
            ((ControlDecoration)this.errorDecoration.getOrCompute()).show();
        }
    }

    public boolean isExpression() {
        return this.isExpression;
    }

    public void setExpression(boolean isExpression) {
        this.isExpression = isExpression;
    }

    public AttributeContext getContext() {
        return this.context;
    }

    public void setNode(IMessageFlowNode node) {
        this.node = node;
    }

    @Override
    public int getDecoratorMarginWidth() {
        return 1;
    }

    public LazyValue<ControlDecoration> getErrorDecoration() {
        return this.errorDecoration;
    }

    protected boolean isGlobalElementPage(AbstractComponentMeta associatedMeta) {
        return associatedMeta instanceof GlobalComponentMeta;
    }

    protected AbstractComponentMeta getAbstractComponentMeta(Composite parentPage) {
        Composite currentPage = parentPage;
        AbstractComponentMeta rootPage = null;
        while (currentPage != null) {
            if (currentPage instanceof PageWithControlsProvider) {
                rootPage = ((PageWithControlsProvider)currentPage).getAssociatedMetadata();
                break;
            }
            currentPage = currentPage.getParent();
        }
        return rootPage;
    }

    private LazyValue<ControlDecoration> buildInfoDecoration() {
        return new LazyValue(() -> {
            AttributeHelper atr = this.getHelper();
            FieldDecoration dec = new FieldDecoration(INFO_IMAGE, atr.getDescription());
            Control infoDecorationControl = this.getInfoDecorationControl();
            boolean showOnlyOnFocus = !(this instanceof BooleanFieldEditor);
            ControlDecoration decoration = new ControlDecoration(infoDecorationControl, showOnlyOnFocus ? 17408 : 131200);
            decoration.setMarginWidth(this.getDecoratorMarginWidth());
            decoration.setImage(dec.getImage());
            decoration.setDescriptionText(dec.getDescription());
            decoration.setShowHover(true);
            decoration.setShowOnlyOnFocus(true);
            if (!showOnlyOnFocus) {
                this.setTooltipTextRec(infoDecorationControl, StringUtils.isNotEmpty((String)atr.getWarningMessage()) ? atr.getWarningMessage() : dec.getDescription());
            }
            return decoration;
        });
    }

    private LazyValue<ControlDecoration> buildErrorDecorator() {
        return new LazyValue(() -> {
            ControlDecoration decoration = new ControlDecoration(this.getErrorDecorationControl(), 17408);
            decoration.setMarginWidth(this.getDecoratorMarginWidth());
            decoration.setImage(ERROR_IMAGE);
            decoration.hide();
            return decoration;
        });
    }

    private final class BasicFieldEditorValidator
    implements FieldEditorValidator {
        private BasicFieldEditorValidator() {
        }

        @Override
        public void validate() {
            boolean requiredAttributeWasEmpty;
            if (!AbstractFieldEditor.this.isEnabled) {
                return;
            }
            AttributeHelper attributeHelper = AbstractFieldEditor.this.attributeHelper;
            String value = AbstractFieldEditor.this.getValue();
            if (value == null) {
                value = "";
            }
            if (attributeHelper == null && (AbstractFieldEditor.this.attributeHelper.isShowOnlyInInbound() || AbstractFieldEditor.this.attributeHelper.isShowOnlyInOutbound())) {
                attributeHelper = AbstractFieldEditor.this.attributeHelper;
            }
            if (attributeHelper == null) {
                return;
            }
            boolean bl = requiredAttributeWasEmpty = attributeHelper.isRequired() && !attributeHelper.isAcceptsEmptyValue() && StringUtils.isEmpty((String)value) && AbstractFieldEditor.this.isEnabled();
            if (requiredAttributeWasEmpty && AbstractFieldEditor.this.shouldReportErrorMessage()) {
                String attributeLabel = StringUtils.isNotBlank((String)attributeHelper.getSaveAs()) ? attributeHelper.getSaveAs() : attributeHelper.getId();
                String string = (attributeHelper.isAttribute() ? "Attribute '" : "Element '") + attributeLabel + "' is required";
                AbstractFieldEditor.this.setError(string, new StaticSeverityProvider(4));
                AbstractFieldEditor.this.validateParent();
                return;
            }
            IValidator helperValidator = attributeHelper.getValidator();
            if (helperValidator != null) {
                if (helperValidator instanceof IEntityAwareValidator) {
                    IEntityAwareValidator eav = (IEntityAwareValidator)helperValidator;
                    boolean enabled = AbstractFieldEditor.this.getControl().isEnabled();
                    if (enabled) {
                        String validate = eav.validate(value, AbstractFieldEditor.this.context, AbstractFieldEditor.this.node, AbstractFieldEditor.this);
                        AbstractFieldEditor.this.setError(validate);
                        AbstractFieldEditor.this.validateParent();
                    }
                } else {
                    String validate = helperValidator.validate(value, AbstractFieldEditor.this.context, AbstractFieldEditor.this.attributeHelper);
                    AbstractFieldEditor.this.setError(validate);
                    AbstractFieldEditor.this.validateParent();
                }
            } else {
                AbstractFieldEditor.this.setError(null);
                AbstractFieldEditor.this.validateParent();
            }
        }
    }

    private static class DefaultSeverityProvider
    implements SeverityProvider {
        public static final DefaultSeverityProvider INSTANCE = new DefaultSeverityProvider();

        private DefaultSeverityProvider() {
        }

        @Override
        public int getSeverity(IFieldEditor field) {
            if (field.getHelper().getValidator() instanceof IValidatorWithSeverity) {
                IValidatorWithSeverity vm = (IValidatorWithSeverity)((Object)field.getHelper().getValidator());
                return vm.getSeverity();
            }
            return 4;
        }
    }

    private final class EventControlDisposeListener
    implements DisposeListener {
        private EventControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            AbstractFieldEditor.this.getEventControl().removeListener(24, AbstractFieldEditor.this.listener);
            AbstractFieldEditor.this.getEventControl().removeListener(13, AbstractFieldEditor.this.listener);
        }
    }

    private class EventControlListener
    implements Listener {
        private EventControlListener() {
        }

        public void handleEvent(Event arg0) {
            AbstractFieldEditor.this.doValidate();
        }
    }

    private static interface SeverityProvider {
        public int getSeverity(IFieldEditor var1);
    }

    private static class StaticSeverityProvider
    implements SeverityProvider {
        private int severity;

        public StaticSeverityProvider(int severity) {
            this.severity = severity;
        }

        @Override
        public int getSeverity(IFieldEditor field) {
            return this.severity;
        }
    }
}

