/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.BaseAbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ICompositeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.SwitchEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public abstract class AbstractCompositeEditor
extends BaseAbstractFieldEditor
implements ICompositeEditor {
    protected final CompositeAndItsParts compositeAndItsParts;
    protected AttributesPropertyPage parentPage;

    public AbstractCompositeEditor(AttributeHelper helper, Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        super(helper);
        this.compositeAndItsParts = this.createComposite(gr, agroup, newEditorCallback);
    }

    protected abstract CompositeAndItsParts createComposite(Composite var1, AttributeGroup var2, SwitchEditor.NewEditorCallback var3);

    @Override
    public List<IFieldEditor> getChildren() {
        return this.compositeAndItsParts.compositeParts;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        for (IFieldEditor editor : this.getChildren()) {
            if (editor.getHelper().hasPersistenceTransformer()) {
                editor.getHelper().transformBeforeLoad(node, props);
            }
            editor.loadFrom(node, props);
        }
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        for (IFieldEditor editor : this.getChildren()) {
            if (editor.getHelper().hasPersistenceTransformer()) {
                editor.getHelper().transformBeforeSave(node, props);
            }
            editor.saveTo(node, props);
            if (!editor.getHelper().hasAfterSaveCorrection()) continue;
            editor.getHelper().transformAfterSave(node, props);
        }
    }

    @Override
    public Control getControl() {
        return this.compositeAndItsParts.composite;
    }

    @Override
    public Control getContentControl() {
        return this.compositeAndItsParts.composite;
    }

    @Override
    public void setParentPage(AttributesPropertyPage parentPage) {
        this.parentPage = parentPage;
        for (IFieldEditor editor : this.getChildren()) {
            editor.setParentPage(parentPage);
        }
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        return this.parentPage;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    protected class CompositeAndItsParts {
        final Composite composite;
        final List<IFieldEditor> compositeParts;

        public CompositeAndItsParts(Composite composite, List<IFieldEditor> compositeParts) {
            this.composite = composite;
            this.compositeParts = compositeParts;
        }
    }
}

