/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.DummyFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IEntityAwareValidator;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IMessageFlowNodeAware;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValueConverter;
import org.mule.tooling.ui.modules.core.widgets.editors.BaseAbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementEditStack;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementTableFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.INestedElementChooser;

public abstract class AbstractChildElementFieldEditor
extends BaseAbstractFieldEditor
implements IMessageFlowNodeAware {
    protected Control control;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected AttributeContext context;
    protected List<PropertyCollection> defs = new ArrayList<PropertyCollection>();
    private boolean loaded;
    private IMessageFlowNode node;
    protected AttributesPropertyPage page;

    @Override
    public boolean isEnabled() {
        boolean enabled = this.control.isEnabled();
        if (enabled && this.getEventControl() != null) {
            enabled = this.getEventControl().isEnabled();
        }
        return enabled;
    }

    public AbstractChildElementFieldEditor(AttributeContext ctx, AttributeHelper helper, Composite parent) {
        super(helper);
        this.context = ctx;
        this.control = this.createControl(parent);
        this.runPostCreateControlActions();
    }

    protected Control getEventControl() {
        return this.control;
    }

    public Map<String, AttributesPropertyPage> getAttributePages() {
        return null;
    }

    @Override
    public void setParentPage(AttributesPropertyPage attributesPropertyPage) {
        this.page = attributesPropertyPage;
    }

    protected abstract Control createControl(Composite var1);

    protected void runPostCreateControlActions() {
    }

    public List<PropertyCollection> getDefs() {
        return this.defs;
    }

    public void addToDefs(PropertyCollection propCol) {
        this.defs.add(propCol);
    }

    public void addToDefs(Collection<PropertyCollection> props) {
        this.defs.addAll(props);
    }

    public void clearDefs() {
        if (this.defs != null) {
            this.defs.clear();
        }
    }

    public void removeFromDefs(PropertyCollection propCol) {
        this.defs.remove(propCol);
    }

    public boolean loaded() {
        return this.loaded;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.clearDefs();
        this.loaded = true;
        this.node = node;
        this.addToDefs(this.getNotErased(this.getChildProps(props)));
        this.initUI(this.getDefs());
    }

    public List<PropertyCollection> getChildProps(PropertyCollectionMap props) {
        ArrayList<PropertyCollection> ret = new ArrayList<PropertyCollection>();
        PropertyCollection properties = props.asPropertyCollection();
        ChildElementAttributeHelper.sortNestedProperties(properties);
        List propertyCollections = properties.getPropertyCollections();
        ChildElementAttributeHelper h = (ChildElementAttributeHelper)this.getHelper();
        List<NestedDefinition> allowedDefinitions = h.getAllowedDefinitions();
        IValueConverter persistence = this.getHelper().getPersistence();
        if (persistence == null) {
            String id = this.getHelper().getId();
            NestedDefinition nestedElement = MuleCorePlugin.getModuleManager().getNestedDefinition(id);
            if (nestedElement != null) {
                persistence = (IValueConverter)nestedElement.getService(INestedElementChooser.class);
            }
        }
        if (persistence instanceof INestedElementChooser) {
            INestedElementChooser nestedElementChooser = (INestedElementChooser)((Object)persistence);
            PropertyCollection adjust = nestedElementChooser.adjust(new ArrayList<PropertyCollection>(propertyCollections), this.getHelper().getId());
            ret.add(adjust);
        } else {
            for (PropertyCollection c : propertyCollections) {
                String name = c.getName();
                if (name == null || name.length() <= 0 || !name.startsWith("@")) continue;
                name = name.substring(1);
                name = name.substring(0, name.lastIndexOf(59));
                for (NestedDefinition d : allowedDefinitions) {
                    if (!d.getId().equals(name)) continue;
                    ret.add(c);
                }
            }
        }
        return ret;
    }

    public static NestedDefinition getNodeDef(PropertyCollection propertyCollection) {
        String name = propertyCollection.getName();
        if (name != null && name.length() > 0 && name.startsWith("@")) {
            name = name.substring(1);
            name = name.substring(0, name.lastIndexOf(59));
        }
        if (name != null && name.length() > 0) {
            return MuleCorePlugin.getModuleManager().getNestedDefinition(name);
        }
        return null;
    }

    protected abstract void initUI(List<PropertyCollection> var1);

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        for (PropertyCollection propetyCollection : this.getDefs()) {
            String name = propetyCollection.getName();
            PropertyCollectionMap defsMap = new PropertyCollectionMap(propetyCollection);
            props.addPropertyCollection(name, defsMap);
        }
    }

    protected static String getNestedElementLabel(NestedDefinition nodeDef, PropertyCollection collection) {
        String string = nodeDef.getMuleElement().getPrefix() + ":" + nodeDef.getMuleElement().getLocalPart();
        AbstractComponentMeta service = (AbstractComponentMeta)nodeDef.getService(AbstractComponentMeta.class);
        if (collection != null) {
            StringBuilder bs = new StringBuilder();
            for (Property p : collection.getProperties()) {
                AttributeHelper attribute;
                if (p.getName().contains(";") || service != null && (attribute = service.getAttribute(p.getName())) != null && attribute.isTransient() || p.getValue() == null || p.getValue().length() <= 0) continue;
                bs.append(" " + p.getName() + "=" + p.getValue() + ",");
            }
            if (bs.length() > 0) {
                bs.deleteCharAt(bs.length() - 1);
            }
            string = string + bs.toString();
        }
        return string;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public Message validate() {
        List<PropertyCollection> propertyCollections = this.getDefs();
        return this.validate(propertyCollections);
    }

    protected Message validate(List<PropertyCollection> propertyCollections) {
        if (this.getHelper().isRequired() && propertyCollections.isEmpty() && this instanceof ChildElementTableFieldEditor) {
            return MessageBuilder.newErrorMessage((String)("Element '" + this.getHelper().getCaption() + "' is required"), (String)this.getLocation()).build();
        }
        for (PropertyCollection propertyCollection : new ArrayList<PropertyCollection>(propertyCollections)) {
            NestedDefinition nodeDefinition = AbstractChildElementFieldEditor.getNodeDef(propertyCollection);
            if (nodeDefinition == null) continue;
            AbstractComponentMeta ms = (AbstractComponentMeta)nodeDefinition.getService(AbstractComponentMeta.class);
            List<AttributeHelper> attributeHelpers = ms.getAllAttributes();
            PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(propertyCollection);
            this.processMap(propertyCollectionMap);
            for (AttributeHelper attributeHelper : attributeHelpers) {
                IValidator validator;
                String attributePropertyValue = propertyCollectionMap.getProperty(attributeHelper.getId(), "").trim();
                String elementName = this.getElementName(nodeDefinition);
                if (attributeHelper.isRequired() && attributePropertyValue.length() == 0) {
                    if (attributeHelper instanceof ChildElementAttributeHelper) {
                        ChildElementAttributeHelper childElementAttributeHelper = (ChildElementAttributeHelper)attributeHelper;
                        if (childElementAttributeHelper.isMultiple() && this.actuallyEmpty(attributeHelper)) {
                            return MessageBuilder.newErrorMessage((String)("Nested element " + elementName + " is missed"), (String)this.getLocation()).build();
                        }
                    } else {
                        Map<String, AttributesPropertyPage> pages = this.getAttributePages();
                        String id = attributeHelper.getId();
                        if (pages != null) {
                            for (AttributesPropertyPage page : pages.values()) {
                                IFieldEditor editor = page.getEditors().get(id);
                                if (editor == null) continue;
                                if (!(editor instanceof DummyFieldEditor) && (!(editor instanceof StringFieldEditor) || ((StringFieldEditor)editor).isEnabled())) break;
                                break;
                            }
                        } else {
                            return MessageBuilder.newErrorMessage((String)("Attribute " + attributeHelper.getId() + " of nested element " + elementName + " is required"), (String)this.getLocation()).build();
                        }
                    }
                }
                if ((validator = attributeHelper.getValidator()) == null) continue;
                ChildElementEditStack.editNested(propertyCollections, null, false);
                try {
                    String message;
                    if (validator instanceof IEntityAwareValidator) {
                        IEntityAwareValidator entityAwareValidator = (IEntityAwareValidator)validator;
                        message = entityAwareValidator.validate(attributePropertyValue, this.context, this.getMessageFlowNode(), this);
                    } else {
                        message = validator.validate(attributePropertyValue, this.context, attributeHelper);
                    }
                    if (message == null) continue;
                    Message message2 = MessageBuilder.newErrorMessage((String)(message + " (error in nested element " + elementName + ")"), (String)this.getLocation()).build();
                    return message2;
                }
                finally {
                    ChildElementEditStack.finishEdit();
                }
            }
            Message validate = this.validate(propertyCollection.getPropertyCollections());
            if (validate == ValidationConstants.MESSAGE_OK) continue;
            return validate;
        }
        return ValidationConstants.MESSAGE_OK;
    }

    private String getElementName(NestedDefinition nodeDefinition) {
        String definitionName = nodeDefinition.getName();
        String definitionId = nodeDefinition.getId();
        String elementName = definitionName == null || definitionName.isEmpty() ? definitionId.substring(Math.max(definitionId.lastIndexOf(47) + 1, 0), definitionId.length()) : definitionName;
        return elementName;
    }

    protected boolean actuallyEmpty(AttributeHelper h) {
        return false;
    }

    protected void processMap(PropertyCollectionMap propertyCollectionMap) {
    }

    @Override
    public Control getContentControl() {
        return this.getControl();
    }

    public void setDefs(List<PropertyCollection> defs) {
        this.defs = defs;
    }

    @Override
    public IMessageFlowNode getMessageFlowNode() {
        return this.node;
    }

    @Override
    public void setMessageFlowNode(IMessageFlowNode node) {
        this.node = node;
    }

    @Deprecated
    public MessageFlowNode getNode() {
        if (this.node instanceof MessageFlowNode) {
            return (MessageFlowNode)this.node;
        }
        return null;
    }

    @Deprecated
    public void setNode(MessageFlowNode node) {
        this.setMessageFlowNode((IMessageFlowNode)node);
    }

    @Override
    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    protected List<PropertyCollection> getNotErased(List<PropertyCollection> defs) {
        ArrayList<PropertyCollection> notErased = new ArrayList<PropertyCollection>(defs.size());
        for (PropertyCollection propertyCollection : defs) {
            if (propertyCollection.isErased()) continue;
            notErased.add(propertyCollection);
        }
        return notErased;
    }

    protected void delete(List<PropertyCollection> propertyCollections, PropertyCollection propertyCollectionToDelete) {
        if (propertyCollections.contains(propertyCollectionToDelete)) {
            for (PropertyCollection collection : propertyCollections) {
                if (!collection.equals((Object)propertyCollectionToDelete)) continue;
                collection.setErased(true);
                return;
            }
        }
        for (PropertyCollection collection : propertyCollections) {
            this.delete(collection.getPropertyCollections(), propertyCollectionToDelete);
        }
        this.revalidateParent();
    }

    protected void revalidateParent() {
        if (this.page != null) {
            this.page.validate();
        }
    }
}

