/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.HashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class SubGroup {
    private HashMap<String, SubGroup> subGroups;
    private String name;
    private GridLayout layout;
    private GridData layoutData;
    private SubGroup parent;
    private Group group;

    public SubGroup(String name, SubGroup parentSG, Composite parent, int style, GridData layoutData) {
        this.name = name;
        this.parent = parentSG;
        this.layout = new GridLayout(3, false);
        this.layout.marginWidth = 10;
        this.layout.marginTop = 0;
        this.layout.marginBottom = 10;
        this.layout.horizontalSpacing = 9;
        if (layoutData == null) {
            this.layoutData = new GridData(4, 4, true, false);
            this.layoutData.horizontalSpan = 3;
        } else {
            this.layoutData = layoutData;
            this.layoutData.horizontalSpan = 3;
        }
        this.group = new Group(parent, style);
        this.group.setText(name);
        this.group.setLayout((Layout)this.layout);
        this.group.setLayoutData((Object)this.layoutData);
        this.subGroups = new HashMap();
    }

    public Group getGroup() {
        return this.group;
    }

    public SubGroup getSubGroup(String path) {
        String rootSubGroup;
        String[] pathArray = path.split("/");
        if (pathArray.length > 0 && this.name.equals(rootSubGroup = pathArray[0])) {
            if (pathArray.length == 1) {
                return this;
            }
            Object subPath = "";
            int i = 1;
            while (i < pathArray.length) {
                subPath = (String)subPath + pathArray[i];
                if (i < pathArray.length - 1) {
                    subPath = (String)subPath + "/";
                }
                ++i;
            }
            SubGroup validChild = null;
            for (String childKey : this.subGroups.keySet()) {
                if (!childKey.equals(pathArray[1])) continue;
                validChild = this.subGroups.get(childKey);
            }
            if (validChild != null) {
                return validChild.getSubGroup((String)subPath);
            }
            validChild = new SubGroup(pathArray[1], this, (Composite)this.getGroup(), 0, this.layoutData);
            this.subGroups.put(pathArray[1], validChild);
            return validChild.getSubGroup((String)subPath);
        }
        return null;
    }
}

