/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.RecalcWhenListener;

public class RecalcWhenConfigurerUtils {
    public static void configureRecalcWhenFor(List<MessageFlowNodeComposite> pages) {
        LinkedList editorsWithRecalWhen = new LinkedList();
        HashMap<String, IFieldEditor> allEditors = new HashMap<String, IFieldEditor>();
        for (MessageFlowNodeComposite page : pages) {
            if (!(page instanceof AttributesPropertyPage)) continue;
            AttributesPropertyPage attributesPropertyPage = (AttributesPropertyPage)page;
            Map<String, IFieldEditor> editors = attributesPropertyPage.getEditorsForPage();
            editors.values().stream().filter(editor -> editor.getHelper().getRecalcWhen() != null).forEach(editorsWithRecalWhen::add);
            allEditors.putAll(editors);
        }
        editorsWithRecalWhen.forEach(editor -> RecalcWhenConfigurerUtils.configureRecalcWhen(editor, allEditors));
    }

    private static void configureRecalcWhen(IFieldEditor editorWithRecalc, Map<String, IFieldEditor> editorsById) {
        String recalcWhen = editorWithRecalc.getHelper().getRecalcWhen();
        Arrays.asList(recalcWhen.split(",")).stream().forEach(when -> RecalcWhenConfigurerUtils.addListener(editorWithRecalc, editorsById, when));
    }

    private static void addListener(IFieldEditor editorWithRecalc, Map<String, IFieldEditor> editorsById, String when) {
        if (editorWithRecalc instanceof IRefresheableEditor) {
            IRefresheableEditor refreshableEditorWithRecalc = (IRefresheableEditor)editorWithRecalc;
            IFieldEditor targetEditor = editorsById.get(when);
            if (targetEditor != null) {
                if (targetEditor instanceof IEditorValueModifiedObservable) {
                    IEditorValueModifiedObservable observableEditor = (IEditorValueModifiedObservable)((Object)targetEditor);
                    RecalcWhenListener observer = new RecalcWhenListener(refreshableEditorWithRecalc);
                    observableEditor.addModificationListener(observer);
                } else {
                    MuleCorePlugin.logError((String)"Cannot configure automatic UI refresh", (Throwable)new IllegalArgumentException(when + " attribute Editor should implement " + IEditorValueModifiedObservable.class.getName() + " for being targeted from recalcWhen"));
                }
            } else {
                MuleCorePlugin.logError((String)"Cannot configure automatic UI refresh", (Throwable)new IllegalArgumentException("Editor with name: " + when + " is not in present in the current properties editor"));
            }
        } else {
            MuleCorePlugin.logError((String)"Cannot configure automatic UI refresh", (Throwable)new IllegalArgumentException("\"recalcWhen\" can only be implemented in attributes that implement " + IRefresheableEditor.class.getName()));
        }
    }
}

