/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.mule.tooling.core.MuleCorePlugin;

public class NewClassCreationWizard
extends Wizard {
    private NewClassWizardPage fPage;
    private boolean fOpenEditorOnFinish;
    private IStructuredSelection fSelection;

    public NewClassCreationWizard(NewClassWizardPage page, boolean openEditorOnFinish) {
        this.setWindowTitle("New Java Class");
        this.fPage = page;
        this.fOpenEditorOnFinish = openEditorOnFinish;
    }

    public NewClassCreationWizard() {
        this(null, true);
        this.addPages();
    }

    public void addPages() {
        if (this.fPage == null) {
            this.fPage = new NewClassWizardPage();
            this.fPage.setWizard((IWizard)this);
            this.fPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    public boolean performFinish() {
        IResource resource;
        boolean createdClass = this.createJavaClass();
        if (createdClass && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            if (this.fOpenEditorOnFinish) {
                this.openResource((IFile)resource);
            }
        }
        return createdClass;
    }

    private boolean createJavaClass() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    NewClassCreationWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            ISchedulingRule rule = null;
            Job job = Job.getJobManager().currentJob();
            if (job != null) {
                rule = job.getRule();
            }
            WorkbenchRunnableAdapter runnable = null;
            runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            this.getContainer().run(this.canRunForked(), true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        MuleCorePlugin.logError((String)"Could not open the selected class", (Throwable)e);
                    }
                }
            });
        }
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }
}

