/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.mule.tooling.core.sax.SAXUtils;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.ui.modules.core.validation.MuleConfigurationValidator;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributeModelWithHelper;
import org.mule.tooling.ui.modules.core.widgets.DefinitionElement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;

public class MuleQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final String CONFIG_REF = "config-ref";
    private static final String CONNECTOR_REF = "connector-ref";
    private static final String REF = "ref";
    private static final List<String> referenceNames = Arrays.asList("ref", "connector-ref", "config-ref");

    public boolean canAssist(IQuickAssistInvocationContext context) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        MuleQuickAssistProcessor.addRenameProposal(proposals, context);
        int cursorPosition = context.getOffset();
        ISourceViewer sourceViewer = context.getSourceViewer();
        IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
        Iterator ai = annotationModel.getAnnotationIterator();
        ArrayList<Annotation> as = new ArrayList<Annotation>();
        while (ai.hasNext()) {
            Annotation a = (Annotation)ai.next();
            Position p = annotationModel.getPosition(a);
            if (p.getOffset() > cursorPosition || cursorPosition > p.getOffset() + p.getLength()) continue;
            as.add(a);
        }
        for (Annotation a : as) {
            this.addProposal(a, proposals, context);
        }
        return proposals.toArray(new ICompletionProposal[0]);
    }

    private static void addRenameProposal(ArrayList<ICompletionProposal> outProposals, IQuickAssistInvocationContext context) {
        Attribute attribtue2;
        ExtractElementInfo elementInfo;
        String docText;
        ISourceViewer sourceViewer;
        block5: {
            for (ICompletionProposal proposal : outProposals) {
                if (!(proposal instanceof RenameProposal)) continue;
                return;
            }
            sourceViewer = context.getSourceViewer();
            Point selectedRange = sourceViewer.getSelectedRange();
            if (selectedRange.y != 0) {
                return;
            }
            docText = sourceViewer.getDocument().get();
            elementInfo = MuleQuickAssistProcessor.extractElement(docText, selectedRange.x);
            if (elementInfo == null) {
                return;
            }
            Element parsed = MuleQuickAssistProcessor.parseXmlElement(elementInfo.value);
            if (parsed == null) {
                return;
            }
            List attribtues = parsed.attributes();
            for (Attribute attribtue2 : attribtues) {
                if (!attribtue2.getQualifiedName().equals("name")) continue;
                break block5;
            }
            return;
        }
        final String name = attribtue2.getValue();
        RenameProposal proposal = new RenameProposal(){

            @Override
            public void apply(IDocument doc) {
                int probableConnectorNameStringOffset;
                int nameAttrValueOffset = MuleQuickAssistProcessor.determineConnectorNameOffset(elementInfo.value, name);
                ArrayList<Integer> attrValueOffsets = new ArrayList<Integer>();
                String nameStr = "\"" + name + "\"";
                int fromIndex = 0;
                while ((probableConnectorNameStringOffset = docText.indexOf(nameStr, fromIndex)) != -1) {
                    this.addAttributeValuesOffsets(name, docText, probableConnectorNameStringOffset, attrValueOffsets);
                    fromIndex = probableConnectorNameStringOffset + nameStr.length() - 1;
                }
                ISourceViewer viewer1 = sourceViewer;
                IDocument doc1 = doc;
                try {
                    LinkedPositionGroup group1 = new LinkedPositionGroup();
                    int length = name.length();
                    if (nameAttrValueOffset != -1) {
                        group1.addPosition(new LinkedPosition(doc1, elementInfo.offset + nameAttrValueOffset, length));
                    }
                    Iterator iterator = attrValueOffsets.iterator();
                    while (iterator.hasNext()) {
                        int attrValueOffset = (Integer)iterator.next();
                        group1.addPosition(new LinkedPosition(doc1, attrValueOffset, length));
                    }
                    LinkedModeModel model = new LinkedModeModel();
                    model.addGroup(group1);
                    model.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(model, new ITextViewer[]{viewer1});
                    ui.enableColoredLabels(true);
                    ui.enter();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }

            private void addAttributeValuesOffsets(String name2, String docText2, int probableConnectorNameStringOffset, List<Integer> outAttrValueOffsets) {
                for (String referenceName : referenceNames) {
                    int connectorNameOffset = MuleQuickAssistProcessor.determineAttributeValueOffset(referenceName, name2, docText2, probableConnectorNameStringOffset);
                    if (connectorNameOffset == -1) continue;
                    outAttrValueOffsets.add(connectorNameOffset);
                }
            }

            @Override
            public Point getSelection(IDocument document) {
                return null;
            }

            @Override
            public String getAdditionalProposalInfo() {
                return this.getProposal();
            }

            @Override
            public String getDisplayString() {
                return this.getProposal();
            }

            private String getProposal() {
                return "Rename this global element/connector";
            }

            @Override
            public Image getImage() {
                return null;
            }

            @Override
            public IContextInformation getContextInformation() {
                return null;
            }
        };
        outProposals.add(proposal);
    }

    private void addProposal(Annotation annotation, ArrayList<ICompletionProposal> outProposals, IQuickAssistInvocationContext context) {
        this.addCreateConnectorProposal(annotation, outProposals, context);
        this.addRenameConnectorProposal(annotation, outProposals, context);
    }

    private static ExtractElementInfo extractElement(String text, int cursorOffset) {
        if (text.length() <= cursorOffset) {
            return null;
        }
        int beginIndex = cursorOffset;
        while (beginIndex >= 0) {
            switch (text.charAt(beginIndex)) {
                case '>': {
                    return null;
                }
                case '<': {
                    int last = text.indexOf(62, beginIndex);
                    if (last == -1) {
                        return null;
                    }
                    int endIndex = last + 1;
                    return new ExtractElementInfo(beginIndex, text.substring(beginIndex, endIndex));
                }
            }
            --beginIndex;
        }
        return null;
    }

    private void addRenameConnectorProposal(Annotation annotation, ArrayList<ICompletionProposal> outProposals, IQuickAssistInvocationContext context) {
        for (ICompletionProposal proposal : outProposals) {
            if (!(proposal instanceof RenameConnectorProposal)) continue;
            return;
        }
        final ISourceViewer sourceViewer = context.getSourceViewer();
        Point selectedRange = sourceViewer.getSelectedRange();
        if (selectedRange.y != 0) {
            return;
        }
        final String docText = sourceViewer.getDocument().get();
        ExtractElementInfo elementInfo = MuleQuickAssistProcessor.extractElement(docText, selectedRange.x);
        if (elementInfo == null) {
            return;
        }
        Element parsed = MuleQuickAssistProcessor.parseXmlElement(elementInfo.value);
        if (parsed == null) {
            return;
        }
        ArrayList<Attribute> referenceAttrs = new ArrayList<Attribute>();
        for (String referenceName : referenceNames) {
            Attribute refAttr = parsed.attribute(referenceName);
            if (refAttr == null || refAttr.getValue().isEmpty()) continue;
            referenceAttrs.add(refAttr);
        }
        for (final Attribute referenceAttr : referenceAttrs) {
            RenameConnectorProposal proposal = new RenameConnectorProposal(){

                @Override
                public void apply(IDocument doc) {
                    int probableConnectorNameStringOffset;
                    String name = referenceAttr.getValue();
                    int nameAttrValueOffset = MuleQuickAssistProcessor.determineConnectorNameOffset(docText, name);
                    ArrayList<Integer> attrValueOffsets = new ArrayList<Integer>();
                    String nameStr = "\"" + name + "\"";
                    int fromIndex = 0;
                    while ((probableConnectorNameStringOffset = docText.indexOf(nameStr, fromIndex)) != -1) {
                        int connectorNameOffset = MuleQuickAssistProcessor.determineAttributeValueOffset(referenceAttr.getName(), name, docText, probableConnectorNameStringOffset);
                        if (connectorNameOffset != -1) {
                            attrValueOffsets.add(connectorNameOffset);
                        }
                        fromIndex = probableConnectorNameStringOffset + nameStr.length() - 1;
                    }
                    ISourceViewer viewer1 = sourceViewer;
                    IDocument doc1 = doc;
                    try {
                        LinkedPositionGroup group1 = new LinkedPositionGroup();
                        int length = name.length();
                        if (nameAttrValueOffset != -1) {
                            group1.addPosition(new LinkedPosition(doc1, nameAttrValueOffset, length));
                        }
                        Iterator iterator = attrValueOffsets.iterator();
                        while (iterator.hasNext()) {
                            int attrValueOffset = (Integer)iterator.next();
                            group1.addPosition(new LinkedPosition(doc1, attrValueOffset, length));
                        }
                        LinkedModeModel model = new LinkedModeModel();
                        model.addGroup(group1);
                        model.forceInstall();
                        LinkedModeUI ui = new LinkedModeUI(model, new ITextViewer[]{viewer1});
                        ui.enableColoredLabels(true);
                        ui.enter();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public Point getSelection(IDocument document) {
                    return null;
                }

                @Override
                public String getAdditionalProposalInfo() {
                    return this.getProposal();
                }

                @Override
                public String getDisplayString() {
                    return this.getProposal();
                }

                @Override
                public Image getImage() {
                    return null;
                }

                @Override
                public IContextInformation getContextInformation() {
                    return new IContextInformation(){

                        public String getContextDisplayString() {
                            return "CONTEXT DISPLAY STRING";
                        }

                        public Image getImage() {
                            return null;
                        }

                        public String getInformationDisplayString() {
                            return "INFORMATION DISPLAY STRING";
                        }
                    };
                }

                private String getProposal() {
                    return "Rename " + referenceAttr.getValue() + " in file";
                }
            };
            outProposals.add(proposal);
        }
    }

    private static Element parseXmlElement(String text) {
        String elName = MuleQuickAssistProcessor.extractElementTagName(text);
        if (elName.equals("")) {
            return null;
        }
        String textToParse = text.endsWith("/>") ? text : text + "</" + elName + ">";
        try {
            return SAXUtils.parseXML((String)textToParse).getRootElement();
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    private void addCreateConnectorProposal(Annotation annotation, ArrayList<ICompletionProposal> proposals, IQuickAssistInvocationContext context) {
        AttributeHelper h;
        AttributeModelWithHelper b;
        Namespace namespace;
        String prefix;
        String substring;
        Position position;
        ISourceViewer sourceViewer;
        block8: {
            String refName2;
            block7: {
                for (ICompletionProposal proposal : proposals) {
                    if (!(proposal instanceof CreateConnectorProposal)) continue;
                    return;
                }
                String text = annotation.getText();
                for (String refName2 : referenceNames) {
                    String errorMessage = "Required attribute " + refName2 + " is not defined";
                    if (!text.contains(errorMessage)) continue;
                    break block7;
                }
                return;
            }
            String referenceName = refName2;
            sourceViewer = context.getSourceViewer();
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            position = annotationModel.getPosition(annotation);
            if (position.getOffset() == 0) {
                return;
            }
            String docText = context.getSourceViewer().getDocument().get();
            substring = docText.substring(position.getOffset(), position.getOffset() + position.getLength());
            String elementName = MuleQuickAssistProcessor.extractElementTagName(substring);
            prefix = this.extractPrefix(elementName);
            String localName = this.extractLocalName(elementName);
            Map<String, Namespace> map = this.getNamespaces();
            namespace = map.get(prefix);
            ElementModel flow = MuleConfigurationValidator.resolve("http://www.mulesoft.org/schema/mule/core", "flow", null, false, null, null);
            ElementModel resolvedElement = MuleConfigurationValidator.resolve(namespace.getURI(), localName, new AttributeContext(), false, flow, null);
            if (!(resolvedElement instanceof DefinitionElement)) {
                return;
            }
            DefinitionElement definition = (DefinitionElement)resolvedElement;
            HashSet<AttributeModel> allProperties = definition.getAllProperties();
            for (AttributeModel a : allProperties) {
                if (!(a instanceof AttributeModelWithHelper)) continue;
                b = (AttributeModelWithHelper)a;
                h = b.getAttributeHelper();
                String id = h.getId();
                if (!(h instanceof GlobalRefAttributeHelper) || !id.equals(referenceName)) continue;
                break block8;
            }
            return;
        }
        final GlobalRefAttributeHelper foundAttr = (GlobalRefAttributeHelper)h;
        AttributeContext foundAttrContext = b.getContext();
        String requiredType = foundAttr.getRequiredType(foundAttrContext.getVersion());
        String globalLocalName = this.extractLocalNameFromURI(requiredType);
        ElementModel mule = MuleConfigurationValidator.resolve("http://www.mulesoft.org/schema/mule/core", "mule", null, false, null, null);
        final ElementModel resolvedGlobal = MuleConfigurationValidator.resolve(namespace.getURI(), globalLocalName, new AttributeContext(), true, mule, null);
        HashSet allPropertiesOfGlobal = resolvedGlobal.getAllProperties();
        final String connectorName = prefix + ":" + globalLocalName;
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(connectorName);
        for (AttributeModel a : allPropertiesOfGlobal) {
            AttributeModelWithHelper b2;
            AttributeHelper h2;
            if (!(a instanceof AttributeModelWithHelper) || !(h2 = (b2 = (AttributeModelWithHelper)a).getAttributeHelper()).isRequired()) continue;
            sb.append(' ');
            sb.append(h2.getId());
            sb.append('=');
            sb.append('\"');
            if (h2.getDefaultValue() != null) {
                sb.append(h2.getDefaultValue());
            }
            sb.append('\"');
        }
        sb.append("/>");
        String elementText = sb.toString();
        final String stringToAdd = "\n    " + elementText;
        CreateConnectorProposal proposal = new CreateConnectorProposal(){

            @Override
            public void apply(IDocument doc) {
                int configRefOldOffset;
                String text = doc.get();
                int indexOfMule = text.indexOf("<mule");
                if (indexOfMule == -1) {
                    return;
                }
                String id = foundAttr.getId();
                int indexOfConfigRef = this.determineAttributeIndex(substring, id);
                if (indexOfConfigRef != -1) {
                    configRefOldOffset = position.getOffset() + indexOfConfigRef + id.length() + 2;
                } else {
                    text = new StringBuilder(text).insert(position.getOffset() + position.getLength() - 2, " " + id + "=\"\"").toString();
                    configRefOldOffset = position.getOffset() + position.getLength() - 2 + 1 + id.length() + 2;
                }
                int indexOfCB = text.indexOf(62, indexOfMule);
                if (indexOfCB == -1) {
                    return;
                }
                int insertOffset = indexOfCB + 1;
                String resultText = new StringBuilder(text).insert(insertOffset, stringToAdd).toString();
                doc.set(resultText);
                ISourceViewer viewer1 = sourceViewer;
                IDocument doc1 = doc;
                int configRefOffset = configRefOldOffset + stringToAdd.length();
                int indexOfName = stringToAdd.indexOf("name=\"");
                int configNameOffset = insertOffset + indexOfName + 6;
                try {
                    LinkedPositionGroup group1 = new LinkedPositionGroup();
                    group1.addPosition(new LinkedPosition(doc1, configRefOffset, 0));
                    group1.addPosition(new LinkedPosition(doc1, configNameOffset, 0));
                    LinkedModeModel model = new LinkedModeModel();
                    model.addGroup(group1);
                    model.forceInstall();
                    LinkedModeUI ui = new LinkedModeUI(model, new ITextViewer[]{viewer1});
                    ui.enableColoredLabels(true);
                    ui.enter();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }

            private int determineAttributeIndex(String elText, String attrName) {
                Pattern pat = Pattern.compile("<([^\"]*\"[^\"]*\")*[^\"]*\\s+(" + attrName + ")\\s*=\\s*\"");
                Matcher matcher = pat.matcher(elText);
                boolean found = matcher.find();
                if (found) {
                    int attributeIndex = matcher.start(2);
                    return attributeIndex;
                }
                return -1;
            }

            @Override
            public String getAdditionalProposalInfo() {
                return this.getProposal();
            }

            @Override
            public IContextInformation getContextInformation() {
                return new IContextInformation(){

                    public String getContextDisplayString() {
                        return "CONTEXT DISPLAY STRING";
                    }

                    public Image getImage() {
                        return null;
                    }

                    public String getInformationDisplayString() {
                        return "INFORMATION DISPLAY STRING";
                    }
                };
            }

            @Override
            public String getDisplayString() {
                return this.getProposal();
            }

            private String getProposal() {
                return "Create " + (foundAttr.getId().equals(MuleQuickAssistProcessor.REF) ? "global endpoint" : "connector") + " (" + connectorName + ")";
            }

            @Override
            public Image getImage() {
                return resolvedGlobal.getIconImage();
            }

            @Override
            public Point getSelection(IDocument doc) {
                return null;
            }
        };
        proposals.add(proposal);
    }

    private String extractLocalNameFromURI(String requiredType) {
        String[] splitted = requiredType.split("/");
        return splitted[splitted.length - 1];
    }

    private Map<String, Namespace> getNamespaces() {
        Map namespacesMap = MultiPageMessageFlowEditor.getActive().getNamespaceByPrefix();
        namespacesMap.put("sap", new Namespace("sap", "http://www.mulesoft.org/schema/mule/sap"));
        return namespacesMap;
    }

    private String extractLocalName(String elementName) {
        if (elementName.contains(":")) {
            return elementName.split(":")[1];
        }
        return elementName;
    }

    private String extractPrefix(String elementName) {
        if (elementName.contains(":")) {
            return elementName.split(":")[0];
        }
        return "";
    }

    private static String extractElementTagName(String text) {
        int to = 1;
        while (":-".indexOf(text.charAt(to)) != -1 || Character.isLetter(text.charAt(to))) {
            ++to;
        }
        return text.substring(1, to);
    }

    public String getErrorMessage() {
        return "My Error Message";
    }

    private static int determineConnectorNameOffset(String docText, String name) {
        String nameStr = "\"" + name + "\"";
        int fromIndex = 0;
        int probableConnectorNameStringOffset;
        while ((probableConnectorNameStringOffset = docText.indexOf(nameStr, fromIndex)) != -1) {
            int connectorNameOffset = MuleQuickAssistProcessor.determineAttributeValueOffset("name", name, docText, probableConnectorNameStringOffset);
            if (connectorNameOffset != -1) {
                return connectorNameOffset;
            }
            fromIndex = probableConnectorNameStringOffset + nameStr.length() - 1;
        }
        return -1;
    }

    private static int determineAttributeValueOffset(String attrName, String attrValue, String docText, int cursor) {
        ExtractElementInfo element = MuleQuickAssistProcessor.extractElement(docText, cursor);
        if (element == null) {
            return -1;
        }
        String elText = element.value;
        Pattern pat = Pattern.compile("<([^\"]*\"[^\"]*\")*[^\"]*\\s+" + attrName + "\\s*=\\s*\"(" + attrValue + ")\"");
        Matcher matcher = pat.matcher(elText);
        boolean found = matcher.find();
        if (found) {
            int attributeValueOffset = matcher.start(2);
            return element.offset + attributeValueOffset;
        }
        return -1;
    }

    private static class CreateConnectorProposal
    extends ProposalTag {
        private CreateConnectorProposal() {
        }
    }

    private static class ExtractElementInfo {
        public final int offset;
        public final String value;

        public ExtractElementInfo(int offset, String value) {
            this.offset = offset;
            this.value = value;
        }
    }

    private static class ProposalTag
    implements ICompletionProposal {
        private ProposalTag() {
        }

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return null;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    }

    private static class RenameConnectorProposal
    extends ProposalTag {
        private RenameConnectorProposal() {
        }
    }

    private static class RenameProposal
    extends ProposalTag {
        private RenameProposal() {
        }
    }
}

