/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import com.onpositive.ide.ui.CustomContentAssistProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLTagsCompletionProposalComputer;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.mel.AutocompleteConfiguration;
import org.mule.tooling.ui.modules.core.validation.MuleConfigurationValidator;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.DefinitionElement;
import org.mule.tooling.ui.modules.core.widgets.EndpointProxyElement;
import org.mule.tooling.ui.modules.core.widgets.MuleCompletionProposal;
import org.mule.tooling.ui.modules.core.widgets.expressions.MuleExpressionProcessor;
import org.mule.tooling.ui.modules.core.widgets.expressions.SubstitutionExpressionsComputer;

public class MuleContentAssistProcessor
extends CustomContentAssistProcessor
implements IContentAssistProcessor {
    private static final String PREFIX_CORE = "core:";
    private static final Image substExpr = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"/icons/attrs/change.gif").createImage();
    private static final Comparator<ICompletionProposal> COMPLETION_PROPOSAL_COMPARATOR = new CompletionProposalComparator();
    private static final Function<ICompletionProposal, String> COMPLETION_PROPOSAL_TRANSFORMER = new CompletionProposalTransformer();
    private final AttributeContext context;
    private final Set<String> blockList;

    public MuleContentAssistProcessor() {
        this(null);
    }

    public MuleContentAssistProcessor(AttributeContext context) {
        this.context = context;
        this.blockList = this.getProposalsToRemove();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        ICompletionProposal[] computeCompletionProposals = super.computeCompletionProposals(viewer, offset);
        if (computeCompletionProposals != null) {
            ICompletionProposal[] iCompletionProposalArray = computeCompletionProposals;
            int n = computeCompletionProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                String displayString = proposal.getDisplayString();
                if (!this.blockList.contains(this.getLocalName(displayString))) {
                    result.add(proposal);
                }
                ++n2;
            }
        }
        this.addXmlCompletionProposals(viewer, offset, result);
        Collections.sort(result, COMPLETION_PROPOSAL_COMPARATOR);
        result = this.removeDuplicates(result, COMPLETION_PROPOSAL_TRANSFORMER);
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected void addXmlCompletionProposals(ITextViewer viewer, int offset, List<ICompletionProposal> result) {
        XMLTagsCompletionProposalComputer xmlTagsCompletionProposalComputer = new XMLTagsCompletionProposalComputer();
        List xmlTagsProposals = xmlTagsCompletionProposalComputer.computeCompletionProposals(new CompletionProposalInvocationContext(viewer, offset), (IProgressMonitor)new NullProgressMonitor());
        for (ICompletionProposal proposal : xmlTagsProposals) {
            CustomCompletionProposal customProposal = (CustomCompletionProposal)proposal;
            String displayString = customProposal.getDisplayString();
            if (displayString.startsWith(PREFIX_CORE)) {
                displayString = displayString.substring(PREFIX_CORE.length());
                customProposal.setDisplayString(displayString);
                String replacementString = customProposal.getReplacementString();
                replacementString = replacementString.replaceAll("</(.)*:", "</");
                replacementString = replacementString.replaceAll("<(.)*:", "<");
                int indexOf = replacementString.indexOf(58);
                if (indexOf != -1) {
                    replacementString = replacementString.substring(indexOf + 1);
                }
                customProposal.setReplacementString(replacementString);
            }
            if (this.blockList.contains(proposal.getDisplayString())) continue;
            result.add((ICompletionProposal)customProposal);
        }
    }

    private String getLocalName(String displayString) {
        if (displayString.contains(":")) {
            return displayString.split(":")[1];
        }
        return displayString;
    }

    private <T> List<T> removeDuplicates(Collection<T> collection, Function<T, String> transformer) {
        HashSet<String> was = new HashSet<String>();
        ArrayList<T> result = new ArrayList<T>();
        for (T el : collection) {
            String name = transformer.apply(el);
            if (was.contains(name)) continue;
            was.add(name);
            result.add(el);
        }
        return result;
    }

    protected ArrayList<ElementModel> resolveAll() {
        final AttributeContext ct = this.context == null ? new AttributeContext() : this.context;
        final ArrayList<ElementModel> ms = new ArrayList<ElementModel>();
        boolean isDomainProject = MuleProjectKind.DOMAIN.classifies(ct.getProject());
        IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
        List definitions = isDomainProject ? Collections.emptyList() : moduleManager.getDefinitions(ct.getVersion());
        for (NodeDefinition def2 : definitions) {
            if (def2.isAbstract() && !def2.isOverriden() && !def2.isShownInXML()) continue;
            def2.accept((NodeDefinitionVisitor)new NodeDefinitionVisitorAdapter(){

                public void visitPatternDefinition(PatternDefinition patternDefinition) {
                    List muleElements = patternDefinition.getMuleElements();
                    for (QName q : muleElements) {
                        ms.add(new DefinitionElement((NodeDefinition)patternDefinition, q, ct));
                    }
                }

                public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                    if (endpointDefinition.isSupportsInbound()) {
                        ms.add(new EndpointProxyElement(endpointDefinition, true, ct));
                    }
                    if (endpointDefinition.isSupportsOutbound()) {
                        ms.add(new EndpointProxyElement(endpointDefinition, false, ct));
                    }
                }

                public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                    QName muleElement = containerDefinition.getMuleElement();
                    ms.add(new DefinitionElement((NodeDefinition)containerDefinition, muleElement, ct));
                }
            });
        }
        List gdef = moduleManager.getGlobals(ct.getVersion());
        if (isDomainProject) {
            gdef = gdef.stream().filter(def -> !DomainUtils.GLOBAL_ELEMENTS_BLOCK_LIST.contains(def.getId())).collect(Collectors.toList());
        }
        for (GlobalDefinition gm : gdef) {
            if (gm.isAbstract() && !gm.isShownInXML()) continue;
            List muleElements = gm.getMuleElements();
            for (QName q : muleElements) {
                ms.add(new DefinitionElement((NodeDefinition)gm, q, ct));
            }
        }
        Collection nested = moduleManager.getNested();
        for (NestedDefinition d : nested) {
            if (d.isAbstract()) continue;
            ms.add(new DefinitionElement((NodeDefinition)d, d.getMuleElement(), ct));
        }
        return ms;
    }

    protected void addCustomProposals(ITextViewer viewer, ArrayList<ICompletionProposal> result, int offset, DomainEditingModelObject findElement, String startString, int lengthCompletion, String fullString) {
        AttributeContext ct;
        AttributeContext attributeContext = ct = this.context == null ? new AttributeContext() : this.context;
        if (findElement != null) {
            boolean isBeans = false;
            DomainEditingModelObject ms = findElement;
            while (ms != null) {
                IDocumentElementNode parentNode;
                String namespace = ms.getNamespace();
                if (namespace != null && namespace.equals("http://www.springframework.org/schema/beans")) {
                    isBeans = true;
                }
                if (!((parentNode = ms.getParentNode()) instanceof DomainEditingModelObject)) break;
                ms = (DomainEditingModelObject)parentNode;
            }
            if (!isBeans) {
                String xmlAttributeValue = findElement.getXMLAttributeValue("evaluator");
                new MuleExpressionProcessor(ct, viewer).addExpressionProposals(viewer, result, offset, findElement, startString, lengthCompletion, fullString, xmlAttributeValue);
            }
        }
        IObjectRef<EvaluatorExtensionConfiguration> configurationRef = new IObjectRef<EvaluatorExtensionConfiguration>(){

            public AutocompleteConfiguration get() {
                return new AutocompleteConfiguration(null, null, MuleCorePlugin.getDefaultDesignContext().getMuleProject(), null);
            }
        };
        IContentAssistProcessor contentAssistProcessor = EvaluatorExtensionManager.getInstance().getDefaultExpressionLanguageEvaluator().getContentAssistProcessor((IObjectRef)configurationRef);
        ICompletionProposal[] expressionLanguageCompletionProposals = contentAssistProcessor.computeCompletionProposals(viewer, offset);
        result.addAll(Arrays.asList(expressionLanguageCompletionProposals));
        String value = fullString;
        int count = -1;
        int p = 0;
        int a = 0;
        while (a < value.length()) {
            char c = value.charAt(a);
            if (c == '{' && p == 36) {
                count = a - 1;
            }
            if (c == '}' && count != -1) {
                if (this.addSubstitutionProposals(result, offset, fullString, startString, count, a, true)) {
                    return;
                }
                count = -1;
            }
            p = c;
            ++a;
        }
        if (count != -1 && this.addSubstitutionProposals(result, offset, fullString, startString, count, value.length(), false)) {
            return;
        }
        if (startString.length() > 0 && startString.charAt(startString.length() - 1) == '$') {
            result.add(new MuleCompletionProposal("{}", offset, 0, 1, substExpr, "${}", null, "Insert substitution expression placeholder"));
            return;
        }
        result.add(new MuleCompletionProposal("${}", offset, 0, 2, substExpr, "${}", null, "Insert substitution expression placeholder"));
    }

    protected boolean addSubstitutionProposals(ArrayList<ICompletionProposal> result, int offset, String fullString, String value, int count, int a, boolean isClosed) {
        IFile fl = this.getActiveFile();
        IProject ps = fl.getProject();
        HashMap<String, String> expressions = new SubstitutionExpressionsComputer(ps).expressions();
        if (count < value.length() && a >= value.length() - 1) {
            String mc = value.substring(count + 3, value.length());
            for (String s : expressions.keySet()) {
                if (!s.startsWith(mc)) continue;
                result.add(new MuleCompletionProposal(s + "}", offset - mc.length(), isClosed ? a - count - 1 : mc.length(), s.length(), substExpr, "${" + s + "}", null, "Substitution expression:" + (String)expressions.get(s)));
            }
            return true;
        }
        return false;
    }

    protected IFile getActiveFile() {
        return (IFile)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().getAdapter(IFile.class);
    }

    protected ElementModel resolve(String localName, String namespace, boolean isGlobal, IDocumentElementNode parent) {
        AttributeContext ct;
        AttributeContext attributeContext = ct = this.context == null ? new AttributeContext() : this.context;
        if (!isGlobal && parent instanceof DomainEditingModelObject) {
            IDocumentElementNode parentNode;
            DomainEditingModelObject z = (DomainEditingModelObject)parent;
            ElementModel resolve = MuleConfigurationValidator.resolve(z.getNamespace(), z.getLocalName(), ct, z.isGlobal(), null, null);
            if (resolve == null && (parentNode = parent.getParentNode()) != null) {
                resolve = this.resolve(z.getLocalName(), z.getNamespace(), isGlobal, parentNode);
            }
            return MuleConfigurationValidator.resolve(namespace, localName, ct, isGlobal, resolve, z);
        }
        return MuleConfigurationValidator.resolve(namespace, localName, ct, isGlobal, null, (DomainEditingModelObject)(parent instanceof DomainEditingModelObject ? parent : null));
    }

    public String getNamespaceLocationString(String namespace) {
        IFile activeFile = this.getActiveFile();
        try {
            IMuleProject muleProject = MuleRuntime.create((IProject)activeFile.getProject());
            String pref = namespace.substring(0, namespace.indexOf(47));
            String aname = namespace.substring(namespace.indexOf(47) + 1);
            String schemaLocation = muleProject.getSchemaLocationLookup().getSchemaLocation(Namespace.get((String)pref, (String)aname));
            return aname + " " + schemaLocation + " ";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Map<String, String> renamedPrefixes() {
        return MultiPageMessageFlowEditor.getActive().getRenamedNamespaces();
    }

    private Set<String> getProposalsToRemove() {
        Properties blocklist = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = MuleContentAssistProcessor.class.getResourceAsStream("autocompletion-blocklist.properties");){
                blocklist.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return blocklist.stringPropertyNames();
    }

    private static String valueToCompare(String displayString) {
        if (displayString.isEmpty()) {
            return displayString;
        }
        if (Character.isLetter(displayString.charAt(0))) {
            return "\"" + displayString + "\"";
        }
        return displayString;
    }

    private static final class CompletionProposalComparator
    implements Comparator<ICompletionProposal> {
        private CompletionProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal lhs, ICompletionProposal rhs) {
            String l = MuleContentAssistProcessor.valueToCompare(lhs.getDisplayString());
            String r = MuleContentAssistProcessor.valueToCompare(rhs.getDisplayString());
            return l.compareTo(r);
        }
    }

    private static final class CompletionProposalTransformer
    implements Function<ICompletionProposal, String> {
        private CompletionProposalTransformer() {
        }

        @Override
        public String apply(ICompletionProposal arg) {
            return MuleContentAssistProcessor.valueToCompare(arg.getDisplayString());
        }
    }
}

