/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public final class MuleCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private int replaceContextLength;

    public MuleCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public MuleCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public int getReplaceContextLength() {
        return this.replaceContextLength;
    }

    public void setReplaceContextLength(int replaceContextLength) {
        this.replaceContextLength = replaceContextLength;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        boolean replaceRight;
        this.fReplacementLength = offset - this.fReplacementOffset + viewer.getSelectedRange().y;
        boolean bl = replaceRight = (stateMask & 0x40000) != 0;
        if (replaceRight) {
            this.fReplacementLength = this.getReplaceContextLength();
        }
        this.apply(viewer.getDocument());
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (event != null) {
            int oldReplaceContextLength = this.getReplaceContextLength();
            int diff = event.getText().length() - event.getLength();
            this.setReplaceContextLength(oldReplaceContextLength + diff);
        }
        try {
            String prefix = document.get(this.fReplacementOffset, offset - this.fReplacementOffset);
            return this.fReplacementString.regionMatches(true, 0, prefix, 0, prefix.length());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }
}

