/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.Collections;
import java.util.Map;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;

public final class HintsToRefreshPage {
    private final IFieldEditor source;
    private final IFilter filter;
    private final Map<String, Hint> hints;

    public HintsToRefreshPage(IFieldEditor source, IFilter filter, Map<String, Hint> hints) {
        this.source = source;
        this.filter = filter;
        this.hints = hints == null ? Collections.emptyMap() : hints;
    }

    public IFieldEditor getSource() {
        return this.source;
    }

    public boolean include(String editorHelperId) {
        return this.filter.include(editorHelperId);
    }

    public Map<String, Hint> getHints() {
        return this.hints;
    }

    public static class Hint {
        private final Map<String, String> pairs;

        public Hint(Map<String, String> pairs) {
            this.pairs = pairs;
        }

        public String getValue(String key) {
            return this.pairs.get(key);
        }

        public String toString() {
            return this.pairs.toString();
        }
    }

    public static interface IFilter {
        public boolean include(String var1);
    }

    public static class SelectNothing
    implements IFilter {
        @Override
        public boolean include(String editorHelperId) {
            return false;
        }
    }

    public static class SelectOnly
    implements IFilter {
        private final String id;

        public SelectOnly(String id) {
            this.id = id;
        }

        @Override
        public boolean include(String editorHelperId) {
            return editorHelperId.equals(this.id);
        }
    }
}

