/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.FlowAttributeHelper;

public class FlowRefEditor
extends EnumFieldEditor {
    public FlowRefEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    public void setSelection(String newFlowRefName, List<EnumOption> options) {
        if (this.node == null || this.getParentPage() == null || StringUtils.isEmpty((String)newFlowRefName)) {
            return;
        }
        super.setSelection(newFlowRefName, options);
    }

    @Override
    protected boolean allowsCustomValues() {
        return true;
    }

    @Override
    public List<EnumOption> calcOptions() {
        ArrayList<EnumOption> results = this.doCalcOptions();
        this.addEmptyOption(results);
        return results;
    }

    @Override
    protected List<EnumOption> calcOptions(String value2) {
        ArrayList<EnumOption> results = this.doCalcOptions();
        this.addEmptyOption(results);
        return results;
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return false;
    }

    private void addEmptyOption(List<EnumOption> results) {
        if (((FlowAttributeHelper)this.attributeHelper).shouldAddEmptyOption()) {
            results.add(EnumOption.getEmptyOption(this.attributeHelper));
        }
    }

    private ArrayList<EnumOption> doCalcOptions() {
        ArrayList<EnumOption> results = new ArrayList<EnumOption>();
        MuleConfiguration muleConfiguration = this.context.getMuleConfiguration();
        ArrayList flowsFromAllFiles = new ArrayList(this.context.getFlows());
        ArrayList<Container> allFlows = new ArrayList<Container>();
        ArrayList flowsFromThisFile = new ArrayList(muleConfiguration.getFlows());
        HashSet<String> flowNamesFromThisFile = new HashSet<String>();
        for (Container flow : flowsFromThisFile) {
            if (!ModelUtils.isFlowOrSubflow((IMessageFlowEntity)flow)) continue;
            allFlows.add(flow);
            flowNamesFromThisFile.add(flow.getName());
        }
        Comparator<Container> compareByName = new Comparator<Container>(){

            @Override
            public int compare(Container lhs, Container rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        };
        Collections.sort(flowsFromThisFile, compareByName);
        Collections.sort(flowsFromAllFiles, compareByName);
        for (Container flow : flowsFromAllFiles) {
            if (flowNamesFromThisFile.contains(flow.getName()) || !ModelUtils.isFlowOrSubflow((IMessageFlowEntity)flow)) continue;
            allFlows.add(flow);
        }
        FlowAttributeHelper hm = (FlowAttributeHelper)this.getHelper();
        for (Container f : allFlows) {
            if (hm.isSubflows() && ModelUtils.isSubflow((IMessageFlowEntity)f)) {
                results.add(new EnumOption(f.getName(), f.getName()));
            }
            if (!hm.isFlows() || ModelUtils.isSubflow((IMessageFlowEntity)f)) continue;
            results.add(new EnumOption(f.getName(), f.getName()));
        }
        return results;
    }
}

