/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeValidator;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.dialog.FlowNameValidator;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.BasicAttributeModel;
import org.mule.tooling.ui.modules.core.widgets.DefinitionElement;
import org.mule.tooling.ui.modules.core.widgets.RootMuleElement;

public class FlowMuleElement
extends RootMuleElement
implements ElementModel {
    public static final String ENTER_INITIAL_STATE_ATTRIBUTE_ERROR = "Enter an initial state attribute.";
    private boolean isSubflow;
    private final AttributeContext context;

    public FlowMuleElement(boolean isSubflow, AttributeContext ctx) {
        this.isSubflow = isSubflow;
        this.context = ctx;
    }

    @Override
    public void validate(DomainEditingModelObject node, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number) {
        IDocumentAttributeNode nameNode = node.getDocumentAttribute("name");
        if (this.isSubflow) {
            this.validateSubFlow(node, childMap, reporter, number, nameNode);
        } else {
            this.validateFlowNaming(node, reporter, number, nameNode);
        }
        if (nameNode != null) {
            this.validateName(reporter, number, nameNode);
        }
    }

    @Override
    public boolean isAllowedChild(ElementModel resolveElement) {
        if (resolveElement instanceof DefinitionElement) {
            DefinitionElement m = (DefinitionElement)resolveElement;
            return !(m.def instanceof GlobalDefinition) && !(m.def instanceof NestedDefinition);
        }
        return super.isAllowedChild(resolveElement);
    }

    @Override
    public void validateChildren(DomainEditingModelObject parentNode, LinkedHashMap<IDocumentElementNode, ElementModel> children, IProblemReporter reporter, int number) {
    }

    @Override
    public HashSet<AttributeModel> getAllProperties() {
        HashSet<Object> allProperties = super.getAllProperties();
        if (allProperties == null) {
            allProperties = new HashSet();
        }
        allProperties.add(this.buildFlowNameAttribute());
        allProperties.add(this.buildInitialStateAttribute());
        allProperties.add(this.buildMaxConcurrencyAttribute());
        return allProperties;
    }

    private BasicAttributeModel buildMaxConcurrencyAttribute() {
        return new BasicAttributeModel("maxConcurrency").withDescription("The maximum concurrency. This value determines the maximum level of parallelism that this async router can use to optimize its performance when processing messages.").withClass("class java.lang.Integer");
    }

    private BasicAttributeModel buildInitialStateAttribute() {
        return new BasicAttributeModel("initialState").withClass("class java.lang.String").withDescription("The initial state of the flow. Usually a flow is started automatically (\"started\"), but this attribute can be used to disable initial startup (\"stopped\").").withValidator(new ITypeValidator(){

            public String validate(IProject project, String value, DomainEditingModelObject element, String typeSpecialization, String atrName) {
                if (value == null || value.trim().isEmpty()) {
                    return FlowMuleElement.ENTER_INITIAL_STATE_ATTRIBUTE_ERROR;
                }
                return null;
            }

            public int getSeverity() {
                return 4;
            }
        });
    }

    private BasicAttributeModel buildFlowNameAttribute() {
        return new BasicAttributeModel("name").withClass("class java.lang.String").withDescription("The name used to identify this flow construct.").withValidator(new ITypeValidator(){

            public String validate(IProject project, String value, DomainEditingModelObject element, String typeSpecialization, String atrName) {
                return FlowNameValidator.validate((Object)value, (AttributeContext)FlowMuleElement.this.context);
            }

            public int getSeverity() {
                return 4;
            }
        });
    }

    @Override
    public boolean shouldIncNumber() {
        return true;
    }

    private void validateFlowNaming(DomainEditingModelObject thisNode, IProblemReporter reporter, int number, IDocumentAttributeNode nameNode) {
        if (nameNode == null || StringUtils.isBlank((String)nameNode.getAttributeValue())) {
            String docName;
            Object errorMsgStr = "Flow should have 'name' attribute defined";
            if (thisNode != null && thisNode.getDocumentAttribute("doc:name") != null && (docName = thisNode.getDocumentAttribute("doc:name").getAttributeValue()) != null && docName.trim().length() > 0) {
                errorMsgStr = "Flow '" + docName + "' should have 'name' attribute defined";
            }
            reporter.accept(4, thisNode.getOffset(), thisNode.getLength() + thisNode.getOffset(), (String)errorMsgStr, number);
        }
    }

    private void validateSubFlow(DomainEditingModelObject parent, Map<IDocumentElementNode, ElementModel> children, IProblemReporter reporter, int number, IDocumentAttributeNode nameNode) {
        if (nameNode == null || StringUtils.isBlank((String)nameNode.getAttributeValue())) {
            reporter.accept(4, parent.getOffset(), parent.getLength() + parent.getOffset(), "Subflow should be named", number);
        }
        for (IDocumentElementNode child : children.keySet()) {
            if (!DefinitionElement.isInboundElement(child, children.get(child))) continue;
            String message = parent.getXMLTagName() + " shouldn't contain " + child.getXMLTagName();
            reporter.accept(4, parent.getOffset(), parent.getOffset() + parent.getLength(), message, number);
        }
    }

    private void validateName(IProblemReporter reporter, int number, IDocumentAttributeNode nameAttribute) {
        String name = nameAttribute.getAttributeValue();
        if (name.length() > 0 && CoreUtils.containsWhitespace((String)name)) {
            reporter.accept(4, nameAttribute.getOffset(), nameAttribute.getLength() + nameAttribute.getOffset(), "flow name should not contain spaces", number);
        }
    }
}

