/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.ui.modules.core.widgets.DynamicErrorMappingTable;
import org.mule.tooling.ui.modules.core.widgets.ErrorMapping;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesTree;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class FloatingErrorMapping {
    private static final int SHELL_LINES_HEIGHT = 23;
    private static final String TITLE = "Check the error types to map: ";
    private static final int TITLE_CHARSET_SIZE = "Check the error types to map: ".length() + "Check the error types to map: ".length() / 2;
    private static final String DEFAULT_APP_NAMESPACE = "APP";
    private static final int OFFSET_Y = 9;
    private static final int OFFSET_X = 15;
    private ErrorMapping errorMapping;
    private Text targetId;
    private Text targetNamespace;
    private ToolBar parent;
    private Shell shell;
    private DynamicErrorMappingTable table;
    private Point initialLocation;
    private boolean isRight;
    private boolean isDown;
    private boolean editMode = false;
    private ErrorTypesTree errorTypesTree;

    public FloatingErrorMapping(ToolBar toolbar, ErrorMapping errorMapping, DynamicErrorMappingTable table) {
        this.errorMapping = errorMapping;
        this.parent = toolbar;
        this.table = table;
    }

    public FloatingErrorMapping(ToolBar toolbar, ErrorMapping errorMapping, DynamicErrorMappingTable table, boolean editMode) {
        this(toolbar, errorMapping, table);
        this.editMode = editMode;
    }

    public void initFloat() {
        this.shell = new Shell(this.table.getShell(), 12);
        ThemeUtils.setCssId((Object)this.shell, (String)"floating-error-mapping");
        this.initialLocation = this.parent.getParent().toDisplay(this.parent.getLocation());
        int height = WidgetUtils.getLinesHeightInPixels((Control)this.shell, (int)23);
        int width = WidgetUtils.getLinesWidthInPixels((Control)this.shell, (int)TITLE_CHARSET_SIZE);
        Point shellSize = new Point(width, height);
        Point shellRect = this.calculatePosition(shellSize);
        GridLayout gl = new GridLayout();
        gl.marginBottom = 6 + (!this.isDown ? 9 : 0);
        gl.marginTop = 6 + (this.isDown ? 9 : 0);
        gl.marginRight = 10;
        gl.marginLeft = 10;
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.shell.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().applyTo((Control)this.shell);
        this.createTable();
        Label separatorLabel = new Label((Composite)this.shell, 258);
        GridDataFactory.fillDefaults().applyTo((Control)separatorLabel);
        separatorLabel.setEnabled(false);
        this.createText();
        this.shell.setSize(shellSize);
        this.shell.setLocation(shellRect.x + (this.isRight ? -15 : 15), shellRect.y);
        this.addRegion();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!FloatingErrorMapping.this.editMode) {
                    FloatingErrorMapping.this.errorMapping.remove();
                }
                if (!FloatingErrorMapping.this.shell.isDisposed()) {
                    FloatingErrorMapping.this.shell.dispose();
                }
            }

            public void shellDeactivated(ShellEvent arg0) {
                if (!FloatingErrorMapping.this.shell.isDisposed()) {
                    if (FloatingErrorMapping.this.isValid()) {
                        if (FloatingErrorMapping.this.editMode) {
                            FloatingErrorMapping.this.errorMapping.layout(true, true);
                        } else {
                            FloatingErrorMapping.this.errorMapping.createControl();
                            FloatingErrorMapping.this.table.addRow(FloatingErrorMapping.this.errorMapping);
                        }
                        FloatingErrorMapping.this.saveMapping();
                    } else if (!FloatingErrorMapping.this.editMode) {
                        FloatingErrorMapping.this.errorMapping.remove();
                    }
                    FloatingErrorMapping.this.shell.dispose();
                    FloatingErrorMapping.this.table.notifyChange();
                }
            }
        });
        this.shell.open();
    }

    private void saveMapping() {
        this.setSourceType(this.errorTypesTree.getTypesText());
        if (!this.targetId.getText().isEmpty()) {
            String targetType = StringUtils.isNotBlank((CharSequence)this.targetNamespace.getText()) ? this.targetNamespace.getText() + ":" + this.targetId.getText() : this.targetId.getText();
            this.errorMapping.setTargetType(targetType);
        }
    }

    private Point calculatePosition(Point size) {
        Rectangle clientArea = this.findCurrentMonitor();
        int areaX = Math.abs(clientArea.x + Math.abs(this.initialLocation.x));
        int areaY = this.initialLocation.y - clientArea.y;
        this.isRight = areaX + size.x < clientArea.width;
        this.isDown = areaY + size.y + 9 < clientArea.height;
        int x = this.isRight ? this.initialLocation.x : this.initialLocation.x - size.x + this.parent.getSize().x / 2;
        int y = this.isDown ? this.initialLocation.y + this.parent.getSize().y : this.initialLocation.y - size.y;
        return new Point(x, y);
    }

    private Rectangle findCurrentMonitor() {
        Monitor[] monitorArray = Display.getCurrent().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Rectangle clientArea = monitor.getClientArea();
            boolean isInClientArea = clientArea.x < this.initialLocation.x && this.initialLocation.x < clientArea.x + clientArea.width;
            if (isInClientArea &= clientArea.y < this.initialLocation.y && this.initialLocation.y < clientArea.y + clientArea.height) {
                return clientArea;
            }
            ++n2;
        }
        return Display.getCurrent().getPrimaryMonitor().getClientArea();
    }

    private void setSourceType(String sourceTypes) {
        this.errorMapping.setSourceType(sourceTypes);
        GC gc = new GC((Drawable)this.errorMapping.getSourceTypeText());
        int stringWidth = gc.stringExtent((String)sourceTypes).x;
        if (stringWidth > this.errorMapping.getSourceTypeText().getSize().x) {
            this.errorMapping.getSourceTypeText().setToolTipText(sourceTypes);
        }
        gc.dispose();
    }

    private void createText() {
        Label customErrorLabel = new Label((Composite)this.shell, 0);
        customErrorLabel.setText("Mapping to custom error: ");
        Composite target = new Composite((Composite)this.shell, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(target);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)target);
        new Label(target, 0).setText("Namespace");
        this.targetNamespace = new Text(target, 2052);
        this.targetNamespace.setLayoutData((Object)new GridData(768));
        new Label(target, 0).setText("Identifier");
        this.targetId = new Text(target, 2052);
        this.targetId.setLayoutData((Object)new GridData(768));
        if (this.editMode) {
            String loadedTarget = this.errorMapping.getTargetType();
            int colonIndex = loadedTarget.indexOf(":");
            String namespace = colonIndex > 0 ? loadedTarget.substring(0, colonIndex) : "";
            String identifier = colonIndex > 0 ? loadedTarget.substring(colonIndex + 1, loadedTarget.length()) : loadedTarget;
            this.targetId.setText(identifier);
            this.targetNamespace.setText(namespace);
        } else {
            this.targetNamespace.setText(DEFAULT_APP_NAMESPACE);
        }
        this.targetId.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 4) {
                    if (FloatingErrorMapping.this.isValid()) {
                        if (FloatingErrorMapping.this.editMode) {
                            FloatingErrorMapping.this.errorMapping.layout(true, true);
                        } else {
                            FloatingErrorMapping.this.errorMapping.createControl();
                            FloatingErrorMapping.this.table.addRow(FloatingErrorMapping.this.errorMapping);
                        }
                        FloatingErrorMapping.this.saveMapping();
                    } else if (!FloatingErrorMapping.this.editMode) {
                        FloatingErrorMapping.this.errorMapping.remove();
                    }
                    FloatingErrorMapping.this.shell.dispose();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createTable() {
        Label errorsLabel = new Label((Composite)this.shell, 0);
        errorsLabel.setText(TITLE);
        this.errorTypesTree = new ErrorTypesTree(this.table.getNode(), false);
        this.errorTypesTree.createTypesTree((Composite)this.shell, this.errorMapping.getSourceType());
    }

    public boolean isValid() {
        return !this.targetId.getText().isEmpty();
    }

    private void addRegion() {
        Region region = new Region();
        Point s = this.shell.getSize();
        region.add(0, 0, s.x, s.y);
        region.subtract(0, this.isDown ? 0 : s.y - 9, s.x, 9);
        int top = this.isDown ? 9 : 0;
        int bottom = this.isDown ? s.y : s.y - 9;
        region.subtract(0, top + 0, 5, 1);
        region.subtract(0, top + 1, 3, 1);
        region.subtract(0, top + 2, 2, 1);
        region.subtract(0, top + 3, 1, 1);
        region.subtract(0, top + 4, 1, 1);
        region.subtract(s.x - 5, top + 0, 5, 1);
        region.subtract(s.x - 3, top + 1, 3, 1);
        region.subtract(s.x - 2, top + 2, 2, 1);
        region.subtract(s.x - 1, top + 3, 1, 1);
        region.subtract(s.x - 1, top + 4, 1, 1);
        region.subtract(0, bottom, 5, 1);
        region.subtract(0, bottom - 1, 3, 1);
        region.subtract(0, bottom - 2, 2, 1);
        region.subtract(0, bottom - 3, 1, 1);
        region.subtract(0, bottom - 4, 1, 1);
        region.subtract(s.x - 5, bottom - 0, 5, 1);
        region.subtract(s.x - 3, bottom - 1, 4, 1);
        region.subtract(s.x - 2, bottom - 2, 3, 1);
        region.subtract(s.x - 1, bottom - 3, 2, 1);
        region.subtract(s.x - 1, bottom - 4, 1, 1);
        int i = 0;
        while (i < 9) {
            region.add(this.isRight ? 16 + i : s.x - this.parent.getSize().x / 2 - 15 + 1 + i, this.isDown ? 9 - i : s.y - 9 + i, 18 - i * 2, 1);
            ++i;
        }
        if (this.shell.getRegion() != null) {
            this.shell.getRegion().dispose();
        }
        this.shell.setRegion(region);
    }
}

