/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOptionLabelProvider;

public class FilteredOptionsSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String MATCH_ALL_PATTERN = "**";
    private List<EnumOption> input;
    private EnumOption selectedOption;

    public FilteredOptionsSelectionDialog(Shell shell, List<EnumOption> input) {
        super(shell);
        this.setDetailsLabelProvider((ILabelProvider)new EnumOptionLabelProvider());
        this.setListLabelProvider((ILabelProvider)new EnumOptionLabelProvider());
        this.setTitle("Select an option");
        this.setMessage("&Search an element (? = any character, * = any string):");
        this.setInput(input);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = new DialogSettings("DialogBoundsSettings");
        dialogSettings.put("ShowStatusLine", true);
        return dialogSettings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new OptionsFilter();
    }

    protected Comparator<EnumOption> getItemsComparator() {
        return (x, y) -> x.value.compareTo(y.value);
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        List<EnumOption> input = this.getInput();
        progressMonitor.beginTask("Filtering items", input.size());
        input.forEach(option -> {
            if (itemsFilter.isConsistentItem(option)) {
                contentProvider.add(option, itemsFilter);
            }
            progressMonitor.worked(1);
        });
        progressMonitor.done();
    }

    public String getElementName(Object item) {
        return ((EnumOption)item).getCaption();
    }

    public List<EnumOption> getInput() {
        return this.input;
    }

    public void setInput(List<EnumOption> input) {
        this.input = input;
    }

    protected void computeResult() {
        StructuredSelection result = this.getSelectedItems();
        this.setSelectedOption((EnumOption)result.getFirstElement());
    }

    private void setSelectedOption(EnumOption selectedOption) {
        this.selectedOption = selectedOption;
    }

    public EnumOption getSelectedOption() {
        return this.selectedOption;
    }

    private class OptionsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private OptionsFilter() {
            super((FilteredItemsSelectionDialog)FilteredOptionsSelectionDialog.this);
        }

        public String getPattern() {
            String pattern = super.getPattern();
            if (StringUtils.isBlank((String)pattern)) {
                return FilteredOptionsSelectionDialog.MATCH_ALL_PATTERN;
            }
            return pattern;
        }

        public boolean matchItem(Object item) {
            if (StringUtils.isBlank((String)this.getPattern())) {
                return true;
            }
            if (item instanceof EnumOption) {
                return this.matches(((EnumOption)item).value);
            }
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof EnumOption;
        }
    }
}

