/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.DynamicErrorMappingTable;
import org.mule.tooling.ui.modules.core.widgets.FloatingErrorMapping;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicTableImages;

public class ErrorMapping
extends Composite {
    private static final String TARGET_TYPE_LABEL = "Map to: ";
    private static final String SOURCE_TYPE_LABEL = "Error types to be mapped: ";
    private Text sourceTypeText;
    private Text targetTypeText;
    private String sourceType = "";
    private String targetType = "";
    private DynamicErrorMappingTable parent;
    private ToolBar toolbar;

    public ErrorMapping(DynamicErrorMappingTable parent, int style) {
        super(parent.getRowsWrapper(), style);
        this.parent = parent;
        this.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.createFrom((GridData)new GridData(768)).grab(true, false).applyTo((Control)this);
    }

    public void createControl() {
        Label errorTypesLabel = new Label((Composite)this, 0);
        errorTypesLabel.setText(SOURCE_TYPE_LABEL);
        Label customErrorLabel = new Label((Composite)this, 0);
        customErrorLabel.setText(TARGET_TYPE_LABEL);
        new Label((Composite)this, 0);
        this.sourceTypeText = new Text((Composite)this, 2060);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.sourceTypeText.setLayoutData((Object)data);
        this.sourceTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text source = (Text)e.getSource();
                String newValue = source.getText();
                if (StringUtils.isBlank((CharSequence)newValue)) {
                    newValue = "ANY";
                    ErrorMapping.this.setSourceType(newValue);
                }
                ErrorMapping.this.sourceType = newValue;
                ErrorMapping.this.parent.notifyChange();
            }
        });
        this.targetTypeText = new Text((Composite)this, 2052);
        this.targetTypeText.setLayoutData((Object)data);
        this.targetTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue;
                Text source = (Text)e.getSource();
                ErrorMapping.this.targetType = newValue = source.getText();
                ErrorMapping.this.parent.notifyChange();
            }
        });
        this.createParameterToolbar();
    }

    private ToolBar createParameterToolbar() {
        this.toolbar = new ToolBar((Composite)this, 4);
        ToolBarManager parametersToolbarManager = new ToolBarManager(this.toolbar);
        parametersToolbarManager.add((IAction)new EditParameterAction(true));
        parametersToolbarManager.add((IAction)new RemoveParameterAction(true));
        parametersToolbarManager.update(true);
        return this.toolbar;
    }

    public Text getSourceTypeText() {
        return this.sourceTypeText;
    }

    public Text getTargetTypeText() {
        return this.targetTypeText;
    }

    public void remove() {
        RemoveParameterAction remove = new RemoveParameterAction(false);
        remove.run();
    }

    public Set<Property> getProperties() {
        HashSet<Property> list = new HashSet<Property>();
        list.add(new Property("sourceType", this.getSourceType()));
        list.add(new Property("targetType", this.getTargetType()));
        return list;
    }

    public void notifyRemovedMapping() {
        if (!this.isDisposed()) {
            this.parent.removeRow(this);
        }
    }

    public void editCurrentMapping() {
        FloatingErrorMapping errorMapping = new FloatingErrorMapping(this.toolbar, this, this.parent, true);
        errorMapping.initFloat();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceTypeText.setText(sourceType);
        this.sourceType = sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetTypeText.setText(targetType);
        this.targetType = targetType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ErrorMapping) {
            ErrorMapping other = (ErrorMapping)((Object)obj);
            return this.getSourceType().equals(other.getSourceType()) && this.getTargetType().equals(other.getTargetType());
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.targetType.hashCode();
        result = 31 * result + this.sourceType.hashCode();
        return result;
    }

    public String toString() {
        return "Error Mapping (" + this.sourceType + " -> " + this.targetType + ")";
    }

    private class EditParameterAction
    extends Action {
        private boolean fireEvent;

        public EditParameterAction(boolean fireEvent) {
            super("edit");
            this.fireEvent = fireEvent;
            this.setImageDescriptor(MuleImages.DESC_EDIT);
        }

        public void run() {
            ErrorMapping.this.parent.getRowsWrapper().layout(true, true);
            if (this.fireEvent) {
                ErrorMapping.this.editCurrentMapping();
            }
        }
    }

    private class RemoveParameterAction
    extends Action {
        private boolean fireEvent;

        public RemoveParameterAction(boolean fireEvent) {
            super("remove");
            this.fireEvent = fireEvent;
            this.setImageDescriptor(DynamicTableImages.REMOVE_PARAMETER_IMAGE);
        }

        public void run() {
            ErrorMapping.this.parent.getRowsWrapper().layout(true, true);
            if (this.fireEvent) {
                ErrorMapping.this.notifyRemovedMapping();
            }
            ErrorMapping.this.dispose();
        }
    }
}

