/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.endpoint.ErrorMappingCustomPage;
import org.mule.tooling.ui.modules.core.widgets.ErrorMapping;
import org.mule.tooling.ui.modules.core.widgets.FloatingErrorMapping;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicTableImages;

public class DynamicErrorMappingTable
extends Composite {
    private static final String EMPTY_LABEL_TEXT = "Add error mappings.";
    private List<ErrorMapping> rows;
    private Composite rowsWrapper;
    private ToolBar toolbar;
    private Composite emptyCanvasComposite;
    private ErrorMappingCustomPage page;
    private List<String> usedSources = new ArrayList<String>();
    private List<String> usedTargets = new ArrayList<String>();
    private List<String> errors = new ArrayList<String>();
    private RemoveAllRowsAction removeAllAction;
    private IMessageFlowNode node;

    public DynamicErrorMappingTable(ErrorMappingCustomPage parent, int style, IMessageFlowNode node) {
        super(parent.getWrapper(), style);
        this.setPage(parent);
        this.rows = new ArrayList<ErrorMapping>();
        this.node = node;
    }

    public List<ErrorMapping> getRows() {
        return this.rows;
    }

    public void createControls() {
        Composite container = new Composite((Composite)this, 4);
        GridLayoutFactory.fillDefaults().applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.createTitle(container);
        this.rowsWrapper = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.getRowsWrapper());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.getRowsWrapper());
        this.createEmptyCanvasInformation();
    }

    private void createTitle(Composite parent) {
        Composite titleWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).extendedMargins(5, 5, 5, 0).applyTo(titleWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleWrapper);
        this.toolbar = new ToolBar(titleWrapper, 4);
        ToolBarManager rowsToolbarManager = new ToolBarManager(this.toolbar);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.toolbar);
        rowsToolbarManager.add((IAction)new AddRowAction());
        this.removeAllAction = new RemoveAllRowsAction();
        this.removeAllAction.setEnabled(!this.rows.isEmpty());
        rowsToolbarManager.add((IAction)this.removeAllAction);
        rowsToolbarManager.update(true);
        Label titleLabel = new Label(titleWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)titleLabel);
        titleLabel.setText("");
        Label separatorLabel = new Label(parent, 258);
        GridDataFactory.fillDefaults().applyTo((Control)separatorLabel);
        separatorLabel.setEnabled(false);
    }

    private void addRow() {
        ErrorMapping newRow = this.createRow();
        FloatingErrorMapping errorMapping = new FloatingErrorMapping(this.toolbar, newRow, this);
        errorMapping.initFloat();
    }

    public ErrorMapping createRow() {
        ErrorMapping errorMapping = new ErrorMapping(this, 0);
        return errorMapping;
    }

    public void addRow(ErrorMapping row) {
        if (this.rows.isEmpty()) {
            this.emptyCanvasComposite.dispose();
        }
        this.rows.add(row);
        this.removeAllAction.setEnabled(true);
        this.onRowsChanged(true);
    }

    protected void clearRows() {
        Control[] controlArray = this.getRowsWrapper().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.rows.clear();
        this.removeAllAction.setEnabled(false);
        if (this.emptyCanvasComposite.isDisposed()) {
            this.createEmptyCanvasInformation();
        }
        this.onRowsChanged(true);
    }

    private void createEmptyCanvasInformation() {
        this.emptyCanvasComposite = new Composite(this.getRowsWrapper(), 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(5, 5, 5, 5).applyTo(this.emptyCanvasComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.emptyCanvasComposite);
        Label emptyCanvasLabel = new Label(this.emptyCanvasComposite, 0x1000000);
        emptyCanvasLabel.setText(EMPTY_LABEL_TEXT);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)emptyCanvasLabel);
    }

    public void removeRow(ErrorMapping row) {
        this.rows.remove((Object)row);
        if (this.rows.isEmpty() && this.emptyCanvasComposite.isDisposed()) {
            this.createEmptyCanvasInformation();
            this.removeAllAction.setEnabled(false);
        }
        this.onRowsChanged(true);
    }

    protected void onRowsChanged(boolean fireEvents) {
        if (fireEvents) {
            this.notifyChange();
        }
    }

    public void notifyChange() {
        this.getPage().listChanged();
    }

    public IMessageFlowNode getNode() {
        return this.node;
    }

    private void calcUsedTypes() {
        this.usedSources.clear();
        this.usedTargets.clear();
        for (ErrorMapping mapping : this.getRows()) {
            this.usedSources.addAll(Lists.newArrayList((Object[])mapping.getSourceType().split(", ")));
            this.usedTargets.add(mapping.getTargetType());
        }
    }

    public List<String> getUsedSources() {
        this.calcUsedTypes();
        return this.usedSources;
    }

    private List<String> getUsedTargets() {
        return this.usedTargets;
    }

    public Composite getRowsWrapper() {
        return this.rowsWrapper;
    }

    public void validate() {
        this.errors.clear();
        this.validateRepeteadSources();
        this.validateOnlyOneAnyOrEmptyTarget();
    }

    private void validateOnlyOneAnyOrEmptyTarget() {
        boolean moreThanOneAnyOrEmpty;
        boolean bl = moreThanOneAnyOrEmpty = this.getUsedTargets().stream().filter(t -> t.toLowerCase().equals("any") || StringUtils.isBlank((CharSequence)t)).collect(Collectors.toList()).size() > 1;
        if (moreThanOneAnyOrEmpty) {
            this.showMoreThanOneAnyOrEmpty();
        }
    }

    private void validateRepeteadSources() {
        HashSet repeated = Sets.newHashSet();
        this.getUsedSources().forEach(source -> {
            boolean add = repeated.add(source.toLowerCase());
            if (!add) {
                this.showRepeatedSource((String)source);
            }
        });
    }

    private void showMoreThanOneAnyOrEmpty() {
        this.errors.add("Only one mapping for 'ANY' or an empty source type is allowed.");
    }

    private void showRepeatedSource(String source) {
        this.errors.add("There are repeated source types: '" + source + "'.");
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ErrorMappingCustomPage getPage() {
        return this.page;
    }

    public void setPage(ErrorMappingCustomPage page) {
        this.page = page;
    }

    private class AddRowAction
    extends Action {
        public AddRowAction() {
            this.setImageDescriptor(DynamicTableImages.ADD_PARAMETER_IMAGE);
            this.setId("Add new mapping");
            this.setToolTipText("Add new mapping");
        }

        public void run() {
            DynamicErrorMappingTable.this.addRow();
        }
    }

    private class RemoveAllRowsAction
    extends Action {
        public RemoveAllRowsAction() {
            this.setImageDescriptor(DynamicTableImages.REMOVE_ALL_PARAMETER_IMAGE);
            this.setId("Delete all mappings");
            this.setToolTipText("Delete all mappings");
        }

        public void run() {
            boolean sure = MessageDialog.openQuestion((Shell)DynamicErrorMappingTable.this.getParent().getShell(), (String)"Delete all mappings", (String)"Are you sure to delete all mappings?");
            if (sure) {
                DynamicErrorMappingTable.this.clearRows();
            }
        }
    }
}

