/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.Collection;
import java.util.Map;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementFieldEditor;
import org.mule.tooling.ui.widgets.group.CollapsableGroup;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;

public class DisableChildsOnCollapseListener
implements ICollapseListener {
    private CollapsableGroup collapseGroup;
    private AttributesPropertyPage attributesPropertyPage;

    public DisableChildsOnCollapseListener(AttributesPropertyPage attributesPropertyPage, CollapsableGroup group) {
        this.attributesPropertyPage = attributesPropertyPage;
        this.collapseGroup = group;
    }

    public void onCollapse() {
        this.manageCollapseExpandGroups();
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    public void onExpand() {
        this.manageCollapseExpandGroups();
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    private void manageCollapseExpandGroups() {
        Map<String, IFieldEditor> currentEditors = this.attributesPropertyPage.getEditorsForPage();
        for (IFieldEditor fieldEditor : currentEditors.values()) {
            if (!this.isGroupChild(fieldEditor)) continue;
            fieldEditor.setEnabled(this.collapseGroup.isExpanded());
            this.validateEditor(fieldEditor);
        }
    }

    private boolean isGroupChild(IFieldEditor fieldEditor) {
        return fieldEditor.getControl().getParent().equals(this.collapseGroup.getContent());
    }

    private void validateEditor(IFieldEditor fieldEditor) {
        if (fieldEditor instanceof AbstractFieldEditor) {
            ((AbstractFieldEditor)fieldEditor).validate();
        } else if (fieldEditor instanceof ChildElementFieldEditor) {
            this.validateInnerEditors((ChildElementFieldEditor)fieldEditor);
        }
    }

    private void validateInnerEditors(ChildElementFieldEditor childEditor) {
        Map<String, AttributesPropertyPage> innerPages = childEditor.getAttributePages();
        for (AttributesPropertyPage page : innerPages.values()) {
            Collection<IFieldEditor> innerEditors = page.getEditors().values();
            for (IFieldEditor innerEditor : innerEditors) {
                this.validateEditor(innerEditor);
            }
            page.validate();
        }
        childEditor.validate();
    }
}

