/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DEMOElementWrapper;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeValidator;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentElementNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.requirement.AbstractValidationCallback;
import org.mule.tooling.core.requirement.RequirementValidator;
import org.mule.tooling.core.requirement.ValidationCallback;
import org.mule.tooling.core.requirement.ValidationResult;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.DefaultNodeNameProvider;
import org.mule.tooling.model.messageflow.INodeNameProvider;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributeModelWithHelper;
import org.mule.tooling.ui.modules.core.widgets.BasicAttributeModel;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValidatorWithSeverity;
import org.mule.tooling.ui.modules.core.widgets.TextElementModel;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DynamicElementModel;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.LabelHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiWayHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.TextAttributeMeta;

public class DefinitionElement
implements ElementModel {
    public static final String NO_VALID_OPERATION_SELECTED_MESSAGE = "No valid operation selected.";
    private static final ArrayList<String> ON_ERROR_VALID_ATTRS = Lists.newArrayList((Object[])new String[]{"ref", "when", "type"});
    private QName name;
    private AttributeContext context;
    protected static ImageRegistry registry;
    private String propAdd = "";
    public final NodeDefinition def;

    public DefinitionElement(NodeDefinition def, QName localName, AttributeContext ctx) {
        String namespacePrefix;
        this.def = def;
        this.name = localName;
        this.context = ctx;
        if (localName.getPrefix().length() == 0) {
            this.name = QNameUtils.get((String)localName.getLocalPart(), (String)this.calcPref(localName.getNamespaceURI()), (String)localName.getNamespaceURI());
        }
        if (!(namespacePrefix = this.name.getPrefix()).equals("core")) {
            this.propAdd = namespacePrefix + ":";
        }
    }

    private String calcPref(String namespaceURI) {
        return namespaceURI.substring(namespaceURI.lastIndexOf(47) + 1);
    }

    public NodeDefinition getDef() {
        return this.def;
    }

    public boolean isExplicitlyAllowedChild(NestedDefinition nd) {
        AbstractComponentMeta service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class);
        return service != null && service.isExplicitlyAllowed(nd);
    }

    public boolean isAllowedChild(ElementModel resolveElement) {
        AbstractComponentMeta service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class);
        if (service == null || service.isAllowAny()) {
            return true;
        }
        if (resolveElement instanceof DefinitionElement) {
            DefinitionElement definitionElement = (DefinitionElement)resolveElement;
            NodeDefinition nodeDefinition = definitionElement.def;
            if (nodeDefinition instanceof NestedDefinition) {
                NestedDefinition nestedDefinition = (NestedDefinition)nodeDefinition;
                if (service != null) {
                    return service.isAllowedChild(nestedDefinition);
                }
            }
        }
        return false;
    }

    public String getName() {
        return this.propAdd + this.name.getLocalPart();
    }

    public HashSet<AttributeModel> getAllProperties() {
        AbstractComponentMeta service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class);
        if (service == null) {
            String attrName = this.name.getLocalPart();
            String attrNamespace = this.name.getNamespaceURI();
            if (("choice".equals(attrName) || "all".equals(attrName)) && "http://www.mulesoft.org/schema/mule/core".equals(attrNamespace)) {
                HashSet<AttributeModel> allProperties = new HashSet<AttributeModel>();
                allProperties.add(new BasicAttributeModel("tracking:enable-default-events").withClass("class java.lang.Boolean"));
                return allProperties;
            }
            return null;
        }
        Map<String, AttributeCategory> attributeCategoryMap = service.getAttributeCategoryMap();
        HashSet<AttributeModel> result = new HashSet<AttributeModel>();
        if (this.def.getAllowsName()) {
            result.add(new BasicAttributeModel("doc:name"));
        }
        if (this.def.getAllowsDescription()) {
            result.add(new BasicAttributeModel("doc:description"));
        }
        String version = this.context == null ? null : this.context.getVersion();
        for (AttributeCategory a : attributeCategoryMap.values()) {
            if (version != null && !a.matches(version)) continue;
            for (AttributeGroup g : a.getGroups()) {
                if (version != null && !g.matches(version)) continue;
                this.addAllAttributesFromGroup(g, version, result);
            }
        }
        return result;
    }

    private void addAllAttributesFromGroup(final AttributeGroup group, final String version, final HashSet<AttributeModel> out) {
        this.def.accept((NodeDefinitionVisitor)new NodeDefinitionVisitorAdapter(){

            public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                boolean hasMode;
                String mode = group.getMode();
                boolean bl = hasMode = mode != null && StringUtils.isNotBlank((String)mode);
                if (hasMode) {
                    if (DefinitionElement.this.elementNameBelongsToMode(DefinitionElement.this.name, mode, endpointDefinition)) {
                        this.defaultVisit((NodeDefinition)endpointDefinition);
                    }
                } else {
                    this.defaultVisit((NodeDefinition)endpointDefinition);
                }
            }

            public void defaultVisit(NodeDefinition containerDefinition) {
                Collection<AttributeHelper> helpers = group.elements();
                DefinitionElement.this.addAllHelpers(helpers, version, out);
            }
        });
    }

    private boolean elementNameBelongsToMode(QName _name, String mode, EndpointDefinition endpointDefinition) {
        QName inboundMuleElement = endpointDefinition.getInboundMuleElement();
        QName outboundMuleElement = endpointDefinition.getOutboundMuleElement();
        return _name.equals(inboundMuleElement) && mode.equals("inbound") || _name.equals(outboundMuleElement) && mode.equals("outbound");
    }

    private void addAllHelpers(Iterable<AttributeHelper> helpers, String version, final HashSet<AttributeModel> out) {
        for (AttributeHelper h : helpers) {
            if (!h.matches(version) || h instanceof ChildElementAttributeHelper || !h.isAttribute() || h instanceof LabelHelper) continue;
            if (h instanceof AbstractCompositeAttributeHelper) {
                AbstractCompositeAttributeHelper composite = (AbstractCompositeAttributeHelper)h;
                List<AttributeHelper> children = composite.getChildren();
                this.addAllHelpers(children, version, out);
            }
            if (h.isHiddenForUser() || h.isTransient()) continue;
            final AttributeModelWithHelper attributeModel = new AttributeModelWithHelper(h, this.context);
            final String mode = h.getMode();
            final boolean hasMode = mode != null && StringUtils.isNotBlank((String)mode);
            this.def.accept((NodeDefinitionVisitor)new NodeDefinitionVisitorAdapter(){

                public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                    if (hasMode) {
                        if (DefinitionElement.this.elementNameBelongsToMode(DefinitionElement.this.name, mode, endpointDefinition)) {
                            this.defaultVisit((NodeDefinition)endpointDefinition);
                        }
                    } else {
                        this.defaultVisit((NodeDefinition)endpointDefinition);
                    }
                }

                public void defaultVisit(NodeDefinition containerDefinition) {
                    out.add(attributeModel);
                }
            });
        }
    }

    public boolean shouldIncNumber() {
        boolean ignored = this.ignoreInc();
        return !this.isNested() && !ignored;
    }

    private boolean isNested() {
        return this.def instanceof NestedDefinition && !(this.def instanceof RouteDefinition) || this.def instanceof NestedContainerDefinition;
    }

    private boolean ignoreInc() {
        return ModelUtils.isDefaultErrorHandler((NodeDefinition)this.def);
    }

    public String getUrl() {
        return this.name.getNamespaceURI();
    }

    public String getDescription() {
        return this.def.getDescription();
    }

    public boolean mayHaveChilds() {
        return false;
    }

    public Image getIconImage() {
        return this.def.getIconImage();
    }

    public boolean isAbstract() {
        return this.def.isAbstract() && !this.def.isOverriden() || this.def.isHiddenFromXML();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public static boolean isInboundElement(IDocumentElementNode node, ElementModel model) {
        QName inboundMuleElement;
        String inboundLocalName;
        String xmlLocalName;
        if (!(node instanceof DomainEditingModelObject) || !(model instanceof DefinitionElement)) {
            return false;
        }
        DomainEditingModelObject element = (DomainEditingModelObject)node;
        DefinitionElement de = (DefinitionElement)model;
        NodeDefinition nodeDefinition = de.getDef();
        if (!(nodeDefinition instanceof EndpointDefinition)) {
            return false;
        }
        EndpointDefinition ed = (EndpointDefinition)nodeDefinition;
        return ed.isSupportsInbound() && (xmlLocalName = element.getLocalName()).equals(inboundLocalName = (inboundMuleElement = ed.getInboundMuleElement()).getLocalPart());
    }

    public static boolean isOutboundElement(IDocumentElementNode node, ElementModel model) {
        QName outboundMuleElement;
        String outboundLocalName;
        String xmlLocalName;
        if (!(node instanceof DomainEditingModelObject) || !(model instanceof DefinitionElement)) {
            return false;
        }
        DomainEditingModelObject element = (DomainEditingModelObject)node;
        DefinitionElement de = (DefinitionElement)model;
        NodeDefinition nodeDefinition = de.getDef();
        if (!(nodeDefinition instanceof EndpointDefinition)) {
            return false;
        }
        EndpointDefinition ed = (EndpointDefinition)nodeDefinition;
        return ed.isSupportsOutbound() && (xmlLocalName = element.getLocalName()).equals(outboundLocalName = (outboundMuleElement = ed.getOutboundMuleElement()).getLocalPart());
    }

    public void validateChildren(DomainEditingModelObject node, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number) {
        Message componentValidationResult;
        AbstractComponentMeta service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class);
        if (service == null) {
            return;
        }
        ArrayList<AttributeHelper> childElements = new ArrayList<AttributeHelper>();
        childElements.addAll(Arrays.asList(service.getChildElements()));
        childElements.addAll(service.getAllAttributes().stream().filter(x -> !x.isAttribute()).collect(Collectors.toList()));
        this.validateChildrenOrder(childMap, childElements, reporter, node, number);
        IComponentValidator componentValidator = service.getComponentValidator();
        if (componentValidator != null && (componentValidationResult = componentValidator.validateComponent(node)) != ValidationConstants.MESSAGE_OK) {
            int end = DefinitionElement.evalEnd((IDocumentElementNode)node);
            reporter.accept(componentValidationResult.getSeverity().getCode(), node.getOffset(), end, componentValidationResult.getMessage(), number);
        }
        this.validateDefinitionRequirements(node, reporter, number);
        PropertyCollectionMap nodePropertyCollectionMap = this.fillPropertyCollecitonMapFromNode(node);
        this.validateRequirementAlternatives(node, reporter, number, service, nodePropertyCollectionMap);
        this.validateRepeatedAndNotAllowMultiple(node, reporter, number, service, nodePropertyCollectionMap);
        this.validateChildNodes(node, childMap, reporter, number, service);
        this.validateMultiwayRequiredChildren(service, reporter, node, number);
        this.validateErrorMappings(node, childMap, reporter, number, service);
        this.validateErrorHandlers(node, childMap, reporter, number + 1, service);
    }

    private void validateErrorHandlers(DomainEditingModelObject node, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number, AbstractComponentMeta service) {
        if (ModelUtils.isErrorHandler((NodeDefinition)this.def) || ModelUtils.isDefaultErrorHandler((NodeDefinition)this.def)) {
            ArrayList onErrors = new ArrayList();
            childMap.forEach((k, v) -> {
                if (v instanceof DefinitionElement && ModelUtils.isOnError((NodeDefinition)((DefinitionElement)v).getDef())) {
                    onErrors.add(k);
                }
            });
            if (!onErrors.isEmpty()) {
                onErrors.remove(onErrors.size() - 1);
                IntStream.range(0, onErrors.size()).forEach(index -> this.validateOnError((IDocumentElementNode)onErrors.get(index), reporter, number + index));
            }
        }
    }

    private void validateOnError(IDocumentElementNode onError, IProblemReporter reporter, int number) {
        boolean hasAnyAttribute = Arrays.stream(onError.getNodeAttributes()).anyMatch(attribute -> ON_ERROR_VALID_ATTRS.contains(attribute.getAttributeName()));
        if (!hasAnyAttribute) {
            reporter.accept(4, onError.getOffset(), DefinitionElement.evalEnd(onError), "Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute.", number);
        }
    }

    private void validateErrorMappings(DomainEditingModelObject node, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number, AbstractComponentMeta service) {
        HashSet errorMappings = Sets.newHashSet();
        childMap.forEach((k, v) -> {
            if (v instanceof DefinitionElement && ModelUtils.isErrorMapping((NodeDefinition)((DefinitionElement)v).getDef())) {
                errorMappings.add(k);
            }
        });
        this.validateMultipleAnySources(node, reporter, number, errorMappings);
        this.validateRepeatedSources(node, reporter, number, errorMappings);
    }

    private void validateRepeatedSources(DomainEditingModelObject node, IProblemReporter reporter, int number, Set<IDocumentElementNode> errorMappings) {
        List sources = errorMappings.stream().map(mapping -> {
            String sourceTypes = mapping.getXMLAttributeValue("sourceType");
            if (StringUtils.isBlank((String)sourceTypes)) {
                return "ANY";
            }
            return sourceTypes;
        }).collect(Collectors.toList());
        List distinctSources = sources.stream().distinct().collect(Collectors.toList());
        if (sources.size() != distinctSources.size()) {
            reporter.accept(4, node.getOffset(), DefinitionElement.evalEnd((IDocumentElementNode)node), String.format("Repeated source types are not allowed. Offending types are '%s'.", Joiner.on((String)"', '").join((Iterable)CollectionUtils.disjunction(sources, distinctSources))), number);
        }
    }

    private void validateMultipleAnySources(DomainEditingModelObject node, IProblemReporter reporter, int number, Set<IDocumentElementNode> errorMappings) {
        boolean moreThanOneAny;
        boolean bl = moreThanOneAny = errorMappings.stream().filter(mapping -> {
            String sourceType = mapping.getXMLAttributeValue("sourceType");
            if (sourceType == null || StringUtils.isBlank((String)sourceType)) {
                return true;
            }
            return sourceType.toUpperCase().equals("ANY");
        }).count() > 1L;
        if (moreThanOneAny) {
            reporter.accept(4, node.getOffset(), DefinitionElement.evalEnd((IDocumentElementNode)node), "Only one mapping for 'ANY' or an empty source type is allowed.", number);
        }
    }

    private PropertyCollectionMap fillPropertyCollecitonMapFromNode(DomainEditingModelObject node) {
        IDocumentElementNode[] children;
        IDocumentAttributeNode[] nodeAttributes;
        PropertyCollectionMap nodePropertyCollectionMap = new PropertyCollectionMap();
        if (node.getTextNode() != null && StringUtils.isNotEmpty((String)node.getTextNode().getText())) {
            nodePropertyCollectionMap.addProperty("#text", node.getTextNode().getText());
        }
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = nodeAttributes = node.getNodeAttributes();
        int n = nodeAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode n3 = iDocumentAttributeNodeArray[n2];
            nodePropertyCollectionMap.addProperty(n3.getAttributeName(), n3.getAttributeValue());
            ++n2;
        }
        IDocumentElementNode[] iDocumentElementNodeArray = children = node.getChildNodes();
        int n4 = children.length;
        n = 0;
        while (n < n4) {
            IDocumentElementNode child = iDocumentElementNodeArray[n];
            if (child instanceof DomainEditingModelObject) {
                PropertyCollectionMap newPropertyCollection = this.fillPropertyCollecitonMapFromNode((DomainEditingModelObject)child);
                nodePropertyCollectionMap.addPropertyCollection(((DomainEditingModelObject)child).getLocalName(), newPropertyCollection);
            }
            ++n;
        }
        return nodePropertyCollectionMap;
    }

    private void validateDefinitionRequirements(DomainEditingModelObject node, IProblemReporter reporter, int number) {
        this.def.getRequirements().stream().filter(x -> x.isRequired() && !x.isAmbiguous()).forEach(requirement -> {
            int end = DefinitionElement.evalEnd((IDocumentElementNode)node);
            String errorMessage = requirement.getErrorMesssage();
            ProblemReporterCallback callback = new ProblemReporterCallback(reporter, node, number, end, errorMessage);
            RequirementValidator.validate((IMuleProject)this.context.getProject(), (Requirement)requirement, (ValidationCallback)callback, (boolean)false);
        });
    }

    private void validateRequirementAlternatives(DomainEditingModelObject node, IProblemReporter reporter, int number, AbstractComponentMeta service, PropertyCollectionMap nodePropertyCollectionMap) {
        List<AttributeGroupRequirement> alternativesRequirement = service.getAttributeGroupRequirements();
        if (!alternativesRequirement.isEmpty()) {
            IReadOnlyPropertyCollection propertiesWithMultiwayAttributes = DefinitionElement.getPropertyCollectionWithMultiWayAttributes(service, node);
            PropertyCollectionMap propertiesMapWithMultiwayAttributes = new PropertyCollectionMap(propertiesWithMultiwayAttributes);
            for (AttributeGroupRequirement requirement : alternativesRequirement) {
                Message validate = requirement.validate(propertiesMapWithMultiwayAttributes);
                if (validate == ValidationConstants.MESSAGE_OK) continue;
                int end = DefinitionElement.evalEnd((IDocumentElementNode)node);
                reporter.accept(validate.getSeverity().getCode(), node.getOffset(), end, validate.getMessage(), number);
            }
        }
    }

    private void validateRepeatedAndNotAllowMultiple(DomainEditingModelObject node, IProblemReporter reporter, int number, AbstractComponentMeta service, PropertyCollectionMap nodePropertyCollectionMap) {
        for (AttributeHelper helper : service.getAllAttributes()) {
            Optional<String> alternativeAttribute;
            HashSet<String> logicalAlternativeTo = helper.getAlternatives();
            if (logicalAlternativeTo.isEmpty() || !nodePropertyCollectionMap.hasProperty(helper.getId()) || !(alternativeAttribute = logicalAlternativeTo.stream().filter(s -> nodePropertyCollectionMap.hasProperty(s)).findFirst()).isPresent()) continue;
            int end = DefinitionElement.evalEnd((IDocumentElementNode)node);
            reporter.accept(4, node.getOffset(), end, "Attribute " + helper.getId() + " should not be specified together with attribute '" + String.valueOf(alternativeAttribute) + "'", number);
        }
    }

    private void validateChildNodes(DomainEditingModelObject node, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number, AbstractComponentMeta service) {
        Set<AttributeHelper> requiredChildren = new HashSet<AttributeHelper>(service.getRequiredChildren());
        HashSet<NodeDefinition> defs = new HashSet<NodeDefinition>();
        for (IDocumentElementNode elementNode : childMap.keySet()) {
            ElementModel elementModel = childMap.get(elementNode);
            if (elementModel instanceof DefinitionElement) {
                DefinitionElement definitionElement = (DefinitionElement)elementModel;
                NodeDefinition nodeDefinition = definitionElement.def;
                boolean defIsNested = nodeDefinition instanceof NestedDefinition;
                if (!defIsNested) {
                    DomainEditingModelObject ml = (DomainEditingModelObject)elementNode;
                    QName qName = QNameUtils.get((String)ml.getLocalName(), null, (String)ml.getNamespace());
                    NestedDefinition nestedDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(qName);
                    Object object = nodeDefinition = nestedDefinition != null ? nestedDefinition : nodeDefinition;
                }
                if (defIsNested && !defs.add(nodeDefinition) && !service.allowMultiple((NestedDefinition)nodeDefinition)) {
                    reporter.accept(4, elementNode.getOffset(), DefinitionElement.evalEnd(elementNode), "Element: " + nodeDefinition.getName() + " is not allowed to be repeated", number);
                }
                if (!(defIsNested && service.isAllowedChild((NestedDefinition)nodeDefinition) || service == null || service.isAllowAny() || DefinitionElement.canBeInsideEndpoint(nodeDefinition))) {
                    NodeDefinition fruta = service.getDefinition();
                    if (fruta instanceof RouteDefinition) {
                        RouteDefinition route = (RouteDefinition)fruta;
                        if (!route.getAcceptsFilter().accepts(nodeDefinition, ModuleManagerNodeDefinitionResolver.get())) {
                            reporter.accept(4, elementNode.getOffset(), DefinitionElement.evalEnd(elementNode), "Element: " + this.getDisplayName(nodeDefinition) + " is not allowed to be child of element " + this.getDisplayName(this.def), number);
                        }
                    } else {
                        reporter.accept(4, elementNode.getOffset(), DefinitionElement.evalEnd(elementNode), "Element: " + this.getDisplayName(nodeDefinition) + " is not allowed to be child of element " + this.getDisplayName(this.def), number);
                    }
                }
                NodeDefinition currentDef = nodeDefinition;
                requiredChildren = requiredChildren.stream().filter(ChildElementAttributeHelper.class::isInstance).map(ChildElementAttributeHelper.class::cast).filter(helper -> !helper.isAllowed(currentDef)).collect(Collectors.toSet());
                continue;
            }
            if (!(elementModel instanceof TextElementModel)) continue;
            String elementName = ((TextElementModel)elementModel).getShortName();
            requiredChildren = requiredChildren.stream().filter(TextAttributeMeta.class::isInstance).map(TextAttributeMeta.class::cast).filter(helper -> !helper.getId().equals(elementName)).collect(Collectors.toSet());
        }
        for (AttributeHelper s : requiredChildren) {
            int end = DefinitionElement.evalEnd((IDocumentElementNode)node);
            reporter.accept(4, node.getOffset(), end, "Required element: " + s.getCaption() + " is missing", number);
        }
    }

    private void validateMultiwayRequiredChildren(AbstractComponentMeta service, IProblemReporter reporter, DomainEditingModelObject pNode, int number) {
        if (service.hasHelper(MultiWayHelper.class)) {
            IReadOnlyPropertyCollection propertyCollection = DefinitionElement.getPropertyCollectionWithMultiWayAttributes(service, pNode);
            service.getMultiwayHelpers().forEach(h -> h.validateMultiWay(propertyCollection, reporter, pNode, number));
        }
    }

    public static IReadOnlyPropertyCollection getPropertyCollectionWithMultiWayAttributes(AbstractComponentMeta service, DomainEditingModelObject pNode) {
        IElementWrapper element = DefinitionElement.wrap(pNode);
        PatternNode node = new PatternNode((INodeNameProvider)new DefaultNodeNameProvider(), null);
        service.generate(element, (MessageFlowEntity)node);
        IReadOnlyPropertyCollection propertyCollection = node.getProperties();
        return DefinitionElement.findCorrespondingPropertyCollection(propertyCollection, element);
    }

    private static IReadOnlyPropertyCollection findCorrespondingPropertyCollection(IReadOnlyPropertyCollection propertyCollection, IElementWrapper element) {
        IReadOnlyPropertyCollection correspondingCollection = propertyCollection;
        if (correspondingCollection.getElement() == element) {
            correspondingCollection = propertyCollection;
        } else {
            List propertyCollections = correspondingCollection.getPropertyCollections();
            for (IReadOnlyPropertyCollection collection : propertyCollections) {
                IReadOnlyPropertyCollection foundCollection = DefinitionElement.findCorrespondingPropertyCollection(collection, element);
                if (foundCollection == null) continue;
                correspondingCollection = foundCollection;
                break;
            }
        }
        return correspondingCollection;
    }

    private static IElementWrapper wrap(DomainEditingModelObject pNode) {
        return new DEMOElementWrapper(pNode);
    }

    private void validateChildrenOrder(LinkedHashMap<IDocumentElementNode, ElementModel> childMap, List<AttributeHelper> supportedChildElements, IProblemReporter reporter, DomainEditingModelObject pNode, int number) {
        if (childMap.size() > 1 && !supportedChildElements.isEmpty()) {
            int lastXmlOrder = -1;
            ElementModel lastElementModel = null;
            for (Map.Entry<IDocumentElementNode, ElementModel> child : childMap.entrySet()) {
                ElementModel childValue = child.getValue();
                if (childValue != null) {
                    AttributeHelper helper = this.getChildElementAttributeHelperForElementModel(childValue, supportedChildElements);
                    if (helper == null) continue;
                    int childXmlOrder = helper.getXmlOrder();
                    if (childXmlOrder < lastXmlOrder) {
                        reporter.accept(4, pNode.getOffset(), DefinitionElement.evalEnd((IDocumentElementNode)pNode), "Element " + pNode.getLocalName() + " has children in incorrect order: " + childValue.getName() + " must be before of " + lastElementModel.getName(), number);
                        break;
                    }
                    lastXmlOrder = childXmlOrder;
                    lastElementModel = childValue;
                    continue;
                }
                if (!(child.getKey() instanceof DomainEditingModelObject)) continue;
                DomainEditingModelObject domainEditingModelObject = (DomainEditingModelObject)child.getKey();
                System.out.println("There is not a definition for the element: " + domainEditingModelObject.getNamespace() + "/" + domainEditingModelObject.getLocalName());
            }
        }
    }

    private AttributeHelper getChildElementAttributeHelperForElementModel(ElementModel child, List<AttributeHelper> supportedChildElements) {
        for (AttributeHelper supportedChild : supportedChildElements) {
            if (child instanceof DefinitionElement) {
                String childId;
                NodeDefinition childNodeDefinition = ((DefinitionElement)child).getDef();
                String string = childId = childNodeDefinition != null ? childNodeDefinition.getId() : null;
                if (supportedChild.getId().equals(childId)) {
                    return supportedChild;
                }
                if (!(supportedChild instanceof ChildElementAttributeHelper)) continue;
                for (NodeDefinition nodeDefinition : ((ChildElementAttributeHelper)supportedChild).getAllowedDefinitions()) {
                    if (!nodeDefinition.getId().equals(childId)) continue;
                    return supportedChild;
                }
                continue;
            }
            if (!supportedChild.getId().equals(child.getShortName())) continue;
            return supportedChild;
        }
        return null;
    }

    private String getDisplayName(NodeDefinition nodeDefitinion) {
        if (nodeDefitinion != null) {
            NestedDefinition nestedDefinition;
            if (nodeDefitinion instanceof ContainerDefinition) {
                ContainerDefinition containerDefinition = (ContainerDefinition)nodeDefitinion;
                if (containerDefinition.getMuleElement() != null) {
                    return containerDefinition.getMuleElement().getLocalPart();
                }
            } else if (nodeDefitinion instanceof NestedDefinition && (nestedDefinition = (NestedDefinition)nodeDefitinion).getMuleElement() != null) {
                return nestedDefinition.getMuleElement().getLocalPart();
            }
            return nodeDefitinion.getName();
        }
        return null;
    }

    public void validateScopeNode(DomainEditingModelObject pNode, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number) {
        Set<IDocumentElementNode> elements = childMap.keySet();
        for (IDocumentElementNode iDocumentElementNode : elements) {
            if (!DefinitionElement.isInboundElement(iDocumentElementNode, childMap.get(iDocumentElementNode))) continue;
            String message = pNode.getXMLTagName() + " shouldn't contain " + iDocumentElementNode.getXMLTagName();
            int end = DefinitionElement.evalEnd((IDocumentElementNode)pNode);
            reporter.accept(4, pNode.getOffset(), end, message, number);
        }
    }

    private static int evalEnd(IDocumentElementNode node) {
        String s = node.toString();
        int indexOfNewLine = s.indexOf(10);
        int start = node.getOffset();
        int end = start + (s.startsWith("<") && indexOfNewLine != -1 ? indexOfNewLine : s.length());
        return end;
    }

    private static boolean canBeInsideEndpoint(NodeDefinition d) {
        if (d == null) {
            return false;
        }
        String id = d.getId();
        return d instanceof PatternDefinition || id.endsWith("logger") || id.endsWith("splitter") || id.endsWith("resequencer") || id.endsWith("aggregator") || id.endsWith("-service") || id.endsWith("-client") || id.endsWith("custom-processor") || id.endsWith("/processor");
    }

    public String getShortName() {
        return this.name.getLocalPart();
    }

    public boolean isAllowedCompletionChild(ElementModel childElement) {
        DefinitionElement childDefinitionElement;
        NodeDefinition childNodeDefinition;
        if (childElement instanceof DynamicElementModel) {
            return true;
        }
        AbstractComponentMeta service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class);
        if (service == null) {
            return false;
        }
        if (this.def instanceof ContainerDefinition) {
            return !this.isNested(childElement) && !this.isGlobal(childElement);
        }
        if (childElement instanceof DefinitionElement && (childNodeDefinition = (childDefinitionElement = (DefinitionElement)childElement).getDef()) instanceof NestedDefinition) {
            NestedDefinition childNestedDefinition = (NestedDefinition)childNodeDefinition;
            if (service != null) {
                return service.isAllowedChildCompletion(childNestedDefinition);
            }
        }
        return false;
    }

    private boolean isNested(ElementModel elementModel) {
        if (elementModel instanceof DefinitionElement) {
            DefinitionElement definitionElement = (DefinitionElement)elementModel;
            NodeDefinition nodeDefinition = definitionElement.getDef();
            return nodeDefinition instanceof NestedDefinition;
        }
        return false;
    }

    private boolean isGlobal(ElementModel elementModel) {
        if (elementModel instanceof DefinitionElement) {
            DefinitionElement definitionElement = (DefinitionElement)elementModel;
            NodeDefinition nodeDefinition = definitionElement.getDef();
            return nodeDefinition instanceof GlobalDefinition;
        }
        return false;
    }

    public boolean skipUnknownChildren() {
        return true;
    }

    public ElementModel.InnerTextValidator getTextValidator() {
        AbstractComponentMeta service;
        if (this.def != null && (service = (AbstractComponentMeta)this.def.getService(AbstractComponentMeta.class)) != null) {
            AttributeHelper innerTextAttributeHelper = null;
            List<AttributeHelper> allAttributes = service.getAllAttributes();
            for (AttributeHelper h : allAttributes) {
                if (h.isAttribute()) continue;
                innerTextAttributeHelper = h;
                break;
            }
            if (innerTextAttributeHelper != null) {
                final IValidator validator = innerTextAttributeHelper.getValidator();
                final AttributeHelper h = innerTextAttributeHelper;
                if (validator != null) {
                    ITypeValidator iTypeValidator = new ITypeValidator(){

                        public String validate(IProject project, String value, DomainEditingModelObject element, String typeSpecialization, String atrName) {
                            if (typeSpecialization != null && atrName != null && validator instanceof ITypeValidator) {
                                ITypeValidator tv = (ITypeValidator)validator;
                                return tv.validate(project, value, element, typeSpecialization, atrName);
                            }
                            return validator.validate(value, DefinitionElement.this.context, h);
                        }

                        public int getSeverity() {
                            if (validator instanceof IValidatorWithSeverity) {
                                IValidatorWithSeverity sv = (IValidatorWithSeverity)((Object)validator);
                                return sv.getSeverity();
                            }
                            return 4;
                        }
                    };
                    ElementModel.InnerTextValidator textValidator = new ElementModel.InnerTextValidator(iTypeValidator, h.getNestedTagName());
                    return textValidator;
                }
            }
        }
        return null;
    }

    public String toString() {
        return QNameUtils.toQualifiedName((QName)this.name);
    }

    public String getCompletionProposalDocName() {
        return this.def.getCompletionProposalDocName();
    }

    public void validate(DomainEditingModelObject thisNode, LinkedHashMap<IDocumentElementNode, ElementModel> childMap, IProblemReporter reporter, int number) {
    }

    public boolean isShownInXML() {
        return this.def.isShownInXML();
    }

    public boolean reportOnParent() {
        return this.isNested();
    }

    class ProblemReporterCallback
    extends AbstractValidationCallback<ValidationResult> {
        private IProblemReporter reporter;
        private DomainEditingModelObject pNode;
        private int number;
        private int end;
        private String errorMessage;

        public ProblemReporterCallback(IProblemReporter reporter, DomainEditingModelObject pNode, int number, int end, String errorMessage) {
            super(true);
            this.reporter = reporter;
            this.pNode = pNode;
            this.number = number;
            this.end = end;
            this.errorMessage = errorMessage;
        }

        public void doRun(ValidationResult result) {
            if (!result.isSuccessful()) {
                this.reporter.accept(4, this.pNode.getOffset(), this.end, this.errorMessage, this.number);
            }
        }
    }
}

