/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.Severity;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.ErrorsCollector;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ICompositeEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;

class DefaultErrorCollector
implements ErrorsCollector<ISimpleHost> {
    private DefaultErrorCollector() {
    }

    static DefaultErrorCollector newErrorCollector() {
        return new DefaultErrorCollector();
    }

    @Override
    public List<Message> getErrorsFrom(ISimpleHost host) {
        Object[] allPages = host.getAllPages();
        List attributePropertyPages = CoreUtils.filterByType((Object[])allPages, AttributesPropertyPage.class);
        MultiMessgeHolder holder = new MultiMessgeHolder();
        this.findErrorFromFieldEditors(attributePropertyPages, holder);
        PropertyCollectionMap propertyCollectionMap = this.createPropertyCollectionMapFrom(attributePropertyPages);
        this.findErrorFromRequirements(host, propertyCollectionMap, holder);
        this.findErrorFromComponentValidator(host, attributePropertyPages, holder);
        return holder.getMessages();
    }

    private void findErrorFromFieldEditors(Collection<AttributesPropertyPage> attributePropertyPages, IMessageHolder holder) {
        for (AttributesPropertyPage currentPage : attributePropertyPages) {
            Collection<IFieldEditor> outerEditors = currentPage.getEditors().values();
            LinkedHashMap<String, IFieldEditor> allEditorsById = new LinkedHashMap<String, IFieldEditor>();
            DefaultErrorCollector.collectAllEditors(outerEditors, allEditorsById);
            Collection<IFieldEditor> editors = allEditorsById.values();
            this.findErrorsInFieldEditor(editors, holder);
        }
    }

    private PropertyCollectionMap createPropertyCollectionMapFrom(List<AttributesPropertyPage> attributePropertyPages) {
        PropertyCollectionMap propCollectionMap = new PropertyCollectionMap();
        for (AttributesPropertyPage currentPage : attributePropertyPages) {
            Collection<IFieldEditor> outerEditors = currentPage.getEditors().values();
            LinkedHashMap<String, IFieldEditor> allEditorsById = new LinkedHashMap<String, IFieldEditor>();
            DefaultErrorCollector.collectAllEditors(outerEditors, allEditorsById);
            List abstractFieldEditors = CoreUtils.filterByType(allEditorsById.values(), AbstractFieldEditor.class);
            for (IFieldEditor currentEditor : abstractFieldEditors) {
                currentEditor.saveTo(null, propCollectionMap);
            }
        }
        return propCollectionMap;
    }

    private void findErrorsInFieldEditor(Collection<IFieldEditor> editors, IMessageHolder holder) {
        for (IFieldEditor currentEditor : editors) {
            IStatus status;
            AbstractFieldEditor fieldEditor;
            if (currentEditor.getHelper() instanceof AttributeReader.NameHelper) {
                fieldEditor = (AbstractFieldEditor)currentEditor;
                holder.addMessage(fieldEditor.getError());
                continue;
            }
            if (currentEditor instanceof AbstractFieldEditor) {
                fieldEditor = (AbstractFieldEditor)currentEditor;
                holder.addMessage(fieldEditor.getError());
                continue;
            }
            if (currentEditor instanceof AbstractChildElementFieldEditor) {
                AbstractChildElementFieldEditor childElementFieldEditor = (AbstractChildElementFieldEditor)currentEditor;
                if (!childElementFieldEditor.isEnabled()) continue;
                Message errorMessage = childElementFieldEditor.validate();
                holder.addMessage(errorMessage);
                if (childElementFieldEditor.getHelper().isRequired() && childElementFieldEditor.getDefs().size() == 0) {
                    String string = "Nested element '" + childElementFieldEditor.getHelper().getCaption() + "' is required";
                    holder.addMessage(MessageBuilder.newErrorMessage((String)string).build());
                }
                if (childElementFieldEditor.getAttributePages() == null) continue;
                Collection<AttributesPropertyPage> innerPages = childElementFieldEditor.getAttributePages().values();
                this.findErrorFromFieldEditors(innerPages, holder);
                continue;
            }
            if (!(currentEditor instanceof CustomEditor) || (status = ((CustomEditor)currentEditor).validate()) == null || Status.OK_STATUS.equals(status)) continue;
            holder.addMessage(MessageBuilder.newMessage((String)status.getMessage(), (Severity)Severity.fromCode((int)status.getSeverity())).build());
        }
    }

    private static void collectAllEditors(Collection<IFieldEditor> editors, Map<String, IFieldEditor> allEditors) {
        for (IFieldEditor editor : editors) {
            String id = editor.getHelper().getId();
            allEditors.put(id, editor);
            if (!(editor instanceof ICompositeEditor)) continue;
            ICompositeEditor composite = (ICompositeEditor)((Object)editor);
            List<IFieldEditor> children = composite.getChildren();
            DefaultErrorCollector.collectAllEditors(children, allEditors);
        }
    }

    private void findErrorFromRequirements(ISimpleHost host, PropertyCollectionMap propertyCollectionMap, IMessageHolder messageHolder) {
        AbstractComponentMeta service;
        NodeDefinition definition;
        IMessageFlowNode currentNode = host.getNode();
        if (currentNode != null && (definition = currentNode.getDefinition()) != null && (service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class)) != null && !(definition instanceof NestedDefinition)) {
            List<AttributeGroupRequirement> requirements = service.getAttributeGroupRequirements();
            for (AttributeGroupRequirement requirement : requirements) {
                messageHolder.addMessage(requirement.validate(propertyCollectionMap));
            }
        }
    }

    private void findErrorFromComponentValidator(ISimpleHost host, List<AttributesPropertyPage> attributePropertyPages, IMessageHolder messageHolder) {
        List<IFieldEditor> editors;
        Message componentValidationResult;
        IMessageFlowNode currentNode = host.getNode();
        if (currentNode == null) {
            return;
        }
        NodeDefinition definition = currentNode.getDefinition();
        if (definition == null) {
            return;
        }
        AbstractComponentMeta service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
        if (service == null) {
            return;
        }
        IComponentValidator componentValidator = service.getComponentValidator();
        if (componentValidator != null && (componentValidationResult = componentValidator.validateComponentGUI(currentNode, editors = this.getFieldEditorsFrom(attributePropertyPages))) != ValidationConstants.MESSAGE_OK) {
            messageHolder.addMessage(componentValidationResult);
        }
    }

    private List<IFieldEditor> getFieldEditorsFrom(List<AttributesPropertyPage> attributePropertyPages) {
        ArrayList<IFieldEditor> editors = new ArrayList<IFieldEditor>();
        for (AttributesPropertyPage attributesPropertyPage : attributePropertyPages) {
            for (IFieldEditor fieldEditor : attributesPropertyPage.getEditors().values()) {
                editors.add(fieldEditor);
            }
        }
        return editors;
    }

    private static interface IMessageHolder {
        public void addMessage(Message var1);

        public List<Message> getMessages();
    }

    private static class MultiMessgeHolder
    implements IMessageHolder {
        private List<Message> messages = new ArrayList<Message>();

        private MultiMessgeHolder() {
        }

        @Override
        public void addMessage(Message message) {
            if (message != ValidationConstants.MESSAGE_OK) {
                this.messages.add(message);
            }
        }

        @Override
        public List<Message> getMessages() {
            return this.messages;
        }
    }
}

