/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.IDialogController;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.IForceSave;

public class ClickHandlerRegistry {
    private static Map<String, IDialogController> categoryControllers = new HashMap<String, IDialogController>();
    private static Map<String, IDialogController> idControllers = new HashMap<String, IDialogController>();
    static boolean inited;

    public static void init() {
        IConfigurationElement[] clickHandlersConfig;
        IConfigurationElement[] iConfigurationElementArray = clickHandlersConfig = Platform.getExtensionRegistry().getConfigurationElementsFor("org.mule.tooling.ui.modules.core.clickHandlers");
        int n = clickHandlersConfig.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement clickHandlerConfig = iConfigurationElementArray[n2];
            try {
                IDialogController createExecutableExtension = (IDialogController)clickHandlerConfig.createExecutableExtension("class");
                String attribute = clickHandlerConfig.getAttribute("category");
                if (attribute != null && attribute.length() > 0) {
                    categoryControllers.put(attribute, createExecutableExtension);
                }
                if ((attribute = clickHandlerConfig.getAttribute("id")) != null && attribute.length() > 0) {
                    idControllers.put(attribute, createExecutableExtension);
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.getLog().log(e.getStatus());
            }
            ++n2;
        }
        inited = true;
    }

    public static boolean proceed(ISimpleHost pageHost, NodeDefinition def, PropertyCollectionMap map, IMuleProject muleProject, MuleConfiguration configuration) {
        boolean doUpdate;
        IDialogController dialogController;
        if (!inited) {
            ClickHandlerRegistry.init();
        }
        if ((dialogController = idControllers.get(def.getId())) != null && !(doUpdate = dialogController.doUpdate(pageHost, map, def, muleProject, configuration))) {
            return false;
        }
        dialogController = categoryControllers.get(def.getCategoryId());
        return dialogController == null || (doUpdate = dialogController.doUpdate(pageHost, map, def, muleProject, configuration));
    }

    public static boolean hasToForceSave(MuleConfiguration muleConfiguration, IMuleProject muleProject, IMessageFlowNode messageFlowEntity) {
        MessageFlowNode messageFlowNode;
        NodeDefinition definition;
        if (!inited) {
            ClickHandlerRegistry.init();
        }
        if (messageFlowEntity instanceof MessageFlowNode && (definition = (messageFlowNode = (MessageFlowNode)messageFlowEntity).getDefinition()) != null) {
            IDialogController iDialogController = idControllers.get(definition.getId());
            if (iDialogController instanceof IForceSave) {
                return ((IForceSave)iDialogController).hasToForceSave(muleConfiguration, muleProject, messageFlowEntity);
            }
            iDialogController = categoryControllers.get(definition.getCategoryId());
            if (iDialogController instanceof IForceSave) {
                return ((IForceSave)iDialogController).hasToForceSave(muleConfiguration, muleProject, messageFlowEntity);
            }
        }
        return false;
    }
}

