/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ILayoutPropertiesEditorRequested;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.messageflow.dialog.ICanBeCancelled;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.messageflow.dialog.IHostAware;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.DisableChildsOnCollapseListener;
import org.mule.tooling.ui.modules.core.widgets.DummyFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.ErrorsCollector;
import org.mule.tooling.ui.modules.core.widgets.ErrorsCollectorFactory;
import org.mule.tooling.ui.modules.core.widgets.FieldEditorFactory;
import org.mule.tooling.ui.modules.core.widgets.FieldEditorVisitorAdapter;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IMessageFlowNodeAware;
import org.mule.tooling.ui.modules.core.widgets.SubGroup;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.BooleanFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.DateTimeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.GlobalRefEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.HContainer;
import org.mule.tooling.ui.modules.core.widgets.editors.IComponentModeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ICompositeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IFieldEditorLayouter;
import org.mule.tooling.ui.modules.core.widgets.editors.MultiWayEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.RadioBooleanAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.RadioBooleanEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.RadioGroupFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.SwitchCaseEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ClassNameAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.MetaDescriptionEntry;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.palette.PaletteManager;
import org.mule.tooling.ui.utils.DelayedRunnableScheduler;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.widgets.group.CollapsableGroup;
import org.mule.tooling.ui.widgets.listener.ICollapseListener;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class AttributesPropertyPage
extends MessageFlowNodeComposite
implements IFieldEditorLayouter,
IHostAware,
ICanBeCancelled,
IMessageFlowNodeAware {
    private static final int DEFAULT_INDENTATION = 28;
    private static WeakReference<AttributesPropertyPage> lastOpenedPage = null;
    private final boolean isChildPage;
    private List<String> unchangeableAttributesNames = new ArrayList<String>();
    private List<Property> unchangeableAttributesValues = new ArrayList<Property>();
    private final AttributeCategoryProvider attrCategoryProvider;
    private AttributeCategory attributeCategory;
    protected ArrayList<Control> labels = new ArrayList();
    protected AttributeContext context;
    protected Map<String, IFieldEditor> editors = new LinkedHashMap<String, IFieldEditor>();
    protected IHost host;
    protected ISimpleHost simpleHost;
    boolean inited;
    protected EndpointDirection direction;
    private Group displayNameGroup;
    private Text txtName;
    protected Map<AttributeGroup, Composite> groups = new HashMap<AttributeGroup, Composite>();
    protected Map<String, CollapsableGroup> collapsableGroups = new HashMap<String, CollapsableGroup>();
    protected PropertyCollectionMap map;
    protected IMessageFlowNode node;
    boolean insideLoad;
    private EventBusHelper busHelper;
    private ErrorsCollector<ISimpleHost> errorCollector;
    private AbstractComponentMeta assotiatedMeta;
    private DelayedRunnableScheduler selectionRequestScheduler = new DelayedRunnableScheduler(10);

    public AttributesPropertyPage(IMuleProject project, Composite parent, AttributeCategoryProvider provider) {
        this(null, project, parent, provider, ErrorsCollectorFactory.newErrorsCollector());
    }

    public AttributesPropertyPage(EndpointDirection direction, IMuleProject project, Composite parent, AttributeCategoryProvider provider) {
        this(direction, project, parent, null, provider, ErrorsCollectorFactory.newErrorsCollector(), null);
    }

    public AttributesPropertyPage(EndpointDirection direction, IMuleProject project, Composite parent, AttributeCategoryProvider provider, ErrorsCollector<ISimpleHost> errorCollector) {
        this(direction, project, parent, null, provider, errorCollector, null);
    }

    public AttributesPropertyPage(EndpointDirection direction, IMuleProject project, Composite parent, MuleConfiguration muleConfiguration, AttributeCategoryProvider provider) {
        this(direction, project, parent, null, provider, ErrorsCollectorFactory.newErrorsCollector(), null);
    }

    public AttributesPropertyPage(EndpointDirection direction, IMuleProject project, Composite parent, MuleConfiguration muleConfiguration, AttributeCategoryProvider provider, ErrorsCollector<ISimpleHost> errorCollector, AbstractComponentMeta assotiatedMeta) {
        super(project, parent);
        this.assotiatedMeta = assotiatedMeta;
        this.attrCategoryProvider = provider;
        this.errorCollector = errorCollector;
        boolean lastOpenedPageDisposed = lastOpenedPage == null || this.lastOpenedPageDisposed();
        boolean bl = this.isChildPage = !lastOpenedPageDisposed;
        if (!this.isChildPage) {
            lastOpenedPage = new WeakReference<AttributesPropertyPage>(this);
        }
        this.direction = direction;
        this.context = new AttributeContext(project);
        this.context.setMuleConfiguration(muleConfiguration);
        this.setLayout((Layout)new GridLayout(1, false));
        this.attributeCategory = provider.getAttributeCategory(this);
        this.createControls(direction);
        int msize = this.computeLabelSize();
        this.updateLabelSize(msize);
        this.busHelper = new EventBusHelper();
        this.busHelper.registerListener(UtilsPlugin.getEventBus(), CoreEventTypes.LAYOUT_PROPERTIES_EDITOR_REQUEST, (IEventHandler)new ILayoutPropertiesEditorRequested(){

            public void onLayoutRequested() {
                AttributesPropertyPage.this.selectionRequestScheduler.schedule(() -> {
                    if (!AttributesPropertyPage.this.isDisposed()) {
                        AttributesPropertyPage.this.redrawComposite();
                    }
                });
            }
        });
        this.busHelper.unregisterWith((Widget)this);
    }

    protected boolean lastOpenedPageDisposed() {
        AttributesPropertyPage attributesPropertyPage = (AttributesPropertyPage)lastOpenedPage.get();
        return attributesPropertyPage != null && attributesPropertyPage.isDisposed();
    }

    public AbstractComponentMeta getAssotiatedMeta() {
        return this.assotiatedMeta;
    }

    public void setAssotiatedMeta(AbstractComponentMeta assotiatedMeta) {
        this.assotiatedMeta = assotiatedMeta;
    }

    public void setHost(IHost host) {
        this.host = host;
    }

    public static void validateLastOpenedFromRoot() {
        AttributesPropertyPage attributesPropertyPage;
        if (lastOpenedPage != null && (attributesPropertyPage = (AttributesPropertyPage)lastOpenedPage.get()) != null) {
            attributesPropertyPage.validate();
        }
    }

    public LinkedHashMap<String, IFieldEditor> getEditors() {
        return new LinkedHashMap<String, IFieldEditor>(this.editors);
    }

    public AttributeContext getContext() {
        return this.context;
    }

    public IHost getHost() {
        return this.host;
    }

    public ISimpleHost getSimpleHost() {
        return this.simpleHost;
    }

    protected boolean isGeneral() {
        String caption;
        AbstractComponentMeta node2 = this.getAssotiatedMeta();
        if (this.attributeCategory != null && node2 != null && !(node2 instanceof GlobalComponentMeta) && (caption = this.attributeCategory.getCaption()) != null) {
            boolean equals = caption.equals("General");
            return equals;
        }
        return false;
    }

    private void updatePage(AttributeCategory attributes) {
        PropertyCollectionMap ms = new PropertyCollectionMap();
        if (this.map != null) {
            for (Property a : this.map.getPropertiesMap().asPropertyList()) {
                ms.addProperty(a.getName(), a.getValue());
            }
            Map propertyCollections = this.map.getPropertyCollections();
            for (String s : propertyCollections.keySet()) {
                ms.addPropertyCollection(s, (PropertyCollectionMap)propertyCollections.get(s));
            }
        }
        this.saveTo(this.node, ms);
        this.labels.clear();
        NodeDefinition currentMode = null;
        for (IFieldEditor f : this.editors.values()) {
            if (!(f instanceof IComponentModeEditor)) continue;
            IComponentModeEditor md = (IComponentModeEditor)f;
            currentMode = md.getCurrentNode();
        }
        this.editors.clear();
        Control[] controlArray = this.getChildren();
        int md = controlArray.length;
        int n = 0;
        while (n < md) {
            Control c = controlArray[n];
            c.dispose();
            ++n;
        }
        try {
            this.attributeCategory = attributes.copy();
            this.createControls(this.direction);
            if (currentMode != null) {
                for (IFieldEditor f : this.editors.values()) {
                    if (!(f instanceof IComponentModeEditor)) continue;
                    IComponentModeEditor md2 = (IComponentModeEditor)f;
                    md2.setCurrentMode(currentMode);
                }
            }
            int msize = this.computeLabelSize();
            this.updateLabelSize(msize);
            this.loadFrom(this.node, ms);
        }
        finally {
            this.setLayoutDeferred(false);
            this.layout(true, true);
        }
    }

    public void sendValues() {
        for (IFieldEditor editor : this.editors.values()) {
            if (!(editor instanceof AbstractFieldEditor)) continue;
            ((AbstractFieldEditor)editor).sendValue();
        }
    }

    @Override
    public void updateLabelSize(int msize) {
        for (final AttributeGroup group : this.groups.keySet()) {
            String controlledBy = group.getControlledBy();
            if (controlledBy == null) continue;
            final boolean inverse = controlledBy.length() > 0 && controlledBy.startsWith("!");
            String trimmedControlledBy = inverse ? controlledBy.substring(1) : controlledBy;
            IFieldEditor fieldEditor = this.editors.get(trimmedControlledBy);
            fieldEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Composite groupComposite = AttributesPropertyPage.this.groups.get(group);
                    Object newValue = evt.getNewValue();
                    boolean enable = Boolean.parseBoolean(String.valueOf(newValue));
                    if (inverse) {
                        enable = !enable;
                    }
                    this.setEnabled((Control)groupComposite, enable);
                }

                private void setEnabled(Control control, boolean enable) {
                    control.setEnabled(enable);
                    if (!(control instanceof Composite)) {
                        return;
                    }
                    Control[] controlArray = ((Composite)control).getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        if (!(child instanceof Label)) {
                            this.setEnabled(child, enable);
                        }
                        ++n2;
                    }
                }
            });
        }
        List fieldEditorLayouters = CoreUtils.filterByType(this.editors.values(), IFieldEditorLayouter.class);
        for (IFieldEditorLayouter fieldEditorLayouter : fieldEditorLayouters) {
            fieldEditorLayouter.updateLabelSize(msize);
        }
    }

    @Override
    public int computeLabelSize() {
        int msize = 0;
        IFieldEditor mp = null;
        Collection<IFieldEditor> outerEditors = this.editors.values();
        HashMap<String, IFieldEditor> allEditors = new HashMap<String, IFieldEditor>();
        AttributesPropertyPage.collectAllEditors(outerEditors, allEditors);
        for (final IFieldEditor fieldEditor : allEditors.values()) {
            Control ca;
            Object layoutData;
            int span;
            if (fieldEditor instanceof IFieldEditorLayouter) {
                IFieldEditorLayouter le = (IFieldEditorLayouter)((Object)fieldEditor);
                msize = Math.max(msize, le.computeLabelSize());
            }
            AttributeHelper helper = fieldEditor.getHelper();
            int indentation = helper.getIndentation();
            if (helper.isIndented() || indentation != 0) {
                int indentSize = indentation != 0 ? indentation : 28;
                Control contentControl = fieldEditor.getContentControl();
                this.setIndentToControl(indentSize, contentControl);
            }
            if ((span = helper.getSpan()) != 0) {
                Control control;
                if (span < 0 && (fieldEditor instanceof StringFieldEditor || fieldEditor instanceof EnumFieldEditor)) {
                    control = fieldEditor.getControl();
                    span = -span;
                } else {
                    control = fieldEditor.getContentControl();
                }
                this.setSpanToControl(span, control);
            }
            if (mp instanceof RadioGroupFieldEditor && fieldEditor instanceof BooleanFieldEditor && (layoutData = (ca = fieldEditor.getControl()).getLayoutData()) instanceof GridData) {
                GridData gm = (GridData)layoutData;
                gm.verticalIndent = 3;
            }
            mp = fieldEditor;
            String controlledAttr = helper.getRequiredPropertyId();
            if (controlledAttr == null) continue;
            String[] splitted = controlledAttr.split(",");
            final boolean[] ops = new boolean[splitted.length];
            int i = 0;
            while (i < ops.length) {
                String strAfterEquals;
                int indexOfEquals;
                boolean hasEqualsChar;
                boolean inverse;
                final int myIndex = i;
                controlledAttr = splitted[i];
                boolean bl = inverse = controlledAttr.length() > 0 && controlledAttr.startsWith("!");
                if (inverse) {
                    controlledAttr = controlledAttr.substring(1);
                }
                boolean bl2 = hasEqualsChar = (indexOfEquals = controlledAttr.indexOf(61)) != -1;
                if (hasEqualsChar) {
                    String tempStrAfterEquals = controlledAttr.substring(indexOfEquals + 1);
                    controlledAttr = controlledAttr.substring(0, indexOfEquals);
                    strAfterEquals = "$".equals(tempStrAfterEquals) ? "" : tempStrAfterEquals;
                } else {
                    strAfterEquals = null;
                }
                IFieldEditor lastEditor = (IFieldEditor)allEditors.get(controlledAttr);
                if (lastEditor == null) {
                    Composite tabFolder = this.getParent().getParent();
                    if (tabFolder instanceof Group) {
                        tabFolder = tabFolder.getParent().getParent().getParent();
                    }
                    List tabs = CoreUtils.filterByType((Object[])tabFolder.getChildren(), Composite.class);
                    for (Composite tab : tabs) {
                        Control tabContent;
                        Control[] tabScroller = tab.getChildren();
                        if (tabScroller.length <= 0 || !((tabContent = tabScroller[0]) instanceof AttributesPropertyPage)) continue;
                        AttributesPropertyPage sibling = (AttributesPropertyPage)tabContent;
                        lastEditor = sibling.editors.get(controlledAttr);
                        if (lastEditor != null) break;
                    }
                }
                if (lastEditor != null) {
                    String v;
                    IFieldEditor z = lastEditor;
                    if (z instanceof AbstractFieldEditor && (v = ((AbstractFieldEditor)z).getValue()) != null) {
                        boolean op = strAfterEquals != null ? v.toString().equals(strAfterEquals) : Boolean.parseBoolean(v.toString());
                        ops[myIndex] = inverse ^ op;
                    }
                    z.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            AbstractFieldEditor afe;
                            Control c = fieldEditor.getControl();
                            Object newValue = evt.getNewValue();
                            if ((evt.getSource() instanceof StringFieldEditor || evt.getSource() instanceof DateTimeEditor) && newValue != null && newValue.toString().trim().length() > 0) {
                                newValue = "true";
                            }
                            boolean visible = newValue == null ? false : this.evaluate(newValue, strAfterEquals);
                            IFieldEditor f0 = fieldEditor;
                            if (f0 instanceof SwitchCaseEditor) {
                                ((SwitchCaseEditor)f0).setCurrentComposite((String)newValue);
                                return;
                            }
                            if (f0 instanceof MultiWayEditor) {
                                ((MultiWayEditor)f0).setCurrentComposite((String)newValue);
                                return;
                            }
                            if (f0 instanceof AbstractFieldEditor) {
                                afe = (AbstractFieldEditor)f0;
                                afe.showErrorDecoration(visible);
                            }
                            if (f0 instanceof StringFieldEditor) {
                                Button browseButton;
                                StringFieldEditor sfe = (StringFieldEditor)f0;
                                AttributeHelper helper2 = sfe.getHelper();
                                if (helper2 instanceof ClassNameAttributeHelper && (browseButton = sfe.getBrowseButton()) != null) {
                                    browseButton.setEnabled(visible);
                                }
                                sfe.setEnabled(visible);
                            }
                            f0.setEnabled(visible);
                            this.process(c, visible);
                            if (fieldEditor instanceof AbstractFieldEditor && fieldEditor.getHelper().isRevalidateOnEnablementChange()) {
                                afe = (AbstractFieldEditor)fieldEditor;
                                if (fieldEditor.getControl() != null && !fieldEditor.getControl().isDisposed()) {
                                    afe.validate();
                                }
                            }
                        }

                        private boolean eval(Object newValue, String strAfterEquals2) {
                            if (strAfterEquals2 != null) {
                                return newValue.toString().equals(strAfterEquals2);
                            }
                            return Boolean.parseBoolean(newValue.toString());
                        }

                        private boolean evaluate(Object newValue, String strAfterEquals2) {
                            ops[myIndex] = inverse ^ this.eval(newValue, strAfterEquals2);
                            boolean[] blArray = ops;
                            int n = ops.length;
                            int n2 = 0;
                            while (n2 < n) {
                                boolean op = blArray[n2];
                                if (!op) {
                                    return false;
                                }
                                ++n2;
                            }
                            return true;
                        }

                        private void process(Control control, boolean visible) {
                            if (control == null || control.isDisposed()) {
                                return;
                            }
                            if (control instanceof StyledText) {
                                Color backgroundColor = visible ? ThemeUtils.getCurrentTheme().getListBackgroundColor() : ThemeUtils.getCurrentTheme().getWidgetBackgroundColor();
                                StyledText styledText = (StyledText)control;
                                styledText.setBackground(backgroundColor);
                            }
                            if (control instanceof Composite) {
                                Control[] children;
                                Composite cm = (Composite)control;
                                Control[] controlArray = children = cm.getChildren();
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Control child = controlArray[n2];
                                    if (!(child instanceof Label)) {
                                        this.process(child, visible);
                                    }
                                    ++n2;
                                }
                            }
                        }
                    });
                }
                ++i;
            }
        }
        for (Control control : this.labels) {
            msize = Math.max(msize, control.computeSize((int)-1, (int)-1).x);
        }
        return msize;
    }

    private void setSpanToControl(int span, Control control) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData == null) {
                GridData data = new GridData();
                data.horizontalSpan = span;
                control.setLayoutData((Object)data);
            } else if (layoutData instanceof GridData) {
                GridData data = (GridData)layoutData;
                data.horizontalSpan = span;
            }
        }
    }

    private void setIndentToControl(int indentSize, Control control) {
        if (control != null) {
            Object layoutData = control.getLayoutData();
            if (layoutData == null) {
                GridData data = new GridData();
                data.horizontalIndent = indentSize;
                control.setLayoutData((Object)data);
            } else if (layoutData instanceof GridData) {
                GridData data = (GridData)layoutData;
                data.horizontalIndent = indentSize;
            }
        }
    }

    private <T extends MetaDescriptionEntry> int findPosition(String idOfGroupToFind, List<T> currentVersionGroups) {
        int i = 0;
        while (i < currentVersionGroups.size()) {
            MetaDescriptionEntry group = (MetaDescriptionEntry)currentVersionGroups.get(i);
            if (group.getId().equals(idOfGroupToFind)) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Error finding group position");
    }

    private <T extends MetaDescriptionEntry> List<T> getOrderedCopyUsingAnchors(Collection<T> toOrder) {
        ArrayList<T> reorderedCopy = new ArrayList<T>(toOrder);
        for (MetaDescriptionEntry group : toOrder) {
            String bottomAnchor;
            String topAnchor = group.getTopAnchor();
            if (topAnchor != null) {
                reorderedCopy.remove(group);
                int pos = topAnchor.equals("$") ? 0 : this.findPosition(topAnchor, reorderedCopy) + 1;
                reorderedCopy.add(pos, group);
            }
            if ((bottomAnchor = group.getBottomAnchor()) == null) continue;
            reorderedCopy.remove(group);
            int pos = bottomAnchor.equals("$") ? reorderedCopy.size() : this.findPosition(bottomAnchor, reorderedCopy);
            reorderedCopy.add(pos, group);
        }
        return reorderedCopy;
    }

    private List<AttributeGroup> getFilteredGroups(Collection<AttributeGroup> groups, String version, EndpointDirection direction) {
        ArrayList<AttributeGroup> attributeGroupList = new ArrayList<AttributeGroup>();
        for (AttributeGroup group : groups) {
            if (version != null && !group.matches(version) || group.isEEOnly() && !version.endsWith(";") || !group.matches(direction)) continue;
            attributeGroupList.add(group);
        }
        return attributeGroupList;
    }

    private Collection<AttributeHelper> getFilteredHelpers(Collection<AttributeHelper> toFilter, String version) {
        ArrayList<AttributeHelper> attributeHelperList = new ArrayList<AttributeHelper>();
        for (AttributeHelper attributeHelper : toFilter) {
            if (!attributeHelper.matches(this.direction) || !attributeHelper.isVisible()) continue;
            if (version != null) {
                if (!attributeHelper.matches(version)) continue;
                boolean showDeprecatedComponents = PaletteManager.INSTANCE.showDeprecatedComponents(version);
                if (attributeHelper.isDeprecatedIn(version) && !showDeprecatedComponents) continue;
            }
            attributeHelperList.add(attributeHelper);
        }
        return attributeHelperList;
    }

    protected void createControls(EndpointDirection direction) {
        Object layoutData;
        this.createDisplayNameGroup();
        Collection<AttributeGroup> attributeGroups = this.attributeCategory.getGroups();
        String version = this.getVersion();
        List<AttributeGroup> filteredGroups = this.getFilteredGroups(attributeGroups, version, direction);
        List<AttributeGroup> orderedFilteredGroups = this.getOrderedCopyUsingAnchors(filteredGroups);
        this.unchangeableAttributesNames.addAll(this.getUnchangeableAttributeNames(orderedFilteredGroups));
        List<AttributeGroup> groupsToShow = this.getGroupsToShow(orderedFilteredGroups);
        Composite lastCreatedGroup = null;
        for (AttributeGroup groupToShow : groupsToShow) {
            Composite groupComposite;
            lastCreatedGroup = groupComposite = this.createGroupComposite(groupToShow);
            this.groups.put(groupToShow, groupComposite);
            List<IFieldEditor> createdFieldEditors = this.createFieldEditors(groupToShow, version, groupComposite);
            this.increaseFirstRadioBooleansIndent(createdFieldEditors);
            for (IFieldEditor fieldEditor : createdFieldEditors) {
                AttributeHelper helper = fieldEditor.getHelper();
                this.editors.put(helper.getId(), fieldEditor);
                CollapsableGroup parentCollapsableGroup = this.getAssociatedCollapsableGroup(fieldEditor);
                if (parentCollapsableGroup == null || !parentCollapsableGroup.isCollapsed()) continue;
                fieldEditor.setEnabled(false);
            }
        }
        if (lastCreatedGroup != null && (layoutData = lastCreatedGroup.getLayoutData()) instanceof GridData) {
            GridData gridData = (GridData)layoutData;
            gridData.grabExcessVerticalSpace = true;
        }
    }

    protected void createDisplayNameGroup() {
        if (this.shouldShowDisplayName()) {
            Group displayNameGroup = new Group((Composite)this, 0);
            displayNameGroup.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label((Composite)displayNameGroup, 0);
            nameLabel.setText("Display Name:");
            Text nameText = new Text((Composite)displayNameGroup, 2048);
            nameText.setLayoutData((Object)new GridData(768));
            nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AttributesPropertyPage.this.validate();
                }
            });
            displayNameGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            this.setTxtName(nameText);
            this.setDisplayNameGroup(displayNameGroup);
        }
    }

    private boolean shouldShowDisplayName() {
        AbstractComponentMeta service = this.getAssotiatedMeta();
        return this.isGeneral() && !(service.getDefinition() instanceof RouteDefinition) && !"http://www.mulesoft.org/schema/mule/core/error-handler".equals(service.getDefinition().getId());
    }

    private List<AttributeGroup> getGroupsToShow(Collection<AttributeGroup> toFilter) {
        ArrayList groupsToShow = Lists.newArrayList();
        for (AttributeGroup attributeGroup : toFilter) {
            Collection<AttributeHelper> filteredHelpers = this.filterEditor(attributeGroup);
            if (!this.hasMatchingElements(filteredHelpers)) continue;
            groupsToShow.add(attributeGroup);
        }
        return groupsToShow;
    }

    private boolean hasMatchingElements(Collection<AttributeHelper> filteredHelpers) {
        for (AttributeHelper helper : filteredHelpers) {
            if (!helper.isVisible() || !helper.matches(this.direction)) continue;
            return true;
        }
        return false;
    }

    private List<String> getUnchangeableAttributeNames(List<AttributeGroup> orderedFilteredGroups) {
        ArrayList unchangeableAttributesNames = Lists.newArrayList();
        for (AttributeGroup agroup : orderedFilteredGroups) {
            Collection<AttributeHelper> filteredHelpers = this.filterEditor(agroup);
            for (AttributeHelper atr : filteredHelpers) {
                if (atr.isVisible() || !atr.isUnchangeable()) continue;
                unchangeableAttributesNames.add(atr.getId());
            }
        }
        return unchangeableAttributesNames;
    }

    protected Composite createGroupComposite(AttributeGroup attributeGroup) {
        Composite group = null;
        if (StringUtils.isNotEmpty((String)attributeGroup.getId()) || StringUtils.isNotEmpty((String)attributeGroup.getCaption()) || StringUtils.isNotEmpty((String)attributeGroup.getMode())) {
            if (attributeGroup.isCollapsable()) {
                CollapsableGroup collapsableGroup = this.createCollapsableGroup(attributeGroup);
                group = collapsableGroup.getContent();
                this.collapsableGroups.put(collapsableGroup.getId(), collapsableGroup);
            } else {
                Group nonCollapsableGroup = new Group((Composite)this, 0);
                nonCollapsableGroup.setText(attributeGroup.getCaption());
                group = nonCollapsableGroup;
            }
            group.setLayout((Layout)AttributesPropertyPage.createGridLayoutForGroup(3, false));
            String description = attributeGroup.getDescription();
            if (description != null && description.length() > 0) {
                Label descriptionLabel = new Label(group, 64);
                descriptionLabel.setText(description);
                GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)descriptionLabel);
            }
        } else {
            group = new Composite((Composite)this, 0);
            GridLayoutFactory.swtDefaults().numColumns(3).margins(0, 0).spacing(9, 5).applyTo(group);
        }
        group.setLayoutData((Object)this.fillHorizontal());
        return group;
    }

    public static GridLayout createGridLayoutForGroup(int numcolumns, boolean equalWidth) {
        GridLayout groupLayout = new GridLayout(numcolumns, equalWidth);
        groupLayout.marginRight = 7;
        groupLayout.marginLeft = 7;
        groupLayout.horizontalSpacing = 9;
        return groupLayout;
    }

    private void increaseFirstRadioBooleansIndent(List<IFieldEditor> createdFieldEditors) {
        boolean previousIsRadioBoolean = false;
        for (IFieldEditor fieldEditor : createdFieldEditors) {
            boolean currentIsRadioBoolean = fieldEditor.getHelper() instanceof RadioBooleanAttributeHelper;
            if (currentIsRadioBoolean && !previousIsRadioBoolean) {
                GridData d = (GridData)fieldEditor.getControl().getLayoutData();
                d.verticalIndent = 10;
            }
            previousIsRadioBoolean = currentIsRadioBoolean;
        }
    }

    public List<IFieldEditor> createFieldEditors(AttributeGroup attributeGroup, String version, Composite parent) {
        ArrayList<IFieldEditor> localEditorsList = new ArrayList<IFieldEditor>();
        Collection<AttributeHelper> elements = this.filterEditor(attributeGroup);
        List<AttributeHelper> orderedHelpers = this.getOrderedCopyUsingAnchors(elements);
        Collection<AttributeHelper> filteredAndOrderedHelpers = this.getFilteredHelpers(orderedHelpers, version);
        HashMap groupsIns = Maps.newHashMap();
        FieldEditorFactory fieldEditorFactory = this.getFieldEditorFactory();
        AttributeReader.currentNameEditorsList.clear();
        for (AttributeHelper attributeHelper : filteredAndOrderedHelpers) {
            IFieldEditor fieldEditor = fieldEditorFactory.newEditor(this.resolveFieldEditorParent(parent, groupsIns, attributeHelper), attributeHelper, attributeGroup);
            if (fieldEditor == null) continue;
            localEditorsList.add(fieldEditor);
            fieldEditor.setParentPage(this);
        }
        return localEditorsList;
    }

    protected FieldEditorFactory getFieldEditorFactory() {
        return new FieldEditorFactory(this);
    }

    private SubGroup getSubGroupAndPutResolvedGroupIns(Composite gr, Map<String, SubGroup> groupsIns, AttributeHelper atr) {
        String[] pathArray = atr.getGroupIn().split("/");
        SubGroup sg = null;
        if (groupsIns.get(pathArray[0]) != null && pathArray.length > 1) {
            sg = groupsIns.get(pathArray[0]).getSubGroup(atr.getGroupIn());
            GridLayout subgroupLayout = new GridLayout(3, false);
            subgroupLayout.marginWidth = 10;
            subgroupLayout.marginTop = 0;
            subgroupLayout.marginBottom = 10;
            subgroupLayout.horizontalSpacing = 9;
            GridData subgroupLayoutData = this.fillHorizontal();
            subgroupLayoutData.horizontalSpan = 3;
        } else if (pathArray.length == 1) {
            SubGroup subGroup = groupsIns.get(pathArray[0]);
            if (subGroup == null) {
                sg = new SubGroup(pathArray[0], null, gr, 0, this.fillHorizontal());
                groupsIns.put(pathArray[0], sg);
                sg = sg.getSubGroup(atr.getGroupIn());
            } else {
                sg = subGroup;
            }
        } else {
            sg = new SubGroup(pathArray[0], null, gr, 0, this.fillHorizontal());
            groupsIns.put(pathArray[0], sg);
            sg = sg.getSubGroup(atr.getGroupIn());
        }
        if (atr.getGroupLabel() != null) {
            Label label = new Label((Composite)sg.getGroup(), 64);
            label.setText(atr.getGroupLabel());
            label.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        }
        return sg;
    }

    private CollapsableGroup createCollapsableGroup(AttributeGroup attributesGroup) {
        CollapsableGroup collapsableGroup = new CollapsableGroup((Composite)this, 16, attributesGroup.isCollapsed());
        collapsableGroup.setText(attributesGroup.getCaption());
        GridDataFactory.fillDefaults().applyTo((Control)collapsableGroup);
        collapsableGroup.addCollapseListener((ICollapseListener)new DisableChildsOnCollapseListener(this, collapsableGroup));
        return collapsableGroup;
    }

    private static void collectAllEditors(Collection<IFieldEditor> editors, Map<String, IFieldEditor> allEditors) {
        for (IFieldEditor editor : editors) {
            String id = editor.getHelper().getId();
            allEditors.put(id, editor);
            if (!(editor instanceof ICompositeEditor)) continue;
            ICompositeEditor composite = (ICompositeEditor)((Object)editor);
            List<IFieldEditor> children = composite.getChildren();
            AttributesPropertyPage.collectAllEditors(children, allEditors);
        }
    }

    public Map<String, IFieldEditor> getEditorsForPage() {
        HashMap<String, IFieldEditor> allEditors = new HashMap<String, IFieldEditor>();
        AttributesPropertyPage.collectAllEditors(this.editors.values(), allEditors);
        return allEditors;
    }

    public List<IFieldEditor> getResolvedEditors() {
        ArrayList<IFieldEditor> ret = new ArrayList<IFieldEditor>();
        AddToCollectionVisitor visitor = new AddToCollectionVisitor(ret);
        for (IFieldEditor editor : this.getEditorsForPage().values()) {
            editor.accept(visitor);
        }
        return ret;
    }

    public IFieldEditor getEditor(String editorId) {
        return this.editors.get(editorId);
    }

    protected String getVersion() {
        if (this.context != null && this.context.getProject() != null && this.context.getProject().getServerDefinition() != null) {
            return this.context.getProject().getServerDefinition().getVersionWithEESign();
        }
        return null;
    }

    protected Collection<AttributeHelper> filterEditor(AttributeGroup agroup) {
        Collection<AttributeHelper> elements = agroup.elements();
        ArrayList<AttributeHelper> hm = new ArrayList<AttributeHelper>();
        for (AttributeHelper m : elements) {
            if (this.isFiltered(m)) continue;
            hm.add(m);
        }
        return hm;
    }

    protected boolean isFiltered(AttributeHelper helper) {
        return false;
    }

    private GridData fillHorizontal() {
        return new GridData(4, 4, true, false);
    }

    public boolean insideLoad() {
        return this.insideLoad;
    }

    public void postInitLoadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        for (IFieldEditor editor : this.editors.values()) {
            if (editor.isDisposed() || editor instanceof IComponentModeEditor) continue;
            editor.postInitLoadFrom(node, props);
        }
    }

    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        try {
            AbstractComponentMeta service;
            NodeDefinition definition;
            this.loadInvisibleAttributes(props);
            this.insideLoad = true;
            this.node = node;
            this.map = props;
            if (node == null) {
                return;
            }
            this.removeDisplayNameIfNecessary(node);
            if (this.shouldShowDisplayName() && this.txtName != null && !this.txtName.isDisposed() && node != null && node.getName() != null) {
                this.txtName.setText(node.getName());
            }
            if ((definition = node.getDefinition()) != null && (service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class)) != null && service.hasPersistenceTransformer()) {
                service.getPersistenceTransformer().onLoad(node, props);
            }
            IFieldEditor modeEditor = null;
            for (IFieldEditor editor : this.editors.values()) {
                if (editor instanceof DummyFieldEditor) {
                    editor.loadFrom(node, props);
                }
                if (editor.isDisposed()) continue;
                if (!(editor instanceof IComponentModeEditor)) {
                    if (editor.getHelper().hasPersistenceTransformer()) {
                        editor.getHelper().transformBeforeLoad(node, props);
                    }
                    editor.loadFrom(node, props);
                    if (!editor.getHelper().hasAfterLoadCorrection()) continue;
                    editor.getHelper().transformAfterLoad(node, props);
                    continue;
                }
                modeEditor = (IComponentModeEditor)editor;
            }
            this.setSelectedRadioBoolean();
            if (modeEditor != null) {
                if (modeEditor.getHelper().hasPersistenceTransformer()) {
                    modeEditor.getHelper().transformBeforeLoad(node, props);
                }
                modeEditor.loadFrom(node, props);
            }
            this.manageCollapsableGroupsOnLoad();
        }
        finally {
            this.inited = true;
            this.insideLoad = false;
            this.validate();
        }
        int msize = this.computeLabelSize();
        this.updateLabelSize(msize);
    }

    protected void setSelectedRadioBoolean() {
        HashMap radioBooleanIdToControlled = new HashMap();
        boolean allRadioBooleansAreFalse = true;
        List<IFieldEditor> resolvedEditors = this.getResolvedEditors();
        BooleanFieldEditor defaultRadioBoolean = null;
        for (IFieldEditor editor : resolvedEditors) {
            if (!(editor instanceof RadioBooleanEditor)) continue;
            RadioBooleanEditor radioBooleanEditor = (RadioBooleanEditor)editor;
            if (Boolean.parseBoolean(radioBooleanEditor.getValue())) {
                allRadioBooleansAreFalse = false;
                break;
            }
            AttributeHelper helper = editor.getHelper();
            String id = helper.getId();
            radioBooleanIdToControlled.put(id, new ArrayList());
            Object defaultValue = helper.getDefaultValue();
            if (!(defaultValue instanceof Boolean) || !((Boolean)defaultValue).booleanValue()) continue;
            defaultRadioBoolean = radioBooleanEditor;
        }
        if (allRadioBooleansAreFalse && !radioBooleanIdToControlled.isEmpty()) {
            for (IFieldEditor editor : resolvedEditors) {
                String controller = editor.getHelper().getRequiredPropertyId();
                if (controller == null || !radioBooleanIdToControlled.containsKey(controller)) continue;
                ((List)radioBooleanIdToControlled.get(controller)).add(editor);
            }
            int notEmptyGroups = 0;
            String radioBooleanToSelect = null;
            for (String radioBooleanId : radioBooleanIdToControlled.keySet()) {
                List controlledEditors = (List)radioBooleanIdToControlled.get(radioBooleanId);
                if (controlledEditors.isEmpty()) continue;
                boolean selectCurrentRadioBoolean = false;
                for (IFieldEditor controlledEditor : controlledEditors) {
                    String defaultValue;
                    if (!(controlledEditor instanceof AbstractFieldEditor)) continue;
                    AbstractFieldEditor castedEditor = (AbstractFieldEditor)controlledEditor;
                    String value = castedEditor.getValue();
                    String string = defaultValue = castedEditor.getHelper().getDefaultValue() != null ? castedEditor.getHelper().getDefaultValue().toString() : null;
                    if (!StringUtils.isNotBlank((String)value) || value.equals(defaultValue)) continue;
                    selectCurrentRadioBoolean = true;
                    ++notEmptyGroups;
                    break;
                }
                if (!selectCurrentRadioBoolean) continue;
                radioBooleanToSelect = radioBooleanId;
            }
            if (radioBooleanToSelect != null) {
                RadioBooleanEditor radioBooleanEditorToSelect = this.getRadioBooleanToSelect(radioBooleanToSelect, resolvedEditors);
                if (radioBooleanEditorToSelect != null) {
                    radioBooleanEditorToSelect.setValue("true");
                    radioBooleanEditorToSelect.sendValue();
                }
            } else if (notEmptyGroups == 0 && defaultRadioBoolean != null) {
                defaultRadioBoolean.setValue("true");
                defaultRadioBoolean.sendValue();
            }
        }
    }

    private RadioBooleanEditor getRadioBooleanToSelect(String radioBooleanToSelectId, List<IFieldEditor> allEditors) {
        RadioBooleanEditor radioBooleanEditorToSelect = (RadioBooleanEditor)this.editors.get(radioBooleanToSelectId);
        if (radioBooleanEditorToSelect == null) {
            for (IFieldEditor editor : allEditors) {
                if (!radioBooleanToSelectId.equals(editor.getHelper().getId())) continue;
                radioBooleanEditorToSelect = (RadioBooleanEditor)editor;
                break;
            }
        }
        return radioBooleanEditorToSelect;
    }

    private void manageCollapsableGroupsOnLoad() {
        for (IFieldEditor editor : this.editors.values()) {
            CollapsableGroup associatedGroup = this.getAssociatedCollapsableGroup(editor);
            if (associatedGroup == null || !associatedGroup.isCollapsed()) continue;
            if (editor instanceof AbstractFieldEditor) {
                if (this.isDefaultValue((AbstractFieldEditor)editor)) continue;
                associatedGroup.toogle();
                continue;
            }
            if (!(editor instanceof ChildElementFieldEditor)) continue;
            Map<String, AttributesPropertyPage> innerPages = ((ChildElementFieldEditor)editor).getAttributePages();
            for (AttributesPropertyPage page : innerPages.values()) {
                Collection<IFieldEditor> innerEditors = page.getEditors().values();
                for (IFieldEditor innerEditor : innerEditors) {
                    if (!(innerEditor instanceof AbstractFieldEditor) || this.isDefaultValue((AbstractFieldEditor)innerEditor)) continue;
                    associatedGroup.toogle();
                }
            }
        }
    }

    public boolean isDefaultValue(AbstractFieldEditor innerEditor) {
        Object defaultValue = innerEditor.getHelper().getDefaultValue();
        String value = innerEditor.getValue();
        if (defaultValue == null || StringUtils.isBlank((String)defaultValue.toString())) {
            return StringUtils.isBlank((String)value);
        }
        return StringUtils.isNotBlank((String)value) && value.trim().equals(defaultValue.toString().trim());
    }

    protected void removeDisplayNameIfNecessary(IMessageFlowNode node) {
        String type = node.getType();
        if (type != null) {
            NodeDefinition definition = node.getDefinition();
            if (definition == null) {
                definition = MuleCorePlugin.getModuleManager().getGlobalDefinition(type);
            }
            if (definition != null && !definition.isUseDocNameAsDisplayName() && this.displayNameGroup != null) {
                UiUtils.disposeComposite((Composite)this.displayNameGroup);
            }
        }
    }

    private void loadInvisibleAttributes(PropertyCollectionMap props) {
        for (String name : this.unchangeableAttributesNames) {
            String value = props.getProperty(name, null);
            if (value == null || value.length() <= 0) continue;
            this.unchangeableAttributesValues.add(PropertiesUtils.create((String)name, (String)value));
        }
    }

    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        AbstractComponentMeta service;
        if (this.shouldShowDisplayName() && this.txtName != null && !this.txtName.isDisposed()) {
            node.setName(this.txtName.getText());
        }
        NodeDefinition definition = node.getDefinition();
        this.saveInvisibleAttributes(props);
        for (IFieldEditor m : this.editors.values()) {
            if (m.getHelper().hasPersistenceTransformer()) {
                m.getHelper().transformBeforeSave(node, props);
            }
            m.saveTo(node, props);
            if (!m.getHelper().hasAfterSaveCorrection()) continue;
            m.getHelper().transformAfterSave(node, props);
        }
        if (node instanceof EndpointNode && props.getProperty("exchange-pattern", null) == null) {
            try {
                EndpointDefinition endpointDefinition = (EndpointDefinition)definition;
                String defaultMep = endpointDefinition.getDefaultMep();
                if (defaultMep.equals("RequestResponse")) {
                    props.addProperty("exchange-pattern", "request-response");
                } else {
                    props.addProperty("exchange-pattern", "one-way");
                }
            }
            catch (RuntimeException runtimeException) {}
        }
        if (definition != null && (service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class)) != null && service.hasPersistenceTransformer()) {
            service.getPersistenceTransformer().onSave(node, props);
        }
    }

    private void saveInvisibleAttributes(PropertyCollectionMap props) {
        for (Property property : this.unchangeableAttributesValues) {
            props.addProperty(property.getName(), property.getValue());
        }
    }

    public void rollback() {
        if (this.isDisposed()) {
            return;
        }
        for (IFieldEditor m : this.editors.values()) {
            if (!(m instanceof ICanBeCancelled)) continue;
            ((ICanBeCancelled)m).rollback();
        }
    }

    public void updateFromAttrs(final Map<String, AttributeCategory> attributeCategoryMap) {
        if (this.isDisposed()) {
            return;
        }
        if (this.getParent().isVisible()) {
            this.getParent().setRedraw(false);
            this.getParent().setLayoutDeferred(true);
        }
        try {
            IHost currentHost = this.getHost();
            if (currentHost != null) {
                HashSet<String> pagesToUpdate = new HashSet<String>(attributeCategoryMap.keySet());
                Set<String> keySet = attributeCategoryMap.keySet();
                if (keySet.isEmpty()) {
                    MessageBox messageBox = new MessageBox(this.getParent().getShell(), 8);
                    messageBox.setText("Warning");
                    messageBox.setMessage("Inner error: the mode must have at least one page and be a heritor of \"" + currentHost.getNode().getType() + "\".");
                    messageBox.open();
                }
                if (!keySet.isEmpty()) {
                    AttributesPropertyPage page;
                    currentHost.retainFrom(keySet);
                    for (final String s : currentHost.getNotExitingPages(keySet)) {
                        pagesToUpdate.remove(s);
                        Composite parentControl = currentHost.createBlankControl();
                        AttributesPropertyPage ps = new AttributesPropertyPage(this.context.getProject(), parentControl, new AttributeCategoryProvider(){

                            @Override
                            public AttributeCategory getAttributeCategory(AttributesPropertyPage page) {
                                return (AttributeCategory)attributeCategoryMap.get(s);
                            }
                        });
                        currentHost.addPage(s, (MessageFlowNodeComposite)ps);
                    }
                    for (final String s : pagesToUpdate) {
                        page = (AttributesPropertyPage)currentHost.getPage(s);
                        AttributeCategory attributes = attributeCategoryMap.get(s);
                        if (attributes.getCaption() == null) {
                            attributes.setCaption(s);
                        }
                        page.updatePage(attributes);
                    }
                    for (final String s : pagesToUpdate) {
                        page = (AttributesPropertyPage)currentHost.getPage(s);
                        page.sendValues();
                    }
                }
            }
        }
        finally {
            this.getParent().setLayoutDeferred(false);
            this.redrawComposite();
        }
    }

    private void redrawComposite() {
        if (!this.isDisposed()) {
            Composite parent = this.getParent();
            if (parent instanceof ScrolledComposite) {
                ScrolledComposite cm = (ScrolledComposite)parent;
                Point computeSize = this.computeSize(-1, -1);
                cm.setMinSize(computeSize.x, computeSize.y);
            }
            this.getParent().layout(true, true);
            this.getParent().setRedraw(true);
        }
    }

    public void updateInParentFromAttrs(Composite parent, Map<String, AttributeCategory> attributeCategoryMap) {
        try {
            IHost currentHost = this.getHost();
            if (currentHost != null) {
                HashSet<String> pagesToUpdate = new HashSet<String>(attributeCategoryMap.keySet());
                Set<String> keySet = attributeCategoryMap.keySet();
                if (!keySet.isEmpty()) {
                    currentHost.retainFrom(keySet);
                    for (String s : pagesToUpdate) {
                        AttributeCategory attributes = attributeCategoryMap.get(s);
                        if (attributes.getCaption() == null) {
                            attributes.setCaption(s);
                        }
                        this.updatePage(attributes);
                    }
                    for (String s : pagesToUpdate) {
                        AttributesPropertyPage page = (AttributesPropertyPage)currentHost.getPage(s);
                        page.sendValues();
                    }
                }
            }
        }
        finally {
            this.getParent().setLayoutDeferred(false);
        }
    }

    public void validate() {
        if (this.insideLoad) {
            return;
        }
        if (this.getHost() == null && this.simpleHost == null) {
            return;
        }
        IHost host = this.getHost() != null ? this.getHost() : this.simpleHost;
        List<Message> errors = this.errorCollector.getErrorsFrom((ISimpleHost)host);
        host.setMessages(errors);
    }

    private CollapsableGroup getAssociatedCollapsableGroup(IFieldEditor fieldEditor) {
        for (CollapsableGroup group : this.collapsableGroups.values()) {
            if (!fieldEditor.getControl().getParent().equals(group.getContent())) continue;
            return group;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabledRec((Composite)this, enabled);
    }

    private void setEnabledRec(Composite attributesPropertyPage, boolean enabled) {
        if (attributesPropertyPage != this) {
            attributesPropertyPage.setEnabled(enabled);
        }
        Control[] controlArray = attributesPropertyPage.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.setEnabled(enabled);
                if (c instanceof Composite) {
                    this.setEnabledRec((Composite)c, enabled);
                }
            }
            ++n2;
        }
        for (IFieldEditor f : this.editors.values()) {
            f.setEnabled(enabled);
        }
    }

    public boolean isChildPage() {
        return this.isChildPage;
    }

    public boolean compliesVersion(String version) {
        return this.getAttributeCategory().matches(version) && (version.endsWith(";") || !this.getAttributeCategory().isEEOnly());
    }

    public String getName() {
        return this.getAttributeCategory().getCaption();
    }

    public ArrayList<AttributesPropertyPage> getAllOpenPages() {
        Composite parent2 = this.getParent().getParent();
        Control[] children = parent2.getChildren();
        ArrayList<AttributesPropertyPage> pages = new ArrayList<AttributesPropertyPage>();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Composite _control;
            Control[] children2;
            Control control = controlArray[n2];
            if (control instanceof Composite && (children2 = (_control = (Composite)control).getChildren()).length != 0 && children2[0] instanceof AttributesPropertyPage) {
                pages.add((AttributesPropertyPage)children2[0]);
            }
            ++n2;
        }
        return pages;
    }

    public String getGlobalElementName(IMessageFlowNode node) {
        IFieldEditor iFieldEditor = this.getEditors().get(MetadataUtils.getGlobalReferenceAttributeName((IMessageFlowNode)node));
        String elementName = null;
        if (iFieldEditor != null) {
            elementName = ((GlobalRefEditor)iFieldEditor).getValue();
        }
        return elementName;
    }

    public Text getTxtName() {
        return this.txtName;
    }

    protected void setTxtName(Text txtName) {
        this.txtName = txtName;
    }

    public Group getDisplayNameGroup() {
        return this.displayNameGroup;
    }

    protected void setDisplayNameGroup(Group displayNameGroup) {
        this.displayNameGroup = displayNameGroup;
    }

    public AttributeCategory getAttributeCategory() {
        return this.attrCategoryProvider.getAttributeCategory(this);
    }

    @Override
    public IMessageFlowNode getMessageFlowNode() {
        return this.node;
    }

    @Override
    public void setMessageFlowNode(IMessageFlowNode node) {
        this.node = node;
        for (Map.Entry<String, IFieldEditor> entry : this.editors.entrySet()) {
            IFieldEditor editor = entry.getValue();
            if (!(editor instanceof IMessageFlowNodeAware)) continue;
            ((IMessageFlowNodeAware)((Object)editor)).setMessageFlowNode(node);
        }
    }

    private Composite resolveFieldEditorParent(Composite parent, Map<String, SubGroup> groupsIns, AttributeHelper attributeHelper) {
        return attributeHelper.getGroupIn() == null ? parent : this.getSubGroupAndPutResolvedGroupIns(parent, groupsIns, attributeHelper).getGroup();
    }

    public static class AddToCollectionVisitor
    extends FieldEditorVisitorAdapter {
        private final Collection<IFieldEditor> collection;

        public AddToCollectionVisitor(Collection<IFieldEditor> collection) {
            this.collection = collection;
        }

        @Override
        public void defaultAction(IFieldEditor fieldEditor) {
            this.collection.add(fieldEditor);
        }

        @Override
        public void visit(HContainer hContainer) {
            this.collection.addAll(hContainer.getChildren());
        }

        @Override
        public void visit(SwitchCaseEditor switchCaseEditor) {
            this.collection.addAll(switchCaseEditor.getChildren());
        }

        @Override
        public void visit(MultiWayEditor editor) {
            this.collection.addAll(editor.getChildren());
        }

        @Override
        public void visit(ChildElementFieldEditor childElementFieldEditor) {
            Collection<AttributesPropertyPage> pages = childElementFieldEditor.getAttributePages().values();
            for (AttributesPropertyPage page : pages) {
                this.collection.addAll(page.getEditorsForPage().values());
            }
        }
    }
}

