/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeCompletionProvider;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeHyperlinkProvider;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeValidator;
import com.onpositive.ide.ui.IHasImage;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.ui.modules.core.dstructure.IStructureProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IContentProposalProviderFactory;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.IValidatorWithSeverity;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DynamicElementModel;
import org.mule.tooling.ui.modules.core.widgets.meta.DynamicStructureHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;

public class AttributeModelWithHelper
implements AttributeModel,
IStructureProvider {
    private final AttributeHelper helper;
    private final AttributeContext context;

    public AttributeModelWithHelper(AttributeHelper helper, AttributeContext context) {
        this.helper = helper;
        this.context = context;
    }

    public boolean isRequired() {
        return this.helper.isRequired();
    }

    public boolean isAcceptsEmptyValue() {
        return this.helper.isAcceptsEmptyValue();
    }

    public String getTypeSpecialization() {
        return this.helper.getClass().toString();
    }

    public String getType() {
        return this.helper.getType().toString();
    }

    public String getName() {
        String saveAs = this.helper.getSaveAs();
        if (StringUtils.isNotBlank((String)saveAs)) {
            return saveAs;
        }
        return this.helper.getId();
    }

    public ITypeValidator getValidator() {
        final IValidator validator = this.helper.getValidator();
        if (validator != null) {
            return new ITypeValidator(){

                public String validate(IProject project, String value, DomainEditingModelObject element, String typeSpecialization, String atrName) {
                    if (validator instanceof ITypeValidator) {
                        ITypeValidator tv = (ITypeValidator)validator;
                        return tv.validate(project, value, element, typeSpecialization, atrName);
                    }
                    return validator.validate(value, AttributeModelWithHelper.this.context, AttributeModelWithHelper.this.helper);
                }

                public int getSeverity() {
                    if (validator instanceof IValidatorWithSeverity) {
                        IValidatorWithSeverity sv = (IValidatorWithSeverity)((Object)validator);
                        return sv.getSeverity();
                    }
                    return 4;
                }
            };
        }
        return null;
    }

    public String getDescription() {
        return this.helper.getDescription();
    }

    public Image getIcon() {
        Image image = this.helper.getImage();
        if (image != null) {
            return image;
        }
        return AttributeReader.stringAtr;
    }

    public ITypeCompletionProvider getCompletionProvider(String type) {
        final IContentProposalProviderFactory proposalProvider = this.helper.getProposalProvider();
        if (proposalProvider != null) {
            return new ITypeCompletionProvider(){

                public void fillProposals(String attributeName, DomainEditingModelObject findElement, ITextViewer viewer, int offset, String startString, int lengthCompletion, ArrayList<ICompletionProposal> result, String fullString, boolean addBraces, String typeSpecialization) {
                    IContentProposal[] proposals;
                    IContentProposalProvider contentProposalProvider = proposalProvider.getContentProposalProvider(AttributeModelWithHelper.this.context);
                    IContentProposal[] iContentProposalArray = proposals = contentProposalProvider.getProposals(startString, startString.length());
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContentProposal p = iContentProposalArray[n2];
                        Image image = null;
                        if (p instanceof IHasImage) {
                            IHasImage im = (IHasImage)p;
                            image = im.getImage();
                        }
                        boolean b = proposalProvider.getProposalAcceptanceStyle() == 2;
                        CompletionProposal ps = new CompletionProposal(p.getContent(), b ? offset - startString.length() : offset, b ? startString.length() : 0, p.getContent().length(), image, p.getLabel(), null, p.getDescription());
                        result.add((ICompletionProposal)ps);
                        ++n2;
                    }
                }
            };
        }
        return null;
    }

    public ITypeHyperlinkProvider getHyperlinkProvider() {
        return this.helper.getHyperLinkProvider();
    }

    public boolean isAppearsAsRequired() {
        return this.helper.isAppearsAsRequired();
    }

    public int priority() {
        return this.helper.getPriority();
    }

    public AttributeHelper getAttributeHelper() {
        return this.helper;
    }

    public AttributeContext getContext() {
        return this.context;
    }

    public boolean isComplex() {
        return this.helper instanceof DynamicStructureHelper;
    }

    @Override
    public ElementModel getModel(AttributeContext ctx, ElementModel definition, DomainEditingModelObject parent) {
        DynamicStructureHelper hl = (DynamicStructureHelper)this.helper;
        IStructureProvider structureProvider = hl.getStructureProvider();
        if (structureProvider != null) {
            return structureProvider.getModel(ctx, definition, parent);
        }
        return null;
    }

    public ElementModel asElement(ElementModel parent) {
        DynamicElementModel dynamicElementModel = new DynamicElementModel();
        String name2 = this.getName();
        int indexOf = name2.indexOf(58);
        if (indexOf > 0) {
            dynamicElementModel.setPrefix(name2.substring(0, indexOf));
            dynamicElementModel.setShortName(name2.substring(indexOf + 1));
        } else {
            dynamicElementModel.setShortName(name2);
        }
        dynamicElementModel.setUrl(parent.getUrl());
        return dynamicElementModel;
    }

    public boolean onlyInInbound() {
        return this.helper.isShowOnlyInInbound();
    }

    public boolean onlyInOutbound() {
        return this.helper.isShowOnlyInOutbound();
    }

    public String toString() {
        return "AttributeModelWithHelper [h=" + String.valueOf(this.helper) + "]";
    }
}

