/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.builder.MuleValidationResult;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.ILocalSchemaLookup;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.modules.core.validation.AbstractMuleValidator;
import org.mule.tooling.utils.Pair;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class MuleXMLValidator
extends AbstractMuleValidator {
    public static final String VALIDATOR_ID = "org.mule.tooling.ui.modules.core.validation.muleXmlValidator";

    public String getValidatorId() {
        return VALIDATOR_ID;
    }

    public void cleanup(IReporter arg0) {
    }

    public MuleValidationResult validate(IFile xmlConfigFile, MuleConfiguration config) throws CoreException, IOException {
        ArrayList<IMuleError> errors;
        block22: {
            IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("no_parsing_xml")) {
                return MuleValidationResult.EMPTY_RESULT;
            }
            IProject project = xmlConfigFile.getProject();
            errors = new ArrayList<IMuleError>();
            SAXParserFactory factory = XmlFactoryUtils.createSecureSAXParserFactory();
            factory.setNamespaceAware(true);
            factory.setValidating(!preferenceStore.getBoolean("no_validation_xsd_xml"));
            try {
                if (!this.isDocumentSet()) break block22;
                byte[] contentBytes = this.document.get().getBytes();
                Throwable throwable = null;
                Object var10_12 = null;
                try (ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contentBytes);){
                    XMLReader reader = factory.newSAXParser().getXMLReader();
                    reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    reader.setEntityResolver(new LocalSchemaEntityResolver(project));
                    reader.setErrorHandler(new XMLValidatorErrorHandler(xmlConfigFile, errors, contentInputStream, this.getValidatorId()));
                    contentInputStream.reset();
                    Throwable throwable2 = null;
                    Object var13_18 = null;
                    try (InputStreamReader input = new InputStreamReader(contentInputStream);){
                        reader.parse(new InputSource(input));
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                MuleCorePlugin.logError((String)"Error while validating", (Throwable)e);
            }
        }
        return MuleValidationResult.withErrors(errors);
    }

    private static class LocalSchemaEntityResolver
    implements EntityResolver {
        private final IProject project;

        private LocalSchemaEntityResolver(IProject project) {
            this.project = project;
        }

        @Override
        public InputSource resolveEntity(String schema, String schemaLocation) throws SAXException, IOException {
            String schemaUrl;
            ISchemaLocationLookup schemaLocationlookup;
            IMuleProject muleProject = MuleRuntime.create((IProject)this.project);
            if (muleProject != null && (schemaLocationlookup = muleProject.getSchemaLocationLookup()) instanceof ILocalSchemaLookup && (schemaUrl = ((ILocalSchemaLookup)schemaLocationlookup).getSchemaUrl(null, schema, schemaLocation)) != null) {
                URL reslovedUrl = new URL(schemaUrl);
                return new InputSource(reslovedUrl.openStream());
            }
            return null;
        }
    }

    private static class XMLValidatorErrorHandler
    implements ErrorHandler {
        private final List<IMuleError> errors;
        private IFile resource;
        private List<String> lines;
        private String validatorId;

        private XMLValidatorErrorHandler(IFile resource, List<IMuleError> errors, InputStream contentsStream, String validatorId) {
            this.resource = resource;
            this.errors = errors;
            this.validatorId = validatorId;
            this.lines = IOUtils.readLines((InputStream)contentsStream);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addError(exception, 1);
        }

        protected void addError(SAXParseException exception, int severity) {
            String localizedMessage = exception.getLocalizedMessage();
            int offset = (Integer)this.getOffset(exception).getLeft();
            int length = (Integer)this.getOffset(exception).getRight();
            LocalizedMessage message = new LocalizedMessage(1, localizedMessage);
            message.setOffset(offset);
            message.setLength(length);
            message.setLineNo(exception.getLineNumber());
            IMuleError editorError = MuleErrorFactory.createXMLMuleErrorVisibleInProblemsPane((IResource)this.resource, (String)localizedMessage, (String)localizedMessage, (IMessage)message, (int)severity, (String)this.validatorId);
            this.errors.add(editorError);
        }

        private Pair<Integer, Integer> getOffset(SAXParseException exception) {
            int offset = 0;
            int lineNumber = 0;
            while (lineNumber < this.lines.size() - 1 && lineNumber < exception.getLineNumber() - 1) {
                offset = offset + this.lines.get(lineNumber).length() + 1;
                ++lineNumber;
            }
            String lineXML = this.lines.get(lineNumber);
            int length = 0;
            int characterIndex = 0;
            while (characterIndex < lineXML.length()) {
                if (StringUtils.isWhitespace((String)String.valueOf(lineXML.charAt(characterIndex)))) {
                    ++offset;
                } else {
                    length = lineXML.length() - characterIndex;
                    break;
                }
                ++characterIndex;
            }
            return new Pair((Object)offset, (Object)length);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(exception, 2);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addError(exception, 2);
        }
    }
}

