/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.validation;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.AttributeModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainValidatorVisitor;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ElementModel;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ISelfProvidingElement;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ITypeValidator;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.ModelVisitor;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalHelper;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.validation.MarkupValidator;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.builder.MuleValidationResult;
import org.mule.tooling.core.dom.location.IAbsoluteLocation;
import org.mule.tooling.core.dom.location.IElementLocation;
import org.mule.tooling.core.dom.location.ILineLocation;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ValidationUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.modules.core.dstructure.IStructureProvider;
import org.mule.tooling.ui.modules.core.validation.AbstractMuleValidator;
import org.mule.tooling.ui.modules.core.validation.HttpRequirementsValidator;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.DefinitionElement;
import org.mule.tooling.ui.modules.core.widgets.FlowMuleElement;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.RootMuleElement;
import org.mule.tooling.ui.modules.core.widgets.SpringMuleElement;
import org.mule.tooling.ui.modules.core.widgets.TextElementModel;
import org.mule.tooling.ui.modules.core.widgets.expressions.MuleExpressionValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.utils.collection.ListView;

public class MuleConfigurationValidator
extends AbstractMuleValidator {
    private static final String ERROR_DELEGATE_SECURITY_PROVIDERS_IS_NOT_ALLOWED = "Element: delegate-security-provider is not allowed to be child of element Spring Security manager";
    private static final String DEFINITION_ID_GLOBAL_SUFFIX = "-global";
    public static final String VALIDATOR_ID = "org.mule.tooling.ui.modules.core.validation.muleConfigurationValidator";
    private ThreadLocal<AttributeContext> attributeContext = new ThreadLocal();

    public String getValidatorId() {
        return VALIDATOR_ID;
    }

    public void cleanup(IReporter reporter) {
    }

    @Override
    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        super.validate(helper, reporter);
    }

    public MuleValidationResult validate(IFile xmlConfigFile, MuleConfiguration muleConfig) throws CoreException, UnsupportedEncodingException, IOException {
        IProject project = xmlConfigFile.getProject();
        if (!this.checkPreConditions(xmlConfigFile, project, xmlConfigFile)) {
            return MuleValidationResult.EMPTY_RESULT;
        }
        try {
            this.attributeContext.set(new AttributeContext(MuleRuntime.create((IProject)project), muleConfig, xmlConfigFile));
            HashMap<Integer, IMessageFlowEntity> numberMap = this.enumerateMessageFlowEntities(muleConfig);
            List<IMessage> messages = this.collectErrorMessages(project, xmlConfigFile);
            MuleConfigurationValidator.removeMessagesWithLowerPriority(messages);
            this.removeErrorsSpringSecurityManager(messages);
            IMuleError[] result = MuleConfigurationValidator.formErrorsList(numberMap, muleConfig, messages, xmlConfigFile, this.getValidatorId());
            MuleValidationResult muleValidationResult = MuleValidationResult.withErrors((IMuleError[])result);
            return muleValidationResult;
        }
        finally {
            this.attributeContext.remove();
        }
    }

    private boolean checkPreConditions(IFile flowFile, IProject project, IFile xmlConfigFile) throws CoreException {
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("no_validation_xml")) {
            return false;
        }
        if (!xmlConfigFile.exists()) {
            return false;
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature") || !project.hasNature("org.mule.tooling.core.muleStudioNature")) {
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath outputLocation = javaProject.getOutputLocation();
        return !outputLocation.isPrefixOf(flowFile.getFullPath());
    }

    private List<IMessage> collectErrorMessages(IProject project, IFile resource) {
        IRegion dirtyRegion = null;
        IncrementalHelper helper = new IncrementalHelper(this.document, project);
        ReporterHelper reporter = new ReporterHelper((IProgressMonitor)new NullProgressMonitor());
        this.doValidate(dirtyRegion, (IValidationContext)helper, (IReporter)reporter, project);
        List<IMessage> xmlMessages = this.getXmlErrorMessages(resource);
        return ListView.of((List)reporter.getMessages(), xmlMessages);
    }

    private List<IMessage> getXmlErrorMessages(IFile resource) {
        NullProgressMonitor markupMonitor = new NullProgressMonitor();
        ValidationResult validationResult = new MarkupValidator().validate((IResource)resource, 0, null, (IProgressMonitor)markupMonitor);
        List messages = validationResult.getReporter((IProgressMonitor)markupMonitor).getMessages();
        return messages.stream().map(message -> new SeverityMessageDecorator((IMessage)message, 1)).collect(Collectors.toList());
    }

    private void doValidate(IRegion dirtyRegion, IValidationContext context, IReporter reporter, IProject prj) {
        if (this.document != null) {
            DomainEditingModel domainEditingModel = new DomainEditingModel(this.document, true);
            domainEditingModel.load((InputStream)new ByteArrayInputStream(this.document.get().getBytes(StandardCharsets.UTF_8)), true);
            XMLProblemReporter iProblemReporter = new XMLProblemReporter(reporter, this, this.document);
            XMLDomainValidatorVisitor validator = new XMLDomainValidatorVisitor(iProblemReporter, prj, iProblemReporter);
            if (domainEditingModel.getRoot() != null) {
                domainEditingModel.getRoot().traverse((ModelVisitor)validator);
            }
        }
    }

    public static ElementModel resolve(String namespace, String localName, AttributeContext ctx, boolean isGlobal, ElementModel parent, DomainEditingModelObject parentNode) {
        return MuleConfigurationValidator.innerResolve(namespace, localName, ctx, isGlobal, parent, parentNode);
    }

    private static ElementModel innerResolve(String namespace, String localName, AttributeContext ctx, boolean isGlobal, ElementModel parent, DomainEditingModelObject parentNode) {
        Collection nested;
        if (namespace == null) {
            return null;
        }
        if (namespace.equals("http://www.mulesoft.org/schema/mule/ee/domain") && localName.equals("mule-domain") || localName.equals("mule") && namespace.equals("http://www.mulesoft.org/schema/mule/core")) {
            return new RootMuleElement();
        }
        if ((localName.equals("flow") || localName.equals("sub-flow")) && namespace.equals("http://www.mulesoft.org/schema/mule/core")) {
            return new FlowMuleElement(localName.equals("sub-flow"), ctx);
        }
        if (namespace.equals("http://www.springframework.org/schema/beans") && localName.equals("bean")) {
            GlobalDefinition def = MuleCorePlugin.getModuleManager().getGlobalDefinition("http://www.springframework.org/schema/beans/bean");
            SpringMuleElement springMuleElement = new SpringMuleElement();
            springMuleElement.setDef((NodeDefinition)def, ctx);
            return springMuleElement;
        }
        if (namespace.equals("http://www.springframework.org/schema/beans") && localName.equals("import")) {
            GlobalDefinition def = MuleCorePlugin.getModuleManager().getGlobalDefinition("http://www.springframework.org/schema/beans/import");
            SpringMuleElement springMuleElement = new SpringMuleElement();
            springMuleElement.setDef((NodeDefinition)def, ctx);
            return springMuleElement;
        }
        QName qName = new QName(namespace, localName);
        NodeDefinition nodeDefinition = null;
        if (parent instanceof RootMuleElement) {
            NodeDefinition potentialGlobal;
            NodeDefinition definition = MuleCorePlugin.getModuleManager().getDefinition(namespace + "/" + localName, false);
            NodeDefinition nodeDefinition2 = potentialGlobal = isGlobal ? MuleCorePlugin.getModuleManager().getDefinition(namespace + "/" + localName + DEFINITION_ID_GLOBAL_SUFFIX, false) : null;
            if (isGlobal && potentialGlobal != null) {
                return new DefinitionElement(potentialGlobal, qName, ctx);
            }
            if (definition != null) {
                return new DefinitionElement(definition, qName, ctx);
            }
        }
        if (parent instanceof DefinitionElement) {
            DefinitionElement parentDefElement = (DefinitionElement)parent;
            if (!(parentDefElement.def instanceof GlobalDefinition)) {
                TextElementModel attribute = MuleConfigurationValidator.findAttributeOfDefinition(localName, parentNode, qName, parentDefElement);
                if (attribute != null) {
                    return attribute;
                }
                Iterator r = MuleConfigurationValidator.findNestedWithQName(ctx, parent, qName);
                NodeDefinition definition = MuleCorePlugin.getModuleManager().getDefinition(namespace + "/" + localName, false);
                if (r != null && definition == null) {
                    return r;
                }
                if (definition != null) {
                    return new DefinitionElement(definition, qName, ctx);
                }
            }
        }
        if (isGlobal) {
            ArrayList definitionsArray;
            nodeDefinition = (NodeDefinition)MuleCorePlugin.getModuleManager().getGlobalQNameMappings(ctx.getVersion()).get(qName);
            if (nodeDefinition == null && (definitionsArray = (ArrayList)MuleCorePlugin.getModuleManager().getQNameMappings(ctx.getVersion()).get(qName)) != null && definitionsArray.size() == 1) {
                nodeDefinition = (NodeDefinition)definitionsArray.get(0);
            }
        } else {
            NestedDefinition nestedDefinition;
            NodeDefinition nodeDefinition3 = nodeDefinition = ctx != null ? MuleConfigurationValidator.getDef(qName, ctx.getVersion(), isGlobal) : null;
            if (nodeDefinition == null && parent != null) {
                nested = MuleCorePlugin.getModuleManager().getNested();
                for (NestedDefinition d : nested) {
                    Object definitionElement;
                    if (!d.matches(qName) || !parent.isAllowedChild((ElementModel)(definitionElement = new DefinitionElement((NodeDefinition)d, qName, ctx)))) continue;
                    return definitionElement;
                }
            }
            if ((nestedDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(namespace + "/" + localName)) != null) {
                return new DefinitionElement((NodeDefinition)nestedDefinition, qName, ctx);
            }
            if (nodeDefinition == null && ctx != null) {
                nodeDefinition = (NodeDefinition)MuleCorePlugin.getModuleManager().getGlobalQNameMappings(ctx.getVersion()).get(qName);
            }
        }
        if (nodeDefinition != null) {
            List copy = nodeDefinition.getAlternativeIdsCopy();
            if (copy != null && !copy.isEmpty()) {
                for (NestedDefinition d : copy) {
                    if (!d.matches(qName)) continue;
                    return new DefinitionElement((NodeDefinition)d, qName, ctx);
                }
            }
            return new DefinitionElement(nodeDefinition, qName, ctx);
        }
        nested = MuleCorePlugin.getModuleManager().getNested();
        DefinitionElement associatedDefinition = null;
        for (NestedDefinition d : nested) {
            if (!d.matches(qName)) continue;
            DefinitionElement definitionElement = new DefinitionElement((NodeDefinition)d, qName, ctx);
            if (parent != null && parent.isAllowedChild((ElementModel)definitionElement)) {
                return definitionElement;
            }
            associatedDefinition = definitionElement;
        }
        if (parent != null) {
            HashSet allProperties = parent.getAllProperties();
            if (allProperties != null) {
                for (AttributeModel m : allProperties) {
                    ElementModel model;
                    String name = m.getName();
                    int indexOf = name.indexOf(58);
                    if (indexOf > 0) {
                        name = name.substring(indexOf + 1);
                    }
                    if (!m.isComplex() || !name.equals(localName) || (model = ((IStructureProvider)m).getModel(ctx, parent, parentNode)) == null) continue;
                    return model;
                }
            }
            if (parent instanceof ISelfProvidingElement) {
                ElementModel[] children;
                ISelfProvidingElement z = (ISelfProvidingElement)parent;
                ElementModel[] elementModelArray = children = z.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementModel q = elementModelArray[n2];
                    if (q.getShortName().equals(localName)) {
                        return q;
                    }
                    ++n2;
                }
            }
        }
        return associatedDefinition;
    }

    private static DefinitionElement findNestedWithQName(AttributeContext ctx, ElementModel parent, QName qName) {
        Collection nested = MuleCorePlugin.getModuleManager().getNested();
        for (NestedDefinition d : nested) {
            DefinitionElement definitionElement;
            if (!qName.equals(d.getMuleElement()) || !parent.isAllowedCompletionChild((ElementModel)(definitionElement = new DefinitionElement((NodeDefinition)d, qName, ctx)))) continue;
            return definitionElement;
        }
        return null;
    }

    private static TextElementModel findAttributeOfDefinition(String localName, DomainEditingModelObject parentNode, QName qName, DefinitionElement parentDefElement) {
        AttributeHelper attribute;
        AbstractComponentMeta componentMeta = (AbstractComponentMeta)parentDefElement.def.getService(AbstractComponentMeta.class);
        if (componentMeta != null && (attribute = componentMeta.getAttribute(localName)) != null && !attribute.isAttribute()) {
            return attribute.isSupportsExpressions() ? new TextElementModel(qName, new ElementModel.InnerTextValidator((ITypeValidator)new TextAreaITypeValidator(parentNode.getNamespace(), parentNode.getLocalName()), null)) : new TextElementModel(qName);
        }
        return null;
    }

    private static NodeDefinition getDef(QName qName, String version, boolean isGlobal) {
        ArrayList possibilities = (ArrayList)MuleCorePlugin.getModuleManager().getQNameMappings(version).get(qName);
        if (possibilities == null || possibilities.isEmpty()) {
            return null;
        }
        if (MuleConfigurationValidator.allNonAbstract(possibilities)) {
            String typeDifference = "";
            for (NodeDefinition nodeDefinition : possibilities) {
                String nodeType = nodeDefinition.getId();
                String string = typeDifference = typeDifference.length() >= nodeType.length() ? typeDifference.replaceAll(nodeType, "") : nodeType.replaceAll(typeDifference, "");
            }
            if (typeDifference.equals(DEFINITION_ID_GLOBAL_SUFFIX)) {
                for (NodeDefinition nodeDefinition : possibilities) {
                    if (isGlobal && nodeDefinition.getId().endsWith(DEFINITION_ID_GLOBAL_SUFFIX)) {
                        return nodeDefinition;
                    }
                    if (isGlobal || nodeDefinition.getId().endsWith(DEFINITION_ID_GLOBAL_SUFFIX)) continue;
                    return nodeDefinition;
                }
            }
        }
        return MuleConfigurationValidator.getFirstNonAbstract(possibilities);
    }

    private static boolean allNonAbstract(ArrayList<NodeDefinition> possibilities) {
        for (NodeDefinition nodeDefinition : possibilities) {
            if (!nodeDefinition.isAbstract()) continue;
            return false;
        }
        return true;
    }

    private static NodeDefinition getFirstNonAbstract(ArrayList<NodeDefinition> possibilities) {
        NodeDefinition definition = null;
        for (NodeDefinition possibility : possibilities) {
            if (possibility.isAbstract()) continue;
            definition = possibility;
            break;
        }
        return definition == null ? possibilities.get(0) : definition;
    }

    private void enumerateLanes(List<CompartmentLane> lanes, AtomicInteger entityNumber, HashMap<Integer, IMessageFlowEntity> numberMap) {
        this.enumerateLanes(lanes, entityNumber, numberMap, false);
    }

    private void enumerateLanes(List<CompartmentLane> lanes, AtomicInteger entityNumber, HashMap<Integer, IMessageFlowEntity> numberMap, boolean considerLanes) {
        for (CompartmentLane lane : lanes) {
            Route route;
            if (considerLanes) {
                MuleConfigurationValidator.putMessageFlowEntity(numberMap, entityNumber, (IMessageFlowEntity)lane);
            } else if (lane instanceof Route && (!(route = (Route)lane).isEmpty() || route.getDefinition().isRequired())) {
                MuleConfigurationValidator.putMessageFlowEntity(numberMap, entityNumber, (IMessageFlowEntity)lane);
            }
            this.enumerateLaneEntries(lane.getCompartmentLaneEntries(), entityNumber, numberMap);
        }
    }

    private void enumerateLaneEntries(List<IMessageFlowEntity> compartmentLaneEntries, AtomicInteger entityNumber, HashMap<Integer, IMessageFlowEntity> numberMap) {
        ArrayList<IMessageFlowEntity> later = new ArrayList<IMessageFlowEntity>();
        for (IMessageFlowEntity value : compartmentLaneEntries) {
            if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)value)) {
                later.add(value);
                continue;
            }
            this.enumerateMessageFlowEntityContents(value, entityNumber, numberMap);
        }
        for (IMessageFlowEntity entity : later) {
            this.enumerateMessageFlowEntityContents(entity, entityNumber, numberMap);
        }
    }

    private void enumerateMessageFlowEntityContents(IMessageFlowEntity value, AtomicInteger entityNumber, HashMap<Integer, IMessageFlowEntity> numberMap) {
        if (!ModelUtils.isComment((IMessageFlowEntity)value)) {
            MuleConfigurationValidator.putMessageFlowEntity(numberMap, entityNumber, value);
        }
        if (value instanceof SplitterNode) {
            SplitterNode splitter = (SplitterNode)value;
            this.enumerateLanes(splitter.getCompartment().getLanes(), entityNumber, numberMap);
        } else if (value instanceof CompartmentLane) {
            this.enumerateLaneEntries(((CompartmentLane)value).getCompartmentLaneEntries(), entityNumber, numberMap);
        } else if (value instanceof Container) {
            this.enumerateLanes(((Container)value).getLanes(), entityNumber, numberMap);
        }
    }

    private static IMuleError[] formErrorsList(HashMap<Integer, IMessageFlowEntity> numberMap, MuleConfiguration config, List<IMessage> messages, IFile xmlConfigFile, String validatorId) {
        ArrayList<IMuleError> result = new ArrayList<IMuleError>();
        for (IMessage message : messages) {
            String localizedMessage;
            String string = localizedMessage = message instanceof LocalizedMessage ? ((LocalizedMessage)message).getLocalizedMessage() : message.getText();
            if (message instanceof NumberedMessage) {
                int severity;
                NumberedMessage numberedMessage = (NumberedMessage)message;
                IMessageFlowEntity messageFlowEntity = numberMap.get(numberedMessage.getNumber() - 1);
                String name = "";
                String path = "";
                int n = severity = numberedMessage.getSeverity() == 1 ? 2 : 1;
                if (messageFlowEntity != null) {
                    name = MessageFlowUtils.getName((IMessageFlowEntity)messageFlowEntity);
                    MulePath mulePath = config.getPathFor(messageFlowEntity);
                    if (mulePath != null) {
                        path = mulePath.toPath();
                    }
                    result.add(MuleErrorFactory.createMessageFlowError((IResource)xmlConfigFile, (String)path, (String)name, (String)localizedMessage, (int)severity, (String)validatorId));
                }
            }
            IMuleError xmlMuleError = message instanceof NumberedMessage ? MuleErrorFactory.createXMLMuleError((IResource)xmlConfigFile, (String)"", (String)localizedMessage, (IMessage)message, (int)2, (String)validatorId) : MuleErrorFactory.createXMLSyntaxMuleError((IResource)xmlConfigFile, (String)"", (String)localizedMessage, (IMessage)message, (int)2, (String)validatorId);
            result.add(xmlMuleError);
        }
        return result.toArray(new IMuleError[result.size()]);
    }

    private static void removeMessagesWithLowerPriority(List<IMessage> messages) {
        ArrayList<IMessage> toRemoveMessages = new ArrayList<IMessage>();
        int i = 0;
        while (i < messages.size()) {
            IMessage messageI = messages.get(i);
            if (messageI.getSeverity() == 4) {
                int j = 0;
                while (j < messages.size()) {
                    IMessage messageJ = messages.get(j);
                    if (messageJ != messageI && messageJ.getOffset() == messageI.getOffset() && messageJ.getSeverity() == 1) {
                        toRemoveMessages.add(messageI);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        messages.removeAll(toRemoveMessages);
    }

    private void removeErrorsSpringSecurityManager(List<IMessage> messages) {
        messages.removeIf(xmlError -> xmlError.getText().equals(ERROR_DELEGATE_SECURITY_PROVIDERS_IS_NOT_ALLOWED));
    }

    private boolean isDefaultErrorHandler(IMessageFlowEntity entity) {
        if (entity instanceof Container) {
            Container container = (Container)entity;
            return ModelUtils.isDefaultErrorHandler((Container)container);
        }
        return false;
    }

    private HashMap<Integer, IMessageFlowEntity> enumerateMessageFlowEntities(MuleConfiguration config) {
        AtomicInteger entityNumber = new AtomicInteger();
        HashMap<Integer, IMessageFlowEntity> numberMap = new HashMap<Integer, IMessageFlowEntity>();
        List globalEntries = config.getGlobalEntries();
        ArrayList rootEntries = new ArrayList();
        rootEntries.addAll(globalEntries);
        rootEntries.addAll(config.getFlows());
        LocationComparator comparator = new LocationComparator();
        rootEntries.sort((x, y) -> comparator.compare(x.getElement().getLocation(), y.getElement().getLocation()));
        rootEntries.forEach(entity -> {
            if (!this.isDefaultErrorHandler((IMessageFlowEntity)entity)) {
                MuleConfigurationValidator.putMessageFlowEntity(numberMap, entityNumber, entity);
            }
            if (entity instanceof Container) {
                List lanes = ((Container)entity).getLanes();
                this.enumerateLanes(lanes, entityNumber, numberMap);
            }
        });
        return numberMap;
    }

    private static void putMessageFlowEntity(HashMap<Integer, IMessageFlowEntity> numberMap, AtomicInteger entityNumber, IMessageFlowEntity value) {
        numberMap.put(entityNumber.getAndIncrement(), value);
    }

    private static class LocationComparator
    implements Comparator<IElementLocation> {
        private LocationComparator() {
        }

        @Override
        public int compare(IElementLocation o1, IElementLocation o2) {
            if (o1 instanceof ILineLocation && o2 instanceof ILineLocation) {
                ILineLocation loc1 = (ILineLocation)o1;
                ILineLocation loc2 = (ILineLocation)o2;
                return Integer.compare(loc1.getLineNumber(), loc2.getLineNumber());
            }
            if (o1 instanceof IAbsoluteLocation && o2 instanceof IAbsoluteLocation) {
                IAbsoluteLocation loc1 = (IAbsoluteLocation)o1;
                IAbsoluteLocation loc2 = (IAbsoluteLocation)o2;
                return Integer.compare(loc1.getStart(), loc2.getStart());
            }
            return 0;
        }
    }

    private static final class NumberedMessage
    extends LocalizedMessage {
        private int number;

        private NumberedMessage(int severity, String messageText) {
            super(severity, messageText);
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String toString() {
            return "NumberedMessage(" + Integer.toString(this.number) + ", " + super.getLocalizedMessage() + ")";
        }
    }

    private static final class SeverityMessageDecorator
    implements IMessage {
        private final IMessage decorated;
        private final int severity;

        public SeverityMessageDecorator(IMessage decorated, int severity) {
            this.decorated = decorated;
            this.severity = severity;
        }

        public int getSeverity() {
            return this.severity;
        }

        public Object getAttribute(String arg0) {
            return this.decorated.getAttribute(arg0);
        }

        public HashMap getAttributes() {
            return this.decorated.getAttributes();
        }

        public String getBundleName() {
            return this.decorated.getBundleName();
        }

        public String getGroupName() {
            return this.decorated.getGroupName();
        }

        public String getId() {
            return this.decorated.getId();
        }

        public int getLength() {
            return this.decorated.getLength();
        }

        public int getLineNumber() {
            return this.decorated.getLineNumber();
        }

        public String getMarkerId() {
            return this.decorated.getMarkerId();
        }

        public int getOffset() {
            return this.decorated.getOffset();
        }

        public String[] getParams() {
            return this.decorated.getParams();
        }

        public Object getTargetObject() {
            return this.decorated.getTargetObject();
        }

        public String getText() {
            return this.decorated.getText();
        }

        public String getText(ClassLoader arg0) {
            return this.decorated.getText(arg0);
        }

        public String getText(Locale arg0, ClassLoader arg1) {
            return this.decorated.getText(arg0, arg1);
        }

        public String getText(Locale arg0) {
            return this.decorated.getText(arg0);
        }

        public void setAttribute(String arg0, Object arg1) {
            this.decorated.setAttribute(arg0, arg1);
        }

        public void setBundleName(String arg0) {
            this.decorated.setBundleName(arg0);
        }

        public void setGroupName(String arg0) {
            this.decorated.setGroupName(arg0);
        }

        public void setId(String arg0) {
            this.decorated.setId(arg0);
        }

        public void setLength(int arg0) {
            this.decorated.setLength(arg0);
        }

        public void setLineNo(int arg0) {
            this.decorated.setLineNo(arg0);
        }

        public void setMarkerId(String arg0) {
            this.decorated.setMarkerId(arg0);
        }

        public void setOffset(int arg0) {
            this.decorated.setOffset(arg0);
        }

        public void setParams(String[] arg0) {
            this.decorated.setParams(arg0);
        }

        public void setSeverity(int arg0) {
            this.decorated.setSeverity(arg0);
        }

        public void setTargetObject(Object arg0) {
            this.decorated.setTargetObject(arg0);
        }
    }

    private static class TextAreaITypeValidator
    implements ITypeValidator {
        final String modelId;

        public TextAreaITypeValidator(String namespace, String element) {
            this.modelId = namespace + "/" + element;
        }

        public String validate(IProject project, String value, DomainEditingModelObject element, String typeSpecialization, String atrName) {
            String result = null;
            IStatus status = new ValidationUtils(MuleRuntime.create((IProject)project)).validate(value, this.modelId);
            if (!Status.OK_STATUS.equals(status)) {
                result = status.getMessage();
            }
            return result;
        }

        public int getSeverity() {
            return 4;
        }
    }

    private final class XMLDomainValidatorVisitor
    extends DomainValidatorVisitor {
        private final IProblemReporter iProblemReporter;

        private XMLDomainValidatorVisitor(IProblemReporter reporter, IProject project, IProblemReporter iProblemReporter) {
            super(reporter, project);
            this.iProblemReporter = iProblemReporter;
        }

        protected ElementModel resolveElement(String namespace, String localName, boolean isGlobal, ElementModel parent, DomainEditingModelObject parentNode) {
            return MuleConfigurationValidator.resolve(namespace, localName, MuleConfigurationValidator.this.attributeContext.get(), isGlobal, parent, parentNode);
        }

        protected void customValudate(IDocumentAttributeNode currentAttribute, IProject project2, String attributeValue, DomainEditingModelObject domainEditingModelObject, int number) {
            new MuleExpressionValidator(this.iProblemReporter, number).validate(currentAttribute, project2, attributeValue, domainEditingModelObject, null);
        }

        protected boolean checkElementAttributeToRequiredValidation(String tag, String namespace, String attributeName) {
            try {
                if (CoreUtils.areNotBlank((String[])new String[]{tag, namespace, attributeName})) {
                    if (tag.equals("inbound-endpoint") || tag.equals("outbound-endpoint")) {
                        return this.checkOldEndpointsRequiredValidation(tag, namespace, attributeName);
                    }
                    HttpRequirementsValidator httpRequirementsValidator = new HttpRequirementsValidator(namespace, tag, attributeName);
                    if (httpRequirementsValidator.applies()) {
                        return httpRequirementsValidator.shouldAttributeBeValidated();
                    }
                }
                return super.checkElementAttributeToRequiredValidation(tag, namespace, attributeName);
            }
            catch (Throwable throwable) {
                return true;
            }
        }

        private boolean checkOldEndpointsRequiredValidation(String tag, String namespace, String attributeName) {
            AttributeHelper attributeHelper;
            AbstractComponentMeta service;
            NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinition(namespace + "/endpoint");
            if (def != null && (service = (AbstractComponentMeta)def.getService(AbstractComponentMeta.class)) != null && (attributeHelper = service.getAttribute(attributeName)).getMode() != null && attributeHelper.getMode().length() > 0) {
                if (attributeHelper.getMode().equals("inbound") && tag.equals("outbound-endpoint")) {
                    return false;
                }
                if (attributeHelper.getMode().equals("outbound") && tag.equals("inbound-endpoint")) {
                    return false;
                }
            }
            return true;
        }

        protected String getElementNameForValidaionMessage(String tag, String namespace) {
            IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
            if (moduleManager != null) {
                try {
                    AbstractComponentMeta service;
                    String cath;
                    NodeDefinition def = moduleManager.getDefinition(namespace + "/" + tag);
                    if (def != null && (cath = def.getCategoryId()).equals(Category.CLOUD_CONNECTORS.getCategoryString()) && (service = (AbstractComponentMeta)def.getService(AbstractComponentMeta.class)) != null) {
                        Object prefix = service.getPrefix();
                        if (prefix != null) {
                            prefix = ((String)prefix).substring(0, 1).toUpperCase() + ((String)prefix).substring(1);
                            return prefix;
                        }
                        return tag;
                    }
                }
                catch (Throwable throwable) {
                    return tag;
                }
            }
            return tag;
        }

        protected String validateElementInnerText(DomainEditingModelObject domainEditingModelObject, String value) {
            try {
                AbstractComponentMeta service;
                String namespace = domainEditingModelObject.getNamespace();
                String tag = domainEditingModelObject.getLocalName();
                IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
                NodeDefinition def = moduleManager.getDefinition(namespace + "/" + tag);
                if (def != null && (service = (AbstractComponentMeta)def.getService(AbstractComponentMeta.class)) != null) {
                    IValidator validator;
                    AttributeHelper innerTextAttributeHelper = null;
                    for (AttributeHelper h : service.getAllAttributes()) {
                        if (!h.isAttribute()) continue;
                        innerTextAttributeHelper = h;
                    }
                    if (innerTextAttributeHelper != null && (validator = innerTextAttributeHelper.getValidator()) != null) {
                        return validator.validate(value, MuleConfigurationValidator.this.attributeContext.get(), innerTextAttributeHelper);
                    }
                }
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    private static final class XMLProblemReporter
    implements IProblemReporter {
        private final IReporter reporter;
        private final MuleConfigurationValidator validator;
        private final IDocument document;
        HashSet<String> existing = new HashSet();

        private XMLProblemReporter(IReporter reporter, MuleConfigurationValidator validator, IDocument document) {
            this.reporter = reporter;
            this.validator = validator;
            this.document = document;
        }

        public void accept(int severity, int start, int end, String message, int number) {
            String mKey = message + start + ":" + end;
            if (this.existing.contains(mKey)) {
                return;
            }
            this.existing.add(mKey);
            int messageSeverity = this.iStatusToIMessageSeverity(severity);
            NumberedMessage ms = new NumberedMessage(messageSeverity, message);
            ms.setNumber(number);
            ms.setOffset(start);
            ms.setLength(end - start);
            try {
                ms.setLineNo(this.document.getLineOfOffset(start));
                this.reporter.addMessage((org.eclipse.wst.validation.internal.provisional.core.IValidator)this.validator, (IMessage)ms);
            }
            catch (BadLocationException e) {
                throw new IllegalStateException(e);
            }
        }

        private int iStatusToIMessageSeverity(int istatus) {
            int severity = istatus == 4 ? 1 : (istatus == 2 ? 2 : (istatus == 1 ? 4 : 1));
            return severity;
        }
    }
}

