/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.validation;

import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class HttpRequirementsValidator {
    private static final String HTTP_NAMESPACE = "http://www.mulesoft.org/schema/mule/http";
    private static final String HTTP_ENDPOINT_EDITOR_ID = "http://www.mulesoft.org/schema/mule/http/listener-request";
    private static final String HTTP_OUTBOUND_ENDPOINT_ID = "request";
    private static final String HTTP_INBOUND_ENDPOINT_ID = "listener";
    private static final String HTTP_PATH_ATTR_ID = "path";
    private static final String HTTP_PATH_OUTBOUND_EDITOR_ID = "path-outbound";
    private static final String HTTP_PATH_INBOUND_EDITOR_ID = "path-inbound";
    private static final String HTTP_CONFIG_REF_ATTR_ID = "config-ref";
    private static final String HTTP_CONFIG_REF_OUTBOUND_EDITOR_ID = "config-ref-outbound";
    private static final String HTTP_CONFIG_REF_INBOUND_EDITOR_ID = "config-ref-inbound";
    private static final String MODE_OUTBOUND_ID = "outbound";
    private static final String MODE_INBOUND_ID = "inbound";
    private String namespace;
    private String tag;
    private String attributeName;

    public HttpRequirementsValidator(String namespace, String tag, String attributeName) {
        this.namespace = namespace;
        this.tag = tag;
        this.attributeName = attributeName;
    }

    public boolean applies() {
        return this.namespace.equals(HTTP_NAMESPACE) && (this.tag.equals(HTTP_INBOUND_ENDPOINT_ID) || this.tag.equals(HTTP_OUTBOUND_ENDPOINT_ID));
    }

    public boolean shouldAttributeBeValidated() {
        AbstractComponentMeta service;
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinition(HTTP_ENDPOINT_EDITOR_ID);
        if (def != null && (service = (AbstractComponentMeta)def.getService(AbstractComponentMeta.class)) != null) {
            String mode;
            boolean isRequest = this.tag.equals(HTTP_OUTBOUND_ENDPOINT_ID);
            boolean isListener = this.tag.equals(HTTP_INBOUND_ENDPOINT_ID);
            AttributeHelper attributeHelper = this.getNewHttpAttributeHelper(service, isListener);
            if (attributeHelper != null && attributeHelper.isRequired() && StringUtils.isNotBlank((String)(mode = attributeHelper.getMode()))) {
                if (mode.equals(MODE_INBOUND_ID) && isListener) {
                    return true;
                }
                if (mode.equals(MODE_OUTBOUND_ID) && isRequest) {
                    return true;
                }
            }
        }
        return false;
    }

    private AttributeHelper getNewHttpAttributeHelper(AbstractComponentMeta service, boolean isListener) {
        if (this.attributeName.equals(HTTP_CONFIG_REF_ATTR_ID)) {
            return isListener ? service.getAttribute(HTTP_CONFIG_REF_INBOUND_EDITOR_ID) : service.getAttribute(HTTP_CONFIG_REF_OUTBOUND_EDITOR_ID);
        }
        if (this.attributeName.equals(HTTP_PATH_ATTR_ID)) {
            return isListener ? service.getAttribute(HTTP_PATH_INBOUND_EDITOR_ID) : service.getAttribute(HTTP_PATH_OUTBOUND_EDITOR_ID);
        }
        return service.getAttribute(this.attributeName);
    }
}

