/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.validation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.MuleValidationResult;
import org.mule.tooling.core.generator.errors.IMuleError;
import org.mule.tooling.core.generator.errors.messageflow.MuleErrorFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.validation.AbstractMuleValidator;

public class CommentInXmlValidator
extends AbstractMuleValidator {
    private static final String DOUBLE_DASH_STRING = "--";
    private static final String THE_STRING_IS_NOT_PERMITTED_WITHIN_COMMENTS = "The string \"--\" is not permitted within comments.";
    public static final String VALIDATOR_ID = "org.mule.tooling.ui.modules.core.validation.commentInXmlValidator";

    private int getLineNumber(int start) {
        int lineNo = -1;
        try {
            lineNo = this.document.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException e) {
            MuleCorePlugin.logError((String)"Could not find line number for the xml error", (Throwable)e);
        }
        return lineNo;
    }

    private LocalizedMessage createDoubleDashInCommentMessage(int start, int doubleDashIndex) {
        LocalizedMessage localizedMessage = new LocalizedMessage(1, THE_STRING_IS_NOT_PERMITTED_WITHIN_COMMENTS);
        localizedMessage.setLength(DOUBLE_DASH_STRING.length());
        localizedMessage.setOffset(start + doubleDashIndex);
        localizedMessage.setLineNo(this.getLineNumber(start));
        return localizedMessage;
    }

    public void cleanup(IReporter arg0) {
    }

    public MuleValidationResult validate(IFile xmlConfigFile, MuleConfiguration config) throws CoreException, UnsupportedEncodingException, IOException {
        ArrayList errors;
        block11: {
            IStructuredModel model = null;
            errors = new ArrayList();
            try {
                try {
                    model = StructuredModelManager.getModelManager().getModelForRead(xmlConfigFile);
                    IStructuredDocument document = null;
                    if (model != null) {
                        document = model.getStructuredDocument();
                        IStructuredDocumentRegion validationRegion = document.getFirstStructuredDocumentRegion();
                        while (validationRegion != null) {
                            if (this.isXmlComment(validationRegion) && validationRegion.getRegions().size() > 2) {
                                int openingCommentTagLength = validationRegion.getFirstRegion().getLength();
                                int commentTextStartIndex = validationRegion.getStartOffset() + openingCommentTagLength;
                                String commentText = validationRegion.getText(validationRegion.getRegionAtCharacterOffset(commentTextStartIndex));
                                this.validateXmlCommentContent(commentText, commentTextStartIndex, xmlConfigFile).ifPresent(message -> {
                                    boolean bl = errors.add(message);
                                });
                            }
                            validationRegion = validationRegion.getNext();
                        }
                    }
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Could not validate comments in xml", (Throwable)e);
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                if (model != null) {
                    model.releaseFromRead();
                }
                throw throwable;
            }
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return MuleValidationResult.withErrors(errors);
    }

    private Optional<IMuleError> validateXmlCommentContent(String comment, int commentTextStartIndex, IFile xmlConfigFile) {
        int doubleDashIndex = comment.indexOf(DOUBLE_DASH_STRING);
        if (doubleDashIndex != -1) {
            LocalizedMessage message = this.createDoubleDashInCommentMessage(commentTextStartIndex, doubleDashIndex);
            return Optional.of(MuleErrorFactory.createXMLSyntaxMuleError((IResource)xmlConfigFile, (String)"", (String)message.getLocalizedMessage(), (IMessage)message, (int)2, (String)this.getValidatorId()));
        }
        return Optional.empty();
    }

    private boolean isXmlComment(IStructuredDocumentRegion validationRegion) {
        return validationRegion.getFirstRegion().getType().equals("XML_COMMENT_OPEN") && validationRegion.getType().equals("XML_COMMENT_TEXT") && validationRegion.getLastRegion().getType().equals("XML_COMMENT_CLOSE");
    }

    public String getValidatorId() {
        return VALIDATOR_ID;
    }
}

