/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.validation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.builder.IMuleValidator;
import org.mule.tooling.core.builder.MuleMarkers;
import org.mule.tooling.core.builder.MuleValidationResult;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public abstract class AbstractMuleValidator
implements IMuleValidator,
IValidator,
ISourceValidator {
    private static final String ERROR_DELEGATE_SECURITY_PROVIDERS_IS_NOT_ALLOWED = "Element: delegate-security-provider is not allowed to be child of element Spring Security manager";
    protected IDocument document;

    public void connect(IDocument document) {
        this.document = document;
    }

    public void disconnect(IDocument document) {
        this.document = null;
    }

    public void validate(IRegion arg0, IValidationContext arg1, IReporter arg2) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris;
        reporter.removeAllMessages((IValidator)this);
        String[] stringArray = uris = helper.getURIs();
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            this.validateWithUri(reporter, uri);
            ++n2;
        }
    }

    private void validateWithUri(final IReporter reporter, String uri) {
        Path xmlPath = new Path(uri);
        if (xmlPath.segmentCount() < 2) {
            return;
        }
        final IFile xmlConfigFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)xmlPath);
        IProject project = xmlConfigFile.getProject();
        final IMuleProject muleProject = MuleRuntime.create((IProject)project);
        if (muleProject != null) {
            StudioDesignContextRunner.runSilentWithMuleProject((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    AbstractMuleValidator.this.innerValidate(reporter, xmlConfigFile, muleProject);
                    return null;
                }
            }, (IMuleProject)muleProject);
        }
    }

    private void innerValidate(IReporter reporter, IFile xmlConfigFile, IMuleProject muleProject) throws CoreException, UnsupportedEncodingException, IOException {
        try {
            Charset charset = MuleResourceUtils.getCharset((IFile)xmlConfigFile);
            String configName = xmlConfigFile.getName().substring(0, xmlConfigFile.getName().lastIndexOf(46));
            MuleConfiguration tempMuleConfiguration = MuleConfigurationUtils.createTemporaryNewMuleConfiguration((IMuleProject)muleProject, (String)this.document.get(), (String)configName, (Charset)charset);
            MuleConfigurationUtils.setScopeAndVisibility((IFile)xmlConfigFile, (MuleConfiguration)tempMuleConfiguration);
            MuleValidationResult result = this.validate(xmlConfigFile, tempMuleConfiguration);
            result.reportInEditor(reporter, (IValidator)this);
            if (!result.getXmlErrors().isEmpty()) {
                this.removeErrorsSpringSecurityManager(result);
            }
            List muleMarkers = MuleMarkers.getAllMuleMarkers((IFile)xmlConfigFile, (IMuleValidator)this);
            result.reportInProblemsPane();
            muleMarkers.forEach(m -> {
                try {
                    m.delete();
                }
                catch (CoreException e) {
                    MuleCorePlugin.logWarning((String)("There was a problem parsing the XML of " + String.valueOf(xmlConfigFile.getLocation())), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            MuleCorePlugin.logWarning((String)("There was a problem parsing the XML of " + String.valueOf(xmlConfigFile.getLocation())), (Throwable)e);
        }
    }

    private void removeErrorsSpringSecurityManager(MuleValidationResult result) {
        result.getXmlErrors().removeIf(xmlError -> xmlError.getMessage().equals(ERROR_DELEGATE_SECURITY_PROVIDERS_IS_NOT_ALLOWED));
        result.getMuleConfigurationErrors().removeIf(xmlError -> xmlError.getMessage().equals(ERROR_DELEGATE_SECURITY_PROVIDERS_IS_NOT_ALLOWED));
    }

    protected boolean isDocumentSet() {
        return this.document != null;
    }
}

