/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.router;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.NamedComponentMeta;

public class RouterModelGenerator
extends NamedComponentMeta {
    public RouterModelGenerator(QName qName, Namespace ns, NodeDefinition def, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInheritArg) {
        super(qName, ns, def, loadCommonProperties, doNotInheritArg);
    }

    @Override
    public List<CompartmentLane> generateRoutes(IElementWrapper element, SplitterNode splitterNode, String runtimeVersion) {
        ArrayList<CompartmentLane> routes = new ArrayList<CompartmentLane>();
        SplitterDefinition definition = (SplitterDefinition)splitterNode.getDefinition();
        INodeListWrapper choiceChildren = element.getChildElements();
        for (IElementWrapper child : choiceChildren) {
            PropertyCollectionMap routeProps = new PropertyCollectionMap(child);
            Optional routeDefinition = definition.getRouteDefinition(child.getQName());
            if (!routeDefinition.isPresent()) continue;
            Route lane = MessageFlowFactory.createRoute((IElementWrapper)child, (int)1, (RouteDefinition)((RouteDefinition)routeDefinition.get()));
            lane.setDefinition((RouteDefinition)routeDefinition.get());
            this.preserveAttributes(child, routeProps);
            lane.setProperties(routeProps.asPropertyCollection());
            routes.add((CompartmentLane)lane);
        }
        return routes;
    }

    private void preserveAttributes(IElementWrapper element, PropertyCollectionMap p) {
        IAttributeListWrapper as = element.getAttributes();
        for (IAttributeWrapper a : as) {
            p.addProperty(a.getTagName(), a.getText());
        }
    }
}

