/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.pattern.scattergather;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.ISplitterModelGenerator;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;

public class ScatterGatherModelGenerator
implements ISplitterModelGenerator {
    public List<CompartmentLane> generateRoutes(IElementWrapper element, SplitterNode splitterNode, String runtimeVersion) {
        SplitterNode messageFlowNode;
        NodeDefinition definition;
        IModelGenerator service;
        if (splitterNode instanceof MessageFlowNode && (service = (IModelGenerator)(definition = (messageFlowNode = splitterNode).getDefinition()).getService(IModelGenerator.class)) instanceof AbstractComponentMeta) {
            AbstractComponentMeta abstractComponentMeta = (AbstractComponentMeta)service;
            List<CompartmentLane> routes = abstractComponentMeta.generateRoutes(element, splitterNode, runtimeVersion);
            return this.filterRoutes(abstractComponentMeta, routes);
        }
        throw new RuntimeException("Could not find a proper service to generate routes");
    }

    private List<CompartmentLane> filterRoutes(AbstractComponentMeta abstractComponentMeta, List<CompartmentLane> routes) {
        List<ChildElementAttributeHelper> childElements = Arrays.asList(abstractComponentMeta.getChildElements());
        final ArrayList configurationElements = Lists.newArrayList((Iterable)Iterables.transform(childElements, (Function)new Function<ChildElementAttributeHelper, String>(){

            public String apply(ChildElementAttributeHelper childElement) {
                return ScatterGatherModelGenerator.this.uriString(MuleCorePlugin.getModuleManager().getNestedDefinition(childElement.getId()).getMuleElement());
            }
        }));
        return Lists.newArrayList((Iterable)Iterables.filter(routes, (Predicate)new Predicate<CompartmentLane>(){

            public boolean apply(CompartmentLane route) {
                String elementUriString = ScatterGatherModelGenerator.this.uriString(route.getElement().getQName());
                return !configurationElements.contains(elementUriString);
            }
        }));
    }

    protected String uriString(QName qname) {
        return MessageFormat.format("{0}/{1}", qname.getNamespaceURI(), qname.getLocalPart());
    }

    public void generate(IElementWrapper element, MessageFlowEntity uiModel) {
        if (uiModel instanceof MessageFlowNode) {
            MessageFlowNode messageFlowNode = (MessageFlowNode)uiModel;
            NodeDefinition definition = messageFlowNode.getDefinition();
            IModelGenerator service = (IModelGenerator)definition.getService(IModelGenerator.class);
            service.generate(element, uiModel);
        }
    }
}

